/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

public class TBSCertList
implements DEREncodable {
    ASN1Sequence seq;
    DERInteger version;
    AlgorithmIdentifier signature;
    X509Name issuer;
    DERUTCTime thisUpdate;
    DERUTCTime nextUpdate;
    CRLEntry[] revokedCertificates;
    X509Extensions crlExtensions;

    public static TBSCertList getInstance(Object object) {
        if (object instanceof TBSCertList) {
            return (TBSCertList)object;
        }
        if (object instanceof ASN1Sequence) {
            return new TBSCertList((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public TBSCertList(ASN1Sequence aSN1Sequence) {
        int n = 0;
        this.seq = aSN1Sequence;
        this.version = aSN1Sequence.getObjectAt(n) instanceof DERInteger ? (DERInteger)aSN1Sequence.getObjectAt(n++) : new DERInteger(0);
        this.signature = aSN1Sequence.getObjectAt(n) instanceof AlgorithmIdentifier ? (AlgorithmIdentifier)aSN1Sequence.getObjectAt(n++) : new AlgorithmIdentifier((DERConstructedSequence)aSN1Sequence.getObjectAt(n++));
        this.issuer = aSN1Sequence.getObjectAt(n) instanceof X509Name ? (X509Name)aSN1Sequence.getObjectAt(n++) : new X509Name((DERConstructedSequence)aSN1Sequence.getObjectAt(n++));
        this.thisUpdate = (DERUTCTime)aSN1Sequence.getObjectAt(n++);
        if (n < aSN1Sequence.getSize() && aSN1Sequence.getObjectAt(n) instanceof DERUTCTime) {
            this.nextUpdate = (DERUTCTime)aSN1Sequence.getObjectAt(n++);
        }
        if (n < aSN1Sequence.getSize() && !(aSN1Sequence.getObjectAt(n) instanceof DERTaggedObject)) {
            DERConstructedSequence dERConstructedSequence = (DERConstructedSequence)aSN1Sequence.getObjectAt(n++);
            this.revokedCertificates = new CRLEntry[dERConstructedSequence.getSize()];
            int n2 = 0;
            while (n2 < this.revokedCertificates.length) {
                this.revokedCertificates[n2] = new CRLEntry((DERConstructedSequence)dERConstructedSequence.getObjectAt(n2));
                ++n2;
            }
        }
        if (n < aSN1Sequence.getSize() && aSN1Sequence.getObjectAt(n) instanceof DERTaggedObject) {
            this.crlExtensions = X509Extensions.getInstance(aSN1Sequence.getObjectAt(n++));
        }
    }

    public int getVersion() {
        return this.version.getValue().intValue() + 1;
    }

    public DERInteger getVersionNumber() {
        return this.version;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X509Name getIssuer() {
        return this.issuer;
    }

    public DERUTCTime getThisUpdate() {
        return this.thisUpdate;
    }

    public DERUTCTime getNextUpdate() {
        return this.nextUpdate;
    }

    public CRLEntry[] getRevokedCertificates() {
        return this.revokedCertificates;
    }

    public X509Extensions getExtensions() {
        return this.crlExtensions;
    }

    public DERObject getDERObject() {
        return this.seq;
    }

    public class CRLEntry
    implements DEREncodable {
        DERConstructedSequence seq;
        DERInteger userCertificate;
        DERUTCTime revocationDate;
        X509Extensions crlEntryExtensions;

        public CRLEntry(DERConstructedSequence dERConstructedSequence) {
            this.seq = dERConstructedSequence;
            this.userCertificate = (DERInteger)dERConstructedSequence.getObjectAt(0);
            this.revocationDate = (DERUTCTime)dERConstructedSequence.getObjectAt(1);
            if (dERConstructedSequence.getSize() == 3) {
                this.crlEntryExtensions = X509Extensions.getInstance(dERConstructedSequence.getObjectAt(2));
            }
        }

        public DERInteger getUserCertificate() {
            return this.userCertificate;
        }

        public DERUTCTime getRevocationDate() {
            return this.revocationDate;
        }

        public X509Extensions getExtensions() {
            return this.crlEntryExtensions;
        }

        public DERObject getDERObject() {
            return this.seq;
        }
    }
}

