/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class SubjectKeyIdentifier
implements DEREncodable {
    private byte[] keyidentifier;

    public SubjectKeyIdentifier(byte[] byArray) {
        this.keyidentifier = byArray;
    }

    public SubjectKeyIdentifier(DEROctetString dEROctetString) {
        this.keyidentifier = dEROctetString.getOctets();
    }

    public SubjectKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        byte[] byArray = new byte[sHA1Digest.getDigestSize()];
        byte[] byArray2 = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        sHA1Digest.update(byArray2, 0, byArray2.length);
        sHA1Digest.doFinal(byArray, 0);
        this.keyidentifier = byArray;
    }

    public byte[] getKeyIdentifier() {
        return this.keyidentifier;
    }

    public DERObject getDERObject() {
        DEROctetString dEROctetString = new DEROctetString(this.keyidentifier);
        return dEROctetString;
    }
}

