/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

public class SubjectKeyIdentifier
implements DEREncodable {
    private DEROctetString id;

    public SubjectKeyIdentifier(byte[] byArray) {
        this.setId(byArray);
    }

    public SubjectKeyIdentifier(DEROctetString dEROctetString) {
        this.id = dEROctetString;
    }

    public SubjectKeyIdentifier(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.id = subjectKeyIdentifier.id;
    }

    public static SubjectKeyIdentifier getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SubjectKeyIdentifier) {
            return (SubjectKeyIdentifier)object;
        }
        if (object instanceof DEROctetString) {
            return new SubjectKeyIdentifier((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return SubjectKeyIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SubjectKeyIdentifier");
    }

    public static SubjectKeyIdentifier newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SubjectKeyIdentifier) {
            return new SubjectKeyIdentifier((SubjectKeyIdentifier)object);
        }
        if (object instanceof DEROctetString) {
            return new SubjectKeyIdentifier((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return SubjectKeyIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SubjectKeyIdentifier");
    }

    public byte[] getId() {
        return this.id.getOctets();
    }

    private void setId(byte[] byArray) {
        this.id = new DEROctetString(byArray);
    }

    public DERObject getDERObject() {
        return this.id;
    }
}

