/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.Attribute;

public class SignedAttributes
implements DEREncodable {
    private DERConstructedSet attributes;

    public SignedAttributes(Vector vector) {
        this.setAttributes(vector);
    }

    public SignedAttributes(DERConstructedSet dERConstructedSet) {
        this.attributes = dERConstructedSet;
    }

    public SignedAttributes(SignedAttributes signedAttributes) {
        this.attributes = signedAttributes.attributes;
    }

    public static SignedAttributes getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SignedAttributes) {
            return (SignedAttributes)object;
        }
        if (object instanceof DERConstructedSet) {
            return new SignedAttributes((DERConstructedSet)object);
        }
        if (object instanceof DERTaggedObject) {
            return SignedAttributes.getInstance(((DERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SignedAttributes");
    }

    public static SignedAttributes newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SignedAttributes) {
            return new SignedAttributes((SignedAttributes)object);
        }
        if (object instanceof DERConstructedSet) {
            return new SignedAttributes((DERConstructedSet)object);
        }
        if (object instanceof DERTaggedObject) {
            return SignedAttributes.getInstance(((DERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SignedAttributes");
    }

    public Vector getAttributes() {
        int n = this.attributes.getSize();
        Vector<Attribute> vector = new Vector<Attribute>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(Attribute.getInstance(this.attributes.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    private void setAttributes(Vector vector) {
        int n = vector.size();
        this.attributes = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.attributes.addObject(Attribute.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }

    public DERObject getDERObject() {
        return this.attributes;
    }
}

