/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.OtherKeyAttribute;
import org.bouncycastle.asn1.cms.SubjectKeyIdentifier;

public class RecipientKeyIdentifier
implements DEREncodable {
    private SubjectKeyIdentifier subjectKeyIdentifier;
    private DERGeneralizedTime date;
    private OtherKeyAttribute other;

    public RecipientKeyIdentifier(SubjectKeyIdentifier subjectKeyIdentifier, String string, OtherKeyAttribute otherKeyAttribute) {
        this.setSubjectKeyIdentifier(subjectKeyIdentifier);
        this.setDate(string);
        this.setOtherKeyAttribute(otherKeyAttribute);
    }

    public RecipientKeyIdentifier(BERConstructedSequence bERConstructedSequence) {
        this.subjectKeyIdentifier = SubjectKeyIdentifier.getInstance(bERConstructedSequence.getObjectAt(0));
        switch (bERConstructedSequence.getSize()) {
            case 1: {
                break;
            }
            case 2: {
                try {
                    this.date = (DERGeneralizedTime)bERConstructedSequence.getObjectAt(1);
                }
                catch (Exception exception) {
                    this.other = OtherKeyAttribute.getInstance(bERConstructedSequence.getObjectAt(2));
                }
                break;
            }
            case 3: {
                this.date = (DERGeneralizedTime)bERConstructedSequence.getObjectAt(1);
                this.other = OtherKeyAttribute.getInstance(bERConstructedSequence.getObjectAt(2));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid KEKIdentifier");
            }
        }
    }

    public RecipientKeyIdentifier(RecipientKeyIdentifier recipientKeyIdentifier) {
        this.subjectKeyIdentifier = recipientKeyIdentifier.subjectKeyIdentifier;
        this.date = recipientKeyIdentifier.date;
        this.other = recipientKeyIdentifier.other;
    }

    public static RecipientKeyIdentifier getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RecipientKeyIdentifier) {
            return (RecipientKeyIdentifier)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new RecipientKeyIdentifier((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return RecipientKeyIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RecipientKeyIdentifier");
    }

    public static RecipientKeyIdentifier newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RecipientKeyIdentifier) {
            return new RecipientKeyIdentifier((RecipientKeyIdentifier)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new RecipientKeyIdentifier((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return RecipientKeyIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RecipientKeyIdentifier");
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    private void setSubjectKeyIdentifier(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
    }

    public String getDate() {
        return this.date.getTime();
    }

    private void setDate(String string) {
        this.date = new DERGeneralizedTime(string);
    }

    public OtherKeyAttribute getOtherKeyAttribute() {
        return this.other;
    }

    private void setOtherKeyAttribute(OtherKeyAttribute otherKeyAttribute) {
        this.other = otherKeyAttribute;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.subjectKeyIdentifier);
        if (this.date != null) {
            bERConstructedSequence.addObject(this.date);
        }
        if (this.other != null) {
            bERConstructedSequence.addObject(this.other);
        }
        return bERConstructedSequence;
    }
}

