/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.RecipientEncryptedKey;

public class RecipientEncryptedKeys
implements DEREncodable {
    private RecipientEncryptedKey[] keys;

    public RecipientEncryptedKeys(RecipientEncryptedKey[] recipientEncryptedKeyArray) {
        this.setKeys(recipientEncryptedKeyArray);
    }

    public RecipientEncryptedKeys(BERConstructedSequence bERConstructedSequence) {
        int n = bERConstructedSequence.getSize();
        this.keys = new RecipientEncryptedKey[bERConstructedSequence.getSize()];
        int n2 = 0;
        while (n2 < n) {
            this.keys[n2] = RecipientEncryptedKey.getInstance(bERConstructedSequence.getObjectAt(n2));
            ++n2;
        }
    }

    public RecipientEncryptedKeys(RecipientEncryptedKeys recipientEncryptedKeys) {
        this.keys = recipientEncryptedKeys.keys;
    }

    public static RecipientEncryptedKeys getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RecipientEncryptedKeys) {
            return (RecipientEncryptedKeys)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new RecipientEncryptedKeys((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return RecipientEncryptedKeys.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RecipientEncryptedKeys");
    }

    public static RecipientEncryptedKeys newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RecipientEncryptedKeys) {
            return new RecipientEncryptedKeys((RecipientEncryptedKeys)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new RecipientEncryptedKeys((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return RecipientEncryptedKeys.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RecipientEncryptedKeys");
    }

    public RecipientEncryptedKey[] getKeys() {
        return this.keys;
    }

    private void setKeys(RecipientEncryptedKey[] recipientEncryptedKeyArray) {
        this.keys = recipientEncryptedKeyArray;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        int n = 0;
        while (n < this.keys.length) {
            bERConstructedSequence.addObject(this.keys[n]);
            ++n;
        }
        return bERConstructedSequence;
    }
}

