/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.OriginatorPublicKey;
import org.bouncycastle.asn1.cms.SubjectKeyIdentifier;

public class OriginatorIdentifierOrKey
implements DEREncodable {
    private DEREncodable id;

    public OriginatorIdentifierOrKey(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.setId(issuerAndSerialNumber);
    }

    public OriginatorIdentifierOrKey(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.setId(subjectKeyIdentifier);
    }

    public OriginatorIdentifierOrKey(OriginatorPublicKey originatorPublicKey) {
        this.setId(originatorPublicKey);
    }

    public OriginatorIdentifierOrKey(DEREncodable dEREncodable) {
        block5: {
            block4: {
                if (!(dEREncodable instanceof BERTaggedObject)) break block4;
                BERTaggedObject bERTaggedObject = (BERTaggedObject)dEREncodable;
                switch (bERTaggedObject.getTagNo()) {
                    case 0: {
                        this.id = SubjectKeyIdentifier.getInstance(bERTaggedObject.getObject());
                        break block5;
                    }
                    case 1: {
                        this.id = OriginatorPublicKey.getInstance(bERTaggedObject.getObject());
                        break block5;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid OriginatorIdentifierOrKey");
                    }
                }
            }
            this.id = IssuerAndSerialNumber.getInstance(dEREncodable);
        }
    }

    public OriginatorIdentifierOrKey(OriginatorIdentifierOrKey originatorIdentifierOrKey) {
        this.id = originatorIdentifierOrKey.id;
    }

    public static OriginatorIdentifierOrKey getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof OriginatorIdentifierOrKey) {
            return (OriginatorIdentifierOrKey)object;
        }
        if (object instanceof DEREncodable) {
            return new OriginatorIdentifierOrKey((DEREncodable)object);
        }
        if (object instanceof BERTaggedObject) {
            return OriginatorIdentifierOrKey.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid OriginatorIdentifierOrKey");
    }

    public static OriginatorIdentifierOrKey newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof OriginatorIdentifierOrKey) {
            return new OriginatorIdentifierOrKey((OriginatorIdentifierOrKey)object);
        }
        if (object instanceof DEREncodable) {
            return new OriginatorIdentifierOrKey((DEREncodable)object);
        }
        if (object instanceof BERTaggedObject) {
            return OriginatorIdentifierOrKey.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid OriginatorIdentifierOrKey");
    }

    public DEREncodable getId() {
        return this.id;
    }

    private void setId(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.id = issuerAndSerialNumber;
    }

    private void setId(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.id = subjectKeyIdentifier;
    }

    private void setId(OriginatorPublicKey originatorPublicKey) {
        this.id = originatorPublicKey;
    }

    public DERObject getDERObject() {
        if (this.id instanceof SubjectKeyIdentifier) {
            return new BERTaggedObject(0, this.id.getDERObject());
        }
        if (this.id instanceof OriginatorPublicKey) {
            return new BERTaggedObject(1, this.id.getDERObject());
        }
        return this.id.getDERObject();
    }
}

