/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.KeyEncryptionAlgorithmIdentifier;
import org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import org.bouncycastle.asn1.cms.RecipientEncryptedKeys;
import org.bouncycastle.asn1.cms.UserKeyingMaterial;

public class KeyAgreeRecipientInfo
implements DEREncodable {
    private CMSVersion version;
    private OriginatorIdentifierOrKey originator;
    private UserKeyingMaterial ukm;
    private KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm;
    private RecipientEncryptedKeys recipientEncryptedKeys;

    public KeyAgreeRecipientInfo(CMSVersion cMSVersion, OriginatorIdentifierOrKey originatorIdentifierOrKey, UserKeyingMaterial userKeyingMaterial, KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier, RecipientEncryptedKeys recipientEncryptedKeys) {
        this.setVersion(cMSVersion);
        this.setOriginator(originatorIdentifierOrKey);
        this.setUserKeyingMaterial(userKeyingMaterial);
        this.setKeyEncryptionAlgorithm(keyEncryptionAlgorithmIdentifier);
        this.setRecipientEncryptedKeys(recipientEncryptedKeys);
    }

    public KeyAgreeRecipientInfo(BERConstructedSequence bERConstructedSequence) {
        int n = 0;
        this.version = CMSVersion.getInstance(bERConstructedSequence.getObjectAt(n++));
        this.originator = OriginatorIdentifierOrKey.getInstance(bERConstructedSequence.getObjectAt(n++));
        if (bERConstructedSequence.getSize() == 5) {
            this.ukm = UserKeyingMaterial.getInstance(bERConstructedSequence.getObjectAt(n++));
        }
        this.keyEncryptionAlgorithm = KeyEncryptionAlgorithmIdentifier.getInstance(bERConstructedSequence.getObjectAt(n++));
        this.recipientEncryptedKeys = RecipientEncryptedKeys.getInstance(bERConstructedSequence.getObjectAt(n++));
    }

    public KeyAgreeRecipientInfo(KeyAgreeRecipientInfo keyAgreeRecipientInfo) {
        this.version = keyAgreeRecipientInfo.version;
        this.originator = keyAgreeRecipientInfo.originator;
        this.ukm = keyAgreeRecipientInfo.ukm;
        this.keyEncryptionAlgorithm = keyAgreeRecipientInfo.keyEncryptionAlgorithm;
        this.recipientEncryptedKeys = keyAgreeRecipientInfo.recipientEncryptedKeys;
    }

    public static KeyAgreeRecipientInfo getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof KeyAgreeRecipientInfo) {
            return (KeyAgreeRecipientInfo)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new KeyAgreeRecipientInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return KeyAgreeRecipientInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid KeyAgreeRecipientInfo");
    }

    public static KeyAgreeRecipientInfo newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof KeyAgreeRecipientInfo) {
            return new KeyAgreeRecipientInfo((KeyAgreeRecipientInfo)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new KeyAgreeRecipientInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return KeyAgreeRecipientInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid KeyAgreeRecipientInfo");
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    public OriginatorIdentifierOrKey getOriginator() {
        return this.originator;
    }

    private void setOriginator(OriginatorIdentifierOrKey originatorIdentifierOrKey) {
        this.originator = originatorIdentifierOrKey;
    }

    public UserKeyingMaterial getUserKeyingMaterial() {
        return this.ukm;
    }

    private void setUserKeyingMaterial(UserKeyingMaterial userKeyingMaterial) {
        this.ukm = userKeyingMaterial;
    }

    public KeyEncryptionAlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    private void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithmIdentifier;
    }

    public RecipientEncryptedKeys getRecipientEncryptedKeys() {
        return this.recipientEncryptedKeys;
    }

    private void setRecipientEncryptedKeys(RecipientEncryptedKeys recipientEncryptedKeys) {
        this.recipientEncryptedKeys = recipientEncryptedKeys;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        bERConstructedSequence.addObject(new BERTaggedObject(true, 0, this.originator.getDERObject()));
        if (this.ukm != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(true, 1, this.ukm.getDERObject()));
        }
        bERConstructedSequence.addObject(this.keyEncryptionAlgorithm);
        bERConstructedSequence.addObject(this.recipientEncryptedKeys);
        return bERConstructedSequence;
    }
}

