/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.X509Name;

public class IssuerAndSerialNumber
implements DEREncodable {
    private X509Name issuer;
    private DERInteger serialNumber;

    public IssuerAndSerialNumber(X509Name x509Name, BigInteger bigInteger) {
        this.setIssuer(x509Name);
        this.setSerialNumber(bigInteger);
    }

    public IssuerAndSerialNumber(BERConstructedSequence bERConstructedSequence) {
        DEREncodable dEREncodable = bERConstructedSequence.getObjectAt(0);
        if (dEREncodable instanceof X509Name) {
            this.issuer = (X509Name)dEREncodable;
        } else if (dEREncodable instanceof BERConstructedSequence) {
            this.issuer = new X509Name((BERConstructedSequence)dEREncodable);
        }
        this.serialNumber = (DERInteger)bERConstructedSequence.getObjectAt(1);
    }

    public IssuerAndSerialNumber(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.issuer = issuerAndSerialNumber.issuer;
        this.serialNumber = issuerAndSerialNumber.serialNumber;
    }

    public static IssuerAndSerialNumber getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IssuerAndSerialNumber) {
            return (IssuerAndSerialNumber)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new IssuerAndSerialNumber((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return IssuerAndSerialNumber.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid IssuerAndSerialNumber");
    }

    public static IssuerAndSerialNumber newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IssuerAndSerialNumber) {
            return new IssuerAndSerialNumber((IssuerAndSerialNumber)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new IssuerAndSerialNumber((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return IssuerAndSerialNumber.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid IssuerAndSerialNumber");
    }

    public X509Name getIssuer() {
        return this.issuer;
    }

    private void setIssuer(X509Name x509Name) {
        this.issuer = x509Name;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber.getValue();
    }

    private void setSerialNumber(BigInteger bigInteger) {
        this.serialNumber = new DERInteger(bigInteger);
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.issuer);
        bERConstructedSequence.addObject(this.serialNumber);
        return bERConstructedSequence;
    }
}

