/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;

public class BERInputStream
extends DERInputStream {
    private DERObject END_OF_STREAM = new DERObject(){

        void encode(DEROutputStream dEROutputStream) throws IOException {
            throw new IOException("Eeek!");
        }
    };

    public BERInputStream(InputStream inputStream) {
        super(inputStream);
    }

    private byte[] readIndefiniteLengthFully() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = this.read();
        while ((n = this.read()) >= 0) {
            if (n2 == 0 && n == 0) break;
            byteArrayOutputStream.write(n2);
            n2 = n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private BERConstructedOctetString buildConstructedOctetString(DEROctetString dEROctetString, DEROctetString dEROctetString2) throws IOException {
        DERObject dERObject;
        Vector<DERObject> vector = new Vector<DERObject>();
        if (dEROctetString != null) {
            vector.addElement(dEROctetString);
            vector.addElement(dEROctetString2);
        }
        while ((dERObject = this.readObject()) != this.END_OF_STREAM) {
            vector.addElement(dERObject);
        }
        return new BERConstructedOctetString(vector);
    }

    public DERObject readObject() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        int n2 = this.readLength();
        if (n2 < 0) {
            switch (n) {
                case 5: {
                    return null;
                }
                case 48: {
                    DERObject dERObject;
                    BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
                    while ((dERObject = this.readObject()) != this.END_OF_STREAM) {
                        bERConstructedSequence.addObject(dERObject);
                    }
                    return bERConstructedSequence;
                }
                case 36: {
                    return this.buildConstructedOctetString(null, null);
                }
            }
            if ((n & 0xA0) != 0) {
                BERTaggedObject bERTaggedObject = new BERTaggedObject(n & 0xF, this.readObject());
                DERObject dERObject = this.readObject();
                if (dERObject == this.END_OF_STREAM) {
                    return bERTaggedObject;
                }
                if (dERObject instanceof DEROctetString && bERTaggedObject.getObject() instanceof DEROctetString) {
                    bERTaggedObject = new BERTaggedObject(false, n & 0xF, this.buildConstructedOctetString((DEROctetString)bERTaggedObject.getObject(), (DEROctetString)dERObject));
                    return bERTaggedObject;
                }
                throw new IOException("truncated tagged object");
            }
            byte[] byArray = this.readIndefiniteLengthFully();
            return this.buildObject(n, byArray);
        }
        if (n == 0 && n2 == 0) {
            return this.END_OF_STREAM;
        }
        byte[] byArray = new byte[n2];
        this.readFully(byArray);
        return this.buildObject(n, byArray);
    }
}

