/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;

public class BERConstructedOctetString
extends DEROctetString {
    private Vector octs;

    private static byte[] toBytes(Vector vector) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n != vector.size()) {
            DEROctetString dEROctetString = (DEROctetString)vector.elementAt(n);
            try {
                byteArrayOutputStream.write(dEROctetString.getOctets());
            }
            catch (IOException iOException) {
                throw new RuntimeException("exception converting octets " + iOException.toString());
            }
            ++n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public BERConstructedOctetString(byte[] byArray) {
        super(byArray);
    }

    public BERConstructedOctetString(Vector vector) {
        super(BERConstructedOctetString.toBytes(vector));
        this.octs = vector;
    }

    public BERConstructedOctetString(DERObject dERObject) {
        super(dERObject);
    }

    public BERConstructedOctetString(DEREncodable dEREncodable) {
        super(dEREncodable.getDERObject());
    }

    public byte[] getOctets() {
        return this.string;
    }

    public Vector getDEROctets() {
        if (this.octs == null) {
            this.octs = this.generateOcts();
        }
        return this.octs;
    }

    private Vector generateOcts() {
        int n;
        byte[] byArray;
        int n2 = 0;
        int n3 = 0;
        Vector<DEROctetString> vector = new Vector<DEROctetString>();
        while (n3 < this.string.length) {
            if (n3 + 1 < this.string.length && this.string[n3] == 0 && this.string[n3 + 1] == 0) {
                byArray = new byte[n3 - n2 + 1];
                n = 0;
                while (n != byArray.length) {
                    byArray[n] = this.string[n2 + n];
                    ++n;
                }
                vector.addElement(new DEROctetString(byArray));
                n2 = n3 + 1;
            }
            ++n3;
        }
        byArray = new byte[n3 - n2];
        n = 0;
        while (n != byArray.length) {
            byArray[n] = this.string[n2 + n];
            ++n;
        }
        vector.addElement(new DEROctetString(byArray));
        return vector;
    }

    public void encode(DEROutputStream dEROutputStream) throws IOException {
        if (dEROutputStream instanceof BEROutputStream) {
            dEROutputStream.write(36);
            dEROutputStream.write(128);
            if (this.octs == null) {
                this.octs = this.generateOcts();
            }
            int n = 0;
            while (n != this.octs.size()) {
                dEROutputStream.writeObject(this.octs.elementAt(n));
                ++n;
            }
            dEROutputStream.write(0);
            dEROutputStream.write(0);
        } else {
            super.encode(dEROutputStream);
        }
    }
}

