/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.settings;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.SyncAdapter;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.to.BluVaultTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPrivacyGateway {
    private static final Logger logger = LoggerFactory.getLogger(GetPrivacyGateway.class);
    static SyncAdapter syncAdapter = new SyncAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());

    private GetPrivacyGateway() {
    }

    public static String getPrivacyGatewayIP() {
        List<BluVaultTO> gatewayList = GetPrivacyGateway.getBluKryptsFromPropertyFile(PropertyHelper.BKRYPT_DOMAIN_FOR_SYNC);
        ArrayList<Long> minimumTime = new ArrayList<Long>();
        int count = 0;
        ArrayList<BluVaultTO> removeGatewayList = new ArrayList<BluVaultTO>();
        if (gatewayList != null && !gatewayList.isEmpty()) {
            for (BluVaultTO gatewayTO : gatewayList) {
                int response;
                logger.debug("Gateway is:" + gatewayTO.getBluVaultName());
                long beforeTime = System.currentTimeMillis();
                try {
                    response = syncAdapter.pingGatewayIP(gatewayTO.getBluVaultName());
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    logger.error("Error in ping privacy gateway" + e.getMessage());
                    removeGatewayList.add(gatewayTO);
                    continue;
                }
                if (response == 200) {
                    long totalHitTime = System.currentTimeMillis() - beforeTime;
                    gatewayTO.setHitTime(totalHitTime);
                    minimumTime.add(totalHitTime);
                    if (++count <= 4) continue;
                    break;
                }
                logger.error("Error in ping privacy gateway");
                removeGatewayList.add(gatewayTO);
            }
            for (BluVaultTO gatewayTO : removeGatewayList) {
                gatewayList.remove(gatewayTO);
            }
            logger.debug("Gateway size after ping:" + gatewayList.size());
            Collections.sort(minimumTime);
            for (BluVaultTO gatewayTO : gatewayList) {
                if (gatewayTO.getHitTime() != ((Long)minimumTime.get(0)).longValue()) continue;
                return gatewayTO.getBluVaultName();
            }
        }
        return null;
    }

    private static List<BluVaultTO> getBluKryptsFromPropertyFile(String bluKryptString) {
        ArrayList<BluVaultTO> bluKryptList = new ArrayList<BluVaultTO>();
        if (!StringUtils.isEmpty((String)bluKryptString)) {
            String[] bkIPStrings = bluKryptString.split(",");
            logger.debug("Length of the ipList is:" + bkIPStrings.length);
            for (int i = 0; i < bkIPStrings.length; ++i) {
                BluVaultTO bluVaultTO = new BluVaultTO();
                bluVaultTO.setBluVaultName(bkIPStrings[i]);
                bluKryptList.add(bluVaultTO);
            }
        }
        return bluKryptList;
    }
}

