/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.settings;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import com.parablu.epa.helper.utils.RegistryUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupHelper {
    private static Logger logger = LoggerFactory.getLogger(BackupHelper.class);
    private static Map<String, Boolean> snapshotDetails = new HashMap<String, Boolean>();
    private static BackUpFolderDAOImpl backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());

    public static String getParabluInstallDirectory() {
        String basePath = SettingHelper.getOsName().toLowerCase().contains("win") ? SettingHelper.getParabluBlusyncAppDataFolderUrl() : SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + ".ParaBlu" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Blusync";
        return basePath;
    }

    public static void deleteContentOfFailedfilesLog() throws FileNotFoundException {
        String basePath = BackupHelper.getParabluInstallDirectory();
        File logFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "failedFile.csv");
        if (logFile.exists()) {
            PrintWriter writer = new PrintWriter(logFile);
            writer.print("");
            writer.close();
        }
    }

    public static File getFailedFilesLogFile() throws IOException, FileNotFoundException {
        File file;
        String basePath = BackupHelper.getParabluInstallDirectory();
        File logFile = new File(basePath + StringLiterals.FILE_SEPARATOR + "failedFile.csv");
        File logZip = new File(basePath + StringLiterals.FILE_SEPARATOR + "failedFilesLogs.zip");
        if (logZip.exists()) {
            logZip.delete();
        }
        if (logFile.length() <= 0L) {
            logger.debug("file content is null");
            return null;
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(logZip));
        try {
            logZip.createNewFile();
            BackupHelper.addEntryToZip(logFile, zipOutputStream);
            IOUtils.closeQuietly((OutputStream)zipOutputStream);
            file = logZip;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error("IOException while entering to zip", (Throwable)e);
                return null;
            }
        }
        zipOutputStream.close();
        return file;
    }

    public static void addEntryToZip(File logFile, ZipOutputStream zipOutputStream) throws IOException {
        if (logFile.exists()) {
            ZipEntry zipEntry = new ZipEntry(logFile.getName());
            zipOutputStream.putNextEntry(zipEntry);
            FileInputStream fileInputStream = new FileInputStream(logFile);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
            fileInputStream.close();
            zipOutputStream.closeEntry();
        }
    }

    public static Set<String> getDriveSet(List<BackupFolderTO> listOfFolder) {
        HashSet<String> driveSet = new HashSet<String>();
        if (listOfFolder != null && !listOfFolder.isEmpty()) {
            for (int i = 0; i < listOfFolder.size(); ++i) {
                try {
                    BackupFolderTO backupFolderTO = listOfFolder.get(i);
                    String filePath = backupFolderTO.getFolderPath();
                    String drive = filePath.substring(0, 1);
                    logger.debug("Drives for snapshot:" + drive);
                    driveSet.add(drive.toLowerCase());
                    continue;
                }
                catch (Exception e) {
                    logger.debug("Exception in creating snap shot:", (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
        return driveSet;
    }

    public static void createTargets(Set<String> driveSet, String crwalTime) {
        Iterator<String> iterator = driveSet.iterator();
        long crwalTimeStamp = 0L;
        if (StringUtils.isNotEmpty((String)crwalTime)) {
            crwalTimeStamp = Long.valueOf(crwalTime);
        }
        while (iterator.hasNext()) {
            String drive = iterator.next();
            Object fileSnapshotPath = ParabluFileSystemUtils.getOldInstallationDir();
            if (StringUtils.equalsIgnoreCase((String)fileSnapshotPath, (String)"null")) {
                fileSnapshotPath = ParabluFileSystemUtils.getInstallationDir();
            }
            fileSnapshotPath = (String)fileSnapshotPath + StringLiterals.CONSTANTS_FILE_SEPARATOR + "Snapshots" + StringLiterals.CONSTANTS_FILE_SEPARATOR + drive + "_drive";
            logger.debug((String)fileSnapshotPath + ".....");
            File f = new File((String)fileSnapshotPath);
            long mondifiedTimeForSnapShot = f.lastModified();
            logger.debug(mondifiedTimeForSnapShot + "....mondifiedTime...");
            if (mondifiedTimeForSnapShot >= crwalTimeStamp) {
                snapshotDetails.put(drive, true);
                continue;
            }
            snapshotDetails.put(drive, false);
        }
    }

    public static boolean validateNetworks() {
        boolean validNetwork = false;
        try {
            String networkNames = backUpFolderDAOImpl.getAllNetworkSettings();
            logger.debug("inside validateNetworks" + networkNames);
            if (StringUtils.isEmpty((String)networkNames)) {
                return true;
            }
            String ethernetStatus = BackupHelper.getEthernetStatus();
            if (!ethernetStatus.isEmpty()) {
                return true;
            }
            String connectedNetworkname = BackupHelper.getConnectedWiFiName();
            if (StringUtils.isEmpty((String)connectedNetworkname)) {
                return false;
            }
            String[] networks = networkNames.split("\\s*,\\s*");
            logger.debug("connected Networkname.." + connectedNetworkname);
            for (String networkName : networks) {
                if (!connectedNetworkname.equalsIgnoreCase(networkName)) continue;
                logger.debug("networkName.." + networkName);
                return true;
            }
        }
        catch (Exception e) {
            logger.error("error to validate network.." + e.getMessage());
        }
        return validNetwork;
    }

    private static String getEthernetStatus() throws Exception {
        String command = "ifconfig en0 | grep inet | awk '{print $2}'";
        return BackupHelper.executeCommand(command);
    }

    private static String executeCommand(String command) throws Exception {
        String line;
        StringBuilder output = new StringBuilder();
        Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            output.append(line);
        }
        reader.close();
        return output.toString().trim();
    }

    public static String getConnectedWiFiName() {
        String wifiName = "";
        try {
            String[] cmd = new String[]{"networksetup", "-getairportnetwork", "en1"};
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            if (line != null && line.contains(": ")) {
                wifiName = line.split(": ")[1];
            }
            reader.close();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                System.err.println("Command exited with error code " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return wifiName;
    }

    public static boolean isCurrentpolicyActive() {
        BackupPolicyTO currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
        boolean isCurrentpolicyActive = true;
        if (currentPolicy != null) {
            logger.debug("currentPolicy is active ...." + currentPolicy.isActive());
            isCurrentpolicyActive = currentPolicy.isActive();
        }
        return isCurrentpolicyActive;
    }

    public static String getbackupTypeFromRegedit() {
        String backupType = "INCREMENTAL";
        if (SettingHelper.getOsName().toLowerCase().contains("win")) {
            try {
                backupType = RegistryUtils.getRegistryValue((String)"HKCU", (String)"Software\\ParaBlu\\BluSync", (String)"backupType");
            }
            catch (Exception e) {
                logger.debug("exception getting sleeptime from reg edit:" + e);
            }
            if (StringUtils.isNotEmpty((String)backupType)) {
                return backupType;
            }
            return "INCREMENTAL";
        }
        return backupType;
    }

    public static void setFullBackupFlagInReg(String backupType) {
        try {
            if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                try {
                    RegistryUtils.setRegistryValue((String)"HKCU", (String)"Software\\ParaBlu\\BluSync", (String)"backupType", (String)backupType);
                }
                catch (Exception e) {
                    logger.debug("exception setting backupType to regedit:" + e);
                }
            }
        }
        catch (TransformerFactoryConfigurationError e) {
            logger.error("errorr...setFullBackupFlagInReg........", (Throwable)e);
            logger.error("errorr...setFullBackupFlagInReg........", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static void updateplist(String plistFileLoc, String updateString) throws TransformerFactoryConfigurationError {
        try {
            logger.debug("plist file location:" + plistFileLoc + " Update string:" + updateString);
            File file = new File(plistFileLoc);
            NSDictionary rootDict = (NSDictionary)PropertyListParser.parse((File)file);
            NSString psDict = (NSString)rootDict.objectForKey("BackupType");
            psDict.setContent(updateString);
            PropertyListParser.saveAsXML((NSObject)rootDict, (File)new File(plistFileLoc));
        }
        catch (Exception ex) {
            logger.error("exception when updating the plist file:", (Throwable)ex);
        }
    }

    public static boolean getallFilesfromBlusync() {
        try {
            String basepath = BackupHelper.getParabluInstallDirectory();
            File blusyncFolder = new File(basepath);
            File logZip = new File(basepath + StringLiterals.FILE_SEPARATOR + "blusync.zip");
            if (logZip.exists()) {
                logZip.delete();
            }
            logZip.createNewFile();
            logger.debug("............." + blusyncFolder.getAbsolutePath());
            FileOutputStream fos = new FileOutputStream(logZip);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fos);
            BackupHelper.addDirToZipArchive(zipOutputStream, blusyncFolder, null);
            IOUtils.closeQuietly((OutputStream)zipOutputStream);
        }
        catch (Exception e) {
            logger.error("IOException while entering to zip", (Throwable)e);
            return false;
        }
        return true;
    }

    public static void addDirToZipArchive(ZipOutputStream zos, File fileToZip, String parrentDirectoryName) throws Exception {
        if (fileToZip == null || !fileToZip.exists()) {
            return;
        }
        Object zipEntryName = fileToZip.getName();
        if (parrentDirectoryName != null && !parrentDirectoryName.isEmpty()) {
            zipEntryName = parrentDirectoryName + StringLiterals.FILE_SEPARATOR + fileToZip.getName();
        }
        if (fileToZip.isDirectory()) {
            System.out.println("+" + (String)zipEntryName);
            for (File file : fileToZip.listFiles()) {
                BackupHelper.addDirToZipArchive(zos, file, (String)zipEntryName);
            }
        } else if (!fileToZip.getName().equalsIgnoreCase("blusync.zip") && !fileToZip.getName().equalsIgnoreCase("ParabluMain.lock")) {
            System.out.println("   " + (String)zipEntryName);
            FileInputStream fis = new FileInputStream(fileToZip);
            zos.putNextEntry(new ZipEntry((String)zipEntryName));
            IOUtils.copy((InputStream)fis, (OutputStream)zos);
            fis.close();
            zos.closeEntry();
        }
    }
}

