/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.dao.RestoreDAO;
import com.parablu.epa.core.element.RestoreElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreDAOImpl
extends BaseDAO
implements RestoreDAO {
    private Logger logger = LoggerFactory.getLogger(RestoreDAOImpl.class);
    private static final String DELETEFROM = "delete from ";

    public RestoreDAOImpl(String uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createRestoreTable() {
        RestoreDAOImpl restoreDAOImpl = this;
        synchronized (restoreDAOImpl) {
            String query = BluSyncSQLConstants.createRestoreTable();
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(query);
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    exception.printStackTrace();
                    this.logger.error("sql exception creating restore  table.." + exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertIntoRestoreTable(List<RestoreElement> fileList) {
        RestoreDAOImpl restoreDAOImpl = this;
        synchronized (restoreDAOImpl) {
            String query = "insert into Restore(filepath,restoreDestPath,status,selectedDevicepath) values(?,?,?,?);";
            boolean success = false;
            this.statement = null;
            int recordCount = 0;
            int listsize = fileList.size();
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("insert into Restore(filepath,restoreDestPath,status,selectedDevicepath) values(?,?,?,?);");
                    this.conn.setAutoCommit(false);
                    if (listsize != 0) {
                        for (RestoreElement restoreElement : fileList) {
                            ++recordCount;
                            this.statement.setString(1, restoreElement.getDevicePath());
                            this.statement.setString(2, restoreElement.getDestinationPath());
                            this.statement.setString(3, "status");
                            this.statement.setString(4, restoreElement.getSelectedDevicePath());
                            this.statement.addBatch();
                            if (recordCount % 50 != 0) continue;
                            this.logger.debug("Inside recordCount reach 50...");
                            this.statement.executeBatch();
                            this.statement.clearBatch();
                        }
                    }
                    this.statement.executeBatch();
                    this.conn.commit();
                    this.closeConnection();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("sql exception inserting restore table..," + exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RestoreElement> getRestoreFilepath() {
        RestoreDAOImpl restoreDAOImpl = this;
        synchronized (restoreDAOImpl) {
            String query = "select * from Restore";
            ArrayList<RestoreElement> files = null;
            this.statement = null;
            ResultSet resultSet = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("select * from Restore");
                    resultSet = this.statement.executeQuery();
                    files = new ArrayList<RestoreElement>();
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            RestoreElement element = new RestoreElement();
                            String filePath = resultSet.getString("filepath");
                            String selectedDevicePath = resultSet.getString("selectedDevicepath");
                            String destPath = resultSet.getString("restoreDestPath");
                            element.setDevicePath(filePath);
                            element.setSelectedDevicePath(selectedDevicePath);
                            element.setDestinationPath(destPath);
                            files.add(element);
                        }
                    }
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while selcting from backup", (Throwable)exception);
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            this.logger.error("SQLException while closing result set for geting folders to backup" + e);
                        }
                    }
                    this.closeConnection();
                }
            }
            return files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearEntireRestoreTable() {
        RestoreDAOImpl restoreDAOImpl = this;
        synchronized (restoreDAOImpl) {
            String query = "delete from Restore";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("delete from Restore");
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while deleting from restore table", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }
}

