/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.SQLiteConfig;

public abstract class BaseDAO {
    private Logger logger = LoggerFactory.getLogger(BaseDAO.class);
    private static final int MAX_CONNECTIONS = 1;
    private int numOfConnections = 0;
    private static final String SQLITE_JDBC_DRIVERNAME = "org.sqlite.JDBC";
    private static final String SQLITE_JDBC = "jdbc:sqlite:";
    private static final String CLASSNOTFOUNDEXCEPTION = "ClassNotFoundException";
    protected Connection conn;
    protected PreparedStatement statement = null;
    protected final String connectionURL;

    public BaseDAO(String uRL) {
        this.connectionURL = uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getConnectionForWALMode() {
        boolean success = false;
        Statement sttment = null;
        if (this.numOfConnections < 1) {
            try {
                Class.forName(SQLITE_JDBC_DRIVERNAME);
                this.conn = DriverManager.getConnection(SQLITE_JDBC + this.connectionURL);
                sttment = this.conn.createStatement();
                sttment.execute("pragma journal_mode = WAL;");
                ++this.numOfConnections;
                success = true;
            }
            catch (ClassNotFoundException e) {
                this.logger.error("ClassNotFoundException while geting Connection For Creating Database" + e);
                success = false;
            }
            catch (SQLException e) {
                this.logger.error("SQLException while geting Connection For Creating Database" + e);
                success = false;
            }
            finally {
                if (sttment != null) {
                    try {
                        sttment.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while geting Connection For Creating Database" + e);
                    }
                }
            }
        }
        return success;
    }

    protected boolean getConnectionForCreatingDatabase() {
        boolean success = false;
        if (this.numOfConnections < 1) {
            try {
                Class.forName(SQLITE_JDBC_DRIVERNAME);
                SQLiteConfig config = new SQLiteConfig();
                config.setDefaultCacheSize(10000);
                config.setPageSize(4096);
                config.setSynchronous(SQLiteConfig.SynchronousMode.NORMAL);
                this.conn = DriverManager.getConnection(SQLITE_JDBC + this.connectionURL);
                ++this.numOfConnections;
                success = true;
            }
            catch (ClassNotFoundException e) {
                this.logger.error("ClassNotFoundException while geting Connection For Creating Database" + e);
                success = false;
            }
            catch (SQLException e) {
                this.logger.error("SQLException whiel get Connection For Creating Database" + e);
                success = false;
            }
        }
        return success;
    }

    protected boolean getConnectionForCreatingDatabase(String newConURL) {
        boolean success = false;
        if (this.numOfConnections < 1) {
            try {
                Class.forName(SQLITE_JDBC_DRIVERNAME);
                SQLiteConfig config = new SQLiteConfig();
                config.setDefaultCacheSize(10000);
                config.setPageSize(4096);
                config.setSynchronous(SQLiteConfig.SynchronousMode.NORMAL);
                this.conn = DriverManager.getConnection(SQLITE_JDBC + newConURL);
                ++this.numOfConnections;
                success = true;
            }
            catch (ClassNotFoundException e) {
                this.logger.error(CLASSNOTFOUNDEXCEPTION + e);
                success = false;
            }
            catch (SQLException e) {
                this.logger.error("SQLException while geting Connection For Creating Database(x)" + e);
                success = false;
            }
        }
        return success;
    }

    protected boolean getConnection() {
        boolean success = false;
        if (this.numOfConnections < 1) {
            try {
                Class.forName(SQLITE_JDBC_DRIVERNAME);
                this.conn = DriverManager.getConnection(SQLITE_JDBC + this.connectionURL);
                ++this.numOfConnections;
                success = true;
            }
            catch (ClassNotFoundException e) {
                this.logger.error(CLASSNOTFOUNDEXCEPTION + e);
                success = false;
            }
            catch (Exception e) {
                this.logger.error("SQLException while geting Connection" + e);
                success = false;
            }
        }
        return success;
    }

    protected boolean getConnection(String newConURL) {
        boolean success = false;
        if (this.numOfConnections < 1) {
            try {
                Class.forName(SQLITE_JDBC_DRIVERNAME);
                this.conn = DriverManager.getConnection(SQLITE_JDBC + newConURL);
                ++this.numOfConnections;
                success = true;
            }
            catch (ClassNotFoundException e) {
                this.logger.error(CLASSNOTFOUNDEXCEPTION + e);
                success = false;
            }
            catch (SQLException e) {
                this.logger.error("SQLException while geting Connection with new url" + e);
                success = false;
            }
        }
        return success;
    }

    protected void closeConnection() {
        if (this.numOfConnections > 0) {
            --this.numOfConnections;
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException " + e);
                this.logger.error("Exception", (Throwable)e);
            }
            finally {
                this.statement = null;
            }
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while closing Connection" + e);
            }
            finally {
                this.conn = null;
            }
        }
    }
}

