/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper;

import com.parablu.epa.common.dao.BackupCrawlDAOImpl;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.helper.enumeration.BackupFoldersToBeSkipped;
import com.parablu.epa.core.to.FileTO;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupCrawlUtility {
    private Logger logger = LoggerFactory.getLogger(BackupCrawlUtility.class);
    private static final String MAC = "Macintosh";
    private int lastSuccessfulCrawledTime = 0;
    BackupCrawlDAOImpl backupCrawlDAOImpl = new BackupCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());

    public void crawlFolderEfficientStoringFullPaths(String completeParentPath, Map<String, Long> fileHashMap) {
        Boolean checkList = true;
        String fullParentPath = this.checkForMacBasePath(completeParentPath);
        File currentFolder = new File(fullParentPath);
        File[] childFileAndFolderNames = currentFolder.listFiles();
        if (childFileAndFolderNames == null) {
            return;
        }
        Arrays.sort(childFileAndFolderNames, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        if (fileHashMap == null || fileHashMap.isEmpty()) {
            checkList = false;
        }
        for (File currentProcessingFile : childFileAndFolderNames) {
            Long prevModifiedValue;
            if (currentProcessingFile.getName().startsWith(".pbsdn")) {
                currentProcessingFile.delete();
                continue;
            }
            boolean isfileHidden = "CHUNK".equals(currentProcessingFile.getName()) || currentProcessingFile.isHidden();
            boolean fileToBeSkipped = this.fileSkip(currentProcessingFile.getName());
            if (isfileHidden || fileToBeSkipped) continue;
            boolean isFileADirectory = currentProcessingFile.isDirectory();
            String absPath = currentProcessingFile.getAbsolutePath();
            if (checkList.booleanValue() && !isFileADirectory && (prevModifiedValue = fileHashMap.get(absPath)) != null && prevModifiedValue.equals(currentProcessingFile.lastModified())) continue;
            boolean success = this.backupCrawlDAOImpl.insertFileNameIntoTable(currentProcessingFile);
            this.logger.debug("after inserting crwawl table" + success);
            if (!isFileADirectory) continue;
            this.crawlFolderEfficientStoringFullPaths(currentProcessingFile.getAbsolutePath(), fileHashMap);
        }
    }

    private boolean fileSkip(String fileName) {
        for (BackupFoldersToBeSkipped.MacBackupFoldersToBeSkipped beSkipped : BackupFoldersToBeSkipped.MacBackupFoldersToBeSkipped.values()) {
            if (!beSkipped.value().equalsIgnoreCase(fileName) && !fileName.toLowerCase().startsWith(beSkipped.value().toLowerCase())) continue;
            this.logger.debug("*************************LIST OF FILES FROM ENUM SKIPPING FILE " + fileName);
            return true;
        }
        return false;
    }

    public List<FileTO> showFolderContent() {
        return new ArrayList<FileTO>();
    }

    public int getLastSuccessfulCrawledTime() {
        return this.lastSuccessfulCrawledTime;
    }

    private String checkForMacBasePath(String completeParentPath) {
        if (completeParentPath.startsWith(MAC + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(9);
        }
        return completeParentPath;
    }
}

