/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.ContentType;

public class EncapsulatedContentInfo
implements DEREncodable {
    private ContentType eContentType;
    private DEROctetString eContent;

    public EncapsulatedContentInfo(ContentType contentType, byte[] byArray) {
        this.setContentType(contentType);
        this.setContent(byArray);
    }

    public EncapsulatedContentInfo(BERConstructedSequence bERConstructedSequence) {
        this.eContentType = ContentType.getInstance(bERConstructedSequence.getObjectAt(0));
        if (bERConstructedSequence.getSize() > 1) {
            this.eContent = (DEROctetString)((BERTaggedObject)bERConstructedSequence.getObjectAt(1)).getObject();
        }
    }

    public EncapsulatedContentInfo(EncapsulatedContentInfo encapsulatedContentInfo) {
        this.eContentType = encapsulatedContentInfo.eContentType;
        this.eContent = encapsulatedContentInfo.eContent;
    }

    public static EncapsulatedContentInfo getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EncapsulatedContentInfo) {
            return (EncapsulatedContentInfo)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new EncapsulatedContentInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return EncapsulatedContentInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid EncapsulatedContentInfo");
    }

    public static EncapsulatedContentInfo newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EncapsulatedContentInfo) {
            return new EncapsulatedContentInfo((EncapsulatedContentInfo)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new EncapsulatedContentInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return EncapsulatedContentInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid EncapsulatedContentInfo");
    }

    public byte[] getContent() {
        return this.eContent.getOctets();
    }

    private void setContent(byte[] byArray) {
        this.eContent = new DEROctetString(byArray);
    }

    public ContentType getContentType() {
        return this.eContentType;
    }

    private void setContentType(ContentType contentType) {
        this.eContentType = contentType;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.eContentType);
        if (this.eContent != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(true, 0, this.eContent.getDERObject()));
        }
        return bERConstructedSequence;
    }
}

