/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import java.util.Enumeration;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x9.KeySpecificInfo;

public class OtherInfo
implements DEREncodable {
    private KeySpecificInfo keyInfo;
    private DEROctetString partyAInfo;
    private DEROctetString suppPubInfo;

    public OtherInfo(KeySpecificInfo keySpecificInfo, DEROctetString dEROctetString, DEROctetString dEROctetString2) {
        this.keyInfo = keySpecificInfo;
        this.partyAInfo = dEROctetString;
        this.suppPubInfo = dEROctetString2;
    }

    public OtherInfo(DERConstructedSequence dERConstructedSequence) {
        Enumeration enumeration = dERConstructedSequence.getObjects();
        this.keyInfo = new KeySpecificInfo((DERConstructedSequence)enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            DERTaggedObject dERTaggedObject = (DERTaggedObject)enumeration.nextElement();
            if (dERTaggedObject.getTagNo() == 0) {
                this.partyAInfo = (DEROctetString)dERTaggedObject.getObject();
                continue;
            }
            if (dERTaggedObject.getTagNo() != 2) continue;
            this.suppPubInfo = (DEROctetString)dERTaggedObject.getObject();
        }
    }

    public KeySpecificInfo getKeyInfo() {
        return this.keyInfo;
    }

    public DEROctetString getPartyAInfo() {
        return this.partyAInfo;
    }

    public DEROctetString getSuppPubInfo() {
        return this.suppPubInfo;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.keyInfo);
        if (this.partyAInfo != null) {
            dERConstructedSequence.addObject(new DERTaggedObject(0, this.partyAInfo));
        }
        dERConstructedSequence.addObject(new DERTaggedObject(2, this.suppPubInfo));
        return dERConstructedSequence;
    }
}

