/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.HashSet;
import java.util.Set;
import zmq.Address;
import zmq.Dealer;
import zmq.IEngine;
import zmq.IMsgSink;
import zmq.IMsgSource;
import zmq.IOObject;
import zmq.IOThread;
import zmq.IPollEvents;
import zmq.IpcConnecter;
import zmq.Msg;
import zmq.Options;
import zmq.Own;
import zmq.Pair;
import zmq.Pipe;
import zmq.Pub;
import zmq.Pull;
import zmq.Push;
import zmq.Rep;
import zmq.Req;
import zmq.Router;
import zmq.SocketBase;
import zmq.Sub;
import zmq.TcpConnecter;
import zmq.XPub;
import zmq.XSub;
import zmq.ZObject;

class SessionBase
extends Own
implements Pipe.IPipeEvents,
IPollEvents,
IMsgSink,
IMsgSource {
    private boolean connect;
    private Pipe pipe;
    private final Set<Pipe> terminatingPipes;
    private boolean incompleteIn;
    private boolean pending;
    private IEngine engine;
    protected SocketBase socket;
    private IOThread ioThread;
    private static final int LINGER_TIMER_ID = 32;
    private boolean hasLingerTimer;
    private boolean identitySent;
    private boolean identityReceived;
    private final Address addr;
    private IOObject ioObject;

    public static SessionBase create(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
        SessionBase s = null;
        switch (options.type) {
            case 3: {
                s = new Req.ReqSession(ioThread, connect, socket, options, addr);
                break;
            }
            case 5: {
                s = new Dealer.DealerSession(ioThread, connect, socket, options, addr);
                break;
            }
            case 4: {
                s = new Rep.RepSession(ioThread, connect, socket, options, addr);
                break;
            }
            case 6: {
                s = new Router.RouterSession(ioThread, connect, socket, options, addr);
                break;
            }
            case 1: {
                s = new Pub.PubSession(ioThread, connect, socket, options, addr);
                break;
            }
            case 9: {
                s = new XPub.XPubSession(ioThread, connect, socket, options, addr);
                break;
            }
            case 2: {
                s = new Sub.SubSession(ioThread, connect, socket, options, addr);
                break;
            }
            case 10: {
                s = new XSub.XSubSession(ioThread, connect, socket, options, addr);
                break;
            }
            case 8: {
                s = new Push.PushSession(ioThread, connect, socket, options, addr);
                break;
            }
            case 7: {
                s = new Pull.PullSession(ioThread, connect, socket, options, addr);
                break;
            }
            case 0: {
                s = new Pair.PairSession(ioThread, connect, socket, options, addr);
                break;
            }
            default: {
                throw new IllegalArgumentException("type=" + options.type);
            }
        }
        return s;
    }

    public SessionBase(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
        super(ioThread, options);
        this.ioObject = new IOObject(ioThread);
        this.connect = connect;
        this.pipe = null;
        this.incompleteIn = false;
        this.pending = false;
        this.engine = null;
        this.socket = socket;
        this.ioThread = ioThread;
        this.hasLingerTimer = false;
        this.identitySent = false;
        this.identityReceived = false;
        this.addr = addr;
        this.terminatingPipes = new HashSet<Pipe>();
    }

    @Override
    public void destroy() {
        assert (this.pipe == null);
        if (this.hasLingerTimer) {
            this.ioObject.cancelTimer(32);
            this.hasLingerTimer = false;
        }
        if (this.engine != null) {
            this.engine.terminate();
        }
    }

    public void attachPipe(Pipe pipe) {
        assert (!this.isTerminating());
        assert (this.pipe == null);
        assert (pipe != null);
        this.pipe = pipe;
        this.pipe.setEventSink(this);
    }

    @Override
    public Msg pullMsg() {
        if (!this.identitySent) {
            Msg msg = new Msg(this.options.identitySize);
            msg.put(this.options.identity, 0, this.options.identitySize);
            this.identitySent = true;
            this.incompleteIn = false;
            return msg;
        }
        if (this.pipe == null) {
            return null;
        }
        Msg msg = this.pipe.read();
        if (msg == null) {
            return null;
        }
        this.incompleteIn = msg.hasMore();
        return msg;
    }

    @Override
    public int pushMsg(Msg msg) {
        if (!this.identityReceived) {
            msg.setFlags(64);
            this.identityReceived = true;
            if (!this.options.recvIdentity) {
                return 0;
            }
        }
        if (this.pipe != null && this.pipe.write(msg)) {
            return 0;
        }
        return 35;
    }

    protected void reset() {
        this.identitySent = false;
        this.identityReceived = false;
    }

    public void flush() {
        if (this.pipe != null) {
            this.pipe.flush();
        }
    }

    private void cleanPipes() {
        if (this.pipe != null) {
            this.pipe.rollback();
            this.pipe.flush();
            while (this.incompleteIn) {
                Msg msg = this.pullMsg();
                if (msg != null) continue;
                assert (!this.incompleteIn);
                break;
            }
        }
    }

    @Override
    public void pipeTerminated(Pipe pipe) {
        assert (this.pipe == pipe || this.terminatingPipes.contains(pipe));
        if (this.pipe == pipe) {
            this.pipe = null;
            if (this.hasLingerTimer) {
                this.ioObject.cancelTimer(32);
                this.hasLingerTimer = false;
            }
        } else {
            this.terminatingPipes.remove(pipe);
        }
        if (this.pending && this.pipe == null && this.terminatingPipes.isEmpty()) {
            this.pending = false;
            super.processTerm(0);
        }
    }

    @Override
    public void readActivated(Pipe pipe) {
        if (this.pipe != pipe) {
            assert (this.terminatingPipes.contains(pipe));
            return;
        }
        if (this.engine != null) {
            this.engine.activateOut();
        } else {
            this.pipe.checkRead();
        }
    }

    @Override
    public void writeActivated(Pipe pipe) {
        if (this.pipe != pipe) {
            assert (this.terminatingPipes.contains(pipe));
            return;
        }
        if (this.engine != null) {
            this.engine.activateIn();
        }
    }

    @Override
    public void hiccuped(Pipe pipe) {
        throw new UnsupportedOperationException("Must Override");
    }

    public SocketBase getSocket() {
        return this.socket;
    }

    @Override
    protected void processPlug() {
        this.ioObject.setHandler(this);
        if (this.connect) {
            this.startConnecting(false);
        }
    }

    @Override
    protected void processAttach(IEngine engine) {
        assert (engine != null);
        if (this.pipe == null && !this.isTerminating()) {
            ZObject[] parents = new ZObject[]{this, this.socket};
            Pipe[] pipes = new Pipe[]{null, null};
            int[] hwms = new int[]{this.options.recvHwm, this.options.sendHwm};
            boolean[] delays = new boolean[]{this.options.delayOnClose, this.options.delayOnDisconnect};
            Pipe.pipepair(parents, pipes, hwms, delays);
            pipes[0].setEventSink(this);
            assert (this.pipe == null);
            this.pipe = pipes[0];
            this.sendBind(this.socket, pipes[1]);
        }
        assert (this.engine == null);
        this.engine = engine;
        this.engine.plug(this.ioThread, this);
    }

    public void detach() {
        this.engine = null;
        this.cleanPipes();
        this.detached();
        if (this.pipe != null) {
            this.pipe.checkRead();
        }
    }

    @Override
    protected void processTerm(int linger) {
        assert (!this.pending);
        if (this.pipe == null && this.terminatingPipes.isEmpty()) {
            super.processTerm(0);
            return;
        }
        this.pending = true;
        if (linger > 0) {
            assert (!this.hasLingerTimer);
            this.ioObject.addTimer(linger, 32);
            this.hasLingerTimer = true;
        }
        if (this.pipe != null) {
            this.pipe.terminate(linger != 0);
            this.pipe.checkRead();
        }
    }

    @Override
    public void timerEvent(int id) {
        assert (id == 32);
        this.hasLingerTimer = false;
        assert (this.pipe != null);
        this.pipe.terminate(false);
    }

    private void detached() {
        if (!this.connect) {
            this.terminate();
            return;
        }
        if (this.pipe != null && this.options.delayAttachOnConnect == 1 && !this.addr.protocol().equals("pgm") && !this.addr.protocol().equals("epgm")) {
            this.pipe.hiccup();
            this.pipe.terminate(false);
            this.terminatingPipes.add(this.pipe);
            this.pipe = null;
        }
        this.reset();
        if (this.options.reconnectIvl != -1) {
            this.startConnecting(true);
        }
        if (this.pipe != null && (this.options.type == 2 || this.options.type == 10)) {
            this.pipe.hiccup();
        }
    }

    private void startConnecting(boolean wait) {
        assert (this.connect);
        IOThread ioThread = this.chooseIoThread(this.options.affinity);
        assert (ioThread != null);
        if (this.addr.protocol().equals("tcp")) {
            TcpConnecter connecter = new TcpConnecter(ioThread, this, this.options, this.addr, wait);
            this.launchChild(connecter);
            return;
        }
        if (this.addr.protocol().equals("ipc")) {
            IpcConnecter connecter = new IpcConnecter(ioThread, this, this.options, this.addr, wait);
            this.launchChild(connecter);
            return;
        }
        assert (false);
    }

    public String toString() {
        return super.toString() + "[" + this.options.socketId + "]";
    }

    @Override
    public void inEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void outEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptEvent() {
        throw new UnsupportedOperationException();
    }
}

