/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.parablu.epa.common.service.backup.interfaces.CleanupInterface;
import com.parablu.epa.common.service.runnables.ChunkRunnable;
import com.parablu.epa.common.service.runnables.DelegateRunnable;
import com.parablu.epa.common.service.runnables.RestartRunnable;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.BackupElement;
import com.parablu.epa.core.helper.FileSizeBlockingQueue;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.ChunkFileTO;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.helper.about.SystemInfo;
import com.parablu.epa.helper.constant.GeneralHelperConstant;
import com.parablu.epa.helper.utils.MD5Generator;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiThreadResendFilesUpload
extends Thread {
    private Logger logger = LoggerFactory.getLogger(MultiThreadResendFilesUpload.class);
    private final List<BackupTO> uploadList;
    private final String keyStorePath;
    private String uploadIP;
    private final String cloudName;
    private Integer port;
    private final String token;
    private BackupAdapter backUpAdapter = null;
    private boolean isTerminated = false;
    private AtomicInteger uploadCount = new AtomicInteger(0);
    private GatewayTO uploadGatewayTo = null;
    private static String batchIdForBackup = "";
    BackupActivityTO backupActivityTO = null;
    BackupPolicyTO currentPolicy = null;
    private String requestURL = "/upload/files/rebkp";
    private String backupType = null;
    private int pftSize = 1;
    private boolean pftEnabled = true;
    private boolean isFullBackup;
    private AtomicLong totalUploadSize = new AtomicLong(0L);
    private static Logger failedFileLog = LoggerFactory.getLogger((String)"failedFileLogger");
    final FileSizeBlockingQueue<BackupTO> fileSizeBlockingQueue = new FileSizeBlockingQueue(50, 0x40000000L);
    ThreadFactoryBuilder factoryBuilder = new ThreadFactoryBuilder().setNameFormat("multipartupload-$$%d$$");
    ExecutorService multiPartUploadService = Executors.newFixedThreadPool(1, this.factoryBuilder.build());
    ExecutorService chunkService = Executors.newFixedThreadPool(10, this.factoryBuilder.build());
    final BlockingQueue<BackupTO> chunkFileQueue = new LinkedBlockingQueue<BackupTO>(500);
    final BlockingQueue<Future<BackupTO>> finishedBatchesQueue = new LinkedBlockingQueue<Future<BackupTO>>(2);
    final AtomicInteger noOfBatches = new AtomicInteger(0);
    final AtomicInteger chunkedFiles = new AtomicInteger(0);
    private AtomicBoolean loopFinished = new AtomicBoolean(false);
    private AtomicBoolean intrupted = new AtomicBoolean(false);
    private Timer backupWatchDogTimer = null;
    private TimerTask backupWatchDogTimerTask = null;
    ParabluFileSystemUtils fileSystemUtils = new ParabluFileSystemUtils();
    private Thread delegateThread = null;
    private Thread chunkDelegateThread = null;
    private Thread restartDelegateThread = null;
    private List<BackupTO> backupTOs = new ArrayList<BackupTO>();

    public MultiThreadResendFilesUpload(String iP, Integer port, String cn, String token, String keyStorePath, List<BackupTO> backupList) {
        this.keyStorePath = keyStorePath;
        this.uploadIP = iP;
        this.cloudName = cn;
        this.uploadList = backupList;
        this.backUpAdapter = new BackupAdapter(this.cloudName, keyStorePath);
        this.token = token;
        this.port = port;
    }

    @Override
    public void run() {
        RateLimiter rateLimiter;
        this.logger.debug("MULTI THREAD BACKUP UPLOAD STARTED");
        this.logger.info("token inside multithreadbackup upload" + this.token);
        this.logger.info("port inside multithreadbackup upload" + this.port);
        this.logger.info("uploadIP inside multithreadbackup upload" + this.uploadIP);
        this.logger.info("keystorepath inside multithreadbackup upload" + this.keyStorePath);
        this.logger.info("backupadapter inside multithreadbackup upload" + this.backUpAdapter);
        GatewayTO currentGatewayTo = null;
        this.loadCurrentBackupActivityAndBackupPolicy();
        if ((SettingHelper.getBackupLicenced().contentEquals("true") || "true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) && "true".equalsIgnoreCase(SettingHelper.getIsExternalStorageSelected())) {
            try {
                this.uploadGatewayTo = PolicyManagementServerHelper.getPrivacyGatewayIP(this.backupType, "BACKUP");
                if (this.uploadGatewayTo == null) {
                    this.logger.error("Error in get privacy gateway");
                    return;
                }
            }
            catch (Exception e) {
                this.logger.error("Error in get privacy gateway", (Throwable)e);
                return;
            }
            currentGatewayTo = this.uploadGatewayTo;
        }
        CleanupInterface<BackupTO> cleanupInterface = new CleanupInterface<BackupTO>(){

            @Override
            public void runCleanup(BackupTO backupTO, int status) {
            }

            @Override
            public void updateUIWrapper(BackupTO backupTO, int uploadCount, long totalUploadSize) {
            }

            @Override
            public void updateTooltipNotification(int failCode) {
            }

            @Override
            public void updateRestartId(long restartId) {
            }

            @Override
            public void updateTotalUploadSize() {
            }

            @Override
            public void updateErrorCode(int failCode) {
            }

            @Override
            public void updateBackupCrawlTable(List<BackupTO> backupTO) {
                MultiThreadResendFilesUpload.this.backupTOs.addAll(backupTO);
            }

            @Override
            public void updateChunkFileDetail(BackupTO backupTO, int uploadedChunkCount) {
            }

            @Override
            public void removeFailedBackupTOs(List<BackupTO> chunkFileBatch, List<BackupTO> failedBackupTOs) {
                Iterator<BackupTO> iter = chunkFileBatch.iterator();
                block0: while (iter.hasNext()) {
                    BackupTO to = iter.next();
                    for (BackupTO backupTo : failedBackupTOs) {
                        if (to.getRestartId() != backupTo.getRestartId()) continue;
                        iter.remove();
                        continue block0;
                    }
                }
            }
        };
        float networkThrottlrLimit = this.currentPolicy.getNetworkThrottleSpeed();
        if (networkThrottlrLimit <= 0.0f) {
            rateLimiter = RateLimiter.create((double)12800.0);
            this.logger.error("rate must be positive");
        } else {
            rateLimiter = RateLimiter.create((double)((double)(networkThrottlrLimit * 1024.0f) / 32.0));
            this.logger.debug("number of permits->" + (double)(networkThrottlrLimit * 1024.0f) / 32.0);
        }
        this.delegateThread = new Thread(new DelegateRunnable(this.chunkFileQueue, this.multiPartUploadService, currentGatewayTo, this.currentPolicy, this.uploadCount, batchIdForBackup, this.finishedBatchesQueue, this.noOfBatches, this.loopFinished, cleanupInterface, this.requestURL, rateLimiter, this.chunkService, this.intrupted, this.isFullBackup, this.totalUploadSize, ""));
        this.delegateThread.start();
        this.chunkDelegateThread = new Thread(new ChunkRunnable(this.chunkedFiles, this.fileSizeBlockingQueue, this.chunkFileQueue, this.loopFinished, this.intrupted));
        this.chunkDelegateThread.start();
        this.restartDelegateThread = new Thread(new RestartRunnable(this.noOfBatches, this.finishedBatchesQueue, this.uploadGatewayTo, batchIdForBackup, this.currentPolicy, this.delegateThread, this.chunkDelegateThread, this.intrupted, null));
        this.restartDelegateThread.start();
        this.startBackupWatchDog();
        for (BackupTO tempUploadFileTO : this.uploadList) {
            if (Thread.currentThread().isInterrupted() || this.intrupted.get()) {
                this.logger.debug("Backup upload thread got nudged>>>>>>>");
                this.delegateThread.interrupt();
                this.chunkDelegateThread.interrupt();
                break;
            }
            boolean currentFileChunkable = false;
            if (tempUploadFileTO == null) continue;
            try {
                tempUploadFileTO.setClientData(this.checkForMacBasePath(tempUploadFileTO.getAbstractFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + tempUploadFileTO.getFileName()));
                if (tempUploadFileTO.isFolder()) continue;
                if (!this.handleFileExist(ObjectUtils.getFileSnapshotPath((String)tempUploadFileTO.getClientData()))) {
                    this.logger.debug("File Not Found ..File name>>" + tempUploadFileTO.getClientData());
                    this.backupTOs.add(tempUploadFileTO);
                    continue;
                }
                if (this.isTerminated) break;
                this.pftSize = this.currentPolicy.getPftSize();
                this.pftEnabled = Boolean.parseBoolean(this.currentPolicy.getPftEnabled());
                this.logger.debug("ptf Enabled :" + this.pftEnabled);
                if (this.pftEnabled && this.pftSize != 0) {
                    currentFileChunkable = this.isFileChunkable(tempUploadFileTO, this.pftSize);
                }
                this.logger.debug("currentFileChunkable : " + currentFileChunkable);
                if (currentFileChunkable) {
                    String sourcePath = tempUploadFileTO.getClientData();
                    File file = null;
                    try {
                        file = new File(sourcePath);
                    }
                    catch (Exception e) {
                        this.logger.trace("" + e);
                        this.logger.error("File is not accessible" + e.getMessage() + "..File name>>" + tempUploadFileTO.getClientData());
                        failedFileLog.error(file.getAbsoluteFile() + ",File is not accessible");
                        this.backupTOs.add(tempUploadFileTO);
                        continue;
                    }
                    if (file == null) continue;
                    this.createDummyChunkFileList(tempUploadFileTO, file);
                    this.logger.debug("Queue size: " + this.fileSizeBlockingQueue.size() + " upload filesize: " + tempUploadFileTO.getFileSize());
                    this.putInFileSizeBlockingQueue(tempUploadFileTO);
                    this.chunkedFiles.incrementAndGet();
                    this.logger.debug("chunks: " + tempUploadFileTO.getChunkFileList().size());
                    continue;
                }
                this.putInSizeQueue(tempUploadFileTO);
            }
            catch (Exception e) {
                this.logger.error("Exception Occurred while backing up  file: ", (Throwable)e);
            }
        }
        try {
            this.sendDeletedFilesToServer();
            this.loopFinished.set(true);
            this.logger.debug("LOOP FINISHED");
            this.delegateThread.join();
            this.chunkDelegateThread.join();
            this.restartDelegateThread.join();
            this.backupWatchDogTimer.cancel();
            return;
        }
        catch (InterruptedException e) {
            this.interuptAllThreadAndShutdownServices(this.delegateThread, this.chunkDelegateThread, this.restartDelegateThread, this.backupTOs);
            return;
        }
    }

    private void createDummyChunkFileList(BackupTO tempUploadFileTO, File file) {
        this.logger.debug("Inside creating dammy chunk File List");
        ArrayList<ChunkFileTO> chunkFileTOs = new ArrayList<ChunkFileTO>();
        ChunkFileTO chunkFileTO = new ChunkFileTO();
        chunkFileTO.setFileName(file.getName());
        chunkFileTO.setFilePath(tempUploadFileTO.getClientData());
        chunkFileTO.setMd5Checksum(null);
        chunkFileTO.setChunkFileNames(null);
        chunkFileTOs.add(chunkFileTO);
        tempUploadFileTO.setChunkFileList(chunkFileTOs);
    }

    private void sendDeletedFilesToServer() {
        try {
            BackupElement backupElement = new BackupElement();
            backupElement.setBackupId(this.generateDeletedFilesIdString());
            this.logger.debug("before sending deleted files to server");
            this.backUpAdapter.sendDeletedFiles(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.readTokenFromFile(), CreateXmlObject.createBackupElementXml((BackupElement)backupElement));
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Error in send deleted files" + e);
        }
    }

    private void interuptAllThreadAndShutdownServices(Thread delegateThread, Thread chunkDelegateThread, Thread restartDelegateThread, List<BackupTO> backupTOs) {
        this.logger.debug(" Delegate Thread and chunk been NUDGED");
        if (delegateThread.isAlive() && !delegateThread.isInterrupted()) {
            delegateThread.interrupt();
        }
        if (chunkDelegateThread.isAlive() && !chunkDelegateThread.isInterrupted()) {
            chunkDelegateThread.interrupt();
        }
        if (restartDelegateThread.isAlive() && !restartDelegateThread.isInterrupted()) {
            restartDelegateThread.interrupt();
        }
        if (chunkDelegateThread.isAlive()) {
            chunkDelegateThread.stop();
        }
        if (restartDelegateThread.isAlive()) {
            restartDelegateThread.stop();
        }
        if (delegateThread.isAlive()) {
            delegateThread.stop();
        }
        if (this.chunkService != null && !this.chunkService.isShutdown()) {
            this.chunkService.shutdownNow();
        }
        if (this.multiPartUploadService != null && !this.multiPartUploadService.isShutdown()) {
            this.multiPartUploadService.shutdownNow();
        }
        boolean isTerminated1 = true;
        try {
            if (this.multiPartUploadService != null) {
                isTerminated1 = this.multiPartUploadService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            this.logger.debug("Nudged thread is TERMINATED : " + isTerminated1);
        }
        catch (InterruptedException e1) {
            this.logger.debug("Nudged thread is TERMINATED : " + isTerminated1, (Object)e1.getMessage());
        }
        this.backupWatchDogTimer.cancel();
    }

    private void putInFileSizeBlockingQueue(BackupTO tempUploadFileTO) {
        try {
            this.fileSizeBlockingQueue.put(tempUploadFileTO);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.trace("" + e);
            this.logger.error("error while adding file to filesize block queue" + e.getMessage());
        }
    }

    public static List<String> getExistingFileNames(String path, BackupTO backupTO) {
        File backupFile;
        File[] files;
        ArrayList<String> results = new ArrayList<String>();
        ArrayList<ChunkFileTO> chunkFileTOs = new ArrayList<ChunkFileTO>();
        if (!StringUtils.isEmpty((String)path) && (files = (backupFile = new File(path)).listFiles()) != null && files.length != 0) {
            Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
            for (File file : files) {
                if (!file.isFile()) continue;
                ChunkFileTO chunkFileTO = new ChunkFileTO();
                results.add(file.getName());
                String md5 = ParabluFileSystemUtils.getMd5FromFileName((String)file.getName());
                chunkFileTO.setFileName(file.getName());
                chunkFileTO.setFilePath(path.substring(0, path.length() - 1));
                chunkFileTO.setMd5Checksum(md5);
                chunkFileTO.setChunkFileNames(results);
                chunkFileTOs.add(chunkFileTO);
            }
        }
        backupTO.setChunkFileList(chunkFileTOs);
        for (ChunkFileTO chunkFileTO : chunkFileTOs) {
            chunkFileTO.setChunkFileNames(results);
        }
        return results;
    }

    private boolean isFileChunkable(BackupTO tempUploadFileTO, int pftSize) {
        boolean isChunkable = false;
        int chunkableSizeFromPolicy = this.getChunkableSize();
        File file = new File(tempUploadFileTO.getClientData());
        if (file.isDirectory()) {
            return isChunkable;
        }
        long fileSizeinBytes = file.length();
        float fileSizeinMb = (float)fileSizeinBytes / 1048576.0f;
        if (fileSizeinMb >= (float)pftSize && fileSizeinMb > (float)chunkableSizeFromPolicy) {
            isChunkable = true;
        }
        return isChunkable;
    }

    private int getChunkableSize() {
        int chunkableSizeFromPolicy = 4;
        if (this.currentPolicy != null) {
            chunkableSizeFromPolicy = this.currentPolicy.getChunkSize();
        }
        return chunkableSizeFromPolicy;
    }

    public double checkSystemUsage() {
        try {
            SystemInfo info = new SystemInfo();
            double percentage = info.getSystemMemory();
            this.logger.debug("System memory percentage is:" + percentage);
            return percentage;
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("error while checking the sytem usage" + e.getMessage());
            return 0.0;
        }
    }

    private String checkForMacBasePath(String completeParentPath) {
        String mac = "Macintosh";
        if (completeParentPath.startsWith("Macintosh" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(9);
        }
        if (completeParentPath.startsWith("ROOT" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(4);
        }
        return completeParentPath;
    }

    private void loadCurrentBackupActivityAndBackupPolicy() {
        batchIdForBackup = this.generateBatchID();
        this.currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
        if (this.currentPolicy != null) {
            this.logger.debug("CHUNK SIZE TO KEEP " + this.currentPolicy.getChunkSize());
            this.logger.debug("COMPRESSION ENABLED " + this.currentPolicy.isCompressionEnabled());
            this.logger.debug("NETWORK THROTTLE SPEED :" + this.currentPolicy.getNetworkThrottleSpeed());
            SettingHelper.setMaxVersionsToKeep(this.currentPolicy.getMaxVersions());
            if (this.currentPolicy.getChunkSize() == 0) {
                this.currentPolicy.setChunkSize(4);
            }
        }
    }

    public abstract void updateSystrayToolTipNotification(String var1, String var2);

    private BackupTO putInSizeQueue(BackupTO tempUploadFileTO) {
        String filePath = ObjectUtils.getFileSnapshotPath((String)tempUploadFileTO.getClientData());
        String md5Checksum = MD5Generator.generateMD5OfFile((File)new File(filePath));
        if (md5Checksum == null) {
            return null;
        }
        tempUploadFileTO.setMd5checksum(md5Checksum);
        ArrayList<ChunkFileTO> chunkFileList = new ArrayList<ChunkFileTO>();
        ChunkFileTO chunkFileTO = new ChunkFileTO();
        chunkFileTO.setFileName(tempUploadFileTO.getFileName());
        chunkFileTO.setFilePath(tempUploadFileTO.getAbstractFilePath());
        chunkFileTO.setMd5Checksum(tempUploadFileTO.getMd5checksum());
        chunkFileList.add(chunkFileTO);
        try {
            this.chunkFileQueue.put(tempUploadFileTO);
        }
        catch (InterruptedException e1) {
            this.logger.debug("Thread is interupted here so set boolean ingterupt to true>>>>>>");
            this.intrupted.set(true);
        }
        return tempUploadFileTO;
    }

    private boolean handleFileExist(String absPath) {
        File file = new File(absPath);
        if (!file.exists()) {
            this.logger.debug("File doesnt exist: " + file.getAbsolutePath());
            failedFileLog.error(file.getAbsoluteFile() + ",File doesnt exist");
            return false;
        }
        return true;
    }

    public void startBackupWatchDog() {
        if (this.backupWatchDogTimer == null) {
            this.backupWatchDogTimer = new Timer();
        }
        if (this.backupWatchDogTimerTask == null) {
            this.backupWatchDogTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (MultiThreadResendFilesUpload.this.intrupted.get()) {
                            MultiThreadResendFilesUpload.this.logger.debug("###############Inside thread nudged watch dog################");
                            MultiThreadResendFilesUpload.this.interuptAllThreadAndShutdownServices(MultiThreadResendFilesUpload.this.delegateThread, MultiThreadResendFilesUpload.this.chunkDelegateThread, MultiThreadResendFilesUpload.this.restartDelegateThread, MultiThreadResendFilesUpload.this.backupTOs);
                            MultiThreadResendFilesUpload.this.pauseBackup(false);
                        }
                    }
                    catch (Exception e) {
                        MultiThreadResendFilesUpload.this.logger.error("Error in Stop backup threads", (Throwable)e);
                    }
                }
            };
            this.backupWatchDogTimer.schedule(this.backupWatchDogTimerTask, 1L, 1L);
        }
    }

    private String generateBatchID() {
        StringBuilder completbatchID = new StringBuilder();
        completbatchID.append(SettingHelper.getDeviceUUId());
        completbatchID.append(SettingHelper.getUserName().toLowerCase());
        String completeUUIDString = completbatchID.toString().replace(' ', '_');
        return MD5Generator.generateMD5OfString((String)completeUUIDString);
    }

    private String generateDeletedFilesIdString() {
        String idString = "";
        String comma = "";
        if (this.backupTOs.isEmpty()) {
            this.logger.debug("backup to list is empty...so return empty string");
            return idString;
        }
        StringBuilder builder = new StringBuilder();
        for (BackupTO backupTO : this.backupTOs) {
            builder.append(comma);
            builder.append(backupTO.getBackupId());
            comma = ",";
        }
        idString = builder.toString();
        this.logger.debug("generated idlist string>>>" + idString);
        return idString;
    }

    public abstract void pauseBackup(boolean var1);
}

