/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.impl.internal.GraphNode;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GraphEdge
implements DependencyNode {
    private GraphNode source;
    private GraphNode target;
    private Dependency dependency;
    private String context;
    private String premanagedScope;
    private String premanagedVersion;
    private List<Artifact> relocations;
    private VersionConstraint versionConstraint;
    private Version version;

    public GraphEdge(GraphNode source, GraphNode target) {
        this.source = source;
        this.target = target;
    }

    public GraphNode getSource() {
        return this.source;
    }

    public GraphNode getTarget() {
        return this.target;
    }

    @Override
    public List<DependencyNode> getChildren() {
        return this.getTarget().getOutgoingEdges();
    }

    @Override
    public Dependency getDependency() {
        return this.dependency;
    }

    public void setDependency(Dependency dependency) {
        this.dependency = dependency;
    }

    @Override
    public void setArtifact(Artifact artifact) {
        this.dependency = this.dependency.setArtifact(artifact);
    }

    @Override
    public List<RemoteRepository> getRepositories() {
        return this.getTarget().getRepositories();
    }

    @Override
    public void setScope(String scope) {
        this.dependency = this.dependency.setScope(scope);
    }

    @Override
    public String getPremanagedScope() {
        return this.premanagedScope;
    }

    public void setPremanagedScope(String premanagedScope) {
        this.premanagedScope = premanagedScope;
    }

    @Override
    public String getPremanagedVersion() {
        return this.premanagedVersion;
    }

    public void setPremanagedVersion(String premanagedVersion) {
        this.premanagedVersion = premanagedVersion;
    }

    @Override
    public String getRequestContext() {
        return this.context;
    }

    @Override
    public void setRequestContext(String context) {
        this.context = context != null ? context : "";
    }

    @Override
    public List<Artifact> getRelocations() {
        return this.relocations;
    }

    public void setRelocations(List<Artifact> relocations) {
        this.relocations = relocations == null || relocations.isEmpty() ? Collections.emptyList() : relocations;
    }

    @Override
    public Collection<Artifact> getAliases() {
        return this.getTarget().getAliases();
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public void setVersionConstraint(VersionConstraint versionConstraint) {
        this.versionConstraint = versionConstraint;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public boolean accept(DependencyVisitor visitor) {
        block1: {
            if (!visitor.visitEnter(this)) break block1;
            for (DependencyNode child : this.getChildren()) {
                if (!child.accept(visitor)) break;
            }
        }
        return visitor.visitLeave(this);
    }

    public String toString() {
        return String.valueOf(this.getDependency());
    }
}

