/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.io.location;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.shared.io.location.Location;
import org.apache.maven.shared.io.location.LocatorStrategy;
import org.apache.maven.shared.io.logging.DefaultMessageHolder;
import org.apache.maven.shared.io.logging.MessageHolder;

public final class Locator {
    private List<LocatorStrategy> strategies;
    private final MessageHolder messageHolder;

    public Locator(List<LocatorStrategy> strategies, MessageHolder messageHolder) {
        this.messageHolder = messageHolder;
        this.strategies = new ArrayList<LocatorStrategy>(strategies);
    }

    public Locator() {
        this.messageHolder = new DefaultMessageHolder();
        this.strategies = new ArrayList<LocatorStrategy>();
    }

    public MessageHolder getMessageHolder() {
        return this.messageHolder;
    }

    public void addStrategy(LocatorStrategy strategy) {
        this.strategies.add(strategy);
    }

    public void removeStrategy(LocatorStrategy strategy) {
        this.strategies.remove(strategy);
    }

    public void setStrategies(List<LocatorStrategy> strategies) {
        this.strategies.clear();
        this.strategies.addAll(strategies);
    }

    public List<LocatorStrategy> getStrategies() {
        return this.strategies;
    }

    public Location resolve(String locationSpecification) {
        Location location = null;
        Iterator<LocatorStrategy> it = this.strategies.iterator();
        while (location == null && it.hasNext()) {
            LocatorStrategy strategy = it.next();
            location = strategy.resolve(locationSpecification, this.messageHolder);
        }
        return location;
    }
}

