/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ReactorModelPool;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.impl.ArtifactResolver;
import org.sonatype.aether.impl.RemoteRepositoryManager;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectModelResolver
implements ModelResolver {
    private final RepositorySystemSession session;
    private final String context = "project";
    private List<RemoteRepository> repositories;
    private List<RemoteRepository> pomRepositories;
    private final List<RemoteRepository> externalRepositories;
    private final ArtifactResolver resolver;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final Set<String> repositoryIds;
    private final ReactorModelPool modelPool;
    private final ProjectBuildingRequest.RepositoryMerging repositoryMerging;

    public ProjectModelResolver(RepositorySystemSession session, ArtifactResolver resolver, RemoteRepositoryManager remoteRepositoryManager, List<RemoteRepository> repositories, ProjectBuildingRequest.RepositoryMerging repositoryMerging, ReactorModelPool modelPool) {
        this.session = session;
        this.resolver = resolver;
        this.remoteRepositoryManager = remoteRepositoryManager;
        this.pomRepositories = new ArrayList<RemoteRepository>();
        this.externalRepositories = repositories;
        this.repositories = repositories;
        this.repositoryMerging = repositoryMerging;
        this.repositoryIds = new HashSet<String>();
        this.modelPool = modelPool;
    }

    private ProjectModelResolver(ProjectModelResolver original) {
        this.session = original.session;
        this.resolver = original.resolver;
        this.remoteRepositoryManager = original.remoteRepositoryManager;
        this.pomRepositories = original.pomRepositories;
        this.externalRepositories = original.externalRepositories;
        this.repositories = original.repositories;
        this.repositoryMerging = original.repositoryMerging;
        this.repositoryIds = new HashSet<String>(original.repositoryIds);
        this.modelPool = original.modelPool;
    }

    @Override
    public void addRepository(Repository repository) throws InvalidRepositoryException {
        if (!this.repositoryIds.add(repository.getId())) {
            return;
        }
        List<RemoteRepository> newRepositories = Collections.singletonList(ProjectModelResolver.convert(repository));
        if (ProjectBuildingRequest.RepositoryMerging.REQUEST_DOMINANT.equals((Object)this.repositoryMerging)) {
            this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.repositories, newRepositories, true);
        } else {
            this.pomRepositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.pomRepositories, newRepositories, true);
            this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.pomRepositories, this.externalRepositories, false);
        }
    }

    private static RemoteRepository convert(Repository repository) {
        RemoteRepository result = new RemoteRepository(repository.getId(), repository.getLayout(), repository.getUrl());
        result.setPolicy(true, ProjectModelResolver.convert(repository.getSnapshots()));
        result.setPolicy(false, ProjectModelResolver.convert(repository.getReleases()));
        return result;
    }

    private static org.sonatype.aether.repository.RepositoryPolicy convert(RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new org.sonatype.aether.repository.RepositoryPolicy(enabled, updates, checksums);
    }

    @Override
    public ModelResolver newCopy() {
        return new ProjectModelResolver(this);
    }

    @Override
    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        File pomFile = null;
        if (this.modelPool != null) {
            pomFile = this.modelPool.get(groupId, artifactId, version);
        }
        if (pomFile == null) {
            Artifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
            try {
                ArtifactRequest request = new ArtifactRequest(pomArtifact, this.repositories, "project");
                pomArtifact = this.resolver.resolveArtifact(this.session, request).getArtifact();
            }
            catch (ArtifactResolutionException e) {
                throw new UnresolvableModelException(e.getMessage(), groupId, artifactId, version, e);
            }
            pomFile = pomArtifact.getFile();
        }
        return new FileModelSource(pomFile);
    }
}

