/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.utils.markers;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.dependency.utils.markers.DefaultFileMarkerHandler;

public class SourcesFileMarkerHandler
extends DefaultFileMarkerHandler {
    boolean resolved;

    public SourcesFileMarkerHandler(File markerFilesDirectory) {
        super(markerFilesDirectory);
    }

    public SourcesFileMarkerHandler(Artifact artifact, File markerFilesDirectory, boolean isResolved) {
        super(artifact, markerFilesDirectory);
        this.resolved = isResolved;
    }

    @Override
    public File getMarkerFile() {
        return this.getMarkerFile(this.resolved);
    }

    protected File getMarkerFile(boolean res) {
        String suffix = res ? ".resolved" : ".unresolved";
        return new File(this.markerFilesDirectory, this.artifact.getId().replace(':', '-') + suffix);
    }

    @Override
    public boolean isMarkerSet() throws MojoExecutionException {
        File marker = this.getMarkerFile();
        File marker2 = this.getMarkerFile(!this.resolved);
        return marker.exists() || marker2.exists();
    }

    @Override
    public boolean isMarkerOlder(Artifact theArtifact) throws MojoExecutionException {
        File marker = this.getMarkerFile();
        if (marker.exists()) {
            return theArtifact.getFile().lastModified() > marker.lastModified();
        }
        marker = this.getMarkerFile(!this.resolved);
        if (marker.exists()) {
            return theArtifact.getFile().lastModified() > marker.lastModified();
        }
        return true;
    }

    @Override
    public void setMarker() throws MojoExecutionException {
        File marker = this.getMarkerFile();
        File clearMarker = this.getMarkerFile(!this.resolved);
        try {
            marker.getParentFile().mkdirs();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            marker.createNewFile();
            if (clearMarker.exists() && !clearMarker.delete()) {
                clearMarker.deleteOnExit();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create Marker: " + marker.getAbsolutePath(), e);
        }
    }

    @Override
    public boolean clearMarker() throws MojoExecutionException {
        File marker = this.getMarkerFile();
        File marker2 = this.getMarkerFile(!this.resolved);
        boolean markResult = marker.delete();
        boolean mark2Result = marker2.delete();
        return markResult || mark2Result;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean isResolved) {
        this.resolved = isResolved;
    }
}

