/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.fromConfiguration;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.AbstractDependencyMojo;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugins.dependency.fromConfiguration.ProcessArtifactItemsRequest;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.plugins.dependency.utils.filters.ArtifactItemFilter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.repository.RepositoryManager;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractFromConfigurationMojo
extends AbstractDependencyMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/dependency")
    private File outputDirectory;
    @Parameter(property="mdep.overWriteReleases", defaultValue="false")
    private boolean overWriteReleases;
    @Parameter(property="mdep.overWriteSnapshots", defaultValue="false")
    private boolean overWriteSnapshots;
    @Parameter(property="mdep.overIfNewer", defaultValue="true")
    private boolean overWriteIfNewer;
    @Parameter
    private List<ArtifactItem> artifactItems;
    @Parameter
    private File localRepositoryDirectory;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private RepositoryManager repositoryManager;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;

    abstract ArtifactItemFilter getMarkedArtifactFilter(ArtifactItem var1);

    protected void verifyRequirements() throws MojoFailureException {
        if (this.artifactItems == null || this.artifactItems.isEmpty()) {
            throw new MojoFailureException("Either artifact or artifactItems is required ");
        }
    }

    protected List<ArtifactItem> getProcessedArtifactItems(ProcessArtifactItemsRequest processArtifactItemsRequest) throws MojoExecutionException {
        boolean removeVersion = processArtifactItemsRequest.isRemoveVersion();
        boolean prependGroupId = processArtifactItemsRequest.isPrependGroupId();
        boolean useBaseVersion = processArtifactItemsRequest.isUseBaseVersion();
        boolean removeClassifier = processArtifactItemsRequest.isRemoveClassifier();
        if (this.artifactItems == null || this.artifactItems.size() < 1) {
            throw new MojoExecutionException("There are no artifactItems configured.");
        }
        for (ArtifactItem artifactItem : this.artifactItems) {
            this.getLog().info("Configured Artifact: " + artifactItem.toString());
            if (artifactItem.getOutputDirectory() == null) {
                artifactItem.setOutputDirectory(this.outputDirectory);
            }
            artifactItem.getOutputDirectory().mkdirs();
            if (StringUtils.isEmpty(artifactItem.getVersion())) {
                this.fillMissingArtifactVersion(artifactItem);
            }
            artifactItem.setArtifact(this.getArtifact(artifactItem));
            if (StringUtils.isEmpty(artifactItem.getDestFileName())) {
                artifactItem.setDestFileName(DependencyUtil.getFormattedFileName(artifactItem.getArtifact(), removeVersion, prependGroupId, useBaseVersion, removeClassifier));
            }
            try {
                artifactItem.setNeedsProcessing(this.checkIfProcessingNeeded(artifactItem));
            }
            catch (ArtifactFilterException e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        return this.artifactItems;
    }

    private boolean checkIfProcessingNeeded(ArtifactItem item) throws MojoExecutionException, ArtifactFilterException {
        return StringUtils.equalsIgnoreCase(item.getOverWrite(), "true") || this.getMarkedArtifactFilter(item).isArtifactIncluded(item);
    }

    protected Artifact getArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        Artifact artifact;
        try {
            ProjectBuildingRequest buildingRequest = this.newResolveArtifactProjectBuildingRequest();
            if (this.localRepositoryDirectory != null) {
                buildingRequest = this.repositoryManager.setLocalRepositoryBasedir(buildingRequest, this.localRepositoryDirectory);
            }
            DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
            coordinate.setGroupId(artifactItem.getGroupId());
            coordinate.setArtifactId(artifactItem.getArtifactId());
            coordinate.setVersion(artifactItem.getVersion());
            coordinate.setClassifier(artifactItem.getClassifier());
            ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(artifactItem.getType());
            String extension = artifactHandler != null ? artifactHandler.getExtension() : artifactItem.getType();
            coordinate.setExtension(extension);
            artifact = this.artifactResolver.resolveArtifact(buildingRequest, coordinate).getArtifact();
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException("Unable to find/resolve artifact.", e);
        }
        return artifact;
    }

    private void fillMissingArtifactVersion(ArtifactItem artifact) throws MojoExecutionException {
        List<Dependency> depMngt;
        MavenProject project = this.getProject();
        List<Dependency> deps = project.getDependencies();
        List<Dependency> list = depMngt = project.getDependencyManagement() == null ? Collections.emptyList() : project.getDependencyManagement().getDependencies();
        if (!(this.findDependencyVersion(artifact, deps, false) || project.getDependencyManagement() != null && this.findDependencyVersion(artifact, depMngt, false) || this.findDependencyVersion(artifact, deps, true) || project.getDependencyManagement() != null && this.findDependencyVersion(artifact, depMngt, true))) {
            throw new MojoExecutionException("Unable to find artifact version of " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " in either dependency list or in project's dependency management.");
        }
    }

    private boolean findDependencyVersion(ArtifactItem artifact, List<Dependency> dependencies, boolean looseMatch) {
        for (Dependency dependency : dependencies) {
            if (!StringUtils.equals(dependency.getArtifactId(), artifact.getArtifactId()) || !StringUtils.equals(dependency.getGroupId(), artifact.getGroupId()) || !looseMatch && !StringUtils.equals(dependency.getClassifier(), artifact.getClassifier()) || !looseMatch && !StringUtils.equals(dependency.getType(), artifact.getType())) continue;
            artifact.setVersion(dependency.getVersion());
            return true;
        }
        return false;
    }

    public List<ArtifactItem> getArtifactItems() {
        return this.artifactItems;
    }

    public void setArtifactItems(List<ArtifactItem> theArtifactItems) {
        this.artifactItems = theArtifactItems;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File theOutputDirectory) {
        this.outputDirectory = theOutputDirectory;
    }

    public boolean isOverWriteIfNewer() {
        return this.overWriteIfNewer;
    }

    public void setOverWriteIfNewer(boolean theOverWriteIfNewer) {
        this.overWriteIfNewer = theOverWriteIfNewer;
    }

    public boolean isOverWriteReleases() {
        return this.overWriteReleases;
    }

    public void setOverWriteReleases(boolean theOverWriteReleases) {
        this.overWriteReleases = theOverWriteReleases;
    }

    public boolean isOverWriteSnapshots() {
        return this.overWriteSnapshots;
    }

    public void setOverWriteSnapshots(boolean theOverWriteSnapshots) {
        this.overWriteSnapshots = theOverWriteSnapshots;
    }

    public void setLocalRepositoryDirectory(File localRepositoryDirectory) {
        this.localRepositoryDirectory = localRepositoryDirectory;
    }

    public void setArtifact(String artifact) throws MojoFailureException {
        if (artifact != null) {
            String packaging = "jar";
            String[] tokens = StringUtils.split(artifact, ":");
            if (tokens.length < 3 || tokens.length > 5) {
                throw new MojoFailureException("Invalid artifact, you must specify groupId:artifactId:version[:packaging[:classifier]] " + artifact);
            }
            String groupId = tokens[0];
            String artifactId = tokens[1];
            String version = tokens[2];
            if (tokens.length >= 4) {
                packaging = tokens[3];
            }
            String classifier = tokens.length == 5 ? tokens[4] : null;
            ArtifactItem artifactItem = new ArtifactItem();
            artifactItem.setGroupId(groupId);
            artifactItem.setArtifactId(artifactId);
            artifactItem.setVersion(version);
            artifactItem.setType(packaging);
            artifactItem.setClassifier(classifier);
            this.setArtifactItems(Collections.singletonList(artifactItem));
        }
    }
}

