/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import org.codehaus.plexus.util.IOUtil;

public class LineBreaker {
    public static final int DEFAULT_MAX_LINE_LENGTH = 78;
    private static final String EOL = System.getProperty("line.separator");
    private Writer destination;
    private BufferedWriter writer;
    private int maxLineLength;
    private int lineLength = 0;
    private StringBuffer word = new StringBuffer(1024);

    public LineBreaker(Writer out) {
        this(out, 78);
    }

    public LineBreaker(Writer out, int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("maxLineLength <= 0");
        }
        this.destination = out;
        this.maxLineLength = max;
        this.writer = new BufferedWriter(out);
    }

    public Writer getDestination() {
        return this.destination;
    }

    public void write(String text) throws IOException {
        this.write(text, false);
    }

    public void write(String text, boolean preserveSpace) {
        int length = text.length();
        try {
            block7: for (int i = 0; i < length; ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case ' ': {
                        if (preserveSpace) {
                            this.word.append(c);
                            continue block7;
                        }
                        this.writeWord();
                        continue block7;
                    }
                    case '\r': {
                        if (i + 1 < length && text.charAt(i + 1) == '\n') continue block7;
                    }
                    case '\n': {
                        this.writeWord();
                        this.writer.write(EOL);
                        this.lineLength = 0;
                        continue block7;
                    }
                    default: {
                        this.word.append(c);
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void flush() {
        try {
            this.writeWord();
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeWord() throws IOException {
        int length = this.word.length();
        if (length > 0) {
            if (this.lineLength > 0) {
                if (this.lineLength + 1 + length > this.maxLineLength) {
                    this.writer.write(EOL);
                    this.lineLength = 0;
                } else {
                    this.writer.write(32);
                    ++this.lineLength;
                }
            }
            this.writer.write(this.word.toString());
            this.word.setLength(0);
            this.lineLength += length;
        }
    }

    public void close() {
        IOUtil.close(this.writer);
    }
}

