/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import org.codehaus.plexus.logging.Logger;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.transfer.MetadataNotFoundException;
import org.sonatype.aether.util.listener.AbstractRepositoryListener;

class LoggingRepositoryListener
extends AbstractRepositoryListener {
    private final Logger logger;

    public LoggingRepositoryListener(Logger logger) {
        this.logger = logger;
    }

    public void artifactInstalling(RepositoryEvent event) {
        this.logger.info("Installing " + event.getArtifact().getFile() + " to " + event.getFile());
    }

    public void metadataInstalling(RepositoryEvent event) {
        this.logger.debug("Installing " + event.getMetadata() + " to " + event.getFile());
    }

    public void metadataResolved(RepositoryEvent event) {
        Exception e = event.getException();
        if (e != null) {
            if (e instanceof MetadataNotFoundException) {
                this.logger.debug(e.getMessage());
            } else if (this.logger.isDebugEnabled()) {
                this.logger.warn(e.getMessage(), e);
            } else {
                this.logger.warn(e.getMessage());
            }
        }
    }

    public void metadataInvalid(RepositoryEvent event) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("The metadata ");
        if (event.getMetadata().getFile() != null) {
            buffer.append(event.getMetadata().getFile());
        } else {
            buffer.append(event.getMetadata());
        }
        buffer.append(" is invalid");
        if (event.getException() != null) {
            buffer.append(": ");
            buffer.append(event.getException().getMessage());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(buffer.toString(), event.getException());
        } else {
            this.logger.warn(buffer.toString());
        }
    }

    public void artifactDescriptorInvalid(RepositoryEvent event) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("The POM for ");
        buffer.append(event.getArtifact());
        buffer.append(" is invalid, transitive dependencies (if any) will not be available");
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(buffer + ": " + event.getException().getMessage());
        } else {
            this.logger.warn(buffer + ", enable debug logging for more details");
        }
    }

    public void artifactDescriptorMissing(RepositoryEvent event) {
        this.logger.warn("The POM for " + event.getArtifact() + " is missing, no dependency information available");
    }
}

