/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class WiproBkpShardingMultiDeviceStage2 {
    static MongoCollection deviceDBCollection;
    static String primary;
    static String secoundry;

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        primary = config.getProperty("primary").toString();
        secoundry = config.getProperty("secoundry").toString();
        String userNames = config.getProperty("userNames").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("user names " + userNames);
        ArrayList<String> userNamesList = new ArrayList<String>();
        userNamesList.addAll(Arrays.asList(userNames.split(",")));
        System.out.println("connectivity success  ");
        deviceDBCollection = db.getCollection("DEVICE");
        for (String userName : userNamesList) {
            userName = userName.trim();
            System.out.println("echo \"Starting user " + userName + "\"");
            System.out.println("mongoexport -h  " + secoundry + " -u \"neil\" -p \"parablu\" --db parablu001 --collection BACKUP -q '{\"userName\":\"" + userName + "\"}' --out " + userName + ".csv");
            System.out.println("mongoimport -h  " + primary + " -u \"neil\" -p \"parablu\" --db parablu001 --collection TEMP_BKP_" + userName + "  --file " + userName + ".csv");
            FindIterable overviews = deviceDBCollection.find(new Document("userName", userName));
            for (Document overview : overviews) {
                System.out.println("mongo  " + primary + " -u \"neil\" -p \"parablu\"  --authenticationDatabase \"admin\" < dbRefToUUID/" + overview.getString("deviceUUID") + ".js");
                System.out.println("mongoexport -h  " + secoundry + " -u \"neil\" -p \"parablu\" --db parablu001 --collection TEMP_BKP_" + userName + " -q '{\"deviceUUID\":\"" + overview.getString("deviceUUID") + "\"}' --out " + overview.getString("deviceUUID") + ".csv");
                System.out.println("mongoimport -h  " + primary + " -u \"neil\" -p \"parablu\" --db parablu001 --collection " + overview.getString("destCollection") + "  --file " + overview.getString("deviceUUID") + ".csv");
            }
            System.out.println("mongoexport -h  " + secoundry + " -u \"neil\" -p \"parablu\" --db parablu001 --collection TEMP_BKP_" + userName + "q '{\"deviceUUID\":{$exists:false}}'   --out " + userName + "WithOutDeviceInfo.csv");
            System.out.println("mongoimport -h  " + primary + " -u \"neil\" -p \"parablu\" --db parablu001 --collection BKP_WITHOUT_DEVICE   --file " + userName + "WithOutDeviceInfo.csv");
            System.out.println("mongo  " + primary + " -u \"neil\" -p \"parablu\"  --authenticationDatabase \"admin\" < deleteTempUser/" + userName + ".js");
            System.out.println("rm -r *.csv");
            System.out.println("echo \"Done user " + userName + "\"\n");
        }
    }
}

