/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.Block;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import java.util.Arrays;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class WiproBkpSharding {
    static MongoCollection deviceDBCollection;
    static String primary;
    static String secoundry;
    static Block<Document> printBlock;

    static {
        printBlock = new Block<Document>(){

            @Override
            public void apply(Document document) {
                if (document.getInteger("count") != 1) {
                    String userName = document.getString("_id");
                    System.out.println("echo \"Starting user " + document.get("_id") + "\"");
                    System.out.println("mongoexport -h  " + secoundry + " -u \"neil\" -p \"parablu\" --db parablu001 --collection BACKUP -q '{\"userName\":\"" + userName + "\"}' --out " + userName + ".csv");
                    System.out.println("mongoimport -h  " + primary + " -u \"neil\" -p \"parablu\" --db parablu001 --collection TEMP_BKP_" + document.get("_id") + "  --file " + userName + ".csv");
                    FindIterable overviews = deviceDBCollection.find(new Document("userName", document.get("_id")));
                    for (Document overview : overviews) {
                        System.out.println("mongo  " + primary + " -u \"neil\" -p \"parablu\"  --authenticationDatabase \"admin\" < dbRefToUUID/" + overview.getString("deviceUUID") + ".js");
                        System.out.println("mongoexport -h  " + secoundry + " -u \"neil\" -p \"parablu\" --db parablu001 --collection TEMP_BKP_" + document.get("_id") + " -q '{\"deviceUUID\":\"" + overview.getString("deviceUUID") + "\"}' --out " + overview.getString("deviceUUID") + ".csv");
                        System.out.println("mongoimport -h  " + primary + " -u \"neil\" -p \"parablu\" --db parablu001 --collection " + overview.getString("destCollection") + "  --file " + overview.getString("deviceUUID") + ".csv");
                    }
                    System.out.println("mongoexport -h  " + secoundry + " -u \"neil\" -p \"parablu\" --db parablu001 --collection TEMP_BKP_" + userName + "q '{\"deviceUUID\":{$exists:false}}'   --file " + userName + "WithOutDeviceInfo.csv");
                    System.out.println("mongoimport -h  " + primary + " -u \"neil\" -p \"parablu\" --db parablu001 --collection BKP_WITHOUT_DEVICE   --file " + userName + "WithOutDeviceInfo.csv");
                    System.out.println("mongo  " + primary + " -u \"neil\" -p \"parablu\"  --authenticationDatabase \"admin\" < deleteTempUser/" + userName + ".js");
                    System.out.println("rm -r *.csv");
                    System.out.println("echo \"Done user " + userName + "\"\n");
                }
            }
        };
    }

    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        primary = config.getProperty("primary").toString();
        secoundry = config.getProperty("secoundry").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        try {
            deviceDBCollection = db.getCollection("DEVICE");
            FindIterable bkpOverviews = deviceDBCollection.find();
            deviceDBCollection.aggregate(Arrays.asList(Aggregates.group("$userName", Accumulators.sum("count", 1)))).forEach(printBlock);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

