/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackupHistoryElement;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EmailProps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.util.CollectionUtils;

public class WeeklyMailChanges {
    private static final String MM_DD_YYYY_HH_MM_SS = "MM/dd/yyyy HH:mm:ss";
    private static final String MM_DD_YYYY = "MM/dd/yyyy";
    private static final String INSIDE_SEND_CLOUD_OVER_VIEW_JOB_TIMER = " @@@@@@@@@@@@@@@@@@@@@@@@@@ inside send cloud over view job timer ";
    private static final String BEFORE_SENDING_MAIL = " @@@ Before sending mail ";
    private static final String NO_ATTEMPT = "No Attempt";
    private static final String NILL = " ";
    private static final String PARSE_EXCEPTION = "ParseException  ";
    private static final String INVALID_DAY_VALUE = "Invalid Day value";
    private static final String NUMBER_FORMAT_EXCEPTION = "NumberFormatException  ";

    public static void main(String[] args) throws ConfigurationException {
        Object config = null;
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@demoqa253.parablu.com:48765/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> userExcludedFoldersDBCollection = db.getCollection("BACKUP_BATCH");
        System.out.println(userExcludedFoldersDBCollection.count());
        MongoCollection<Document> devicebkpCol = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        DeviceBackupOverView device = new DeviceBackupOverView();
        device.setFirstBkpStartTime("21-Jan-2019 16:08:15");
        device.setFirstBkpEndTime("29-Jan-2019 17:05:32");
        device.setLastBkpStartTime("05-Feb-2019 18:46:18");
        device.setLastBkpEndTime("05-Feb-2019 18:46:18");
        device.setLastSuccessfulBkp("05-Feb-2019 18:46:18");
        device.setLastBkpStatus("COMPLETED");
        FindIterable<Document> batchList = userExcludedFoldersDBCollection.find(new BasicDBObject("userName", "longtest"));
        ArrayList<BackupHistoryElement> backupHistoryElements = new ArrayList<BackupHistoryElement>();
        StringBuilder bodyData = new StringBuilder();
        for (Document document : batchList) {
            BackupHistoryElement backupHistoryElement = new BackupHistoryElement();
            backupHistoryElement.setBatchId(document.getObjectId("_id").toString());
            backupHistoryElement.setDeviceName("bat");
            backupHistoryElement.setUserName("batUserName");
            backupHistoryElement.setPolicyName("policyName");
            backupHistoryElement.setStartTime(WeeklyMailChanges.getDate(document.getLong("batchStartTimestamp")));
            backupHistoryElement.setEndTime(WeeklyMailChanges.getDate(document.getLong("batchEndTimestamp")));
            backupHistoryElement.setUploadedSize(document.getString("uploadedSize"));
            backupHistoryElement.setAction(WeeklyMailChanges.getCommentsForBackupBatch(document.getString("errorCode")));
            String uploadedFiles = document.getString("uploadedFiles");
            String[] parts = uploadedFiles.split("/");
            try {
                backupHistoryElement.setNoOfFiles(Integer.parseInt(parts[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            backupHistoryElements.add(backupHistoryElement);
        }
        EmailProps tempEmail = new EmailProps();
        WeeklyMailChanges.setDaysElementForSendmail(tempEmail);
        backupHistoryElements.sort(Comparator.comparing(BackupHistoryElement::getEndTime));
        int i = 0;
        while (i < 7) {
            String dateToCheck = WeeklyMailChanges.getDateForApproprioteDay(i);
            WeeklyMailChanges.setDate(tempEmail, WeeklyMailChanges.getDayOfTheWeek(dateToCheck), dateToCheck);
            for (BackupHistoryElement backupHistoryElement1 : backupHistoryElements) {
                int startDayVal;
                List<Integer> previousDays;
                int dayVal;
                if (backupHistoryElement1 == null) continue;
                System.out.println("starting " + i + (WeeklyMailChanges.getTimeStamp(backupHistoryElement1.getStartTime()) < WeeklyMailChanges.getTimeStampForGivenDaysBack(6) && WeeklyMailChanges.getTimeStamp(backupHistoryElement1.getEndTime()) < WeeklyMailChanges.getTimeStampForGivenDaysBack(6)));
                if (dateToCheck.equals(WeeklyMailChanges.getDay(backupHistoryElement1.getEndTime()))) {
                    System.out.println("Inside 1 " + backupHistoryElement1.getBatchId());
                    dayVal = WeeklyMailChanges.getDayOfTheWeek(WeeklyMailChanges.getDay(backupHistoryElement1.getEndTime()));
                    previousDays = WeeklyMailChanges.getDaysOfBatch(WeeklyMailChanges.getDay(backupHistoryElement1.getStartTime()), dayVal);
                    WeeklyMailChanges.setBackupStatusForPreviousDays(tempEmail, previousDays, backupHistoryElement1.getBatchId());
                    if (WeeklyMailChanges.isBackupStartedinWindowPeriod(WeeklyMailChanges.getDay(backupHistoryElement1.getStartTime()))) {
                        startDayVal = WeeklyMailChanges.getDayOfTheWeek(WeeklyMailChanges.getDay(backupHistoryElement1.getStartTime()));
                        WeeklyMailChanges.setBackupStatusForDay(tempEmail, startDayVal, WeeklyMailChanges.getStatusWithTime(backupHistoryElement1.getStartTime(), "Backup Started"), null, WeeklyMailChanges.getDay(backupHistoryElement1.getStartTime()), backupHistoryElement1.getBatchId());
                    }
                    if ("Successfully Completed".equals(backupHistoryElement1.getAction())) {
                        WeeklyMailChanges.setBackupStatusForDay(tempEmail, dayVal, WeeklyMailChanges.getStatusWithTime(backupHistoryElement1.getEndTime(), "Completed"), null, dateToCheck, backupHistoryElement1.getBatchId());
                        continue;
                    }
                    WeeklyMailChanges.setBackupStatusForDay(tempEmail, dayVal, "In progress", backupHistoryElement1.getAction(), dateToCheck, backupHistoryElement1.getBatchId());
                    continue;
                }
                if (WeeklyMailChanges.isdateAfter(backupHistoryElement1.getEndTime(), WeeklyMailChanges.getEndDate()) && dateToCheck.equals(WeeklyMailChanges.getDay(backupHistoryElement1.getStartTime()))) {
                    System.out.println("Inside 2");
                    dayVal = WeeklyMailChanges.getDayOfTheWeek(WeeklyMailChanges.getDay(backupHistoryElement1.getEndTime()));
                    previousDays = WeeklyMailChanges.getDaysOfBatch(WeeklyMailChanges.getDay(backupHistoryElement1.getStartTime()), dayVal);
                    WeeklyMailChanges.setBackupStatusForPreviousDays(tempEmail, previousDays, backupHistoryElement1.getBatchId());
                    if (!WeeklyMailChanges.isBackupStartedinWindowPeriod(WeeklyMailChanges.getDay(backupHistoryElement1.getStartTime()))) continue;
                    startDayVal = WeeklyMailChanges.getDayOfTheWeek(WeeklyMailChanges.getDay(backupHistoryElement1.getStartTime()));
                    WeeklyMailChanges.setBackupStatusForDay(tempEmail, startDayVal, WeeklyMailChanges.getStatusWithTime(backupHistoryElement1.getStartTime(), "Backup Started"), null, WeeklyMailChanges.getDay(backupHistoryElement1.getStartTime()), backupHistoryElement1.getBatchId());
                    continue;
                }
                if ((backupHistoryElements.size() != 1 || WeeklyMailChanges.getTimeStamp(backupHistoryElement1.getStartTime()) >= WeeklyMailChanges.getTimeStampForGivenDaysBack(6) || WeeklyMailChanges.getTimeStamp(backupHistoryElement1.getEndTime()) >= WeeklyMailChanges.getTimeStampForGivenDaysBack(6)) && WeeklyMailChanges.getTimeStamp(backupHistoryElement1.getEndTime()) <= WeeklyMailChanges.getTimeStampForGivenDaysBack(1)) continue;
                System.out.println("inside 3 " + backupHistoryElement1.getBatchId());
                WeeklyMailChanges.setBackupStatusForDay(tempEmail, i + 1, "In progress", "", dateToCheck, backupHistoryElement1.getBatchId());
            }
            ++i;
        }
        WeeklyMailChanges.setNoAttemptForSendmail(tempEmail);
        bodyData.append(WeeklyMailChanges.setDynamicDeviceTemplate(device, tempEmail));
        System.out.println(bodyData);
    }

    private static long getDateForApproprioteDayTimeStamp(int i) {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, -i);
        Date fiveDaysAgo = cal.getTime();
        return fiveDaysAgo.getTime();
    }

    private static String getCommentsForBackupBatch(String errorCode) {
        String comments = "";
        if (StringUtils.isEmpty(errorCode)) {
            return "";
        }
        if ("0".equals(errorCode)) {
            comments = "Successfully Completed";
        }
        if ("909".equals(errorCode)) {
            comments = "Network disconnected during backup";
        }
        if ("911".equals(errorCode)) {
            comments = "User Exited the agent manually";
        }
        if ("912".equals(errorCode)) {
            comments = "Machine Utilization exceeded during backup";
        }
        if ("2304".equals(errorCode)) {
            comments = "Backup temporarily suspended because server is busy.Will be retried later";
        }
        if ("1992".equals(errorCode)) {
            comments = "User stopped BackUp manually.";
        }
        if ("1981".equals(errorCode)) {
            comments = "User storage limit reached.";
        }
        if ("1996".equals(errorCode)) {
            comments = "Backup Deferred.";
        }
        return comments;
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The dates must not be null");
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return WeeklyMailChanges.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The dates must not be null");
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    private static String getEndDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 55);
        Date date = cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(MM_DD_YYYY);
        return formatter.format(date);
    }

    private static long getEndDateTimeStamp() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 55);
        ((Calendar)cal).add(5, -1);
        Date date = cal.getTime();
        return date.getTime();
    }

    private static long getTimeStamp(String startDate) {
        long millis = 0L;
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(MM_DD_YYYY);
            Date dateD = new Date(startDate);
            millis = dateD.getTime();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return millis;
    }

    private static String setDynamicDeviceTemplate(DeviceBackupOverView device, EmailProps email) {
        StringBuilder bodyData = new StringBuilder("<table class=\"table\" style=\"width:100%\">");
        bodyData.append("<thead>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: center\">").append("Device Name").append("</th>").append("<th colspan=\"3\" style=\"border: 1px solid black;text-align: center\">").append(device.getDeviceName()).append("</th>").append("</tr>").append("</thead>").append("<tbody>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: center\">").append("Last Successful").append("<br>").append("Backup").append("</th>").append("<th colspan=\"3\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(device.getLastSuccessfulBkp()).orElse("")).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append("Day Wise Status").append("</th>").append("</tr>").append("<th style=\"border: 1px solid black;text-align: center\">").append("Day").append("</th>").append("<th style=\"border: 1px solid black;text-align: center\">").append("Date").append("</th>").append("<th style=\"border: 1px solid black;text-align: center\">").append("Backup Status").append("</th>").append("<th style=\"border: 1px solid black;text-align: center\">").append("Details").append("</th>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;width:").append("20%;\">").append(WeeklyMailChanges.getWeekDay(7)).append("</td>").append("<td style=\"border: 1px solid black;width:").append(";\">").append(WeeklyMailChanges.getWeekDate(7)).append("</td>").append("<td style=\"border: 1px solid black;width:").append("30%;\">").append(WeeklyMailChanges.getMultipleStatusTemplate(WeeklyMailChanges.getStatus(7, email))).append("</td>").append("<td style=\"border: 1px solid black;width:").append("40%;\">").append(WeeklyMailChanges.getRemarks(7, email)).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getWeekDay(6)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getWeekDate(6)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getMultipleStatusTemplate(WeeklyMailChanges.getStatus(6, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getRemarks(6, email)).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getWeekDay(5)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getWeekDate(5)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getMultipleStatusTemplate(WeeklyMailChanges.getStatus(5, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getRemarks(5, email)).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getWeekDay(4)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getWeekDate(4)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getMultipleStatusTemplate(WeeklyMailChanges.getStatus(4, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getRemarks(4, email)).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getWeekDay(3)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getWeekDate(3)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getMultipleStatusTemplate(WeeklyMailChanges.getStatus(3, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getRemarks(3, email)).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getWeekDay(2)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getWeekDate(2)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getMultipleStatusTemplate(WeeklyMailChanges.getStatus(2, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getRemarks(2, email)).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getWeekDay(1)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getWeekDate(1)).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getMultipleStatusTemplate(WeeklyMailChanges.getStatus(1, email))).append("</td>").append("<td style=\"border: 1px solid black;\">").append(WeeklyMailChanges.getRemarks(1, email)).append("</td>").append("</tr>").append("</tbody>").append("</table>").append("<br>");
        return bodyData.toString();
    }

    private static String getMultipleStatusTemplate(List<String> statusList) {
        StringBuilder statusTemplate = new StringBuilder();
        if (!CollectionUtils.isEmpty(statusList)) {
            statusList.forEach(status -> statusTemplate.append((String)status).append("<br>"));
        }
        System.out.println("Returned : " + statusTemplate.toString());
        return statusTemplate.toString();
    }

    private static String getWeekDay(int day) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat simpleDateformat = new SimpleDateFormat("EEEE");
        if (day != 0) {
            cal.add(5, -day);
        }
        return simpleDateformat.format(cal.getTime());
    }

    private static String getRemarks(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayRemark();
            }
            case 6: {
                return email.getFridayRemark();
            }
            case 5: {
                return email.getThursdayRemark();
            }
            case 4: {
                return email.getWednesdayRemark();
            }
            case 3: {
                return email.getTuesdayRemark();
            }
            case 2: {
                return email.getMondayRemark();
            }
            case 1: {
                return email.getSundayRemark();
            }
        }
        System.out.println(INVALID_DAY_VALUE);
        return "";
    }

    private static List<String> getStatus(int day, EmailProps email) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -day);
        int dayValue = cal.get(7);
        switch (dayValue) {
            case 7: {
                return email.getSaturdayStatus();
            }
            case 6: {
                return email.getFridayStatus();
            }
            case 5: {
                return email.getThursdayStatus();
            }
            case 4: {
                return email.getWednesdayStatus();
            }
            case 3: {
                return email.getTuesdayStatus();
            }
            case 2: {
                return email.getMondayStatus();
            }
            case 1: {
                return email.getSundayStatus();
            }
        }
        System.out.println(INVALID_DAY_VALUE);
        return null;
    }

    private static String getWeekDate(int day) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat simpleDateformat = new SimpleDateFormat("dd/MM/yyyy");
        if (day != 0) {
            cal.add(5, -day);
        }
        return simpleDateformat.format(cal.getTime());
    }

    private static void setNoAttemptForSendmail(EmailProps email) {
        if (CollectionUtils.isEmpty(email.getMondayStatus())) {
            email.setMondayStatus(NO_ATTEMPT);
        }
        if (CollectionUtils.isEmpty(email.getTuesdayStatus())) {
            email.setTuesdayStatus(NO_ATTEMPT);
        }
        if (CollectionUtils.isEmpty(email.getWednesdayStatus())) {
            email.setWednesdayStatus(NO_ATTEMPT);
        }
        if (CollectionUtils.isEmpty(email.getThursdayStatus())) {
            email.setThursdayStatus(NO_ATTEMPT);
        }
        if (CollectionUtils.isEmpty(email.getFridayStatus())) {
            email.setFridayStatus(NO_ATTEMPT);
        }
        if (CollectionUtils.isEmpty(email.getSaturdayStatus())) {
            email.setSaturdayStatus(NO_ATTEMPT);
        }
        if (CollectionUtils.isEmpty(email.getSundayStatus())) {
            email.setSundayStatus(NO_ATTEMPT);
        }
    }

    private static boolean isdateAfter(String batchEndDate, String windowEndDate) {
        boolean isdateBefore = false;
        try {
            SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
            if (StringUtils.isNotEmpty(batchEndDate) && StringUtils.isNotEmpty(windowEndDate)) {
                Date formatedBatchEndDate = format.parse(batchEndDate);
                Date formatedWindowEndDate = format.parse(windowEndDate);
                isdateBefore = formatedBatchEndDate.after(formatedWindowEndDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isdateBefore;
    }

    private static boolean isBackupStartedinWindowPeriod(String activityStartDateString) {
        String batchStartDateString = WeeklyMailChanges.getDateForApproprioteDay(0);
        Date activityStartTime = null;
        Date batchStartTime = null;
        SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
        try {
            activityStartTime = format.parse(activityStartDateString);
            batchStartTime = format.parse(batchStartDateString);
        }
        catch (ParseException e) {
            System.out.println(PARSE_EXCEPTION + e);
        }
        return activityStartTime == null || !activityStartTime.before(batchStartTime);
    }

    private static void setBackupStatusForDay(EmailProps email, int dayValue, String status, String remark, String date, String id) {
        String tempRemark = NILL;
        if (!StringUtils.isEmpty(remark)) {
            tempRemark = remark;
        }
        switch (dayValue) {
            case 1: {
                email.setSundayStatus(status);
                email.setSundayRemark(tempRemark);
                email.setSundayDate(date);
                break;
            }
            case 2: {
                email.setMondayStatus(status);
                email.setMondayRemark(tempRemark);
                email.setMondayDate(date);
                break;
            }
            case 3: {
                email.setTuesdayStatus(status);
                email.setTuesdayRemark(tempRemark);
                email.setTuesdayDate(date);
                break;
            }
            case 4: {
                email.setWednesdayStatus(status);
                email.setWednesdayRemark(tempRemark);
                email.setWednesdayDate(date);
                break;
            }
            case 5: {
                email.setThursdayStatus(status);
                email.setThursdayRemark(tempRemark);
                email.setThursdayDate(date);
                break;
            }
            case 6: {
                email.setFridayStatus(status);
                email.setFridayRemark(tempRemark);
                email.setFridayDate(date);
                break;
            }
            case 7: {
                email.setSaturdayStatus(status);
                email.setSaturdayRemark(tempRemark);
                email.setSaturdayDate(date);
                break;
            }
            default: {
                System.out.println(INVALID_DAY_VALUE);
            }
        }
    }

    private static void setDaysElementForSendmail(EmailProps email) {
        email.setMonday(DaysEnum.MONDAY.toString());
        email.setMondayRemark(NILL);
        email.setTuesday(DaysEnum.TUESDAY.toString());
        email.setTuesdayRemark(NILL);
        email.setWednesday(DaysEnum.WEDNESDAY.toString());
        email.setWednesdayRemark(NILL);
        email.setThursday(DaysEnum.THURSDAY.toString());
        email.setThursdayRemark(NILL);
        email.setFriday(DaysEnum.FRIDAY.toString());
        email.setFridayRemark(NILL);
        email.setSaturday(DaysEnum.SATURDAY.toString());
        email.setSaturdayRemark(NILL);
        email.setSunday(DaysEnum.SUNDAY.toString());
        email.setSundayRemark(NILL);
    }

    private static String getDate(long dateVal) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(MM_DD_YYYY_HH_MM_SS);
            Date dateD = new Date(dateVal);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return date;
    }

    private static Date getDateFromMillis(long dateVal) {
        Date dateD = null;
        try {
            dateD = new Date(dateVal);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return dateD;
    }

    private static String getDateForApproprioteDay(int i) {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, -7 + i);
        Date fiveDaysAgo = cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(MM_DD_YYYY);
        return formatter.format(fiveDaysAgo);
    }

    private static long getTimeStampForGivenDaysBack(int i) {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, -i);
        Date fiveDaysAgo = cal.getTime();
        return fiveDaysAgo.getTime();
    }

    private static int getDayOfTheWeek(String dat) {
        SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
        Date date = null;
        try {
            date = format.parse(dat);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    private static void setDate(EmailProps email, int dayValue, String date) {
        switch (dayValue) {
            case 1: {
                email.setSundayDate(date);
                break;
            }
            case 2: {
                email.setMondayDate(date);
                break;
            }
            case 3: {
                email.setTuesdayDate(date);
                break;
            }
            case 4: {
                email.setWednesdayDate(date);
                break;
            }
            case 5: {
                email.setThursdayDate(date);
                break;
            }
            case 6: {
                email.setFridayDate(date);
                break;
            }
            case 7: {
                email.setSaturdayDate(date);
            }
        }
    }

    private static String getDay(String startDate) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(MM_DD_YYYY);
            Date dateD = new Date(startDate);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return date;
    }

    private static void setBackupStatusForPreviousDays(EmailProps email, List<Integer> batchStartDayValue, String batchId) {
        String status = "In progress";
        batchStartDayValue.stream().forEach(dayValue -> {
            switch (dayValue) {
                case 7: {
                    email.setSaturdayStatus(status);
                    break;
                }
                case 6: {
                    email.setFridayStatus(status);
                    break;
                }
                case 5: {
                    email.setThursdayStatus(status);
                    break;
                }
                case 4: {
                    email.setWednesdayStatus(status);
                    break;
                }
                case 3: {
                    email.setTuesdayStatus(status);
                    break;
                }
                case 2: {
                    email.setMondayStatus(status);
                    break;
                }
                case 1: {
                    email.setSundayStatus(status);
                    break;
                }
                default: {
                    System.out.println(INVALID_DAY_VALUE);
                }
            }
        });
    }

    private static List<Integer> getDaysOfBatch(String activityStartDateString, int currentDayTemp) {
        int currentDay = currentDayTemp;
        String batchStartDateString = WeeklyMailChanges.getDateForApproprioteDay(0);
        Date activityStartTime = null;
        Date batchStartTime = null;
        SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY);
        try {
            activityStartTime = format.parse(activityStartDateString);
            batchStartTime = format.parse(batchStartDateString);
        }
        catch (ParseException e) {
            System.out.println(PARSE_EXCEPTION + e);
            System.out.println(PARSE_EXCEPTION + e.getMessage());
        }
        Date date = activityStartTime != null && activityStartTime.before(batchStartTime) ? batchStartTime : activityStartTime;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int startDay = calendar.get(7);
        ArrayList<Integer> days = new ArrayList<Integer>();
        if (startDay > currentDay) {
            currentDay += 7;
        }
        if (activityStartTime != null && !activityStartTime.before(batchStartTime)) {
            ++startDay;
        }
        int i = startDay;
        while (i < currentDay) {
            int day = i % 7;
            if (day == 0) {
                day = 7;
            }
            days.add(day);
            ++i;
        }
        return days;
    }

    private static String getStatusWithTime(String time, String status) {
        String formatedTime = WeeklyMailChanges.getTime(time);
        return status + " - " + formatedTime;
    }

    private static String getTime(String startDate) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat("HH:mm");
            Date dateD = new Date(startDate);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            System.out.println(NUMBER_FORMAT_EXCEPTION + e);
            System.out.println(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        return date;
    }

    public static enum DaysEnum {
        SUNDAY,
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY;

    }
}

