/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class UserBackupPolicyMappingUpdate {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        boolean canTakeBackup = Boolean.parseBoolean(config.getProperty("canTakeBackup").toString());
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("connectivity success  ");
        MongoCollection<Document> userBkpPolicyMapping = db.getCollection("USER_BACKUP_POLICY_MAPPING");
        MongoCollection<Document> bkpPolicyDB = db.getCollection("BACKUP_POLICY");
        MongoCollection<Document> syncPolicyDB = db.getCollection("SYNC_POLICY");
        MongoCollection<Document> userDB = db.getCollection("USER");
        MongoCollection<Document> newuserBkpPolicyMapping = db.getCollection("USER_BACKUP_POLICY_MAPPING_BKP");
        FindIterable<Document> userbkpMapping = userBkpPolicyMapping.find();
        if (canTakeBackup) {
            System.out.println("canTakeBackup is true so copy USER_BACKUP_POLICY_MAPPING collection to USER_BACKUP_POLICY_MAPPING_BKP");
            for (Document mapping : userbkpMapping) {
                try {
                    newuserBkpPolicyMapping.insertOne(mapping);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        for (Document mapping : userbkpMapping) {
            try {
                DBRef userRef;
                Document user;
                DBRef syncPolicyref;
                Document syncPolicy;
                DBRef bkpPolicyref;
                Document bkpPolicy;
                if (mapping.get("backupPolicy") != null && (bkpPolicy = (Document)bkpPolicyDB.find(new Document("_id", (bkpPolicyref = (DBRef)mapping.get("backupPolicy")).getId())).first()) != null) {
                    mapping.put("backupPolicyName", (Object)bkpPolicy.getString("policyName"));
                    mapping.remove("backupPolicy");
                }
                if (mapping.get("syncPolicy") != null && (syncPolicy = (Document)syncPolicyDB.find(new Document("_id", (syncPolicyref = (DBRef)mapping.get("syncPolicy")).getId())).first()) != null) {
                    mapping.put("syncPolicyName", (Object)syncPolicy.getString("policyName"));
                    mapping.remove("syncPolicy");
                }
                if (mapping.get("user") != null && (user = (Document)userDB.find(new Document("_id", (userRef = (DBRef)mapping.get("user")).getId())).first()) != null) {
                    mapping.put("userName", (Object)user.getString("userName"));
                    mapping.remove("user");
                }
                userBkpPolicyMapping.findOneAndDelete(new Document("_id", mapping.getObjectId("_id")));
                userBkpPolicyMapping.insertOne(mapping);
                System.out.println("Update for " + mapping.getObjectId("_id"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("Completed........");
    }
}

