/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.bson.Document;

public class RebackupFromBkpBG {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String deviceUUIDValue = config.getProperty("deviceUUIDValue").toString();
        String gatewayName = config.getProperty("gatewayName").toString();
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase mainPB001DB = client.getDatabase(uri.getDatabase());
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        MongoCollection<Document> bkpPGColl = db.getCollection("BACKUP_PG");
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        MongoCollection<Document> reBkpCollection = mainPB001DB.getCollection("RE_BACKUP");
        System.out.println("gatewayName...." + gatewayName + "..");
        ArrayList<String> deviceUUIDList = new ArrayList<String>();
        deviceUUIDList.addAll(Arrays.asList(deviceUUIDValue.split(",")));
        for (String deviceUUID : deviceUUIDList) {
            try {
                FindIterable<Document> files;
                deviceUUID = deviceUUID.replace("[", "");
                deviceUUID = deviceUUID.replace("]", "");
                deviceUUID = deviceUUID.trim();
                ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
                whereQuery.add(new BasicDBObject("gatewayName", gatewayName));
                BasicDBObject andQuery = new BasicDBObject();
                andQuery.put("$and", whereQuery);
                ArrayList<Document> allFilesList = new ArrayList<Document>();
                Document device = (Document)deviceColl.find(new BasicDBObject("deviceUUID", deviceUUID)).first();
                if (device == null) {
                    System.out.println("device is empty ...." + deviceUUID);
                    continue;
                }
                MongoCollection<Document> bkpColl = db.getCollection(device.getString("destCollection"));
                int skip = 0;
                while ((files = bkpPGColl.find(andQuery).skip(skip * 500).limit(500)).first() != null) {
                    for (Document file : files) {
                        allFilesList.add(file);
                    }
                    ++skip;
                }
                System.out.println("For deviceUUID " + deviceUUID + " count is " + allFilesList.size());
                for (Document file : allFilesList) {
                    try {
                        Document rebkpFile = new Document();
                        Document bkpFile = (Document)bkpColl.find(new BasicDBObject("_id", file.getObjectId("_id"))).first();
                        System.out.println(new BasicDBObject("_id", file.getObjectId("_id")));
                        System.out.println(bkpFile);
                        if (bkpFile == null) continue;
                        rebkpFile.put("_id", (Object)file.getObjectId("_id"));
                        rebkpFile.put("userName", (Object)file.getString("userName"));
                        rebkpFile.put("fileName", (Object)file.getString("fileName"));
                        rebkpFile.put("devicePath", (Object)bkpFile.getString("devicePath"));
                        rebkpFile.put("deviceId", (Object)device.getObjectId("_id").toString());
                        reBkpCollection.insertOne(rebkpFile);
                    }
                    catch (Exception e) {
                        System.out.println("Exception:" + e.getLocalizedMessage());
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Exception:" + e.getLocalizedMessage());
            }
        }
    }
}

