/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class DeleteUserDataByUserName {
    public static void main(String[] args) throws ConfigurationException {
        PropertiesConfiguration config = null;
        config = new PropertiesConfiguration(args[0]);
        String mongoIP = config.getProperty("mongoIP").toString();
        String mongoPort = config.getProperty("mongoPort").toString();
        String userNames = config.getProperty("userNames").toString();
        if (StringUtils.isEmpty(mongoIP)) {
            System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
            throw new ArrayIndexOutOfBoundsException();
        }
        System.out.println("mongo IP:" + mongoIP);
        MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
        MongoClient client = new MongoClient(uri);
        MongoDatabase db = client.getDatabase(uri.getDatabase());
        System.out.println("mongo connectivity success  " + db.getName());
        userNames = userNames.replaceAll(" ", "");
        System.out.println("user names " + userNames);
        ArrayList<String> userNamesList = new ArrayList<String>();
        userNamesList.addAll(Arrays.asList(userNames.split(",")));
        System.out.println("Total user count " + userNamesList.size());
        MongoCollection<Document> userDBCollection = db.getCollection("USER");
        MongoCollection<Document> deviceDBCollection = db.getCollection("DEVICE");
        MongoCollection<Document> deviceBkpOverviewDB = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        MongoCollection<Document> tokenDB = db.getCollection("AUTHORIZATION_TOKENS");
        System.out.println("User Count in DB  " + userDBCollection.count());
        for (String userName : userNamesList) {
            userName.replaceAll(" ", "");
            System.out.println("User name :" + userName);
            Document user = (Document)userDBCollection.find(new Document("userName", userName)).first();
            if (user != null) {
                BasicDBObject userSearchQuery = new BasicDBObject();
                userSearchQuery.append("_id", user.get("_id"));
                BasicDBObject userUpdateFields = new BasicDBObject();
                userUpdateFields.append("active", false);
                userUpdateFields.append("deleted", true);
                BasicDBObject updateuserQuery = new BasicDBObject();
                updateuserQuery.append("$set", userUpdateFields);
                userDBCollection.updateOne(userSearchQuery, updateuserQuery);
                FindIterable<Document> deviceList = deviceDBCollection.find(new Document("userName", userName));
                for (Document device : deviceList) {
                    BasicDBObject deviceSearchQuery = new BasicDBObject();
                    deviceSearchQuery.append("_id", device.get("_id"));
                    BasicDBObject deviceUpdateFields = new BasicDBObject();
                    deviceUpdateFields.append("blocked", true);
                    deviceUpdateFields.append("deleted", true);
                    BasicDBObject updateDeviceQuery = new BasicDBObject();
                    updateDeviceQuery.append("$set", deviceUpdateFields);
                    deviceDBCollection.updateOne(deviceSearchQuery, updateDeviceQuery);
                }
                FindIterable<Document> devicebkpList = deviceBkpOverviewDB.find(new Document("userName", userName));
                for (Document deviceBkp : devicebkpList) {
                    BasicDBObject deviceBkpSearchQuery = new BasicDBObject();
                    deviceBkpSearchQuery.append("_id", deviceBkp.get("_id"));
                    BasicDBObject deviceBkpUpdateFields = new BasicDBObject();
                    deviceBkpUpdateFields.append("isDeviceBolcked", true);
                    deviceBkpUpdateFields.append("isDeviceDeleted", true);
                    deviceBkpUpdateFields.append("isUserActive", false);
                    deviceBkpUpdateFields.append("isUserDeleted", true);
                    BasicDBObject updateDeviceBKPQuery = new BasicDBObject();
                    updateDeviceBKPQuery.append("$set", deviceBkpUpdateFields);
                    deviceBkpOverviewDB.updateOne(deviceBkpSearchQuery, updateDeviceBKPQuery);
                }
                DBRef userDBRef = new DBRef("USER", user.getObjectId("_id"));
                BasicDBObject userDBRefQuery = new BasicDBObject();
                userDBRefQuery.append("user", userDBRef);
                tokenDB.deleteMany(userDBRefQuery);
                System.out.println("Completed user name :" + userName);
                continue;
            }
            System.out.println(String.valueOf(userName) + " user not present in user table");
        }
    }
}

