/*
 * Decompiled with CFR 0.152.
 */
package pst;

import com.aspose.email.MapiMessage;
import com.aspose.email.MapiRecipientCollection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class MapiMessageIterator
implements Iterator<MapiMessage> {
    private Queue<String> queue = new LinkedList<String>();

    public MapiMessageIterator(Queue<String> queue) {
        this.queue = queue;
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public MapiMessage next() {
        MapiMessage message = null;
        try {
            message = MapiMessage.load(this.queue.poll());
        }
        catch (Exception e) {
            message = MapiMessageIterator.createDefaultTemplate();
            e.printStackTrace();
            System.out.println("Exception while loading eml" + e);
        }
        return message;
    }

    public static MapiMessage createDefaultTemplate() {
        MapiMessage message = new MapiMessage();
        message.setSubject("Default Subject");
        message.setBody("This is the default body of the message because the actual mail looks corrupted .");
        message.setSenderEmailAddress("pbsender@pb.com");
        message.setSenderName("Default Sender");
        MapiRecipientCollection recipients = new MapiRecipientCollection();
        recipients.add("PBTemplate@pb.com", "Default Recipient", 1);
        message.setRecipients(recipients);
        message.setMessageFlags(8L);
        return message;
    }
}

