/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email.system;

import com.aspose.email.internal.ae.za;

public class BitConverter {
    public static final boolean IsLittleEndian = true;

    public static int toUInt16(byte[] value, int startIndex) {
        return za.a(value, startIndex << 3, true) & 0xFFFF;
    }

    public static long toUInt32(byte[] value, int startIndex) {
        return (long)za.b(value, startIndex << 3, true) & 0xFFFFFFFFL;
    }

    public static long toUInt64(byte[] value, int startIndex) {
        return za.d(value, startIndex << 3, true);
    }

    public static int toInt16(byte[] value, int startIndex) {
        return za.a(value, startIndex << 3, true);
    }

    public static int toInt32(byte[] value, int startIndex) {
        return za.b(value, startIndex << 3, true);
    }

    public static long toInt64(byte[] value, int startIndex) {
        return za.d(value, startIndex << 3, true);
    }

    public static boolean toBoolean(byte[] value, int startIndex) {
        return value[startIndex] != 0;
    }

    public static char toChar(byte[] value, int startIndex) {
        return (char)za.a(value, startIndex << 3, true);
    }

    public static float toSingle(byte[] value, int startIndex) {
        return za.c(value, startIndex << 3, true);
    }

    public static double toDouble(byte[] value, int startIndex) {
        return za.e(value, startIndex << 3, true);
    }

    public static byte[] getBytes(byte value) {
        return new byte[]{value};
    }

    public static byte[] getBytesBoolean(Boolean value) {
        byte[] byArray = new byte[]{(byte)(value != false ? 1 : 0)};
        return byArray;
    }

    public static byte[] getBytesChar(char value) {
        return BitConverter.getBytesInt16((short)value);
    }

    public static byte[] getBytesDouble(double value) {
        return za.a(value, true);
    }

    public static byte[] getBytesSingle(float value) {
        return za.a(value, true);
    }

    public static byte[] getBytesInt16(short value) {
        return za.a(value, true);
    }

    public static byte[] getBytesUInt16(int value) {
        return za.a((short)(value & 0xFFFF), true);
    }

    public static byte[] getBytesInt32(int value) {
        return za.a(value, true);
    }

    public static byte[] getBytesUInt32(long value) {
        return za.a((int)(value & 0xFFFFFFFFL), true);
    }

    public static byte[] getBytesInt64(long value) {
        return za.a(value, true);
    }

    public static byte[] getBytesUInt64(long value) {
        return za.a(value, true);
    }

    public static String toString(byte[] value) {
        return BitConverter.toString(value, 0);
    }

    public static String toString(byte[] value, int startIndex) {
        int n = value.length - startIndex;
        return BitConverter.toString(value, startIndex, n);
    }

    public static String toString(byte[] value, int startIndex, int length) {
        byte[] byArray = new byte[length];
        System.arraycopy(value, startIndex, byArray, 0, length);
        return za.a(byArray, za.zb.a, za.zc.e, false, za.za.a);
    }

    public static double int64BitsToDouble(long value) {
        return BitConverter.toDouble(BitConverter.getBytesInt64(value), 0);
    }

    public static long doubleToInt64Bits(double value) {
        return BitConverter.toInt64(BitConverter.getBytesDouble(value), 0);
    }
}

