/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.domain;

import com.parablu.pcbd.domain.FileRevision;
import java.io.Serializable;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Document(collection="CONSOLIDATED_IMAGE")
public class ConsolidatedImage
implements Serializable {
    private static final long serialVersionUID = 5517070046794795300L;
    @Id
    @Field
    private ObjectId id;
    @Field
    @Indexed
    private String fileName;
    @Field
    @Indexed
    private String devicePath;
    @Field
    private long crawlStartTimestamp;
    @Field
    @Indexed
    private String modifiedTime;
    @Field
    private String metaData;
    @Field
    private String regID;
    @Field
    @Indexed
    private boolean present;
    @Field
    private String md5;
    @Field
    @Indexed
    private boolean folder;
    @Field
    @Indexed
    private boolean miniCloud;
    @Field
    private double size = 0.0;
    @Field
    private String sharedTimeStamp = null;
    @Field
    private boolean sharedByMe;
    @Field
    private String sharedBy;
    @Field
    @Indexed
    private String userName;
    @DBRef
    private List<FileRevision> fileRevisions;
    @Field
    private boolean FileInfected;

    public List<FileRevision> getFileRevisions() {
        return this.fileRevisions;
    }

    public void setFileRevisions(List<FileRevision> fileRevisions) {
        this.fileRevisions = fileRevisions;
    }

    public boolean isSharedByMe() {
        return this.sharedByMe;
    }

    public void setSharedByMe(boolean sharedByMe) {
        this.sharedByMe = sharedByMe;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDevicePath() {
        return this.devicePath;
    }

    public void setDevicePath(String devicePath) {
        this.devicePath = devicePath;
    }

    public boolean isFolder() {
        return this.folder;
    }

    public void setFolder(boolean folder) {
        this.folder = folder;
    }

    public boolean isMiniCloud() {
        return this.miniCloud;
    }

    public void setMiniCloud(boolean miniCloud) {
        this.miniCloud = miniCloud;
    }

    public ObjectId getId() {
        return this.id;
    }

    public void setId(ObjectId id) {
        this.id = id;
    }

    public long getCrawlStartTimestamp() {
        return this.crawlStartTimestamp;
    }

    public void setCrawlStartTimestamp(long crawlStartTimestamp) {
        this.crawlStartTimestamp = crawlStartTimestamp;
    }

    public String getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(String modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String metaData) {
        this.metaData = metaData;
    }

    public boolean isPresent() {
        return this.present;
    }

    public void setPresent(boolean present) {
        this.present = present;
    }

    public String getMD5() {
        return this.md5;
    }

    public void setMD5(String mD5) {
        this.md5 = mD5;
    }

    public String getRegID() {
        return this.regID;
    }

    public void setRegID(String regID) {
        this.regID = regID;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public String getSharedTimeStamp() {
        return this.sharedTimeStamp;
    }

    public void setSharedTimeStamp(String sharedTimeStamp) {
        this.sharedTimeStamp = sharedTimeStamp;
    }

    public String getSharedBy() {
        return this.sharedBy;
    }

    public void setSharedBy(String sharedBy) {
        this.sharedBy = sharedBy;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String toString() {
        return "ConsolidatedImage [id=" + String.valueOf(this.id) + ", fileName=" + this.fileName + ", devicePath=" + this.devicePath + ",crawlStartTimestamp=" + this.crawlStartTimestamp + ", modifiedTime=" + this.modifiedTime + ", metaData=" + this.metaData + ", regID=" + this.regID + ", present=" + this.present + ", md5=" + this.md5 + ", folder=" + this.folder + ", size=" + this.size + ", shared=" + this.sharedTimeStamp + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ConsolidatedImage)) {
            return false;
        }
        ConsolidatedImage consolidatedImage = (ConsolidatedImage)object;
        if (consolidatedImage.getId() != null) {
            return consolidatedImage.getId().equals((Object)this.getId());
        }
        if (consolidatedImage.getDevicePath().equals(this.getDevicePath()) && consolidatedImage.getFileName().equals(this.getFileName())) {
            return consolidatedImage.getMD5().equals(this.getMD5()) && consolidatedImage.isPresent() == this.isPresent();
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public boolean isFileInfected() {
        return this.FileInfected;
    }

    public void setFileInfected(boolean fileInfected) {
        this.FileInfected = fileInfected;
    }
}

