/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.ReadPreference;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.FailedLogin;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.SharePointProperties;
import com.parablu.pcbd.domain.SyncPolicy;
import com.parablu.pcbd.domain.User;
import com.pg.factory.BlukryptMongoFactoryUtils;
import com.pg.helper.constant.PCHelperConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.util.CollectionUtils;

public class UserDaoImpl
implements UserDao {
    Logger logger = LogManager.getLogger(UserDaoImpl.class);
    private static final String ACTIVE = "active";
    private static final String DELETED = "deleted";
    private static final String EMAILID = "emailId";
    private static final String USER_NAME = "userName";
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;

    private void logMessage(String logMessage) {
        this.logger.trace(logMessage);
    }

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public List<User> getAllUsers(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllActiveUsers(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, String cloudName, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public User getUserInfo(int cloudId, String cloudName, String userId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId));
        return (User)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
    }

    @Override
    public User updateUser(int cloudId, String cloudName, User user) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.save((Object)user);
        return user;
    }

    @Override
    public void deleteUser(int cloudId, String cloudName, User user) {
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).remove((Object)user);
    }

    @Override
    public void deleteUsers(int cloudId, String cloudName, List<String> userIdList) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userId").in(userIdList)});
        Query query = new Query((CriteriaDefinition)criteria);
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).remove(query, User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, String cloudName, List<String> userIdlist) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userId").in(userIdlist), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public User getUserInfoByName(int cloudId, String cloudName, String userName) {
        this.logMessage("******Before, Inside getUserInfoByName***** ");
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logMessage("*****After, Inside getUserInfoByName****** ");
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        if (user == null) {
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"userNameLowerCase").is((Object)userName), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
            query = new Query((CriteriaDefinition)criteria);
        }
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public long countOfPresentUsers(int cloudId, String cloudName) {
        Query query = new Query();
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).count(query, User.class);
    }

    @Override
    public long countOfPresentUsers(int cloudId, String cloudName, boolean active) {
        Criteria criteria = Criteria.where((String)ACTIVE).is((Object)active);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).count(query, User.class);
    }

    @Override
    public long countOfPresentSyncUsers(int cloudId, String cloudName, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"syncEnabled").is((Object)active)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).count(query, User.class);
    }

    @Override
    public long countOfPresentBackupUsers(int cloudId, String cloudName, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"backupEnabled").is((Object)active)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).count(query, User.class);
    }

    @Override
    public List<User> getAllAdmins(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"admin").is((Object)true), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllShareEnabledActiveUsers(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"shareEnabled").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public void saveFailedLogin(int cloudId, String cloudName, FailedLogin failedLogin) {
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)failedLogin);
    }

    @Override
    public User saveUser(int cloudId, String cloudName, User user) {
        user.setLastModifiedTimestamp(Long.toString(System.currentTimeMillis()));
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)user);
        return user;
    }

    @Override
    public List<User> searchUsers(int cloudId, List<String> list) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        for (String userName : list) {
            userName = userName.trim();
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName, 2)), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
            List userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class);
            if (userDbList == null) continue;
            for (User userObj : userDbList) {
                userList.add(userObj);
            }
        }
        return userList;
    }

    @Override
    public List<User> getUsersNotConnectedToDevice(int cloudId, List<ObjectId> existingUserIDList) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userId").nin(existingUserIDList)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public void updateUserPolicy(int cloudId, String policyName, ObjectId userId) {
        Criteria criteria = Criteria.where((String)"userId").is((Object)userId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("policyName", (Object)policyName);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, (UpdateDefinition)update, User.class);
    }

    @Override
    public List<User> getUsersNotConnectedToDevice(int cloudId, List<ObjectId> existingUserIDList, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userId").nin(existingUserIDList)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllDeletedUsersById(int cloudId, String cloudName, List<ObjectId> userIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userId").in(userIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, List<ObjectId> userIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userId").in(userIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public boolean checkIfEmailAlreadyExists(int cloudId, String emailId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)EMAILID).is((Object)emailId)});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
        return !CollectionUtils.isEmpty((Collection)list);
    }

    @Override
    public List<User> getAllUsersForNames(int cloudId, List<String> usersNames) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).in(usersNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public User getUserByName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public User getAdminUserWithServerBackupEnabled(int cloudId) {
        this.logger.debug("User getAdminUserWithServerBackupEnabled(int cloudId) > BEGIN");
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true).and("admin").is((Object)true).and("serverBackupEnabled").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        this.logger.debug("User getAdminUserWithServerBackupEnabled(int cloudId) > BEFORE RETURN > USER OBJ > " + String.valueOf(user));
        return user;
    }

    @Override
    public List<User> searchUsersByEmail(int cloudId, List<String> list) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        for (String email : list) {
            email = email.trim();
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)EMAILID).regex(Pattern.compile("^" + email, 2)), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
            List userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class);
            if (userDbList == null) continue;
            for (User userObj : userDbList) {
                userList.add(userObj);
            }
        }
        return userList;
    }

    @Override
    public User getUserDetailsForEmail(int cloudId, String email) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)EMAILID).is((Object)email)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (User)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
    }

    @Override
    public void updateUserStoragePath(int cloudId, String userName, String path, boolean isSync) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)userName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        if (isSync) {
            update.set("cloudSyncStoragePath", (Object)path);
        } else {
            update.set("cloudBkpStoragePath", (Object)path);
        }
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, (UpdateDefinition)update, User.class);
    }

    @Override
    public List<User> getAllUser(int cloudId) {
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAll(User.class);
    }

    @Override
    public String getSyncPolicyNameByUserName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        User user = (User)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
        if (user != null) {
            return user.getSyncPolicyName();
        }
        return "";
    }

    @Override
    public List<User> getAllUsersForPolicy(int cloudId, String policyName) {
        this.logMessage("******Before, Inside getAllUsersForPolicy***** ");
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").regex(Pattern.compile(policyName)), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logMessage("*****After, Inside getAllUsersForPolicy****** ");
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getAllUsersForOfficeBackupPolicy(int cloudId, String policyName, String productType) {
        Criteria policyTypeCriteria = new Criteria();
        this.logger.debug("...sssapolicyType...." + policyName + ".." + productType);
        if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(productType)) {
            policyTypeCriteria.andOperator(new Criteria[]{Criteria.where((String)"oneDrivePolicyName").is((Object)policyName), Criteria.where((String)"onedriveBkpEnabled").is((Object)true), Criteria.where((String)ACTIVE).is((Object)true)});
            this.logger.debug("...sssapolicyType..oneDrivePolicyName.." + policyName + ".." + productType);
        } else if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(productType)) {
            policyTypeCriteria.andOperator(new Criteria[]{Criteria.where((String)"exchangePolicyName").is((Object)policyName), Criteria.where((String)"exchangeBkpEnabled").is((Object)true), Criteria.where((String)ACTIVE).is((Object)true)});
        } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(productType)) {
            policyTypeCriteria.andOperator(new Criteria[]{Criteria.where((String)"spPolicyName").is((Object)policyName), Criteria.where((String)"site").is((Object)true), Criteria.where((String)ACTIVE).is((Object)true)});
        }
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{policyTypeCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    private OfficeBackupPolicy getOdbPolicyByName(int cloudId, String policyName, String policyType) {
        if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
            policyType = "ODB";
        } else if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
            policyType = "Exchange";
        } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
            policyType = "Sharepoint";
        }
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName), Criteria.where((String)"policyType").is((Object)policyType)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (OfficeBackupPolicy)paracloudMongoTemplate.findOne(query, OfficeBackupPolicy.class);
    }

    @Override
    public BackupPolicy getBackupPolicyByPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)criteria);
        return (BackupPolicy)mongoTemplate.findOne(query, BackupPolicy.class);
    }

    @Override
    public SyncPolicy getSyncPolicyByPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (SyncPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), SyncPolicy.class);
    }

    @Override
    public void updateFailedMailBox(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("failedMailBox", (Object)true);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, (UpdateDefinition)update, User.class);
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyForUserName(int cloudId, String userName, String policyType) {
        OfficeBackupPolicy oneDriveBackupPolicy = null;
        Criteria policyTypeCriteria = new Criteria();
        if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria = Criteria.where((String)"onedriveBkpEnabled").is((Object)true);
        } else if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria = Criteria.where((String)"exchangeBkpEnabled").is((Object)true);
        } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria = Criteria.where((String)"site").is((Object)true);
        }
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)ACTIVE).is((Object)true), policyTypeCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        List userList = paracloudMongoTemplate.find(query, User.class);
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            User user = (User)userList.get(0);
            if (user != null) {
                String policyName = "";
                if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
                    policyName = user.getOneDrivePolicyName();
                } else if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
                    policyName = user.getExchangePolicyName();
                } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
                    policyName = user.getSpPolicyName();
                }
                oneDriveBackupPolicy = this.getOdbPolicyByName(cloudId, policyName, policyType);
            } else {
                this.logger.debug("..........user not found1....." + userName);
            }
        } else {
            this.logger.debug("..........user not found....." + userName);
        }
        return oneDriveBackupPolicy;
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyForPolicyName(int cloudId, String policyName, String policyType) {
        this.logger.debug(policyName + "...getOfficeBackupPolicyForPolicyName...." + policyType);
        OfficeBackupPolicy oneDriveBackupPolicy = this.getOdbPolicyByName(cloudId, policyName, policyType);
        return oneDriveBackupPolicy;
    }

    @Override
    public List<User> getAllSitesForOfficeBackupPolicy(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"site").is((Object)true), Criteria.where((String)"spPolicyName").is((Object)policyName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public User getUserSite(int cloudId, String siteName) {
        User user = null;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"site").is((Object)true), Criteria.where((String)USER_NAME).is((Object)siteName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        List list = paracloudMongoTemplate.find(query, User.class, "SITE_DISCOVERY");
        if (!CollectionUtils.isEmpty((Collection)list)) {
            user = (User)list.get(0);
        }
        return user;
    }

    @Override
    public List<User> getAllBlockedUsers(int cloudId) {
        Criteria criteria = Criteria.where((String)ACTIVE).is((Object)false);
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getExistingSites(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"site").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class, "SITE_DISCOVERY");
    }

    @Override
    public void createSite(int cloudId, User site) {
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)site, "SITE_DISCOVERY");
    }

    @Override
    public SharePointProperties getSPProperties(int cloudId) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (SharePointProperties)paracloudMongoTemplate.findOne(new Query(), SharePointProperties.class);
    }

    @Override
    public List<User> getActiveSPSites(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"site").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getAllSPSites(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"site").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getAllReadOnlyAdminsForPolicyName(int cloudId, List<String> policyNames) {
        Criteria criteria = new Criteria();
        Criteria policyCriteria = new Criteria();
        policyCriteria.orOperator(new Criteria[]{Criteria.where((String)"odbPoliciesAdmin").in(policyNames), Criteria.where((String)"backupPoliciesAdmin").in(policyNames)});
        criteria.andOperator(new Criteria[]{Criteria.where((String)"readOnlyAdmin").is((Object)true), policyCriteria, criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }
}

