/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.ReadPreference;
import com.mongodb.client.result.UpdateResult;
import com.parablu.pcbd.dao.SyncBackUpImageDAO;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.User;
import com.pg.factory.BlukryptMongoFactoryUtils;
import com.pg.helper.constant.PCHelperConstant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.util.CollectionUtils;

public class SyncBackUpImageDAOImpl
implements SyncBackUpImageDAO {
    private static final String BACKUP = "BACKUP";
    private static final String DEVICE_PATH = "devicePath";
    private static final String FILE_NAME = "fileName";
    private static final String USER_NAME = "userName";
    private static final String LAST_SERVER_MODIFIED_TIME = "lastServerModifiedTime";
    private static final String STATUS = "status";
    private static final String DELETED = "DELETED";
    private static final String RESTORED = "RESTORED";
    private static final String PRESENT = "present";
    Logger logger = LoggerFactory.getLogger(SyncBackUpImageDAOImpl.class);
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;

    private void logMessage(String logMessage) {
        this.logger.debug(logMessage);
    }

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    private List<String> getCollectionsForSyncQuery(User user, MiniCloud miniCloud) {
        ArrayList<String> queryTablesList = new ArrayList<String>();
        if (user != null && StringUtils.isNotEmpty((String)user.getSyncDestinationCollection())) {
            queryTablesList.add(user.getSyncDestinationCollection());
        } else if (miniCloud != null && StringUtils.isNotEmpty((String)miniCloud.getSyncDestinationCollection())) {
            queryTablesList.add(miniCloud.getSyncDestinationCollection());
        } else if (PCHelperConstant.isBackupCollectionQueryRequired()) {
            queryTablesList.add(BACKUP);
        }
        return queryTablesList;
    }

    @Override
    public BackUpImage getBackUpImageDBRecordByDevicePath(int cloudId, String userName, String cloudName, String devicePath, String fileName, User user, MiniCloud miniCloud) {
        String dest;
        this.logMessage("--- Getting BackUpImage by device path ---");
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackUpImage backUpImage = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (backUpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        return backUpImage;
    }

    @Override
    public BackUpImage getExistingBackUpImageDBRecordByDevicePathForFolderLatest(int cloudId, String userName, String cloudName, String devicePath, String fileName, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        if (!backUpImageList.isEmpty()) {
            backUpImageList.get(0);
        }
        return null;
    }

    @Override
    public void updateDeletedFolder(int cloudId, ObjectId backUpImageId, User user, MiniCloud miniCloud) {
        Criteria criteria = Criteria.where((String)"id").is((Object)backUpImageId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(PRESENT, (Object)true);
        update.set(STATUS, (Object)"ADDED");
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            UpdateResult updateFirst = mongoTemplate.updateFirst(query, (UpdateDefinition)update, BackUpImage.class, dest);
            if (!updateFirst.wasAcknowledged()) continue;
            this.logger.debug("--- Update Deleted Folder --- " + updateFirst.getModifiedCount() + " --- " + updateFirst.wasAcknowledged());
            break;
        }
    }

    @Override
    public BackUpImage getExistingBackUpImageDBRecordByDevicePathForFolder(int cloudId, String userName, String cloudName, String devicePath, String fileName, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)true)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        if (!backUpImageList.isEmpty()) {
            return (BackUpImage)backUpImageList.get(0);
        }
        return null;
    }

    @Override
    public void saveToBackUpImageDB(int cloudId, BackUpImage backUpImage, User user, MiniCloud miniCloud) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (user != null && StringUtils.isNotEmpty((String)user.getSyncDestinationCollection())) {
            mongoTemplate.save((Object)backUpImage, user.getSyncDestinationCollection());
        } else if (miniCloud != null && StringUtils.isNotEmpty((String)miniCloud.getSyncDestinationCollection())) {
            mongoTemplate.save((Object)backUpImage, miniCloud.getSyncDestinationCollection());
        } else {
            mongoTemplate.save((Object)backUpImage);
        }
    }

    @Override
    public long getCountOfVersionsForFile(int cloudId, BackUpImage backUpImage, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(RESTORED);
        statusList.add(DELETED);
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)backUpImage.getDevicePath()), Criteria.where((String)FILE_NAME).is((Object)backUpImage.getFileName()), Criteria.where((String)STATUS).nin(statusList)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long count = 0L;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            count += mongoTemplate.count(query, BackUpImage.class, dest);
        }
        return count;
    }

    @Override
    public BackUpImage getOldestRevision(int cloudId, BackUpImage backUpImage, User user, MiniCloud miniCloud) {
        String dest;
        Criteria criteria = new Criteria();
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(DELETED);
        statusList.add(RESTORED);
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)backUpImage.getDevicePath()), Criteria.where((String)FILE_NAME).is((Object)backUpImage.getFileName()), Criteria.where((String)STATUS).nin(statusList)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackUpImage backUpImageOldestRevision = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (backUpImageOldestRevision = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        return backUpImageOldestRevision;
    }

    @Override
    public void deleteBackUpImageRevision(int cloudId, BackUpImage backUpImage, User user, MiniCloud miniCloud) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String destinationCollection = null;
        if (user != null) {
            destinationCollection = user.getSyncDestinationCollection();
        } else if (miniCloud != null) {
            destinationCollection = miniCloud.getSyncDestinationCollection();
        } else if (PCHelperConstant.isBackupCollectionQueryRequired()) {
            destinationCollection = BACKUP;
        }
        mongoTemplate.remove((Object)backUpImage, destinationCollection);
    }

    @Override
    public BackUpImage getSyncBackUpImageById(int cloudId, String syncBackUpImageId, User user, MiniCloud miniCloud) {
        String dest;
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)syncBackUpImageId));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackUpImage backUpImage = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (backUpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        return backUpImage;
    }

    @Override
    public List<BackUpImage> getAllChildFilesOfFolder(int cloudId, String userName, String devicePath, boolean isFolder, User user, MiniCloud miniCloud, boolean isRestoreDeletedFile) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"folder").is((Object)isFolder)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)"folder").is((Object)isFolder), Criteria.where((String)USER_NAME).is((Object)userName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        ArrayList<BackUpImage> filteredList = new ArrayList<BackUpImage>();
        backUpImageList.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName))).forEach((key1, value1) -> value1.forEach((key2, value2) -> filteredList.add(value2.stream().max(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).get())));
        if (!isRestoreDeletedFile) {
            return filteredList.stream().filter(filteredImage -> !filteredImage.getStatus().equalsIgnoreCase(DELETED)).collect(Collectors.toList());
        }
        return filteredList;
    }

    @Override
    public BackUpImage getSyncBackUpImageForDeletedVersion(int cloudId, String devicePath, String fileName, User user, MiniCloud miniCloud) {
        BackUpImage backUpImage = null;
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(RESTORED);
        statusList.add(DELETED);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)STATUS).nin(statusList)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        query.limit(1);
        String queryTable = this.getCollectionForSyncQuery(user, miniCloud);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List versionsList = mongoTemplate.find(query, BackUpImage.class, queryTable);
        backUpImage = (BackUpImage)versionsList.get(0);
        return backUpImage;
    }

    @Override
    public List<BackUpImage> getAllSyncFilesToBeDeletedByUserName(int cloudId, long filesExpiredDate, String userName, User user) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)LAST_SERVER_MODIFIED_TIME).lt((Object)filesExpiredDate), Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"folder").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(200);
        this.logger.debug(" limit 200 files........." + filesExpiredDate);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String queryTable = this.getCollectionForSyncQuery(user, null);
        return mongoTemplate.find(query, BackUpImage.class, queryTable);
    }

    @Override
    public List<BackUpImage> getVersions(int cloudId, String cloudName, String userName, String fileName, String fileCompletePath, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)fileCompletePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)fileCompletePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)USER_NAME).is((Object)userName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<BackUpImage> backUpImageList = new ArrayList<BackUpImage>();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        return backUpImageList;
    }

    @Override
    public BackUpImage getSyncBackUpImageForFile(int cloudId, String cloudName, String fileName, String devicePath, boolean readPreference, User user, MiniCloud miniCloud) {
        String dest;
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)devicePath)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (readPreference) {
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        }
        BackUpImage backUpImage = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (backUpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        return backUpImage;
    }

    @Override
    public BackUpImage getSyncBackUpImageWithNullPath(int cloudId, String cloudName, String fileName, User user, MiniCloud miniCloud) {
        String dest;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is(null), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackUpImage bkpImage = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (bkpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        return bkpImage;
    }

    @Override
    public BackUpImage getSyncBackUpImageForId(int cloudId, String cloudName, String userName, String backUpImageId, User user, MiniCloud miniCloud) {
        String dest;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backUpImageId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackUpImage backUpImage = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (backUpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        if (backUpImage != null && StringUtils.isNotEmpty((String)backUpImage.getStoragePlace()) && CollectionUtils.isEmpty(backUpImage.getChunkFiles())) {
            backUpImage = this.getParentBackUpImageForMd5(cloudId, userName, user, miniCloud, backUpImage.getMd5Checksum());
        }
        return backUpImage;
    }

    @Override
    public BackUpImage getParentBackUpImageForMd5(int cloudId, String userName, User user, MiniCloud miniCloud, String md5Checksum) {
        Criteria criteria = new Criteria();
        if (!userName.isEmpty()) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i")});
        }
        criteria.andOperator(new Criteria[]{Criteria.where((String)"md5Checksum").exists(true), Criteria.where((String)STATUS).ne((Object)DELETED), Criteria.where((String)"md5Checksum").is((Object)md5Checksum)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        query.limit(1);
        String queryTable = this.getCollectionForSyncQuery(user, miniCloud);
        List versionsList = mongoTemplate.find(query, BackUpImage.class, queryTable);
        BackUpImage backUpImage = (BackUpImage)versionsList.get(0);
        return backUpImage;
    }

    private String getCollectionForSyncQuery(User user, MiniCloud miniCloud) {
        String queryTable = null;
        if (user != null && StringUtils.isNotEmpty((String)user.getSyncDestinationCollection())) {
            queryTable = user.getSyncDestinationCollection();
        } else if (miniCloud != null && StringUtils.isNotEmpty((String)miniCloud.getSyncDestinationCollection())) {
            queryTable = miniCloud.getSyncDestinationCollection();
        } else if (PCHelperConstant.isBackupCollectionQueryRequired()) {
            queryTable = BACKUP;
        }
        return queryTable;
    }
}

