/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.pcbd.dao.DailyUserBackupOverviewDao;
import com.parablu.pcbd.domain.DailyUserBackupOverView;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.pg.factory.BlukryptMongoFactoryUtils;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class DailyUserBackupOverviewDaoImpl
implements DailyUserBackupOverviewDao {
    Logger logger = LogManager.getLogger(DailyUserBackupOverviewDaoImpl.class);
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;
    private static final String DEVICE_UUID = "deviceUUID";

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public DailyUserBackupOverView getDailyUserBackupOverview(int cloudId, String userName, String deviceUUID, long storageDate) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").regex(Pattern.compile("^" + userName + "$", 2)), Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)"storageDate").is((Object)storageDate)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (DailyUserBackupOverView)mongoTemplate.findOne(query, DailyUserBackupOverView.class);
    }

    @Override
    public void saveDailyUserBackupOverView(int cloudId, DailyUserBackupOverView userBackupOverView) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long storageUtilizedInCloud = this.getCloudStorageUsed(cloudId, userBackupOverView.getDeviceUUID());
        long storageUtilizedInPg = 0L;
        DailyUserBackupOverView existingDailyUserBackupOverView = this.getDailyUserBackupOverview(cloudId, userBackupOverView.getUserName(), userBackupOverView.getDeviceUUID(), userBackupOverView.getStorageDate());
        this.logger.debug(userBackupOverView.getStorageUtilizedInPg() + "...before save storage details............ " + userBackupOverView.getStorageUtilizedInCloud());
        if (existingDailyUserBackupOverView != null) {
            Map<String, Long> blukrytStorageMap = this.updatePgStorage(userBackupOverView, existingDailyUserBackupOverView);
            userBackupOverView.setBlukryptStorageUtilized(blukrytStorageMap);
            mongoTemplate.remove((Object)existingDailyUserBackupOverView);
        }
        if (userBackupOverView.getBlukryptStorageUtilized() != null) {
            for (Map.Entry entry : userBackupOverView.getBlukryptStorageUtilized().entrySet()) {
                Long value = (Long)entry.getValue();
                storageUtilizedInPg += value.longValue();
            }
        }
        userBackupOverView.setStorageUtilizedInCloud(storageUtilizedInCloud);
        mongoTemplate.save((Object)userBackupOverView);
        Calendar cal = Calendar.getInstance();
        cal.add(5, -30);
        try {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").regex(Pattern.compile("^" + userBackupOverView.getUserName() + "$", 2)), Criteria.where((String)DEVICE_UUID).is((Object)userBackupOverView.getDeviceUUID()), Criteria.where((String)"storageDate").lt((Object)cal.getTimeInMillis())});
            Query query = new Query((CriteriaDefinition)criteria);
            mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.remove(query, DailyUserBackupOverView.class);
        }
        catch (Exception exception) {
            this.logger.trace(" save overview report error....." + String.valueOf(exception));
            this.logger.error("........unable to save overview report........" + cal.getTimeInMillis());
        }
    }

    private Map<String, Long> updatePgStorage(DailyUserBackupOverView userBackupOverView, DailyUserBackupOverView existingDailyUserBackupOverView) {
        Set<Map.Entry<String, Long>> entrySet;
        Map<String, Long> blukrytStorageMap = userBackupOverView.getBlukryptStorageUtilized();
        Map<String, Long> existingBlukrytStorageMap = existingDailyUserBackupOverView.getBlukryptStorageUtilized();
        if (existingBlukrytStorageMap == null) {
            existingBlukrytStorageMap = new HashMap<String, Long>();
        }
        if (blukrytStorageMap != null && !(entrySet = blukrytStorageMap.entrySet()).isEmpty()) {
            Map.Entry<String, Long> entry = entrySet.iterator().next();
            String key = entry.getKey();
            Long value = entry.getValue();
            existingBlukrytStorageMap.remove(key);
            existingBlukrytStorageMap.put(key, value);
        }
        return existingBlukrytStorageMap;
    }

    private DeviceBackupOverView getDeviceBkpOverviewForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (DeviceBackupOverView)mongoTemplate.findOne(query, DeviceBackupOverView.class);
    }

    public long getCloudStorageUsed(int cloudId, String deviceUUID) {
        DeviceBackupOverView deviceBackupOverView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
        long totalSize = 0L;
        if (deviceBackupOverView != null) {
            totalSize = deviceBackupOverView.getStorageUtilizedInCloud();
        }
        this.logger.debug(deviceUUID + ".....cloud storage used for deviceuuid ..... " + totalSize);
        return totalSize;
    }
}

