/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCredentials;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.CloudPluginDetails;
import com.parablu.pcbd.domain.CloudProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class CloudDaoImpl
implements CloudDao {
    private static Logger logger = LogManager.getLogger(CloudDaoImpl.class);
    private MongoOperations mongoOps;

    public MongoOperations getMongoOps() {
        return this.mongoOps;
    }

    public void setMongoOps(MongoOperations mongoOps) {
        this.mongoOps = mongoOps;
    }

    @Override
    public Cloud getCloudDetails(String cloudName) {
        Criteria criteria = Criteria.where((String)"cloudName").regex(Pattern.compile("^" + cloudName + "$", 2));
        Query query = new Query((CriteriaDefinition)criteria);
        return (Cloud)this.mongoOps.findOne(query, Cloud.class);
    }

    @Override
    public void saveCloud(Cloud cloud) {
        this.mongoOps.save((Object)cloud);
    }

    @Override
    public void updateCloudLicense(Cloud cloud) {
        this.mongoOps.save((Object)cloud);
    }

    @Override
    @Cacheable(value={"getCloud"})
    public List<Cloud> getAllClouds() {
        logger.debug("**************Inside");
        return this.mongoOps.findAll(Cloud.class);
    }

    @Override
    public void createNewCloud(Cloud cloud) {
        this.addCloudPlugins(cloud);
        this.addCloudCustomizable(cloud);
        this.mongoOps.save((Object)cloud);
    }

    private void addCloudPlugins(Cloud cloud) {
        List<CloudPluginDetails> cloudPluginDetailsList = cloud.getCloudPluginDetails();
        ArrayList<CloudPluginDetails> newCloudPluginDetailsList = new ArrayList<CloudPluginDetails>();
        for (CloudPluginDetails cloudPluginDetails : cloudPluginDetailsList) {
            Criteria criteria = Criteria.where((String)"pluginName").is((Object)cloudPluginDetails.getPluginName());
            Query query = new Query((CriteriaDefinition)criteria);
            CloudPluginDetails existingPluginDetails = (CloudPluginDetails)this.mongoOps.findOne(query, CloudPluginDetails.class);
            if (existingPluginDetails == null) {
                this.mongoOps.save((Object)cloudPluginDetails);
                newCloudPluginDetailsList.add(cloudPluginDetails);
                continue;
            }
            newCloudPluginDetailsList.add(existingPluginDetails);
        }
        cloud.getCloudPluginDetails().clear();
        cloud.getCloudPluginDetails().addAll(newCloudPluginDetailsList);
    }

    private void addCloudCustomizable(Cloud cloud) {
        List<CloudCustomisableDetails> cloudCustomisableDetailsList = cloud.getCloudCustomisableDetails();
        ArrayList<CloudCustomisableDetails> newCloudCustomisableDetailsList = new ArrayList<CloudCustomisableDetails>();
        for (CloudCustomisableDetails cloudCustomizableDetails : cloudCustomisableDetailsList) {
            Criteria criteria = Criteria.where((String)"name").is((Object)cloudCustomizableDetails.getName());
            Query query = new Query((CriteriaDefinition)criteria);
            CloudCustomisableDetails existingPluginDetails = (CloudCustomisableDetails)this.mongoOps.findOne(query, CloudCustomisableDetails.class);
            if (existingPluginDetails == null) {
                this.mongoOps.save((Object)cloudCustomizableDetails);
                newCloudCustomisableDetailsList.add(cloudCustomizableDetails);
                continue;
            }
            newCloudCustomisableDetailsList.add(existingPluginDetails);
        }
        cloud.getCloudCustomisableDetails().clear();
        cloud.getCloudCustomisableDetails().addAll(newCloudCustomisableDetailsList);
    }

    @Override
    public void updateAmazonCloud(String cloudName) {
        Criteria criteria = Criteria.where((String)"cloudName").is((Object)"");
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("cloudName", (Object)cloudName.toLowerCase());
        this.mongoOps.updateFirst(query, (UpdateDefinition)update, Cloud.class);
    }

    @Override
    public void saveCloudCredentials(int cloudId, CloudCredentials cloudCredentials) {
        Criteria criteria = Criteria.where((String)"cloudId").is((Object)cloudId);
        Query query = new Query((CriteriaDefinition)criteria);
        Cloud cloud = (Cloud)this.mongoOps.findOne(query, Cloud.class);
        criteria = Criteria.where((String)"identity").is((Object)cloudCredentials.getIdentity());
        query = new Query((CriteriaDefinition)criteria);
        CloudCredentials credentials = (CloudCredentials)this.mongoOps.findOne(query, CloudCredentials.class);
        if (credentials != null) {
            credentials.setCredential(cloudCredentials.getCredential());
            credentials.setEndPointUrl(cloudCredentials.getEndPointUrl());
            credentials.setProvider(cloudCredentials.getProvider());
            this.mongoOps.save((Object)credentials);
            this.saveCredentialsToCloud(cloud);
        } else {
            this.mongoOps.save((Object)cloudCredentials);
            this.saveCredentialsToCloud(cloud);
        }
    }

    private void saveCredentialsToCloud(Cloud cloud) {
        List allCredentials = this.mongoOps.findAll(CloudCredentials.class);
        cloud.getCloudCredentials().clear();
        cloud.getCloudCredentials().addAll(allCredentials);
        this.mongoOps.save((Object)cloud);
    }

    @Override
    public List<CloudCredentials> getAllCloudCredentials(int cloudId) {
        return this.mongoOps.findAll(CloudCredentials.class);
    }

    @Override
    public void deleteCloudCredentials(int cloudId, String cloudTypeName) {
        Criteria criteria = Criteria.where((String)"cloudName").is((Object)cloudTypeName);
        Query query = new Query((CriteriaDefinition)criteria);
        CloudCredentials credentials = (CloudCredentials)this.mongoOps.findOne(query, CloudCredentials.class);
        if (credentials != null) {
            this.mongoOps.remove((Object)credentials);
        }
    }

    @Override
    public CloudCredentials getCloudCredentials(int cloudId, String identity) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"identity").is((Object)identity)});
        return (CloudCredentials)this.mongoOps.findOne(new Query((CriteriaDefinition)criteria), CloudCredentials.class);
    }

    @Override
    public CloudProperties getCloudProperties(int cloudId) {
        List cloudProps = this.mongoOps.findAll(CloudProperties.class);
        if (cloudProps != null && !cloudProps.isEmpty()) {
            return (CloudProperties)cloudProps.get(0);
        }
        return null;
    }
}

