/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.pcbd.dao.BlackListUserDao;
import com.parablu.pcbd.domain.BlackListUser;
import com.parablu.pcbd.domain.User;
import com.pg.factory.BlukryptMongoFactoryUtils;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class BlackListUserDaoImpl
implements BlackListUserDao {
    Logger logger = LogManager.getLogger(BlackListUserDaoImpl.class);
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public void saveBlackListUser(int cloudId, BlackListUser blackListUser) {
        blackListUser.setBlackListedTime(System.currentTimeMillis());
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)blackListUser);
    }

    @Override
    public List<BlackListUser> getAllBlackListUsers(int cloudId) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.findAll(BlackListUser.class);
    }

    @Override
    public BlackListUser getBlackListUserbyName(int cloudId, String userName, String localHost) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserName = Criteria.where((String)"userName").regex(Pattern.compile("^" + userName + "$", 2));
        Criteria criteriaLocalHost = Criteria.where((String)"localHost").is((Object)localHost);
        criteria.andOperator(new Criteria[]{criteriaUserName, criteriaLocalHost});
        Query query = new Query((CriteriaDefinition)criteria);
        return (BlackListUser)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, BlackListUser.class);
    }

    @Override
    public void deleteBlackListUserByUserName(int cloudId, String userName) {
        Criteria criteriaUserName = Criteria.where((String)"userName").regex(Pattern.compile("^" + userName + "$", 2));
        Query query = new Query((CriteriaDefinition)criteriaUserName);
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).remove(query, BlackListUser.class);
    }

    @Override
    public void deleteBlackListUser(int cloudId, String userName, String localHost) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserName = Criteria.where((String)"userName").regex(Pattern.compile("^" + userName + "$", 2));
        Criteria criteriaLocalHost = Criteria.where((String)"localHost").is((Object)localHost);
        criteria.andOperator(new Criteria[]{criteriaUserName, criteriaLocalHost});
        Query query = new Query((CriteriaDefinition)criteria);
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).remove(query, BlackListUser.class);
    }

    @Override
    public void updateBlackListUserWithCode(int cloudId, String userName, String gateWayName, String code) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserName = Criteria.where((String)"userName").regex(Pattern.compile("^" + userName + "$", 2));
        Criteria criteriaLocalHost = Criteria.where((String)"localHost").is((Object)gateWayName);
        criteria.andOperator(new Criteria[]{criteriaUserName, criteriaLocalHost});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("responseCode", (Object)code);
        update.set("blackListedTime", (Object)System.currentTimeMillis());
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).updateMulti(query, (UpdateDefinition)update, BlackListUser.class);
    }

    @Override
    public void changeTargetAssignByUserName(int cloudId, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"userNameLowerCase").is((Object)userName.toLowerCase());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("backupTargetErrorCode", (Object)404);
        update.set("backupTargetAssigned", (Object)false);
        update.set("lastModifiedTimestamp", (Object)System.currentTimeMillis());
        mongoTemplate.updateFirst(query, (UpdateDefinition)update, User.class);
    }
}

