/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.ReadPreference;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.parablu.paracloud.element.KeyValueElement;
import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackUpImageStatistics;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.User;
import com.pg.factory.BlukryptMongoFactoryUtils;
import com.pg.helper.constant.PCHelperConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.util.CollectionUtils;

public class BackUpImageDaoImpl
implements BackUpImageDao {
    public static final String BACKUP = "BACKUP";
    private static final String ACTIVE = "active";
    private static final String MD5CHECKUM = "md5Checksum";
    private static final String FILEEXTENSION = "fileExtension";
    private static final String CRC32VAL = "crc32Val";
    private static final String DEVICE_UUID = "deviceUUID";
    private static final String DEVICE = "device";
    private static final String FILE_NAME = "fileName";
    private static final String DEVICE_PATH = "devicePath";
    private static final String LAST_SERVER_MODIFIED_TIME = "lastServerModifiedTime";
    private static final String PRESENT = "present";
    private static final String DEVICE_ID = "device.$id";
    private static final String BLOCKED = "blocked";
    private static final String STATUS = "status";
    private static final String USER_NAME = "userName";
    private static final String DEVICE_NAME = "deviceName";
    private static final String DELETED = "DELETED";
    private static final String MD5_CHECK_SUM = "md5Checksum";
    private static final String FOLDER = "folder";
    Logger logger = LogManager.getLogger(BackUpImageDaoImpl.class);
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;

    private void logMessage(String logMessage) {
        this.logger.debug(logMessage);
    }

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public void saveImageToBackUpDao(int cloudId, String cloudName, BackUpImage backUpImage, Device device) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (StringUtils.isNotEmpty((String)device.getDestCollection())) {
            mongoTemplate.save((Object)backUpImage, device.getDestCollection());
        } else {
            mongoTemplate.save((Object)backUpImage);
        }
    }

    @Override
    public void saveImageToBackUp(int cloudId, BackUpImage backUpImage, Device device) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (StringUtils.isNotEmpty((String)device.getDestCollection())) {
            mongoTemplate.save((Object)backUpImage, device.getDestCollection());
        } else {
            mongoTemplate.save((Object)backUpImage);
        }
    }

    @Override
    public void saveSyncBackUpImageToDB(int cloudId, BackUpImage backUpImage) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backUpImage);
    }

    @Override
    public BackUpImage getBackUpImageForFile(int cloudId, String cloudName, String fileName, String devicePath, Device device, boolean readPreference) {
        this.logMessage("$$$$$Before getting backup image for file$$$$");
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)devicePath)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (readPreference) {
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        }
        BackUpImage backUpImage = null;
        if (StringUtils.isEmpty((String)devicePath)) {
            List list = mongoTemplate.find(query, BackUpImage.class, device.getDestCollection());
            if (CollectionUtils.isEmpty((Collection)list)) {
                for (BackUpImage backUpImageObj : list) {
                    if (!StringUtils.isEmpty((String)devicePath) || !StringUtils.isEmpty((String)backUpImageObj.getDevicePath())) continue;
                    backUpImage = backUpImageObj;
                    break;
                }
            }
        } else {
            backUpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, device.getDestCollection());
        }
        this.logMessage("$$$$$After getting backup image for file$$$$");
        return backUpImage;
    }

    @Override
    public List<BackUpImage> getListOfEntriesExceptGivenListFromTable(int cloudId, String cloudName, List<String> backUpImagePathList, Device device) {
        return Collections.emptyList();
    }

    @Override
    public List<BackUpImage> getAllBackUpDataForDevice(int cloudId, String cloudName, Device device1) {
        Device device = this.getDeviceForId(cloudId, device1.getId());
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public void removeEntryFromTable(int cloudId, String cloudName, BackUpImage backUpImage) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backUpImage);
    }

    @Override
    public List<BackUpImage> getChildrenByFolder(int cloudId, String cloudName, String folderPath, Device device) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<ObjectId> listOfBackupIds = this.getAggregatedBackupIds(mongoTemplate, folderPath, device);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(listOfBackupIds)});
        Query query1 = new Query((CriteriaDefinition)criteria);
        query1.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        return mongoTemplate.find(query1, BackUpImage.class);
    }

    private List<ObjectId> getAggregatedBackupIds(MongoTemplate mongoTemplate, String folderPath, Device device) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        return this.getBackupIds(mongoTemplate, device, (TypedAggregation<BackUpImage>)aggregation);
    }

    private List<ObjectId> getBackupIds(MongoTemplate mongoTemplate, Device device, TypedAggregation<BackUpImage> aggregation) {
        ArrayList stateStatsList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
        for (String dest : queryTablesList) {
            AggregationResults result = mongoTemplate.aggregate(aggregation, dest, BasicDBObject.class);
            List resultList = result.getMappedResults();
            if (CollectionUtils.isEmpty((Collection)resultList)) continue;
            stateStatsList.addAll(resultList);
        }
        ArrayList<ObjectId> listOfObjectIds = new ArrayList<ObjectId>();
        for (BasicDBObject dbObject : stateStatsList) {
            Long lastServerModifiedTime;
            String devicePath;
            String fileName = dbObject.get(FILE_NAME).toString();
            BackUpImage backUpImage = this.getBackUpImageForFile(mongoTemplate, fileName, devicePath = dbObject.get(DEVICE_PATH).toString(), device, lastServerModifiedTime = (Long)dbObject.get(LAST_SERVER_MODIFIED_TIME));
            if (backUpImage == null) continue;
            listOfObjectIds.add(backUpImage.getId());
        }
        return listOfObjectIds;
    }

    private List<String> getCollectionsForBkpQuery(Device device) {
        ArrayList<String> queryTablesList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)device.getDestCollection())) {
            queryTablesList.add(device.getDestCollection());
        }
        if (PCHelperConstant.isBackupCollectionQueryRequired()) {
            queryTablesList.add(BACKUP);
        }
        return queryTablesList;
    }

    private List<BackUpImage> getAllLatestBackup(MongoOperations mongoTemplate, List<ObjectId> listOfBackupIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(listOfBackupIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    private Device getDeviceForId(int cloudId, ObjectId deviceId) {
        this.logMessage("$$$$$Before getting Device info for ID $$$$");
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)deviceId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logMessage("$$$$$After getting device info for ID $$$$");
        return (Device)mongoTemplate.findOne(query, Device.class);
    }

    @Override
    public List<BackUpImage> getVersions(int cloudId, String cloudName, String fileName, String devicePath, Device device) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<BackUpImage> versions = this.getAggregatedBackupImagesForVersions(mongoTemplate, devicePath, fileName, device);
        return versions;
    }

    private List<BackUpImage> getAggregatedBackupImagesForVersions(MongoTemplate mongoTemplate, String folderPath, String fileName, Device device) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        return this.getBackupIMagesForVersions(mongoTemplate, device, (TypedAggregation<BackUpImage>)aggregation);
    }

    private List<BackUpImage> getBackupIMagesForVersions(MongoTemplate mongoTemplate, Device device, TypedAggregation<BackUpImage> aggregation) {
        ArrayList stateStatsList = new ArrayList();
        List<BackUpImage> backupImages = new ArrayList<BackUpImage>();
        List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
        try {
            for (String dest : queryTablesList) {
                this.logger.debug("Before the aggregation....");
                AggregationResults result = mongoTemplate.aggregate(aggregation, dest, Document.class);
                this.logger.debug("After the aggregation......");
                List resultList = result.getMappedResults();
                if (CollectionUtils.isEmpty((Collection)resultList)) continue;
                stateStatsList.addAll(resultList);
            }
            this.logger.debug("result set:" + String.valueOf(stateStatsList));
            for (Document dbObject : stateStatsList) {
                Long lastServerModifiedTime;
                String devicePath;
                String fileName = dbObject.get((Object)FILE_NAME).toString();
                BackUpImage backUpImage = this.getBackUpImageForFile(mongoTemplate, fileName, devicePath = dbObject.get((Object)DEVICE_PATH).toString(), device, lastServerModifiedTime = (Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME));
                if (backUpImage == null) continue;
                backupImages.add(backUpImage);
            }
            backupImages = this.getFilteredBackupImageListForVersions(backupImages);
        }
        catch (Exception e) {
            this.logger.error("exception in getting the versions..", (Throwable)e);
        }
        return backupImages;
    }

    private List<BackUpImage> getFilteredBackupImageListForVersions(List<BackUpImage> backUpImages) {
        this.logger.debug("Inside grouping backup images For versions");
        ArrayList iterateList = new ArrayList();
        backUpImages.stream().collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackUpImage::getLastServerModifiedTime)).entrySet().stream().forEach(p -> iterateList.add((BackUpImage)((List)p.getValue()).stream().findFirst().get()));
        List<BackUpImage> filteredBackUpImages = iterateList.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).collect(Collectors.toList());
        return filteredBackUpImages;
    }

    @Override
    public List<BackUpImage> getAllVersionsOfChildren(int cloudId, String cloudName, String devicePath, ObjectId deviceId) {
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(devicePath);
        Device device = this.getDeviceForId(cloudId, deviceId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), pathLikeCriteria});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getLatestFiles(int cloudId, String cloudName, ObjectId deviceId, int isExternalStorage) {
        Device device = this.getDeviceForId(cloudId, deviceId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)PRESENT).is((Object)true)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME}), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        List<BackUpImage> resList = this.getBackupImagesForRestore(cloudId, (TypedAggregation<BackUpImage>)aggregation, device, null);
        resList = isExternalStorage == 1 ? this.getFilteredBackupImageListOnlyStoragePlaceExists(resList) : this.getFilteredBackupImageList(resList);
        return resList;
    }

    @Override
    public List<BackUpImage> getLatestFiles(int cloudId, String cloudName, ObjectId deviceId, String devicePath, String fileName, boolean isExtrnalStorage) {
        Device device = this.getDeviceForId(cloudId, deviceId);
        this.logger.error("##Start Trying to restore using user .........." + devicePath);
        ArrayList<Long> consolidatedTimeStamps = new ArrayList<Long>();
        Criteria pathLikeCriteria = new Criteria();
        pathLikeCriteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath)});
        List<Long> listOfObjectIds = this.getLatestTimeStampForDevicePath(cloudId, device, pathLikeCriteria);
        consolidatedTimeStamps.addAll(listOfObjectIds);
        this.logger.error("##End Trying to get devicepath list andoperator .........." + listOfObjectIds.size());
        pathLikeCriteria = new Criteria();
        pathLikeCriteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).regex("^" + devicePath + "/", "i")});
        listOfObjectIds = this.getLatestTimeStampForDevicePath(cloudId, device, pathLikeCriteria);
        consolidatedTimeStamps.addAll(listOfObjectIds);
        this.logger.error("##End Trying to get devicepath regex list  .........." + listOfObjectIds.size());
        List<BackUpImage> resList = this.getBackupImagesForRestoreForLatestModifiedTime(cloudId, consolidatedTimeStamps, device);
        if (isExtrnalStorage) {
            resList = this.getFilteredBackupImageListForStoragePlaceExists(resList);
        }
        return resList;
    }

    private List<BackUpImage> getBackupImagesForRestoreForLatestModifiedTime(int cloudId, List<Long> listOfObjectIds, Device device) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug(" before starting basic mongo  ...... ");
        MongoCollection collection = mongoTemplate.getCollection(BACKUP);
        Bson searchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)LAST_SERVER_MODIFIED_TIME, (Object)new Document("$in", listOfObjectIds)), Filters.eq((String)DEVICE_ID, (Object)device.getId())});
        FindIterable find = collection.find(searchQuery);
        this.logger.debug("before Converted FileElementlist................... ");
        ArrayList<BackUpImage> bkpList = new ArrayList<BackUpImage>();
        MongoCursor iterator = find.iterator();
        while (iterator.hasNext()) {
            Document dbObject = (Document)iterator.next();
            BackUpImage backUpImage = (BackUpImage)mongoTemplate.getConverter().read(BackUpImage.class, (Object)dbObject);
            bkpList.add(backUpImage);
        }
        this.logger.debug("Converted final list ................... " + bkpList.size());
        iterator.close();
        return bkpList;
    }

    private List<Long> getLatestTimeStampForDevicePath(int cloudId, Device device, Criteria pathLikeCriteria) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), pathLikeCriteria, Criteria.where((String)PRESENT).is((Object)true)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<Long> listOfObjectIds = new ArrayList<Long>();
        for (BasicDBObject dbObject : stateStatsList) {
            listOfObjectIds.add((Long)dbObject.get(LAST_SERVER_MODIFIED_TIME));
        }
        return listOfObjectIds;
    }

    private List<BackUpImage> getBackupImagesForRestore(int cloudId, TypedAggregation<BackUpImage> aggregation, Device device, Criteria pathLikeCriteria) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.error("$$Before Aggregation .......");
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<Long> listOfObjectIds = new ArrayList<Long>();
        for (BasicDBObject dbObject : stateStatsList) {
            listOfObjectIds.add((Long)dbObject.get(LAST_SERVER_MODIFIED_TIME));
        }
        this.logger.error("$$End of Aggregation ......." + listOfObjectIds.size());
        Criteria criteria = new Criteria();
        Query query = null;
        if (device != null) {
            if (pathLikeCriteria != null) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)LAST_SERVER_MODIFIED_TIME).in(listOfObjectIds)});
                query = new Query((CriteriaDefinition)criteria);
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)LAST_SERVER_MODIFIED_TIME).in(listOfObjectIds), Criteria.where((String)DEVICE).is((Object)device)});
                query = new Query((CriteriaDefinition)criteria);
            }
        } else if (pathLikeCriteria == null) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)LAST_SERVER_MODIFIED_TIME).in(listOfObjectIds)});
            query = new Query((CriteriaDefinition)criteria);
        }
        mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getLatestFiles(int cloudId, String cloudName, ObjectId deviceId, boolean present) {
        Device device = this.getDeviceForId(cloudId, deviceId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME}), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        List<BackUpImage> resList = this.getBackupImagesForRestore(cloudId, (TypedAggregation<BackUpImage>)aggregation, device, null);
        resList = this.getFilteredBackupImageList(resList, present);
        return resList;
    }

    @Override
    public List<BackUpImage> getAllLatestFiles(int cloudId, String cloudName, ObjectId deviceId) {
        Device device = this.getDeviceForId(cloudId, deviceId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME}), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        List<BackUpImage> list = this.getBackupImagesForRestore(cloudId, (TypedAggregation<BackUpImage>)aggregation, device, null);
        list = this.getFilteredBackupImageList(list);
        return list;
    }

    @Override
    public Long getTotalSizeUsed(int cloudId, String cloudName) {
        Long totalSizeUsed = 0L;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List deviceList = mongoTemplate.findAll(DeviceBackupOverView.class);
        for (DeviceBackupOverView deviceBackupOverView : deviceList) {
            if (deviceBackupOverView == null || deviceBackupOverView.isDeviceBolcked()) continue;
            totalSizeUsed = totalSizeUsed + deviceBackupOverView.getStorageUtilized();
        }
        this.logger.debug(" TOTAL Size in cloud ............... " + totalSizeUsed);
        return totalSizeUsed;
    }

    @Override
    public void deleteRevision(int cloudId, String cloudName, BackUpImage backUpImage, Device device) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)backUpImage.getId()));
        this.logger.debug(" %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   " + String.valueOf(backUpImage.getId()));
        List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
        for (String dest : queryTablesList) {
            paracloudMongoTemplate.findAndRemove(query, BackUpImage.class, dest);
        }
    }

    @Override
    public List<Device> getAllBackedUpDevice(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.findAll(DeviceBackupOverView.class);
        ArrayList<Device> existingDeviceList = new ArrayList<Device>();
        for (DeviceBackupOverView deviceBackupOverView : list) {
            Device device;
            if (deviceBackupOverView == null || (device = this.getDeviceForDeviceUUID(cloudId, deviceBackupOverView.getDeviceUUID())) == null) continue;
            existingDeviceList.add(device);
        }
        return existingDeviceList;
    }

    @Override
    public List<BackUpImage> getLatestFiles(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME}), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        List<BackUpImage> resList = this.getBackupImagesForRestore(cloudId, (TypedAggregation<BackUpImage>)aggregation, null, null);
        resList = this.getFilteredBackupImageList(resList);
        return resList;
    }

    @Override
    public List<BackUpImage> getAllLatestFiles(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME}), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        List<BackUpImage> resList = this.getBackupImagesForRestore(cloudId, (TypedAggregation<BackUpImage>)aggregation, null, null);
        resList = this.getFilteredBackupImageList(resList);
        return resList;
    }

    @Override
    public List<BackUpImage> getAllBackups(int cloudId, String cloudName, List<Long> backupIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(backupIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getVersionsForNullPath(int cloudId, String cloudName, String fileName, ObjectId deviceId) {
        Device device = this.getDeviceForId(cloudId, deviceId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is(null), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public long getCountOfBackupDevices(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, DeviceBackupOverView.class);
    }

    @Override
    public Integer validateBackupDevice(int cloudId, String cloudName, ObjectId devId) {
        DeviceBackupOverView overView;
        Device device = this.getDeviceForId(cloudId, devId);
        if (device != null && (overView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID())) != null) {
            return new Integer(1);
        }
        return null;
    }

    @Override
    public BackUpImage getBackUpImageForFileWithNullPath(int cloudId, String cloudName, String fileName, Device device) {
        String dest;
        this.logMessage("@@@@@@@@@@..Before getting Backup Image for File With Null Path..@@@@@@");
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is(null), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logMessage("@@@@@@@@@@..After getting Backup Image for File With Null Path..@@@@@@");
        BackUpImage bkpImage = null;
        List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (bkpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        return bkpImage;
    }

    @Override
    public List<BackUpImage> getAllFilesForDeviceId(int cloudId, String cloudName, ObjectId deviceId) {
        Device device = this.getDeviceForId(cloudId, deviceId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<BackUpImage> backupList = mongoTemplate.find(query, BackUpImage.class);
        backupList = this.getFilteredBackupImageList(backupList);
        return backupList;
    }

    @Override
    public List<BackUpImage> getAllFilesForExternalStorageUpload(int cloudId, String cloudName, ObjectId deviceId, List<Long> alreadyBackedUpIds) {
        Device device = this.getDeviceForId(cloudId, deviceId);
        Criteria criteria = new Criteria();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        if (!CollectionUtils.isEmpty(alreadyBackedUpIds)) {
            Criteria criteria3 = Criteria.where((String)"id").nin(alreadyBackedUpIds);
            list.add(criteria3);
        }
        Criteria criteria4 = Criteria.where((String)DEVICE).is((Object)device);
        list.add(criteria4);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<BackUpImage> backupList = mongoTemplate.find(query, BackUpImage.class);
        backupList = this.getFilteredBackupImageListWithoutFolders(backupList);
        return backupList;
    }

    @Override
    public List<BackUpImage> getBackedUpFolders(int cloudId, String cloudName, ObjectId deviceId) {
        Device device = this.getDeviceForId(cloudId, deviceId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<BackUpImage> backupList = mongoTemplate.find(query, BackUpImage.class);
        backupList = this.getFilteredBackupImageListWithoutFolders(backupList);
        return backupList;
    }

    @Override
    public List<BackUpImage> getAllFilesForUserName(int cloudId, String cloudName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i")});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<BackUpImage> backupList = mongoTemplate.find(query, BackUpImage.class);
        backupList = this.getFilteredBackupImageList(backupList);
        return backupList;
    }

    public List<String> getAllActiveUsers(int cloudId, List<String> existingUserNames) {
        Criteria criteria = new Criteria();
        if (!CollectionUtils.isEmpty(existingUserNames)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)USER_NAME).nin(existingUserNames)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, User.class);
        ArrayList<String> userNames = new ArrayList<String>();
        for (User user : list) {
            userNames.add(user.getUserName());
        }
        return userNames;
    }

    public List<String> getAllActiveUsers(int cloudId, List<String> existingUserNames, int skipValue) {
        Criteria criteria = new Criteria();
        if (!CollectionUtils.isEmpty(existingUserNames)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)USER_NAME).nin(existingUserNames)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, User.class);
        ArrayList<String> userNames = new ArrayList<String>();
        for (User user : list) {
            userNames.add(user.getUserName());
        }
        return userNames;
    }

    @Override
    public List<Object[]> getDeviceHistoryElement(int cloudId, String cloudName, String userName, String deviceName) {
        Object[] arr;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<Object[]> list1 = new ArrayList<Object[]>();
        Criteria criteria = new Criteria();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserCriteria(userName, list);
        this.addDeviceCriteria(cloudId, deviceName, list);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE}).sum("size").as("size"), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME, DEVICE}), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE, PRESENT}), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<String> existingUserNames = new ArrayList<String>();
        ArrayList<ObjectId> existingDeviceIds = new ArrayList<ObjectId>();
        for (BasicDBObject dbObject : stateStatsList) {
            boolean isPresent = this.isFilePresent(dbObject);
            if (!isPresent) continue;
            arr = new Object[3];
            String userName2 = dbObject.get(USER_NAME).toString();
            arr[2] = userName2;
            arr[0] = dbObject.get("size");
            DBRef dbRef = (DBRef)dbObject.get(DEVICE);
            String deviceId = dbRef.getId().toString();
            Device device = this.getDeviceForId(cloudId, deviceId);
            String deviceName2 = device.getDeviceName();
            arr[1] = deviceName2;
            if (StringUtils.isEmpty((String)deviceName) && StringUtils.isEmpty((String)userName)) {
                existingDeviceIds.add(device.getId());
                existingUserNames.add(userName2);
            }
            list1.add(arr);
        }
        if (StringUtils.isEmpty((String)deviceName) && StringUtils.isEmpty((String)userName)) {
            List<String> userNames = this.getAllActiveUsers(cloudId, existingUserNames);
            for (String userNameVal : userNames) {
                arr = new Object[3];
                arr[0] = new Long(0L);
                arr[2] = userNameVal;
                arr[1] = "";
                list1.add(arr);
            }
            this.addOnlyActiveDeviceNames(cloudId, list1, existingDeviceIds);
        }
        return list1;
    }

    private boolean isFilePresent(BasicDBObject dbObject) {
        boolean isPresent = false;
        if (dbObject.get(PRESENT) != null) {
            isPresent = Boolean.parseBoolean(dbObject.get(PRESENT).toString());
        }
        return isPresent;
    }

    private void addDeviceCriteria(int cloudId, String deviceName, List<Criteria> list) {
        if (!StringUtils.isEmpty((String)deviceName)) {
            List<ObjectId> idList = this.getDeviceIDsForName(cloudId, deviceName);
            Criteria criteria3 = Criteria.where((String)DEVICE_ID).in(idList);
            list.add(criteria3);
        }
    }

    private void addUserCriteria(String userName, List<Criteria> list) {
        if (!StringUtils.isEmpty((String)userName)) {
            Criteria criteria2 = Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i");
            list.add(criteria2);
        }
    }

    private void addOnlyActiveDeviceNames(int cloudId, List<Object[]> list1, List<ObjectId> existingDeviceIds) {
        List<Device> devices = this.getActiveDeviceNames(cloudId, existingDeviceIds);
        for (Device deviceNameVal : devices) {
            Object[] arr = new Object[3];
            arr[0] = new Long(0L);
            arr[2] = deviceNameVal.getUserName();
            arr[1] = deviceNameVal.getDeviceName();
            list1.add(arr);
        }
    }

    @Override
    public List<Object[]> getDeviceHistoryElement(int cloudId, String cloudName, String deviceName) {
        ArrayList<Object[]> list1 = new ArrayList<Object[]>();
        Criteria criteria = new Criteria();
        if (!StringUtils.isEmpty((String)deviceName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).regex("^" + deviceName + "$", "i"), Criteria.where((String)BLOCKED).is((Object)false)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return this.getDeviceHistoryList(cloudId, list1, query);
    }

    private List<Object[]> getDeviceHistoryList(int cloudId, List<Object[]> list1, Query query) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List deviceList = mongoTemplate.find(query, Device.class);
        for (Device device : deviceList) {
            if (device == null || StringUtils.isEmpty((String)device.getUserName())) continue;
            Object[] arr = new Object[4];
            arr[0] = new Long(0L);
            arr[2] = device.getUserName();
            arr[1] = device.getDeviceName();
            arr[3] = device.getDeviceCreatedDate();
            list1.add(arr);
        }
        return list1;
    }

    @Override
    public List<Object[]> getUserHistoryElement(int cloudId, String cloudName, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<Object[]> list1 = new ArrayList<Object[]>();
        Criteria criteria = this.getUserCriteria(userName);
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE, PRESENT}).sum("size").as("size"), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE, PRESENT})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<String> existingUserNames = new ArrayList<String>();
        for (BasicDBObject dbObject : stateStatsList) {
            Object[] arr = new Object[4];
            boolean isPresent = false;
            this.logger.debug("present object.." + dbObject.get(PRESENT).toString());
            if (dbObject.get(PRESENT) != null) {
                isPresent = Boolean.parseBoolean(dbObject.get(PRESENT).toString());
            }
            if (!isPresent) continue;
            arr[0] = dbObject.get("size");
            String userName2 = dbObject.get(USER_NAME).toString();
            arr[2] = userName2;
            this.addDeviceInfo(cloudId, userName, list1, existingUserNames, dbObject, arr, userName2);
        }
        this.addActiveUsers(cloudId, userName, list1, existingUserNames);
        return list1;
    }

    private void addDeviceInfo(int cloudId, String userName, List<Object[]> list1, List<String> existingUserNames, BasicDBObject dbObject, Object[] arr, String userName2) {
        DBRef dbRef = (DBRef)dbObject.get(DEVICE);
        if (dbRef != null) {
            String deviceId = dbRef.getId().toString();
            Device device = this.getDeviceForId(cloudId, deviceId);
            User user = this.getUserInfoByName(cloudId, userName2);
            if (user != null && device != null && !device.isBlocked()) {
                String deviceName2 = device.getDeviceName();
                arr[1] = deviceName2;
                if (StringUtils.isEmpty((String)userName)) {
                    existingUserNames.add(userName2);
                }
                arr[3] = device.getDeviceCreatedDate();
                list1.add(arr);
            }
        }
    }

    private void addActiveUsers(int cloudId, String userName, List<Object[]> list1, List<String> existingUserNames) {
        if (StringUtils.isEmpty((String)userName)) {
            List<String> userNames = this.getAllActiveUsers(cloudId, existingUserNames);
            for (String userNameVal : userNames) {
                Object[] arr = new Object[4];
                arr[0] = new Long(0L);
                arr[2] = userNameVal;
                arr[1] = "";
                arr[3] = "";
                list1.add(arr);
            }
        }
    }

    private Criteria getUserCriteria(String userName) {
        Criteria criteria = new Criteria();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserCriteria(userName, list);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return criteria;
    }

    @Override
    public List<Object[]> getUserHistoryElement(int cloudId, String cloudName, String userName, Map<String, User> userMap, Map<String, Device> deviceIdMap) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<Object[]> list1 = new ArrayList<Object[]>();
        Criteria criteria = new Criteria();
        ArrayList list = new ArrayList();
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE, PRESENT}).sum("size").as("size"), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE, PRESENT})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<String> existingUserNames = new ArrayList<String>();
        this.addUserHistoryFromDbResults(userName, userMap, deviceIdMap, list1, stateStatsList, existingUserNames);
        this.addActiveUsers(cloudId, userName, list1, existingUserNames);
        return list1;
    }

    private void addUserHistoryFromDbResults(String userName, Map<String, User> userMap, Map<String, Device> deviceIdMap, List<Object[]> list1, List<BasicDBObject> stateStatsList, List<String> existingUserNames) {
        for (BasicDBObject dbObject : stateStatsList) {
            boolean isPresent = false;
            if (dbObject.get("isPresent") != null) {
                isPresent = Boolean.parseBoolean(dbObject.get(PRESENT).toString());
            }
            if (!isPresent) continue;
            Object[] arr = new Object[4];
            arr[0] = dbObject.get("size");
            String userName2 = dbObject.get(USER_NAME).toString();
            arr[2] = userName2;
            this.addUserInfo(userMap, deviceIdMap, list1, dbObject, arr, userName2);
            if (!StringUtils.isEmpty((String)userName)) continue;
            existingUserNames.add(userName2);
        }
    }

    private void addUserInfo(Map<String, User> userMap, Map<String, Device> deviceIdMap, List<Object[]> list1, BasicDBObject dbObject, Object[] arr, String userName2) {
        DBRef dbRef = (DBRef)dbObject.get(DEVICE);
        if (dbRef != null) {
            String deviceId = dbRef.getId().toString();
            Device device = deviceIdMap.get(deviceId);
            User user = userMap.get(userName2);
            if (user != null && device != null && !device.isBlocked()) {
                String deviceName2 = device.getDeviceName();
                arr[1] = deviceName2;
                arr[3] = device.getDeviceCreatedDate();
                list1.add(arr);
            }
        }
    }

    public User getUserInfoByName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)ACTIVE).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    private List<Device> getActiveDeviceNames(int cloudId, List<ObjectId> existingIds) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria deviceCriteria = new Criteria();
        if (CollectionUtils.isEmpty(existingIds)) {
            deviceCriteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false)});
        } else {
            deviceCriteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false), Criteria.where((String)"id").nin(existingIds)});
        }
        Query query = new Query((CriteriaDefinition)deviceCriteria);
        return mongoTemplate.find(query, Device.class);
    }

    @Override
    public List<Object[]> getTotalSizeUsed(int cloudId, String cloudName, String userName, String deviceName, int skipValue) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<Object[]> list1 = new ArrayList<Object[]>();
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)STATUS).ne((Object)DELETED);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        list.add(criteria1);
        this.addUserCriteria(userName, list);
        this.addDeviceCriteria(cloudId, deviceName, list);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE}).sum("size").as("size"), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME, DEVICE}), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE}), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME})});
        if (StringUtils.isEmpty((String)deviceName) && StringUtils.isEmpty((String)userName)) {
            aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE}).sum("size").as("size"), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME, DEVICE}), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE}), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME}), Aggregation.limit((long)PCHelperConstant.getReportDisplayRecords())});
        }
        if (skipValue != 0 && StringUtils.isEmpty((String)deviceName) && StringUtils.isEmpty((String)userName)) {
            aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE}).sum("size").as("size"), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME, DEVICE}), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE}), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{USER_NAME}), Aggregation.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords())), Aggregation.limit((long)PCHelperConstant.getReportDisplayRecords())});
        }
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List stateStatsList = result.getMappedResults();
        for (BasicDBObject dbObject : stateStatsList) {
            Object[] arr = new Object[3];
            arr[0] = dbObject.get("size");
            arr[1] = dbObject.get(USER_NAME);
            DBRef dbRef = (DBRef)dbObject.get(DEVICE);
            String deviceId = dbRef.getId().toString();
            Device device = this.getDeviceForId(cloudId, deviceId);
            if (device == null) continue;
            arr[2] = device.getDeviceName();
            list1.add(arr);
        }
        return list1;
    }

    @Override
    public void deleteBackupFile(int cloudId, String cloudName, ObjectId backupId, Device device) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
        for (String dest : queryTablesList) {
            mongoTemplate.findAndRemove(query, BackUpImage.class, dest);
        }
    }

    @Override
    public ObjectId getBackupIDForDedupifiedFile(int cloudId, String cloudName, String userName, String md5checksum) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)"md5Checksum").is((Object)md5checksum)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            BackUpImage backUpImage = (BackUpImage)list.get(0);
            return backUpImage.getId();
        }
        return null;
    }

    @Override
    public List<BackUpImage> getBackupImageForMd5s(int cloudId, String userName, List<String> md5checksums, Device device) {
        return this.getBackupFileForMd5s(cloudId, userName, md5checksums, device);
    }

    @Override
    public List<KeyValueElement> getBackupImageForDedupifiedFiles(int cloudId, String cloudName, String userName, List<String> md5checksums, Device device) {
        List<BackUpImage> list = this.getBackupFileForMd5s(cloudId, userName, md5checksums, device);
        ArrayList<KeyValueElement> md5AndBackupIds = new ArrayList<KeyValueElement>();
        for (BackUpImage backUpImage : list) {
            if (backUpImage.isFolder()) continue;
            KeyValueElement element = new KeyValueElement();
            element.setKey(backUpImage.getMd5Checksum());
            element.setValue(backUpImage.getId().toString());
            md5AndBackupIds.add(element);
        }
        return md5AndBackupIds;
    }

    private List<BackUpImage> getBackupFileForMd5s(int cloudId, String userName, List<String> md5checksums, Device device) {
        this.logger.debug(md5checksums.size() + " @@@@STARTMD5 getBackupFileForMd5s without username  ");
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)"md5Checksum").in(md5checksums), Criteria.where((String)STATUS).ne((Object)DELETED)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"md5Checksum"}).min(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{"md5Checksum", LAST_SERVER_MODIFIED_TIME})});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = this.queryForBackup((TypedAggregation<BackUpImage>)aggregation, mongoTemplate, device);
        ArrayList<BackUpImage> list = new ArrayList<BackUpImage>();
        List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
        for (String dest : queryTablesList) {
            List resultList = mongoTemplate.find(query, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)resultList)) continue;
            list.addAll(resultList);
        }
        return list;
    }

    @Override
    public List<BackUpImage> getBackupImageForMd5WithUserName(int cloudId, String userName, List<String> md5checksums) {
        this.logger.debug(" @@@@STARTMD5 with username !!!!! ");
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)"md5Checksum").in(md5checksums)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class);
        this.logger.debug(" @@@@ENDMD5 with username !!!!! ");
        return list;
    }

    @Override
    public BackUpImage getBackupImageForDeviceUUID(int cloudId, String cloudName, String fileName, String devicePath, String deviceUUID) {
        Device device = this.getDeviceForDeviceUUID(cloudId, deviceUUID);
        if (device != null) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
            Query query = new Query((CriteriaDefinition)criteria);
            query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
            query.limit(1);
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
        }
        return null;
    }

    private Device getDeviceForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (Device)mongoTemplate.findOne(query, Device.class);
    }

    private List<Device> getDeviceForDeviceNameAndUserName(int cloudId, String deviceName, String userName) {
        User user = this.getUserInfoByName(cloudId, userName);
        Criteria criteria = new Criteria();
        if (user != null) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).is((Object)deviceName), Criteria.where((String)USER_NAME).is((Object)user.getUserName()), Criteria.where((String)BLOCKED).is((Object)false)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).is((Object)deviceName), Criteria.where((String)BLOCKED).is((Object)false)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, Device.class);
    }

    private Device getDeviceForId(int cloudId, String deviceID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)deviceID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (Device)mongoTemplate.findOne(query, Device.class);
    }

    @Override
    public long getStorageUsed(int cloudId, String cloudName, ObjectId userId, ObjectId deviceId) {
        Long total = 0L;
        if (deviceId != null) {
            DeviceBackupOverView overView;
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)deviceId), Criteria.where((String)BLOCKED).is((Object)false)});
            Query query = Query.query((CriteriaDefinition)criteria);
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Device device = (Device)mongoTemplate.findOne(query, Device.class);
            if (device != null && (overView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID())) != null) {
                total = overView.getStorageUtilized();
            }
        }
        return total;
    }

    @Override
    public long getStorageUsedForDevice(int cloudId, String cloudName, String deviceName, String userName) {
        Long total = 0L;
        List<Device> list = this.getDeviceForDeviceNameAndUserName(cloudId, deviceName, userName);
        for (Device device : list) {
            DeviceBackupOverView overView;
            if (device == null || (overView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID())) == null) continue;
            total = total + overView.getStorageUtilized();
        }
        return total;
    }

    @Override
    public void saveBackupStatistics(int cloudId, String cloudName, BackUpImageStatistics imageStatistics) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)imageStatistics);
    }

    @Override
    public void deleteStatisticsForUser(int cloudId, String cloudName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i")});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(query, BackUpImageStatistics.class);
    }

    @Override
    public List<Object[]> getStatisticsForBackup(int cloudId, String cloudName, String userName, String deviceName) {
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserCriteria(userName, list);
        if (!StringUtils.isEmpty((String)deviceName)) {
            Criteria deviceCriteria = Criteria.where((String)DEVICE_NAME).is((Object)deviceName);
            list.add(deviceCriteria);
        }
        Criteria criteria = new Criteria();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            criteria.andOperator(list.toArray(new Criteria[list.size()]));
        }
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImageStatistics.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, FILEEXTENSION, DEVICE_NAME}).sum("size").as("size").count().as("count"), Aggregation.project((String[])new String[]{USER_NAME, FILEEXTENSION, "size", DEVICE_NAME, "count"})});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<Object[]> objectList = new ArrayList<Object[]>();
        for (BasicDBObject dbObject : stateStatsList) {
            Object[] arr = new Object[]{dbObject.get(USER_NAME), dbObject.get(FILEEXTENSION), dbObject.get("size"), dbObject.get(DEVICE_NAME), dbObject.get("count")};
            objectList.add(arr);
        }
        return objectList;
    }

    private List<ObjectId> getDeviceIDsForName(int cloudId, String deviceName) {
        Criteria criteria = new Criteria();
        if (!StringUtils.isEmpty((String)deviceName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).is((Object)deviceName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List devices = mongoTemplate.find(query, Device.class);
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
        for (Device device : devices) {
            objectIds.add(device.getId());
        }
        return objectIds;
    }

    @Override
    public void updateAzureFileStatusinBackupImageTable(int cloudId, String cloudName, ObjectId backupId, String storagePlace, Device device) {
        Criteria criteria = Criteria.where((String)"id").is((Object)backupId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("storagePlace", (Object)storagePlace);
        update.set("lastCloudUploadedTime", (Object)System.currentTimeMillis());
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
        for (String dest : queryTablesList) {
            mongoTemplate.updateFirst(query, (UpdateDefinition)update, BackUpImage.class, dest);
        }
    }

    private BackUpImage getBackUpImageForFile(MongoTemplate mongoTemplate, String fileName, String devicePath, Device device, Long serverModifiedTime) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)LAST_SERVER_MODIFIED_TIME).is((Object)serverModifiedTime)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        ArrayList backUpImageList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
        for (String dest : queryTablesList) {
            List list = mongoTemplate.find(query, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            backUpImageList.addAll(list);
        }
        if (!CollectionUtils.isEmpty(backUpImageList)) {
            return (BackUpImage)backUpImageList.get(0);
        }
        return null;
    }

    @Override
    public long getStorageUsedByUser(int cloudId, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Long totalSizeUsed = 0L;
        User user = this.getUserInfoByName(cloudId, userName);
        if (user != null) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false), Criteria.where((String)USER_NAME).is((Object)user.getUserName())});
            Query query = new Query((CriteriaDefinition)criteria);
            List list = mongoTemplate.find(query, Device.class);
            for (Device device : list) {
                DeviceBackupOverView overView;
                if (device == null || (overView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID())) == null) continue;
                totalSizeUsed = totalSizeUsed + overView.getStorageUtilized();
            }
        }
        return totalSizeUsed;
    }

    @Override
    public long getTotalSizeUsedByUserForDevice(int cloudId, String userName, ObjectId deviceId) {
        DeviceBackupOverView overView;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long totalSizeUsed = 0L;
        Criteria criteria = Criteria.where((String)"id").is((Object)deviceId);
        Query query = new Query((CriteriaDefinition)criteria);
        Device device = (Device)mongoTemplate.findOne(query, Device.class);
        if (device != null && (overView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID())) != null) {
            totalSizeUsed += overView.getStorageUtilized();
        }
        return totalSizeUsed;
    }

    @Override
    public List<Object[]> getDeviceHistoryElement(int cloudId, String cloudName, String deviceName, int skipValue) {
        ArrayList<Object[]> list1 = new ArrayList<Object[]>();
        Criteria criteria = new Criteria();
        if (!StringUtils.isEmpty((String)deviceName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).regex("^" + deviceName + "$", "i"), Criteria.where((String)BLOCKED).is((Object)false)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        this.logger.debug("   Skip value in getDeviceHistoryElement ... aggregation ... " + skipValue);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return this.getDeviceHistoryList(cloudId, list1, query);
    }

    @Override
    public List<Object[]> getUserHistoryElement(int cloudId, String cloudName, String userName, int skipValue) {
        Object[] arr;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<Object[]> list1 = new ArrayList<Object[]>();
        Criteria criteria = this.getUserCriteria(userName);
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE}).sum("size").as("size"), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE}), Aggregation.limit((long)PCHelperConstant.getReportDisplayRecords())});
        this.logger.debug("   Skip value in getUserHistoryElement ... aggregation ... " + skipValue);
        if (skipValue != 0 && skipValue != -1) {
            aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{USER_NAME, DEVICE}).sum("size").as("size"), Aggregation.project((String[])new String[]{"size", USER_NAME, DEVICE, PRESENT}), Aggregation.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords())), Aggregation.limit((long)PCHelperConstant.getReportDisplayRecords())});
        }
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List stateStatsList = result.getMappedResults();
        ArrayList<String> existingUserNames = new ArrayList<String>();
        for (BasicDBObject dbObject : stateStatsList) {
            boolean isPresent = this.isFilePresent(dbObject);
            if (!isPresent) continue;
            arr = new Object[4];
            arr[0] = dbObject.get("size");
            String userName2 = dbObject.get(USER_NAME).toString();
            arr[2] = userName2;
            this.addDeviceInfo(cloudId, userName, list1, existingUserNames, dbObject, arr, userName2);
        }
        if (StringUtils.isEmpty((String)userName)) {
            List<String> userNames = this.getAllActiveUsers(cloudId, existingUserNames, skipValue);
            for (String userNameVal : userNames) {
                arr = new Object[4];
                arr[0] = new Long(0L);
                arr[2] = userNameVal;
                arr[1] = "";
                arr[3] = "";
                list1.add(arr);
            }
        }
        return list1;
    }

    @Override
    public void deleteBackupImagesForUser(int cloudId, String cloudName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i")});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getChildrenByFolderForAgent(int cloudId, String cloudName, String folderPath, Device device, boolean isExternalStorage) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<ObjectId> listOfBackupIds = this.getAggregatedBackupIdsForAgentRestore(mongoTemplate, folderPath, device);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(listOfBackupIds)});
        Query query1 = new Query((CriteriaDefinition)criteria);
        query1.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        return mongoTemplate.find(query1, BackUpImage.class);
    }

    private List<ObjectId> getAggregatedBackupIdsForAgentRestore(MongoTemplate mongoTemplate, String folderPath, Device device) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{DEVICE_PATH, FILE_NAME}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{DEVICE_PATH, FILE_NAME, LAST_SERVER_MODIFIED_TIME})});
        return this.getBackupIds(mongoTemplate, device, (TypedAggregation<BackUpImage>)aggregation);
    }

    private List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage backUpImage : backUpImages) {
            if (!backUpImage.isPresent()) continue;
            filteredBackUpImages.add(backUpImage);
        }
        return filteredBackUpImages;
    }

    @Override
    public List<Object[]> getTotalSizeUsed(int cloudId, String cloudName, String userName, String deviceName) {
        return Collections.emptyList();
    }

    private List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages, boolean present) {
        String presentString = String.valueOf(present);
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage backUpImage : backUpImages) {
            String presentVal = String.valueOf(backUpImage.isPresent());
            if (!presentVal.equals(presentString)) continue;
            filteredBackUpImages.add(backUpImage);
        }
        return filteredBackUpImages;
    }

    private List<BackUpImage> getFilteredBackupImageListWithoutFolders(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage backUpImage : backUpImages) {
            if (!backUpImage.isPresent() || backUpImage.isFolder()) continue;
            filteredBackUpImages.add(backUpImage);
        }
        return filteredBackUpImages;
    }

    private List<BackUpImage> getFilteredBackupImageListOnlyStoragePlaceExists(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage backUpImage : backUpImages) {
            if (!backUpImage.isPresent() || backUpImage.getStoragePlace() == null) continue;
            filteredBackUpImages.add(backUpImage);
        }
        return filteredBackUpImages;
    }

    private List<BackUpImage> getFilteredBackupImageListForStoragePlaceExists(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage backUpImage : backUpImages) {
            if (backUpImage.getStoragePlace() == null) continue;
            filteredBackUpImages.add(backUpImage);
        }
        return filteredBackUpImages;
    }

    @Override
    public void saveBackupImageInBatch(int cloudId, List<BackUpImage> backUpImages) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug("@@@@ INSERT in batches ..........");
        mongoTemplate.insertAll(backUpImages);
    }

    @Override
    public void updateBackupImageCR32(int cloudId, ObjectId backupId, long cr32Val) {
        Criteria criteria = Criteria.where((String)"id").is((Object)backupId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(CRC32VAL, (Object)cr32Val);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, (UpdateDefinition)update, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getBackupFileForCr32(int cloudId, String userName, List<Long> crc32Vals) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CRC32VAL).in(crc32Vals)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getBackupImageForServerModifiedTime(int cloudId, List<Long> serverModifiedTimes) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)LAST_SERVER_MODIFIED_TIME).in(serverModifiedTimes)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public BackUpImage getBackupImageForTesting(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"md5Checksum").exists(true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        query.limit(1);
        return (BackUpImage)mongoTemplate.find(query, BackUpImage.class).get(0);
    }

    @Override
    public List<ObjectId> getListOfDeletedBackupIds(int cloudId, String userName, List<ObjectId> backupIds) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug("backup ids List>>>>>>>>>>" + backupIds.size());
        List<BackUpImage> backupFileList = this.getAllLatestBackup((MongoOperations)mongoTemplate, backupIds);
        this.logger.debug("backupFileList>>>>>>>>>>" + backupFileList.size());
        List<ObjectId> backupIdListFromBackupImage = this.getListOfBackupIdStrings(backupFileList);
        Collection retainedList = org.apache.commons.collections.CollectionUtils.retainAll(backupIdListFromBackupImage, backupIds);
        this.logger.debug(" retained backupFileList size>>>>>>>>>>" + retainedList.size());
        backupIds.removeAll(retainedList);
        this.logger.debug("backup ids List>>>>>>>>>>#############" + backupIds.size());
        return backupIds;
    }

    private List<ObjectId> getListOfBackupIdStrings(List<BackUpImage> backupFileList) {
        ArrayList<ObjectId> backupIdsFromBackupImage = new ArrayList<ObjectId>();
        if (backupFileList != null) {
            for (BackUpImage backUpImage : backupFileList) {
                backupIdsFromBackupImage.add(backUpImage.getId());
            }
        }
        return backupIdsFromBackupImage;
    }

    @Override
    public List<BackUpImage> getMd5ForUpdatingCr32(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)"bhmur"), Criteria.where((String)"md5Checksum").exists(true), Criteria.where((String)CRC32VAL).exists(false)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(5000);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public BackUpImage getParentBackupFileForMd5(int cloudId, String userName, String md5checksum, Device device) {
        String dest;
        this.logger.debug(md5checksum + " @@@@STARTMD5 getBackupFileForMd5s without username  ");
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)"md5Checksum").exists(true), Criteria.where((String)STATUS).ne((Object)DELETED), Criteria.where((String)"md5Checksum").is((Object)md5checksum)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"md5Checksum"}).min(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{"md5Checksum", LAST_SERVER_MODIFIED_TIME})});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = this.queryForBackup((TypedAggregation<BackUpImage>)aggregation, mongoTemplate, device);
        BackUpImage backupFile = null;
        if (PCHelperConstant.isBackupCollectionQueryRequired()) {
            backupFile = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, BACKUP);
        }
        if (StringUtils.isNotEmpty((String)(dest = device.getDestCollection())) && backupFile == null) {
            backupFile = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest);
        }
        return backupFile;
    }

    private Query queryForBackup(TypedAggregation<BackUpImage> aggregation, MongoTemplate mongoTemplate, Device device) {
        ArrayList stateStatsList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
        for (String dest : queryTablesList) {
            AggregationResults result = mongoTemplate.aggregate(aggregation, dest, BasicDBObject.class);
            List list = result.getMappedResults();
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            stateStatsList.addAll(list);
        }
        ArrayList<Long> listOfObjectIds = new ArrayList<Long>();
        for (BasicDBObject dbObject : stateStatsList) {
            listOfObjectIds.add((Long)dbObject.get(LAST_SERVER_MODIFIED_TIME));
        }
        this.logger.debug("TOTAL deduped files Size ..... " + listOfObjectIds.size());
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)LAST_SERVER_MODIFIED_TIME).in(listOfObjectIds)});
        return new Query((CriteriaDefinition)criteria);
    }

    @Override
    public BackUpImage getBackupFileForID(int cloudId, ObjectId backupId, String userName, Device device, boolean getDeletedFilesLatestVersion) {
        String dest;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId)});
        Query query = new Query((CriteriaDefinition)criteria);
        BackUpImage backupFile = null;
        if (PCHelperConstant.isBackupCollectionQueryRequired()) {
            backupFile = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, BACKUP);
        }
        if (StringUtils.isNotEmpty((String)(dest = device.getDestCollection())) && backupFile == null) {
            backupFile = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest);
        }
        if (backupFile != null && StringUtils.isNotEmpty((String)backupFile.getStoragePlace()) && CollectionUtils.isEmpty(backupFile.getChunkFiles())) {
            backupFile = this.getParentBackupFileForMd5(1, userName, backupFile.getMd5Checksum(), device);
        }
        return backupFile;
    }

    @Override
    public List<ChunkFile> getChunkFileNamesForId(int cloudId, String cloudName, String userName, String backupId) {
        Object tableName = "privacy_gateway_od_" + cloudName + "_" + userName;
        tableName = ((String)tableName).toUpperCase();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists((String)tableName)) {
            mongoTemplate.createCollection((String)tableName);
        }
        MongoCollection collection = mongoTemplate.getCollection((String)tableName);
        Bson searchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)new ObjectId(backupId))});
        FindIterable iterable = collection.find(searchQuery);
        List<ChunkFile> chunkFiles = new ArrayList<ChunkFile>();
        for (Document dbObject : iterable) {
            chunkFiles = BackUpImageDaoImpl.getChunkFiles(dbObject);
        }
        return chunkFiles;
    }

    private static List<ChunkFile> getChunkFiles(Document dbObject) {
        List list = (List)dbObject.get((Object)"chunkFiles");
        ArrayList<ChunkFile> chunkFiles = new ArrayList<ChunkFile>();
        for (BasicDBObject chunk : list) {
            Object cloudStoragePath = chunk.get("cloudStoragePath");
            Object size = chunk.get("size");
            ChunkFile chunkFile = new ChunkFile();
            chunkFile.setFileId(chunk.get("fileId").toString());
            chunkFile.setFileName(chunk.get(FILE_NAME).toString());
            if (chunk.get("fSPath") != null) {
                chunkFile.setfSPath(chunk.get("fSPath").toString());
            }
            chunkFile.setUploadedTimeStamp((Long)chunk.get("uploadedTimeStamp"));
            if (cloudStoragePath != null) {
                chunkFile.setCloudStoragePath(cloudStoragePath.toString());
            }
            if (size != null) {
                chunkFile.setSize((Long)size);
            }
            chunkFiles.add(chunkFile);
        }
        return chunkFiles;
    }

    @Override
    public String getBackupIDForMd5(int cloudId, String userName, String md5checksum) {
        this.logMessage("####Before getting BackupID for MD5####");
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String tableName = BACKUP;
        Bson searchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)"md5Checksum", (Object)md5checksum)});
        FindIterable iterable = mongoTemplate.getCollection(tableName).find(searchQuery);
        ArrayList<BackUpImage> list = new ArrayList<BackUpImage>();
        String backupId = "";
        MongoCursor iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Document dbObject = (Document)iterator.next();
            BackUpImage backUpImage = (BackUpImage)mongoTemplate.getConverter().read(BackUpImage.class, (Object)dbObject);
            if (backUpImage == null) continue;
            list.add(backUpImage);
        }
        iterator.close();
        if (!CollectionUtils.isEmpty(list)) {
            list.sort((c1, c2) -> {
                long t2;
                long t1 = c2.getLastServerModifiedTime();
                if (t1 < (t2 = c1.getLastServerModifiedTime())) {
                    return 1;
                }
                if (t1 == t2) {
                    return 0;
                }
                return -1;
            });
        }
        if (!CollectionUtils.isEmpty(list)) {
            BackUpImage backupImage = (BackUpImage)list.get(0);
            backupId = backupImage.getId().toString();
        }
        this.logMessage("####After getting BackupID for MD5####");
        return backupId;
    }

    @Override
    public List<BackUpImage> getContainerChildren(int cloudId, String containerName, Device device) {
        this.logger.debug("getVersionsForServerBackup(int cloudId, String containerName, Device device) > BEGIN");
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<BackUpImage> backupList = new ArrayList<BackUpImage>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE).is((Object)device), Criteria.where((String)"containerName").is((Object)containerName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        this.logger.debug("getVersionsForServerBackup(int cloudId, String containerName, Device device) > BEFORE RETURN");
        List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
        for (String dest : queryTablesList) {
            List list = mongoTemplate.find(query, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            backupList.addAll(list);
        }
        return backupList;
    }

    @Override
    public BackUpImage getBackupFileForIDOnly(int cloudId, ObjectId backupId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
    }

    @Override
    public void updateGatewayInBackupImage(int cloudId, ObjectId backupId, String gateWayName) {
        Criteria criteria = Criteria.where((String)"id").is((Object)backupId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("gatewayName", (Object)gateWayName);
        update.set(LAST_SERVER_MODIFIED_TIME, (Object)System.currentTimeMillis());
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, (UpdateDefinition)update, BackUpImage.class);
    }

    private DeviceBackupOverView getDeviceBkpOverviewForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (DeviceBackupOverView)mongoTemplate.findOne(query, DeviceBackupOverView.class);
    }

    @Override
    public void deleteBackupFile(int cloudId, ObjectId backupId, Device device) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
        for (String dest : queryTablesList) {
            mongoTemplate.findAndRemove(query, BackUpImage.class, dest);
        }
    }

    @Override
    public BackupBatch getBackupBatchById(int cloudId, String batchId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)new ObjectId(batchId))});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
    }

    @Override
    public String getBackupBatchStatusById(int cloudId, String batchId) {
        String status = null;
        try {
            this.logger.debug("Inside getBackupBatchStatusById ..batchId " + batchId);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)new ObjectId(batchId))});
            Query query = new Query((CriteriaDefinition)criteria);
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
            if (backupBatch != null) {
                status = backupBatch.getStatus();
            }
            return status;
        }
        catch (Exception e) {
            this.logger.error("Error to get the batchstatus for given batch id :" + e.getMessage());
            return status;
        }
    }

    @Override
    public BackupBatch getLastRestoreBatch(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)"jobType").is((Object)"RESTORE");
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        Criteria criteriaForUUID = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
        list.add(criteriaForUUID);
        list.add(criteria1);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"batchStartTimestamp"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
    }

    @Override
    public List<BackUpImage> getBaseChildrenByDeviceandTimeStamp(int cloudId, String cloudName, Device device, String serverModifiedTime) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        long modifiedTime = Long.parseLong(serverModifiedTime);
        List<ObjectId> listOfBackupIds = this.getAggregatedBackupIdsForRoot(cloudId, mongoTemplate, device, true);
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        List<BackUpImage> backupList = new ArrayList<BackUpImage>();
        for (String dest : bkpCollectionList) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(listOfBackupIds)});
            Query query1 = new Query((CriteriaDefinition)criteria);
            List list = mongoTemplate.find(query1, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            for (BackUpImage backUpImage : list) {
                if (backUpImage.getLastServerModifiedTime() > modifiedTime) continue;
                backupList.add(backUpImage);
            }
        }
        if (!CollectionUtils.isEmpty(backupList)) {
            this.logger.debug("@@@before filtering backup list ........... " + backupList.size());
            backupList = this.getFilteredListForDevice(backupList, device);
            this.logger.debug("@@@Before getFilteredListForDevice........... " + backupList.size());
            backupList = this.getFilteredBackupImageListByGrouping(backupList, true);
            this.logger.debug("@@@After getFilteredListForDevice........... " + backupList.size());
            return backupList;
        }
        return new ArrayList<BackUpImage>();
    }

    @Override
    public List<BackUpImage> getBaseChildrenByDevice(int cloudId, String cloudName, Device device, boolean isrestoreDeletedFile) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        List<ObjectId> listOfBackupIds = this.getAggregatedBackupIdsForRoot(cloudId, mongoTemplate, device, isrestoreDeletedFile);
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        List<BackUpImage> backupList = new ArrayList<BackUpImage>();
        for (String dest : bkpCollectionList) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(listOfBackupIds)});
            Query query1 = new Query((CriteriaDefinition)criteria);
            List list = mongoTemplate.find(query1, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            backupList.addAll(list);
        }
        this.logger.debug("@@@before filtering backup list ........... " + backupList.size());
        backupList = this.getFilteredListForDevice(backupList, device);
        backupList = this.getFilteredBackupImageListByGrouping(backupList, isrestoreDeletedFile);
        return backupList;
    }

    @Override
    public List<BackUpImage> getRestBackupFilesForGivenPathfromBackupImage(int cloudId, String cloudName, String folderPath, Device device, boolean isExchange, String serverModifiedTime, boolean restoreDeletedFiles) {
        List<Object> list = new ArrayList();
        ArrayList<BackUpImage> bkpImages = new ArrayList<BackUpImage>();
        long modifiedTime = 0L;
        if (!org.springframework.util.StringUtils.isEmpty((Object)serverModifiedTime)) {
            modifiedTime = Long.parseLong(serverModifiedTime);
        }
        this.logger.debug(folderPath + "..File list based on time stamp .................... " + modifiedTime);
        try {
            this.logger.debug(folderPath + "....RESTORE-QUERY ..getBackupFilesForGivenPathfromBackupImage.........." + device.getDeviceUUID());
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FOLDER).is((Object)false)});
            Query query = new Query((CriteriaDefinition)criteria);
            List results = mongoTemplate.find(query, BackUpImage.class, device.getDestCollection());
            if (!CollectionUtils.isEmpty((Collection)results)) {
                list.addAll(results);
            }
            if (modifiedTime != 0L) {
                if (!CollectionUtils.isEmpty(list)) {
                    for (BackUpImage backUpImage : list) {
                        long serverModTime = backUpImage.getLastServerModifiedTime();
                        if (serverModTime > modifiedTime) continue;
                        bkpImages.add(backUpImage);
                    }
                }
            } else {
                bkpImages.addAll(list);
            }
            this.logger.debug("....count of list..." + list.size());
            list = this.getFilteredLatestVersionBackupImageList(bkpImages, restoreDeletedFiles, isExchange);
            this.logger.debug("....count of list after ..." + list.size());
            this.logger.error("##End getBackupFilesForGivenPathfromBackupImage ..........");
        }
        catch (Exception e) {
            this.logger.trace(String.valueOf(e));
            this.logger.error(" Exception while getting filefrom backupimage:", (Throwable)e);
            return null;
        }
        return list;
    }

    @Override
    public List<BackUpImage> getChildrenByFolderForAgent(int cloudId, String cloudName, String folderPath, Device device, boolean isExternalStorage, boolean restoreDeletedFiles) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        List<BackUpImage> backupList = new ArrayList<BackUpImage>();
        List<ObjectId> listOfBackupIds = this.getAggregatedBackupIdsForAgentRestore(cloudId, mongoTemplate, folderPath, device, isExternalStorage, restoreDeletedFiles);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(listOfBackupIds)});
        Query query1 = new Query((CriteriaDefinition)criteria);
        query1.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{LAST_SERVER_MODIFIED_TIME}));
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String dest : bkpCollectionList) {
            List list = mongoTemplate.find(query1, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            backupList.addAll(list);
        }
        backupList = this.getFilteredBackupImageListByGrouping(backupList, restoreDeletedFiles);
        return backupList;
    }

    private List<ObjectId> getAggregatedBackupIdsForAgentRestore(int cloudId, MongoTemplate mongoTemplate, String folderPath, Device device, boolean isExternalStorage, boolean restoreDeletedFiles) {
        String deviceUUID = device.getDeviceUUID();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath)});
        Query query = new Query((CriteriaDefinition)criteria);
        ArrayList backupList = new ArrayList();
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String dest : bkpCollectionList) {
            List result = mongoTemplate.find(query, BackUpImage.class, dest);
            backupList.addAll(result);
        }
        ArrayList<ObjectId> listOfObjectIds = new ArrayList<ObjectId>();
        for (BackUpImage dbObject : backupList) {
            Long lastServerModifiedTime;
            String devicePath;
            String fileName = dbObject.getFileName();
            BackUpImage backUpImage = this.getBackUpImageForFile(cloudId, device, mongoTemplate, fileName, devicePath = dbObject.getDevicePath(), lastServerModifiedTime = Long.valueOf(dbObject.getLastServerModifiedTime()));
            if (backUpImage == null) continue;
            listOfObjectIds.add(backUpImage.getId());
        }
        return listOfObjectIds;
    }

    private BackUpImage getBackUpImageForFile(int cloudId, Device device, MongoTemplate mongoTemplate, String fileName, String devicePath, Long serverModifiedTime) {
        String deviceUUID = device.getDeviceUUID();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)LAST_SERVER_MODIFIED_TIME).is((Object)serverModifiedTime)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        ArrayList backUpImageList = new ArrayList();
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String dest : bkpCollectionList) {
            List list = mongoTemplate.find(query, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            backUpImageList.addAll(list);
        }
        if (!CollectionUtils.isEmpty(backUpImageList)) {
            return (BackUpImage)backUpImageList.get(0);
        }
        return null;
    }

    private List<BackUpImage> getFilteredBackupImageListByGrouping(List<BackUpImage> backUpImages, boolean restoreDeletedFiles) {
        this.logger.debug("Inside grouping backup images");
        this.logger.debug("Inside grouping backup images" + backUpImages.size());
        ArrayList filteredBackUpImages = new ArrayList();
        ArrayList<BackUpImage> filteredBackUpImagesList = new ArrayList<BackUpImage>();
        ArrayList deltedBackUpImages = new ArrayList();
        ArrayList<BackUpImage> deletedBackUpImagesList = new ArrayList<BackUpImage>();
        backUpImages.stream().filter(p -> p.getDevicePath() == null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackUpImage::getFileName)).entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        for (BackUpImage filteredBackUpImage : filteredBackUpImages) {
            if (filteredBackUpImage.isPresent()) {
                filteredBackUpImagesList.add(filteredBackUpImage);
                continue;
            }
            deletedBackUpImagesList.add(filteredBackUpImage);
        }
        if (restoreDeletedFiles) {
            backUpImages.stream().filter(p -> p.getDevicePath() == null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackUpImage::getFileName)).entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).filter(p1 -> p1.isPresent()).findFirst().orElse(null)));
            Map<String, Map<String, List<BackUpImage>>> map1 = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
            for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map1.entrySet()) {
                entry.getValue().entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).filter(p1 -> p1.isPresent()).findFirst().orElse(null)));
            }
            block3: for (BackUpImage bkpimage : deletedBackUpImagesList) {
                for (BackUpImage bkpimage1 : deltedBackUpImages) {
                    if (bkpimage1 == null || !bkpimage.getFileName().equals(bkpimage1.getFileName()) || !bkpimage.getDevicePath().equals(bkpimage1.getDevicePath())) continue;
                    bkpimage1.setPresent(false);
                    filteredBackUpImagesList.add(bkpimage1);
                    continue block3;
                }
            }
        }
        return filteredBackUpImagesList;
    }

    private List<BackUpImage> getFilteredLatestVersionBackupImageList(List<BackUpImage> backUpImages, boolean restoreDeletedFiles, boolean isExchange) {
        this.logger.debug("Inside grouping backup images...." + backUpImages.size());
        ArrayList filteredBackUpImages = new ArrayList();
        ArrayList<BackUpImage> filteredBackUpImagesList = new ArrayList<BackUpImage>();
        ArrayList deltedBackUpImages = new ArrayList();
        ArrayList<BackUpImage> deletedBackUpImagesList = new ArrayList<BackUpImage>();
        backUpImages.removeAll(Collections.singleton(null));
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(isExchange ? BackUpImage::getMd5Checksum : BackUpImage::getFileName)));
        this.logger.debug(isExchange + "......map...." + map.size());
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        this.logger.debug(restoreDeletedFiles + "......filteredBackUpImages...." + filteredBackUpImages.size());
        for (BackUpImage filteredBackUpImage : filteredBackUpImages) {
            if (filteredBackUpImage.isPresent()) {
                filteredBackUpImagesList.add(filteredBackUpImage);
                continue;
            }
            deletedBackUpImagesList.add(filteredBackUpImage);
        }
        if (restoreDeletedFiles && !isExchange) {
            for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
                entry.getValue().entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).filter(isExchange ? p1 -> p1.getStatus().equalsIgnoreCase("ADDED") : p1 -> p1.isPresent()).findFirst().orElse(null)));
            }
            block3: for (BackUpImage bkpimage : deletedBackUpImagesList) {
                for (BackUpImage bkpimage1 : deltedBackUpImages) {
                    if (bkpimage1 == null || !bkpimage.getFileName().equals(bkpimage1.getFileName()) || !bkpimage.getDevicePath().equals(bkpimage1.getDevicePath())) continue;
                    bkpimage1.setPresent(false);
                    filteredBackUpImagesList.add(bkpimage1);
                    continue block3;
                }
            }
        }
        this.logger.debug("....after-filteringe1...." + filteredBackUpImagesList.size());
        return filteredBackUpImagesList;
    }

    private List<String> getBackupCollectionList(Device device) {
        ArrayList<String> bkpCollectionList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)device.getDestCollection())) {
            bkpCollectionList.add(device.getDestCollection());
        }
        if (PCHelperConstant.isBackupCollectionQueryRequired()) {
            bkpCollectionList.add(BACKUP);
        }
        return bkpCollectionList;
    }

    private List<BackUpImage> getFilteredListForDevice(List<BackUpImage> backupList, Device device) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage backUpImage : backupList) {
            if (backUpImage == null) continue;
            if (backUpImage.getDevice() == null) {
                if (!backUpImage.getDeviceUUID().equals(device.getDeviceUUID())) continue;
                filteredBackUpImages.add(backUpImage);
                continue;
            }
            if (!backUpImage.getDevice().getId().equals((Object)device.getId())) continue;
            filteredBackUpImages.add(backUpImage);
        }
        return filteredBackUpImages;
    }

    private List<ObjectId> getAggregatedBackupIdsForRoot(int cloudId, MongoTemplate mongoTemplate, Device device, boolean restoreDeletedFiles) {
        Criteria criteria = new Criteria();
        String deviceUUID = device.getDeviceUUID();
        this.logger.debug("----------ID-----------*************************8" + device.getDeviceName());
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).exists(false)});
        ArrayList resultList = new ArrayList();
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String dest : bkpCollectionList) {
            TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{FILE_NAME, LAST_SERVER_MODIFIED_TIME})});
            AggregationResults result = mongoTemplate.aggregate(aggregation, dest, Document.class);
            List stateStatsList = result.getMappedResults();
            if (CollectionUtils.isEmpty((Collection)stateStatsList)) continue;
            resultList.addAll(stateStatsList);
        }
        ArrayList<ObjectId> listOfObjectIds = new ArrayList<ObjectId>();
        this.logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^" + resultList.size());
        for (Document dbObject : resultList) {
            String fileName = dbObject.get((Object)"_id").toString();
            this.logger.debug("555555555%%%%%%%%%%%%%%%%" + fileName);
            Long lastServerModifiedTime = (Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME);
            BackUpImage backUpImage = this.getBackUpImageForFileForRoot(cloudId, mongoTemplate, fileName, device, lastServerModifiedTime);
            if (backUpImage == null) continue;
            listOfObjectIds.add(backUpImage.getId());
            this.logger.debug("----------ID------------" + String.valueOf(backUpImage.getId()));
        }
        return listOfObjectIds;
    }

    private BackUpImage getBackUpImageForFileForRoot(int cloudId, MongoTemplate mongoTemplate, String fileName, Device device, Long serverModifiedTime) {
        Criteria criteria = new Criteria();
        String deviceUUID = device.getDeviceUUID();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).exists(false), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)LAST_SERVER_MODIFIED_TIME).is((Object)serverModifiedTime)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        ArrayList backUpImageList = new ArrayList();
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String dest : bkpCollectionList) {
            List resultList = mongoTemplate.find(query, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)resultList)) continue;
            backUpImageList.addAll(resultList);
        }
        this.logger.debug("getBackUpImageForFileForRoot backUpImageList size :" + backUpImageList.size());
        if (!CollectionUtils.isEmpty(backUpImageList)) {
            this.logger.debug("<<<<<<<>>>>>>>>>>>>>>>>>>>>>" + backUpImageList.size());
            return (BackUpImage)backUpImageList.get(0);
        }
        return null;
    }

    @Override
    public List<BackUpImage> getLatestFoldersRecursive(int cloudId, String cloudName, Device device, String devicePath) {
        List<BackUpImage> resList = new ArrayList<BackUpImage>();
        try {
            boolean retry;
            String deviceUUID = device.getDeviceUUID();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
            int retryCount = 0;
            do {
                retry = false;
                try {
                    ArrayList<BackUpImage> backupImages = new ArrayList<BackUpImage>();
                    this.logger.debug("##getting folders recursive device path: .........." + devicePath);
                    Criteria pathLikeCriteria = new Criteria();
                    if (!StringUtils.isEmpty((String)devicePath)) {
                        pathLikeCriteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
                    } else {
                        pathLikeCriteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).exists(false), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
                    }
                    Query query = new Query((CriteriaDefinition)pathLikeCriteria);
                    List<String> bkpCollectionList = this.getBackupCollectionList(device);
                    for (String dest : bkpCollectionList) {
                        List backupImagesList = mongoTemplate.find(query, BackUpImage.class, dest);
                        if (CollectionUtils.isEmpty((Collection)backupImagesList)) continue;
                        backupImages.addAll(backupImagesList);
                    }
                    resList = this.getFilteredBackupImageListByGrouping(backupImages, true);
                    this.logger.error("##End Result list after grouping.........." + resList.size());
                }
                catch (Exception e) {
                    retry = true;
                    ++retryCount;
                    this.logger.debug("insode mongo db exception whule getting folder list so sleep and retry######");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e1) {
                        this.logger.debug("InterruptedException" + e1.getMessage());
                        this.logger.debug("InterruptedException" + String.valueOf(e1));
                    }
                    this.logger.trace(String.valueOf(e));
                    this.logger.error("Exception while getting latest files:" + e.getMessage());
                    if (retryCount != 3) continue;
                    return null;
                }
            } while (retry && retryCount < 3);
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
            this.logger.debug("exception:", (Throwable)e);
        }
        this.logger.debug("result list size>>>>" + resList.size());
        return resList;
    }

    @Override
    public List<BackUpImage> getVersionsEwsId(int cloudId, String cloudName, String fileName, String fileCompletePath, Device device, String ewsId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)ewsId)) {
            this.logger.debug("empty ewsID...");
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)fileCompletePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            this.logger.debug("non empty ewsID..." + ewsId);
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)fileCompletePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)"ewsId").is((Object)ewsId)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        List<BackUpImage> versions = mongoTemplate.find(query, BackUpImage.class, device.getDestCollection());
        versions = this.getFilteredBackupImageListForVersions(versions);
        return versions;
    }

    @Override
    public List<BackUpImage> getVersionsBeforeInsert(int cloudId, String cloudName, String fileName, String devicePath, Device device, String odItemId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<BackUpImage> versions = this.getAggregatedBackupImagesForVersionsBeforeInsert(mongoTemplate, devicePath, fileName, device, odItemId);
        return versions;
    }

    private List<BackUpImage> getAggregatedBackupImagesForVersionsBeforeInsert(MongoTemplate mongoTemplate, String folderPath, String fileName, Device device, String odItemId) {
        Criteria criteria = new Criteria();
        if (!StringUtils.isEmpty((String)odItemId) && (device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.toString()) || device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.toString()))) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)"odItemId").is((Object)odItemId)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        }
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        return this.getBackupIMagesForVersionsBeforeInsert(mongoTemplate, device, (TypedAggregation<BackUpImage>)aggregation);
    }

    private List<BackUpImage> getAggregatedBackupImagesForVersionsBeforeInsertForItemId(MongoTemplate mongoTemplate, Device device, String odItemId) {
        Criteria criteria = new Criteria();
        if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.toString()) || device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.toString())) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)"odItemId").is((Object)odItemId)});
        }
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        return this.getBackupIMagesForVersionsBeforeInsert(mongoTemplate, device, (TypedAggregation<BackUpImage>)aggregation);
    }

    private List<BackUpImage> getBackupIMagesForVersionsBeforeInsert(MongoTemplate mongoTemplate, Device device, TypedAggregation<BackUpImage> aggregation) {
        ArrayList stateStatsList = new ArrayList();
        List<BackUpImage> backupImages = new ArrayList<BackUpImage>();
        try {
            this.logger.debug("Before the aggregation....");
            AggregationResults result = mongoTemplate.aggregate(aggregation, device.getDestCollection(), Document.class);
            this.logger.debug("After the aggregation......");
            List resultList = result.getMappedResults();
            if (!CollectionUtils.isEmpty((Collection)resultList)) {
                stateStatsList.addAll(resultList);
            }
            this.logger.debug("result set:" + String.valueOf(stateStatsList));
            for (Document dbObject : stateStatsList) {
                Long lastServerModifiedTime;
                String devicePath;
                String fileName = dbObject.get((Object)FILE_NAME).toString();
                BackUpImage backUpImage = this.getBackUpImageForFileBeforeInsert(mongoTemplate, fileName, devicePath = dbObject.get((Object)DEVICE_PATH).toString(), device, lastServerModifiedTime = (Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME));
                if (backUpImage == null) continue;
                backupImages.add(backUpImage);
            }
            backupImages = this.getFilteredBackupImageListForVersions(backupImages);
        }
        catch (Exception e) {
            this.logger.error("exception in getting the versions..", (Throwable)e);
        }
        return backupImages;
    }

    private BackUpImage getBackUpImageForFileBeforeInsert(MongoTemplate mongoTemplate, String fileName, String devicePath, Device device, Long serverModifiedTime) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)LAST_SERVER_MODIFIED_TIME).is((Object)serverModifiedTime)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        query.fields().exclude("chunkFiles");
        ArrayList backUpImageList = new ArrayList();
        List list = mongoTemplate.find(query, BackUpImage.class, device.getDestCollection());
        if (!CollectionUtils.isEmpty((Collection)list)) {
            backUpImageList.addAll(list);
        }
        if (!CollectionUtils.isEmpty(backUpImageList)) {
            return (BackUpImage)backUpImageList.get(0);
        }
        return null;
    }

    @Override
    public List<BackUpImage> getLatestFoldersRecursiveForExchange(int cloudId, String cloudName, Device device, String devicePath, boolean present) {
        ArrayList<BackUpImage> resList = new ArrayList<BackUpImage>();
        try {
            boolean retry;
            String deviceUUID = device.getDeviceUUID();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
            int retryCount = 0;
            do {
                retry = false;
                try {
                    ArrayList backupImages = new ArrayList();
                    this.logger.debug("##getting folders recursive device path: .........." + devicePath);
                    Criteria pathLikeCriteria = new Criteria();
                    if (!StringUtils.isEmpty((String)devicePath)) {
                        pathLikeCriteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)present)});
                    } else {
                        pathLikeCriteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).exists(false), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)present)});
                    }
                    Query query = new Query((CriteriaDefinition)pathLikeCriteria);
                    List<String> bkpCollectionList = this.getBackupCollectionList(device);
                    for (String dest : bkpCollectionList) {
                        List backupImagesList = mongoTemplate.find(query, BackUpImage.class, dest);
                        if (CollectionUtils.isEmpty((Collection)backupImagesList)) continue;
                        backupImages.addAll(backupImagesList);
                    }
                    resList = backupImages;
                    this.logger.error("##End Result list after grouping.........." + resList.size());
                }
                catch (Exception e) {
                    retry = true;
                    ++retryCount;
                    this.logger.debug("insode mongo db exception whule getting folder list so sleep and retry######");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e1) {
                        this.logger.debug("InterruptedException" + e1.getMessage());
                        this.logger.debug("InterruptedException" + String.valueOf(e1));
                    }
                    this.logger.trace(String.valueOf(e));
                    this.logger.error("Exception while getting latest files:" + e.getMessage());
                    if (retryCount != 3) continue;
                    return null;
                }
            } while (retry && retryCount < 3);
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
            this.logger.debug("exception:", (Throwable)e);
        }
        this.logger.debug("result list size>>>>" + resList.size());
        return resList;
    }

    @Override
    public List<BackUpImage> getRestBackupFilesForGivenPathfromBackupImageForExchange(int cloudId, String cloudName, String folderPath, Device device, boolean isExchange, String serverModifiedTime, boolean restoreDeletedFiles, AtomicInteger skipValue) {
        List<BackUpImage> list = new ArrayList<BackUpImage>();
        ArrayList<BackUpImage> bkpImages = new ArrayList<BackUpImage>();
        long modifiedTime = 0L;
        if (!org.springframework.util.StringUtils.isEmpty((Object)serverModifiedTime)) {
            modifiedTime = Long.parseLong(serverModifiedTime);
        }
        this.logger.debug(folderPath + "..File list based on time stamp skip value.................... " + skipValue.get());
        try {
            boolean tryAgainWithIncreasedSkipValue = false;
            do {
                this.logger.debug("RESTORE-QUERY ..getBackupFilesForGivenPathfromBackupImage..........");
                MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
                mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
                Criteria criteria = new Criteria();
                Query query = null;
                if (!restoreDeletedFiles) {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FOLDER).is((Object)false)});
                    query = new Query((CriteriaDefinition)criteria);
                } else {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)STATUS).is((Object)"ADDED")});
                    query = new Query((CriteriaDefinition)criteria);
                }
                if (isExchange) {
                    if (skipValue.get() != 0) {
                        query.skip((long)(skipValue.get() * 50));
                    }
                    query.limit(50);
                }
                List<String> queryTablesList = this.getBackupCollectionList(device);
                for (String dest : queryTablesList) {
                    List results = mongoTemplate.find(query, BackUpImage.class, dest);
                    if (CollectionUtils.isEmpty((Collection)results)) continue;
                    list.addAll(results);
                }
                if (list.size() == 0) {
                    return list;
                }
                if (isExchange && !restoreDeletedFiles) {
                    ArrayList deletedBackupImagesTotal = new ArrayList();
                    this.logger.debug("starting the getting deleted files operation...");
                    list.forEach(image -> {
                        if (image.getStatus().equalsIgnoreCase("ADDED")) {
                            Criteria criteria1 = new Criteria();
                            criteria1.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)"md5Checksum").is((Object)image.getMd5Checksum()), Criteria.where((String)STATUS).is((Object)DELETED)});
                            Query query1 = new Query((CriteriaDefinition)criteria1);
                            BackUpImage deletedBkpImg = (BackUpImage)mongoTemplate.findOne(query1, BackUpImage.class, device.getDestCollection());
                            if (deletedBkpImg != null) {
                                deletedBackupImagesTotal.add(deletedBkpImg);
                            }
                        }
                    });
                    this.logger.debug("end of the getting deleted files operation..." + deletedBackupImagesTotal.size());
                    list.addAll(deletedBackupImagesTotal);
                }
                if (modifiedTime != 0L) {
                    if (!CollectionUtils.isEmpty(list)) {
                        for (BackUpImage backUpImage : list) {
                            long serverModTime = backUpImage.getLastServerModifiedTime();
                            if (serverModTime > modifiedTime) continue;
                            bkpImages.add(backUpImage);
                        }
                    }
                } else {
                    bkpImages.addAll(list);
                }
                this.logger.debug("....count of list..." + list.size());
                if (!restoreDeletedFiles) {
                    list = this.getFilteredLatestVersionBackupImageList(bkpImages, restoreDeletedFiles, isExchange);
                }
                this.logger.debug("....count of list after ..." + list.size());
                if (list.size() != 0) continue;
                tryAgainWithIncreasedSkipValue = true;
                skipValue.set(skipValue.incrementAndGet());
            } while (tryAgainWithIncreasedSkipValue);
            this.logger.error("##End getBackupFilesForGivenPathfromBackupImage ..........");
        }
        catch (Exception e) {
            this.logger.trace(String.valueOf(e));
            this.logger.error(" Exception while getting filefrom backupimage:", (Throwable)e);
            return null;
        }
        return list;
    }

    @Override
    public long getCountOfBackupFilesForGivenPathfromBackupImageForExchange(int cloudId, String cloudName, String folderPath, Device device, boolean restoreDeletedFiles, long restoreDataBefore) {
        long totalCount = 0L;
        this.logger.debug(folderPath + "..gettign total count for  .................... ");
        try {
            this.logger.debug("RESTORE-QUERY ..getBackupFilesForGivenPathfromBackupImage..........");
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
            Criteria criteria = new Criteria();
            String status = "ADDED";
            if (!restoreDeletedFiles) {
                status = DELETED;
            }
            if (restoreDataBefore != 0L) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)LAST_SERVER_MODIFIED_TIME).lte((Object)restoreDataBefore), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)STATUS).is((Object)status)});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)STATUS).is((Object)status)});
            }
            Query query = new Query((CriteriaDefinition)criteria);
            List<String> queryTablesList = this.getBackupCollectionList(device);
            for (String dest : queryTablesList) {
                long count = mongoTemplate.count(query, BackUpImage.class, dest);
                totalCount = count + totalCount;
            }
            this.logger.debug("....count of list..." + totalCount);
            this.logger.error("##End getBackupFilesForGivenPathfromBackupImage ..........");
        }
        catch (Exception e) {
            this.logger.trace(String.valueOf(e));
            this.logger.error(" Exception while getting filefrom backupimage:", (Throwable)e);
            return 0L;
        }
        return totalCount;
    }

    @Override
    public void updateLInkGen(String backupId, String destCollection, boolean linkGenerated) {
        Criteria criteria = Criteria.where((String)"id").is((Object)backupId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("mailLinkGenerated", (Object)linkGenerated);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        mongoTemplate.updateFirst(query, (UpdateDefinition)update, BackUpImage.class, destCollection);
    }

    @Override
    public List<BackUpImage> getVersionsBeforeInsertForItemId(int cloudId, String cloudName, Device device, String odItemId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<BackUpImage> versions = this.getAggregatedBackupImagesForVersionsBeforeInsertForItemId(mongoTemplate, device, odItemId);
        return versions;
    }

    private List<BackUpImage> getDeletedVersionForPathAndItemId(MongoTemplate mongoTemplate, String folderPath, Device device, String odItemId) {
        Criteria criteria = new Criteria();
        if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.toString()) || device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.toString())) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)"odItemId").is((Object)odItemId), Criteria.where((String)STATUS).is((Object)DELETED)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)STATUS).is((Object)DELETED)});
        }
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        return this.getBackupIMagesForVersionsBeforeInsert(mongoTemplate, device, (TypedAggregation<BackUpImage>)aggregation);
    }

    @Override
    public BackUpImage getDeletedVersionForPathAndItemId(int cloudId, String devicePath, Device device, String odItemId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<BackUpImage> versions = this.getDeletedVersionForPathAndItemId(mongoTemplate, devicePath, device, odItemId);
        if (!CollectionUtils.isEmpty(versions)) {
            return versions.get(0);
        }
        return null;
    }

    @Override
    public void updateOdItemId(int cloudId, ObjectId backupId, String odItemId, String destCollection) {
        Criteria criteria;
        Query query;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackUpImage findOne = (BackUpImage)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"id").is((Object)backupId))), BackUpImage.class, destCollection);
        if (findOne != null) {
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"odItemId").is((Object)findOne.getOdItemId())});
            query = new Query((CriteriaDefinition)criteria);
            List bkpImages = mongoTemplate.find(query, BackUpImage.class, destCollection);
            if (!CollectionUtils.isEmpty((Collection)bkpImages)) {
                for (BackUpImage backUpImage : bkpImages) {
                    if (backUpImage == null) continue;
                    this.logger.debug("...iterating id for update....." + backUpImage.getId().toString());
                    Update update = new Update();
                    update.set("linkDeleted", (Object)true);
                    criteria = Criteria.where((String)"id").is((Object)backUpImage.getId());
                    query = new Query((CriteriaDefinition)criteria);
                    mongoTemplate.updateFirst(query, (UpdateDefinition)update, BackUpImage.class, destCollection);
                }
            }
        }
    }

    @Override
    public BackupBatch getBackupBatchByDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"batchStartTimestamp"}));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
    }
}

