/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.microsoft.graph.requests.GraphServiceClient;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.SIEMCredentials;
import com.parablu.pcbd.domain.User;
import com.pg.dao.UtilDao;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.odb.util.GoogleDriveUtil;
import com.pg.odb.util.OneDriveUtil;
import com.pg.service.GraphUploadService;
import com.pg.service.SIEMService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import okhttp3.Request;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.domain.Location;
import org.jclouds.openstack.swift.v1.SwiftApiMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SIEMServiceImpl
implements SIEMService {
    private static Logger logger = LogManager.getLogger(SIEMServiceImpl.class);
    private static final String cefTemplateString = "${date} host CEF:1|Parablu|BluVault|1.0|${eventId}|${name}|LOW|suser=${actionByUserName} cs1=${actionOnObject} cs1Label=actionOnObject cs2=${actionUsingObject} cs2Label=parabluActionUsingObject deviceCustomDate1=${timestamp} deviceCustomDate1Label=parabluTimestamp filePath=${fileCompletePath} cs3=${additionalInfo} cs3Label=parabluAdditionalInfo cn1=${isMiniCloud} cn1Label=parabluIsMiniCloud cs4=${mcName} cs4Label=parabluMiniCloudName";
    private static final String PARABLU_SIEM = "parablu-siem";
    private static final String PARABLU_SIEM_CONTAINER = "parablu-siem-container";
    private static final String NUM_1048576 = "1048576";
    private static final String NUM_THREADS = "2";
    @Autowired
    private UtilDao utilDao;
    @Autowired
    private GraphUploadService graphUploadService;

    @Override
    public String convertAuditHistoryToCEF(String cloudName, long jobTimestamp) {
        long lastUploadedTimestamp = this.utilDao.getLastUploadedTimestampForSIEM();
        List auditHistoryList = this.utilDao.getAuditHistoryForRange(lastUploadedTimestamp);
        logger.debug("Size of Audit History for this cycle : " + auditHistoryList.size());
        List partitionedLists = Lists.partition((List)auditHistoryList, (int)1000);
        StringBuffer stringBuffer = new StringBuffer();
        for (List auditHistoryChildList : partitionedLists) {
            for (AuditHistory auditHistoryObj : auditHistoryChildList) {
                stringBuffer.append(this.formatLogToCEF(auditHistoryObj)).append(System.getProperty("line.separator"));
            }
        }
        String filePath = this.writeToFileOnDisk(cloudName, stringBuffer, jobTimestamp);
        if (filePath != null && !filePath.isEmpty()) {
            logger.debug("File Path after writing to disk : " + filePath);
            return filePath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeToFileOnDisk(String cloudName, StringBuffer stringBuffer, long jobTimestamp) {
        BufferedWriter bufferedWriter = null;
        try {
            String fileName = PCHelperConstant.getPropertyFileSIEMPath((String)cloudName) + jobTimestamp + ".log";
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
            file.getParentFile().mkdirs();
            file.createNewFile();
            bufferedWriter = new BufferedWriter(new FileWriter(file.getAbsoluteFile(), true));
            bufferedWriter.write(stringBuffer.toString());
            String string = fileName;
            return string;
        }
        catch (IOException e) {
            logger.error("Exception occurred while writing SIEM logs to file" + e.getMessage());
            logger.error("Exception Stacktrace : ", (Throwable)e);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    logger.error("Exception occurred while closing the BufferedWriter : " + e.getMessage());
                }
            }
        }
        return null;
    }

    private String formatLogToCEF(AuditHistory auditHistoryObj) {
        Date date = new Date(auditHistoryObj.getTimestamp());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd hh:mm:ss");
        HashMap<String, Object> auditHistoryMap = new HashMap<String, Object>();
        auditHistoryMap.put("date", simpleDateFormat.format(date));
        auditHistoryMap.put("eventId", auditHistoryObj.getActionType());
        auditHistoryMap.put("name", this.validateString(auditHistoryObj.getAction()) ? auditHistoryObj.getAction() : "");
        auditHistoryMap.put("actionByUserName", this.validateString(auditHistoryObj.getActionByUserName()) ? auditHistoryObj.getActionByUserName() : "");
        auditHistoryMap.put("actionOnObject", this.validateString(auditHistoryObj.getActionOnObject()) ? auditHistoryObj.getActionOnObject() : "");
        auditHistoryMap.put("actionUsingObject", this.validateString(auditHistoryObj.getActionUsingObject()) ? auditHistoryObj.getActionUsingObject() : "");
        auditHistoryMap.put("timestamp", auditHistoryObj.getTimestamp());
        auditHistoryMap.put("fileCompletePath", this.validateString(auditHistoryObj.getFileCompletePath()) ? auditHistoryObj.getFileCompletePath() : "");
        auditHistoryMap.put("additionalInfo", this.validateString(auditHistoryObj.getAdditionalInfo()) ? auditHistoryObj.getAdditionalInfo() : "");
        auditHistoryMap.put("isMiniCloud", auditHistoryObj.isMiniCloud() ? 1 : 0);
        auditHistoryMap.put("mcName", this.validateString(auditHistoryObj.getMcName()) ? auditHistoryObj.getMcName() : "");
        StringSubstitutor substitutor = new StringSubstitutor(auditHistoryMap);
        return substitutor.replace(cefTemplateString);
    }

    private boolean validateString(String value) {
        return value != null && !value.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean uploadFileToCloud(SIEMCredentials siemCredentials, String filePath) {
        boolean uploadStatus = false;
        Path completePath = Paths.get(filePath, new String[0]);
        File file = new File(completePath.toString());
        Object fileName = completePath.getFileName().toString();
        String baseFileName = FilenameUtils.getBaseName((String)fileName);
        fileName = "parablu-siem/" + baseFileName + "/" + (String)fileName;
        String containerName = siemCredentials.getContainerName();
        try (BlobStoreContext blobStoreContext = null;){
            blobStoreContext = this.getBlobStoreContext(siemCredentials);
            if (StringUtils.isEmpty((String)containerName)) {
                logger.debug("Container name is empty; setting to default container name");
                containerName = PARABLU_SIEM_CONTAINER;
            }
            containerName = this.checkPreConditionForCreateContainer(containerName);
            logger.debug("Container Name : " + containerName);
            ApiMetadata apiMetadata = blobStoreContext.unwrap().getProviderMetadata().getApiMetadata();
            BlobStore blobStore = blobStoreContext.getBlobStore();
            Location location = null;
            if (apiMetadata instanceof SwiftApiMetadata) {
                location = (Location)Iterables.getFirst((Iterable)blobStore.listAssignableLocations(), null);
            }
            boolean blobExists = this.createContainerIfNotExists(containerName, blobStore, location);
            logger.debug("Provider : " + siemCredentials.getProvider() + " Container Created : " + blobExists);
            if (!blobExists) {
                boolean bl = false;
                return bl;
            }
            logger.debug("Provider : " + siemCredentials.getProvider() + " Upload to directory : parablu-siem Filename : " + (String)fileName + " Blob exists? : " + blobExists + " File length : " + file.length());
            Blob blob = blobStore.blobBuilder((String)fileName).payload(file).contentLength(file.length()).build();
            String putBlob = blobStore.putBlob(containerName, blob);
            logger.debug("Upload logs to cloud successful - putBlob : " + putBlob);
            uploadStatus = true;
        }
        return uploadStatus;
    }

    private BlobStoreContext getBlobStoreContext(SIEMCredentials siemCredentials) {
        Properties properties = new Properties();
        if (!StringUtils.isEmpty((String)siemCredentials.getIdentity())) {
            properties.setProperty(siemCredentials.getProvider() + ".identity", siemCredentials.getIdentity());
        }
        if (!StringUtils.isEmpty((String)siemCredentials.getCredential())) {
            properties.setProperty(siemCredentials.getProvider() + ".credential", siemCredentials.getCredential());
        }
        properties.setProperty("jclouds.mpu.parts.size", NUM_1048576);
        properties.setProperty("jclouds.mpu.parallel.degree", NUM_THREADS);
        if (!StringUtils.isEmpty((String)PCHelperConstant.getProxyHost()) && !StringUtils.isEmpty((String)String.valueOf(PCHelperConstant.getProxyPort()))) {
            logger.debug("Setting proxy for jclouds : " + PCHelperConstant.getProxyHost());
            properties.setProperty("jclouds.proxy-host", PCHelperConstant.getProxyHost());
            properties.setProperty("jclouds.proxy-port", String.valueOf(PCHelperConstant.getProxyPort()));
            if (!StringUtils.isEmpty((String)PCHelperConstant.getProxyUserName()) && !StringUtils.isEmpty((String)PCHelperConstant.getProxyPassword())) {
                properties.setProperty("jclouds.proxy-user", PCHelperConstant.getProxyUserName());
                properties.setProperty("jclouds.proxy-password", PCHelperConstant.getProxyPassword());
            }
        }
        ContextBuilder credentials = ContextBuilder.newBuilder((String)siemCredentials.getProvider()).overrides(properties);
        if ("swift".equalsIgnoreCase(siemCredentials.getProvider()) || "s3".equalsIgnoreCase(siemCredentials.getProvider())) {
            credentials.endpoint(siemCredentials.getEndPointUrl());
        }
        return (BlobStoreContext)credentials.buildView(BlobStoreContext.class);
    }

    private String checkPreConditionForCreateContainer(String containerName) {
        Object containerNameTemp = containerName;
        containerNameTemp = ((String)containerNameTemp).toLowerCase();
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((String)containerNameTemp)) {
            if (((String)containerNameTemp).length() < 3) {
                containerNameTemp = (String)containerNameTemp + "-parablu";
            }
            containerNameTemp = ((String)containerNameTemp).replace(" ", "-");
            containerNameTemp = ((String)containerNameTemp).replace(".", "-46");
            containerNameTemp = ((String)containerNameTemp).replace("@", "-64");
            containerNameTemp = ((String)containerNameTemp).replace("_", "-95");
            sb.append((String)containerNameTemp);
            return sb.toString();
        }
        return containerNameTemp;
    }

    private boolean createContainerIfNotExists(String containerName, BlobStore blobStore, Location location) {
        boolean blobExists = false;
        try {
            boolean containerExists = blobStore.containerExists(containerName);
            if (containerExists) {
                logger.debug("Container exists: " + containerName);
                blobExists = true;
            } else {
                boolean isContainerCreated = blobStore.createContainerInLocation(location, containerName);
                if (isContainerCreated) {
                    logger.debug("Container did not exist, created new container : " + containerName);
                    blobExists = true;
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to create a container" + e.getMessage());
            logger.error("Exception stacktrace : ", (Throwable)e);
        }
        return blobExists;
    }

    @Override
    public boolean uploadFileToODB(Cloud cloud, String filePath, String odbLoginId) {
        GraphServiceClient<Request> graphClient;
        boolean uploadStatus = false;
        if (cloud.getGraphApiEnabled() == 1 && (graphClient = OneDriveUtil.getSIEMGraphClient()) != null) {
            PciAuthorizationTokenElement pciAuthorizationTokenElement = new PciAuthorizationTokenElement();
            pciAuthorizationTokenElement.setCloudName(cloud.getCloudName());
            pciAuthorizationTokenElement.setAccountId(odbLoginId);
            FileStatusElement fileStatusElement = new FileStatusElement();
            File siemFile = new File(filePath);
            Path completePath = Paths.get(filePath, new String[0]);
            String fileName = completePath.getFileName().toString();
            String baseFileName = FilenameUtils.getBaseName((String)fileName);
            fileStatusElement = this.graphUploadService.uploadToOneDriveUsingGraph(pciAuthorizationTokenElement, siemFile, fileName, odbLoginId, "", "Parablu-SIEM/" + baseFileName, "", false, true, false);
            uploadStatus = fileStatusElement.isUploadStatus();
        }
        return uploadStatus;
    }

    @Override
    public boolean uploadFileToGoogleDrive(Cloud cloud, String filePath) {
        boolean uploadStatus = false;
        User user = new User();
        Path completePath = Paths.get(filePath, new String[0]);
        File siemFile = new File(filePath);
        boolean isGDServiceAcctEnabled = this.checkLicenseEnabledForFeature(cloud.getCloudCustomisableDetails(), "GD Service Account Enabled");
        PciAuthorizationTokens pciAuthorizationTokens = isGDServiceAcctEnabled ? this.utilDao.getPciAuthorizationTokens(cloud.getCloudId()) : this.utilDao.getPciAuthorizationTokensForUserName(cloud.getCloudId(), user.getUserName());
        if (pciAuthorizationTokens != null) {
            PciAuthorizationTokenElement pciTokenElement = this.getTokenElement(pciAuthorizationTokens);
            pciTokenElement.setUserName(user.getUserName());
            GoogleDriveUtil googleDriveUtil = GoogleDriveUtil.getInstance();
            if (StringUtils.isEmpty((String)user.getOdbLoginId())) {
                pciTokenElement.setAccountId(user.getEmailId());
            } else {
                pciTokenElement.setAccountId(user.getOdbLoginId());
            }
            pciTokenElement.setCloudName(cloud.getCloudName());
            String cloudChunkName = completePath.getFileName().toString();
            logger.debug(user.getOdbLoginId() + " ....uploading using googleDriveUtil for user login id....... " + user.getEmailId());
            FileStatusElement fileStatusElement = new FileStatusElement();
            fileStatusElement = googleDriveUtil.uploadToGD(pciTokenElement, false, fileStatusElement, siemFile, null, cloudChunkName, null, user);
            uploadStatus = fileStatusElement.isUploadStatus();
        }
        return uploadStatus;
    }

    @Override
    public void updateLastUploadedTimestamp(long jobTimestamp) {
        this.utilDao.updateLastUploadedTimestamp(jobTimestamp);
    }

    @Override
    public SIEMCredentials getSIEMCredentials() {
        return this.utilDao.getSIEMCredentials();
    }

    private boolean checkLicenseEnabledForFeature(List<CloudCustomisableDetails> licenseDetails, String featureType) {
        boolean featureEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !featureType.equalsIgnoreCase(license.getName())) continue;
            featureEnabled = true;
            break;
        }
        return featureEnabled;
    }

    private PciAuthorizationTokenElement getTokenElement(PciAuthorizationTokens pciAuthorizationTokens) {
        PciAuthorizationTokenElement tokenElement = new PciAuthorizationTokenElement();
        if (pciAuthorizationTokens == null) {
            return tokenElement;
        }
        tokenElement.setAccessToken(pciAuthorizationTokens.getAccessToken());
        tokenElement.setAuthenticationToken(pciAuthorizationTokens.getAuthenticationToken());
        tokenElement.setClientId(pciAuthorizationTokens.getClientId());
        tokenElement.setClientSecret(pciAuthorizationTokens.getClientSecret());
        tokenElement.setEmailId(pciAuthorizationTokens.getEmailId());
        tokenElement.setRedirectUri(pciAuthorizationTokens.getRedirectUri());
        tokenElement.setRefreshToken(pciAuthorizationTokens.getRefreshToken());
        tokenElement.setCloudStorageType(pciAuthorizationTokens.getCloudStorageType().getName());
        tokenElement.setAccountId(pciAuthorizationTokens.getAccountId());
        tokenElement.setSharePointUrl(pciAuthorizationTokens.getSharePointUrl());
        tokenElement.setCloudName(pciAuthorizationTokens.getCloudName());
        User user = this.utilDao.getUserInfo(1, "", pciAuthorizationTokens.getUserId().toString());
        if (user != null) {
            tokenElement.setUserName(user.getUserName());
        }
        return tokenElement;
    }
}

