/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"writeCache"})
public class CachedWriteService {
    private final ConcurrentHashMap<String, Boolean> writeAllowedCache = new ConcurrentHashMap();
    private final AtomicInteger fileCounter = new AtomicInteger(0);

    @Cacheable(key="#key")
    public boolean isWriteAllowed(String key) {
        return this.writeAllowedCache.getOrDefault(key, true);
    }

    @CachePut(key="#key")
    public void setWriteAllowed(String key, boolean allowed) {
        this.writeAllowedCache.put(key, allowed);
    }

    public void checkAndSetFlag(String key) {
        if (!this.isWriteAllowed(key)) {
            this.setWriteAllowed(key, false);
        }
    }
}

