/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.google.common.util.concurrent.RateLimiter;
import com.mongodb.MongoException;
import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.dao.MSUtilDao;
import com.parablu.pcbd.dao.SyncBackUpImageDAO;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.dao.UserSyncOverViewDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.MailAttachment;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.OutlookEmailAddress;
import com.parablu.pcbd.domain.SyncPolicy;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserSyncOverView;
import com.pg.controller.BaseController;
import com.pg.dao.SyncFileDao;
import com.pg.element.BackupElement;
import com.pg.element.FileUploadDetailsElement;
import com.pg.element.OutlookEmailAddressElement;
import com.pg.exception.ParacloudBackupException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.BackupService;
import com.pg.service.UtilService;
import com.pg.util.PathConversionHelper;
import com.pg.util.PathGenerator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BackupServiceImpl
implements BackupService {
    private static Logger logger = LogManager.getLogger(BackupServiceImpl.class);
    private BackUpImageDao backUpImageDao;
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    private MSUtilDao msUtilDao;
    private UserDao userDao;
    @Autowired
    private UtilService utilService;
    @Autowired
    private SyncBackUpImageDAO syncBackUpImageDAO;
    @Autowired
    private SyncFileDao syncFileDao;
    @Autowired
    private UserSyncOverViewDao userSyncOverViewDao;
    static final String NEWLINE = System.getProperty("line.separator");
    private RateLimiter limiter = null;

    public UtilService getUtilService() {
        return this.utilService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public void setBackUpImageDao(BackUpImageDao backUpImageDao) {
        this.backUpImageDao = backUpImageDao;
    }

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }

    public void setMsUtilDao(MSUtilDao msUtilDao) {
        this.msUtilDao = msUtilDao;
    }

    @Override
    public FileUploadDetailsElement uploadExternalFileToBackUp(int cloudId, String cloudName, BackupElement fileElement, Device device, String userUnderLegalHold, boolean isFullBackup, boolean isEncrypted) {
        FileUploadDetailsElement fileUploadDetailsElement = new FileUploadDetailsElement();
        ObjectId id = null;
        String fileName = null;
        String newStatus = null;
        BackUpImage backUpImage = null;
        User user = null;
        MiniCloud miniCloud = null;
        boolean isSync = fileElement.getIsSync();
        try {
            this.convertToServerPath(fileElement, device);
            fileName = fileElement.getFileName();
            if (!StringUtils.isEmpty((String)fileElement.getFileCompletePath()) && fileElement.getFileCompletePath().equalsIgnoreCase("Tasks")) {
                fileElement.setFileName(fileElement.getTaskSubject());
            }
            long storageUtilized = 0L;
            logger.debug(fileElement.getTaskSubject() + " Before calling getVersionslatest ........device id ..." + String.valueOf(device.getId()) + " PATH " + fileElement.getFileCompletePath() + " FILE NAME " + fileName);
            boolean isMail = false;
            if (device.getOsType().equalsIgnoreCase("OUTLOOK")) {
                isMail = true;
            }
            List<BackUpImage> backUpImagesList = new ArrayList();
            logger.debug(isSync + " end of calling getVersions ..... ewsid......" + fileElement.getEwsId());
            this.setRateLimiter();
            logger.debug(fileElement.getOdItemId() + "..%%% PVN ACQ for version in secs:" + this.limiter.acquire());
            if (!isMail && !isSync) {
                logger.debug(fileName + "&*&file-detail*&*" + fileElement.getOdItemId());
                if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.toString()) || device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.toString())) {
                    logger.debug(fileElement.getVersionId() + "....versionidlatest..." + fileElement.getOdItemId());
                    backUpImagesList = this.backUpImageDao.getVersionsBeforeInsertForItemId(cloudId, cloudName, device, fileElement.getOdItemId());
                } else {
                    backUpImagesList = this.backUpImageDao.getVersionsEwsId(cloudId, cloudName, fileName, fileElement.getFileCompletePath(), device, fileElement.getEwsId());
                }
                logger.debug("****versioncheck***");
                for (BackUpImage image : backUpImagesList) {
                    logger.debug("****versioncheck***" + image.getDevicePath());
                    logger.debug(fileElement.getFileCompletePath() + "****versioncheckfile***" + image.getDevicePath());
                    logger.debug(fileElement.getFileName() + "****versioncheckfilefile***" + image.getFileName());
                    if (image == null || StringUtils.isEmpty((String)image.getDevicePath()) || image.getDevicePath().equalsIgnoreCase(fileElement.getFileCompletePath()) && image.getFileName().equalsIgnoreCase(fileElement.getFileName())) continue;
                    BackUpImage backUpImageDeleted = this.backUpImageDao.getDeletedVersionForPathAndItemId(cloudId, image.getDevicePath(), device, fileElement.getOdItemId());
                    logger.debug("****versioncheck***" + String.valueOf(backUpImageDeleted));
                    if (backUpImageDeleted != null) continue;
                    BackUpImage deletedBkpImage = this.convertToBkpImage(image.getDeviceUUID(), image);
                    this.backUpImageDao.saveImageToBackUp(cloudId, deletedBkpImage, device);
                }
            } else if (!isMail && isSync) {
                List allMiniCloudsList = this.syncFileDao.getAllMiniClouds(cloudId);
                boolean isFileUnderMC = this.isFileUnderMC(allMiniCloudsList, fileElement.getFileCompletePath());
                if (isFileUnderMC) {
                    String mcName = BackupServiceImpl.getMCName(fileElement.getFileCompletePath());
                    miniCloud = this.syncFileDao.getMiniCloudByName(cloudId, mcName);
                } else {
                    user = this.userDao.getUserByName(cloudId, fileElement.getFileUserOwner());
                }
                backUpImagesList = this.syncBackUpImageDAO.getVersions(cloudId, cloudName, fileElement.getFileUserOwner(), fileName, fileElement.getFileCompletePath(), user, miniCloud);
            } else {
                backUpImagesList = this.backUpImageDao.getVersionsEwsId(cloudId, cloudName, fileName, fileElement.getFileCompletePath(), device, fileElement.getEwsId());
            }
            boolean lastRecordPresent = false;
            boolean diffPath = false;
            long prevVersionSize = 0L;
            backUpImagesList.removeAll(Collections.singleton(null));
            if (!CollectionUtils.isEmpty(backUpImagesList)) {
                logger.debug("...backup images size .... " + backUpImagesList.size());
                backUpImage = (BackUpImage)backUpImagesList.get(0);
                if (backUpImage != null) {
                    logger.debug(backUpImage.getFileName() + "....ffillle....." + backUpImage.getStatus());
                    logger.debug(backUpImage.getStatus() + "....ffillle....." + backUpImage.getDevicePath());
                    logger.debug("....complete path....." + fileElement.getFileCompletePath());
                }
                logger.debug(String.valueOf(fileElement) + "...backup images .... " + String.valueOf(backUpImage));
                if (backUpImage != null && fileElement != null && backUpImage.getDevicePath().equalsIgnoreCase(fileElement.getFileCompletePath()) && !StringUtils.isEmpty((String)backUpImage.getFileName()) && !StringUtils.isEmpty((String)fileElement.getFileName()) && backUpImage.getFileName().equalsIgnoreCase(fileElement.getFileName()) && !backUpImage.getStatus().equalsIgnoreCase(PCHelperConstant.REVISION_STATUS.DELETED.toString())) {
                    logger.debug(backUpImage.getDevicePath() + " *&*&*&*file already present .............." + backUpImage.getFileName());
                    lastRecordPresent = true;
                }
                if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.toString()) && !StringUtils.isEmpty((String)fileElement.getVersionId())) {
                    boolean versionIdExists = false;
                    for (BackUpImage bkp : backUpImagesList) {
                        if (StringUtils.isEmpty((String)fileElement.getVersionId()) || StringUtils.isEmpty((String)bkp.getVersionId()) || !fileElement.getVersionId().equalsIgnoreCase(bkp.getVersionId())) continue;
                        versionIdExists = true;
                    }
                    if (!versionIdExists) {
                        // empty if block
                    }
                }
                for (BackUpImage bkp : backUpImagesList) {
                    if (bkp == null || bkp.getStatus().equalsIgnoreCase(PCHelperConstant.REVISION_STATUS.DELETED.toString())) continue;
                    prevVersionSize = bkp.getSize();
                    break;
                }
                logger.debug("................prevVersionSize......" + prevVersionSize);
            } else {
                logger.debug(" no versions present...............");
            }
            logger.debug(lastRecordPresent + "....diff path12...." + diffPath);
            if (diffPath) {
                // empty if block
            }
            boolean noChange = false;
            if (lastRecordPresent) {
                noChange = this.checkIfRevisionHasBeenModified(fileElement, backUpImage);
                if (isMail) {
                    noChange = true;
                }
            }
            if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.toString()) && !StringUtils.isEmpty((String)fileElement.getVersionId())) {
                noChange = false;
            }
            logger.debug(lastRecordPresent + "...checkversionchanged1...." + noChange + "...path.." + String.valueOf(backUpImage));
            if (lastRecordPresent && noChange && backUpImage != null && !StringUtils.isEmpty((String)backUpImage.getDevicePath()) && ("Contacts".equalsIgnoreCase(backUpImage.getDevicePath()) || backUpImage.getDevicePath().startsWith("Calendar") || backUpImage.getDevicePath().startsWith("To Do"))) {
                BackUpImage backUpImageDeleted = this.backUpImageDao.getDeletedVersionForPathAndItemId(cloudId, backUpImage.getDevicePath(), device, fileElement.getOdItemId());
                logger.debug(backUpImage.getStatus() + "****contactcs/Calendar/task check***" + String.valueOf(backUpImageDeleted));
                if (backUpImageDeleted == null || !backUpImage.getStatus().equalsIgnoreCase(PCHelperConstant.REVISION_STATUS.DELETED.toString())) {
                    BackUpImage deletedBkpImage = this.convertToBkpImage(backUpImage.getDeviceUUID(), backUpImage);
                    this.backUpImageDao.saveImageToBackUp(cloudId, deletedBkpImage, device);
                    noChange = false;
                }
            }
            if (lastRecordPresent && noChange) {
                Object alreadyExist = "ALREADY_EXISTS";
                id = backUpImage.getId();
                if (isMail && backUpImage.isMailLinkGenerated()) {
                    alreadyExist = "ALREADY_EXISTS_LINK";
                } else if (isMail && !backUpImage.isMailLinkGenerated()) {
                    alreadyExist = "ALREADY_EXISTS-" + backUpImage.getId().toString() + "-" + device.getDestCollection();
                } else if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.toString()) || device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.toString()) && !backUpImage.isLinkGenerated()) {
                    alreadyExist = "ALREADY_EXISTS-" + backUpImage.getId().toString() + "-" + device.getDestCollection();
                }
                if (isFullBackup) {
                    // empty if block
                }
                fileUploadDetailsElement.setBkpId((String)alreadyExist);
                return fileUploadDetailsElement;
            }
            newStatus = lastRecordPresent ? PCHelperConstant.REVISION_STATUS.MODIFIED.toString() : PCHelperConstant.REVISION_STATUS.ADDED.toString();
            logger.debug(lastRecordPresent + " ############### newStatus    " + newStatus + "....ew.." + fileElement.getEwsId());
            long fileSizeinBytes = fileElement.getSize();
            BaseController.printLogs("...fileinbytes...." + fileSizeinBytes, PCHelperConstant.isBrevityLogging());
            long filesizeInKB = fileSizeinBytes / 1024L;
            long latestVersionSize = filesizeInKB - prevVersionSize;
            if (lastRecordPresent) {
                if (isSync) {
                    this.handleVersioning(cloudId, cloudName, backUpImage.getUserName(), backUpImagesList, user, miniCloud);
                    this.updateUserSyncOverview(cloudId, user, filesizeInKB);
                } else {
                    storageUtilized = this.getStorageUtilizedAfterRevisionChange(cloudId, cloudName, backUpImage.getUserName(), filesizeInKB, backUpImagesList, userUnderLegalHold, device, isSync);
                }
            } else {
                storageUtilized = filesizeInKB;
                latestVersionSize = filesizeInKB;
                if (isSync) {
                    this.updateUserSyncOverview(cloudId, user, filesizeInKB);
                }
            }
            id = this.uploadExternalFile(cloudId, cloudName, fileElement, device, fileName, newStatus, user, miniCloud, isEncrypted);
            fileUploadDetailsElement.setFileSize(storageUtilized);
            fileUploadDetailsElement.setLatestVersionSize(latestVersionSize);
            BaseController.printLogs("!!!Insert to Backup    completed  " + newStatus + " ... id.... " + String.valueOf(id), PCHelperConstant.isBrevityLogging());
        }
        catch (ParacloudBackupException e) {
            logger.error("@ResourceFunnelException@", (Throwable)e);
            throw new ParacloudBackupException("Exception occured in uploadImpl" + String.valueOf((Object)e), e.getResponseCode());
        }
        catch (MongoException e) {
            logger.error("@Exception@", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("@Exception@", (Throwable)e);
            throw new ParacloudBackupException("Exception occured in uploadImpl" + String.valueOf(e), 500);
        }
        if (id != null) {
            fileUploadDetailsElement.setBkpId(id.toString());
        }
        return fileUploadDetailsElement;
    }

    private void setRateLimiter() {
        if (this.limiter == null) {
            this.limiter = RateLimiter.create((double)PCHelperConstant.getNumOfHitsToDBForContentChunkCheck());
            logger.debug("....Rate limiter value:" + this.limiter.getRate());
        }
    }

    private void updateUserSyncOverview(int cloudId, User user, long filesizeInKB) {
        if (user != null) {
            double syncUserStorage;
            UserSyncOverView userSyncOverView = user.getUserSyncOverView();
            if (userSyncOverView != null) {
                syncUserStorage = userSyncOverView.getStorageUtilized();
                syncUserStorage += (double)filesizeInKB;
            } else {
                userSyncOverView = new UserSyncOverView();
                syncUserStorage = filesizeInKB;
            }
            userSyncOverView.setStorageUtilized(syncUserStorage);
            this.userSyncOverViewDao.saveUserSyncOverViewToDB(cloudId, userSyncOverView);
        }
    }

    private void handleVersioning(int cloudId, String cloudName, String userName, List<BackUpImage> backUpImagesList, User user, MiniCloud miniCloud) {
        int currentNumberOfVersions = (int)backUpImagesList.stream().filter(backupImage -> !backupImage.getStatus().equalsIgnoreCase("DELETED") && !backupImage.getStatus().equalsIgnoreCase("RESTORED")).count();
        User userByName = this.userDao.getUserByName(cloudId, userName);
        int maxVersionsToKeep = 2;
        if (userByName != null && !StringUtils.isEmpty((String)userByName.getSyncPolicyName())) {
            SyncPolicy syncPolicy = this.userDao.getSyncPolicyByPolicyName(cloudId, userByName.getSyncPolicyName());
            maxVersionsToKeep = syncPolicy.getMaxVersions();
        }
        if (maxVersionsToKeep == -1) {
            logger.debug("Maxversions Unlimited...................");
        } else {
            List backUpImagesSorted = backUpImagesList.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).collect(Collectors.toList());
            for (BackUpImage backUpImage : backUpImagesSorted) {
                logger.debug("BackUpImage : " + String.valueOf(backUpImage.getId()) + " status : " + backUpImage.getStatus() + " current number of versions : " + currentNumberOfVersions);
                if (maxVersionsToKeep > currentNumberOfVersions && maxVersionsToKeep != 0) {
                    if (!backUpImage.getStatus().equalsIgnoreCase("DELETED") && !backUpImage.getStatus().equalsIgnoreCase("RESTORED")) break;
                    this.removeSyncBackUpImage(backUpImage, cloudId, cloudName, user, miniCloud);
                }
                if (backUpImage.isBusy()) {
                    logger.debug("BackUpImage is busy, will not delete : " + String.valueOf(backUpImage.getId()));
                    continue;
                }
                if (!backUpImage.getStatus().equalsIgnoreCase("DELETED") && !backUpImage.getStatus().equalsIgnoreCase("RESTORED")) {
                    UserSyncOverView userSyncOverView;
                    this.removeSyncBackUpImage(backUpImage, cloudId, cloudName, user, miniCloud);
                    --currentNumberOfVersions;
                    if (userByName == null || (userSyncOverView = userByName.getUserSyncOverView()) == null) continue;
                    double storageUtilized = userSyncOverView.getStorageUtilized();
                    userSyncOverView.setStorageUtilized(storageUtilized -= (double)backUpImage.getSize());
                    this.userSyncOverViewDao.saveUserSyncOverViewToDB(cloudId, userSyncOverView);
                    continue;
                }
                this.removeSyncBackUpImage(backUpImage, cloudId, cloudName, user, miniCloud);
            }
        }
    }

    private void removeSyncBackUpImage(BackUpImage backUpImage, int cloudId, String cloudName, User user, MiniCloud miniCloud) {
        this.syncBackUpImageDAO.deleteBackUpImageRevision(cloudId, backUpImage, user, miniCloud);
        if (!backUpImage.getStatus().equalsIgnoreCase("DELETED") && !backUpImage.getStatus().equalsIgnoreCase("RESTORED")) {
            List chunkFiles = backUpImage.getChunkFiles();
            for (ChunkFile chunkFile : chunkFiles) {
                String dedupVal = this.getDedupValue(backUpImage.getUserName(), true, null);
                ChunkDetail chunkDetail = null;
                this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(backUpImage.getUserName(), dedupVal, chunkFile.getMd5(), backUpImage.getLastServerModifiedTime(), chunkDetail, false);
                if (chunkDetail == null) {
                    logger.debug("................chunk detail is empty for userName " + backUpImage.getUserName() + " so search with userName case insesitive...........");
                    chunkDetail = this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(backUpImage.getUserName(), dedupVal, chunkFile.getMd5(), backUpImage.getLastServerModifiedTime(), chunkDetail, true);
                }
                if (chunkDetail == null) continue;
                try {
                    chunkDetail.setRefCount(chunkDetail.getRefCount() - 1);
                    this.externalStorageBackupFileDao.saveChunkDetail(cloudId, chunkDetail);
                    logger.debug("--- Chunk details updated successfully ---");
                }
                catch (OptimisticLockingFailureException e) {
                    int count = 0;
                    int maxRetries = PCHelperConstant.getMaxRetryForChunkUpdate();
                    while (true) {
                        try {
                            logger.debug("--- Retry chunk detail update --- " + chunkFile.getMd5() + " --- Retry count ---" + count);
                            ChunkDetail chunkDetailRetry = this.externalStorageBackupFileDao.getChunkDetailForMd5AndUserName(cloudId, chunkDetail.getMd5(), chunkDetail.getUserName());
                            chunkDetailRetry.setRefCount(chunkDetailRetry.getRefCount() - 1);
                            this.externalStorageBackupFileDao.saveChunkDetail(cloudId, chunkDetailRetry);
                        }
                        catch (Exception ex) {
                            logger.error("--- Exception during retry chunk details update --- " + ex.getMessage());
                            logger.trace("--- Exception stack trace --- ", (Throwable)ex);
                            if (++count != maxRetries) continue;
                        }
                        break;
                    }
                    logger.error("--- Exception while handling version for Image --- " + e.getMessage());
                    logger.trace("--- Exception stack trace --- ", (Throwable)e);
                }
            }
        }
    }

    private boolean isFileUnderMC(List<MiniCloud> allMiniClouds, String path) {
        boolean isFileUnderMC = false;
        for (MiniCloud mcElement : allMiniClouds) {
            String mcName = BackupServiceImpl.getMCName(path);
            logger.debug(" MC name ...... " + mcName);
            if (mcName == null || "".equals(mcName) || !mcName.equalsIgnoreCase(mcElement.getMiniCloudName())) continue;
            isFileUnderMC = true;
            break;
        }
        logger.debug(" file under mc ..... " + isFileUnderMC);
        return isFileUnderMC;
    }

    private static String getMCName(String path) {
        String[] list = path.split("/");
        if (list != null && list.length == 1) {
            return "";
        }
        return list[1];
    }

    private void convertToServerPath(BackupElement fileElement, Device device) {
        String ostype = device.getOsType();
        boolean type = ostype != null ? ostype.equals("Android") : true;
        String convertedPath = PathConversionHelper.getServerCompatiblePath((String)fileElement.getFileCompletePath(), (boolean)type);
        if (device.isLowercasePathConversionEnabled()) {
            convertedPath = PathConversionHelper.getLowercaseConvertedPath((String)convertedPath);
        }
        fileElement.setFileCompletePath(convertedPath);
    }

    private boolean checkIfRevisionHasBeenModified(BackupElement fileElement, BackUpImage backUpImage) {
        if (backUpImage.isFolder() && fileElement.isFolder()) {
            return true;
        }
        return backUpImage.getMd5Checksum().equals(fileElement.getMd5Checksum());
    }

    public long getStorageUtilizedAfterRevisionChange(int cloudId, String cloudName, String userName, Long fileSize, List<BackUpImage> backUpImages, String userUnderLegalHold, Device device, boolean isSync) {
        BackupPolicy backupPolicy;
        long storageUtilized = 0L;
        int currentNoOfVersions = 0;
        currentNoOfVersions = isSync ? (int)backUpImages.stream().filter(backupImage -> !backupImage.getStatus().equalsIgnoreCase("DELETED") && !backupImage.getStatus().equalsIgnoreCase("RESTORED")).count() : backUpImages.stream().filter(backupImage -> !backupImage.getStatus().equalsIgnoreCase("DELETED")).collect(Collectors.toList()).size();
        boolean isUserUnderLegalHold = false;
        logger.debug(" User under legal hold from agent .... " + userUnderLegalHold);
        int maxVersionsToKeep = 2;
        storageUtilized = fileSize;
        User userByName = this.userDao.getUserByName(cloudId, userName);
        boolean isOneDriveDevice = false;
        if (!isSync && userByName != null && !StringUtils.isEmpty((String)userByName.getPolicyName())) {
            backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, userByName.getPolicyName());
            isUserUnderLegalHold = backupPolicy.isLegalHoldEnabled();
            maxVersionsToKeep = backupPolicy.getMaxVersions();
        } else if (isSync && userByName != null && !StringUtils.isEmpty((String)userByName.getPolicyName())) {
            SyncPolicy syncPolicy = this.userDao.getSyncPolicyByPolicyName(cloudId, userByName.getSyncPolicyName());
            maxVersionsToKeep = syncPolicy.getMaxVersions();
        }
        if (!StringUtils.isEmpty((String)device.getOsType()) && Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(device.getOsType())) {
            isOneDriveDevice = true;
            backupPolicy = this.userDao.getOfficeBackupPolicyForPolicyName(cloudId, userByName.getOneDrivePolicyName(), OfficeBackupPolicy.TYPE.ODB.toString());
            isUserUnderLegalHold = backupPolicy.isLegalHoldEnabled();
            maxVersionsToKeep = backupPolicy.getMaxVersions();
            logger.debug("....officepolicy...." + maxVersionsToKeep);
        } else if (!StringUtils.isEmpty((String)device.getOsType()) && Device.TYPE.SHAREPOINT.toString().equalsIgnoreCase(device.getOsType())) {
            isOneDriveDevice = true;
            backupPolicy = this.userDao.getOfficeBackupPolicyForPolicyName(cloudId, userByName.getSpPolicyName(), OfficeBackupPolicy.TYPE.SHAREPOINT.toString());
            isUserUnderLegalHold = backupPolicy.isLegalHoldEnabled();
            maxVersionsToKeep = backupPolicy.getMaxVersions();
            logger.debug("....officepolicy...." + maxVersionsToKeep);
        }
        logger.debug(isOneDriveDevice + " Is User under legal hold .... " + isUserUnderLegalHold);
        if (isUserUnderLegalHold) {
            return storageUtilized;
        }
        logger.debug("maxVersionsToKeep..................." + maxVersionsToKeep + "current no of versions........" + currentNoOfVersions);
        if (maxVersionsToKeep == -1) {
            logger.debug("Maxversions Unlimited...................");
        } else {
            long deleteFileSize = 0L;
            List bkpImageList = backUpImages.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).collect(Collectors.toList());
            for (BackUpImage bkpImage : bkpImageList) {
                logger.debug("bkpImage " + String.valueOf(bkpImage.getId()) + " ...bkpImage...status..." + bkpImage.getStatus() + "...currentNoOfVersions.." + currentNoOfVersions);
                if (maxVersionsToKeep > currentNoOfVersions && maxVersionsToKeep != 0) break;
                if (bkpImage.isBusy()) {
                    logger.debug("bkp image is busy so don't delete:" + String.valueOf(bkpImage.getId()));
                    continue;
                }
                if (!(bkpImage = this.backUpImageDao.getBackupFileForID(cloudId, bkpImage.getId(), userName, device, false)).getStatus().equals("DELETED")) {
                    logger.debug("....inside dleted...." + bkpImage.getId().toString());
                    this.removeBackupImage(bkpImage, cloudId, cloudName, device, isSync);
                    --currentNoOfVersions;
                    deleteFileSize += bkpImage.getSize();
                    continue;
                }
                logger.debug("....inside dleted11...." + bkpImage.getId().toString());
                this.removeBackupImage(bkpImage, cloudId, cloudName, device, isSync);
            }
            storageUtilized = fileSize - deleteFileSize;
            logger.debug(fileSize + "..." + deleteFileSize + ".........versionupdated size.... " + storageUtilized);
        }
        return storageUtilized;
    }

    private ObjectId uploadExternalFile(int cloudId, String cloudName, BackupElement fileElement, Device device, String fileName, String newStatus, User user, MiniCloud miniCloud, boolean isEncrypted) throws IOException, NoSuchAlgorithmException {
        OutlookEmailAddress emailAddress;
        String intermediateUploadFolder = device.getDeviceTempPath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "backup";
        File intermediateFile = new File(intermediateUploadFolder + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        BackUpImage backUpImage = new BackUpImage();
        String fsPath = this.getFsPathForFile(fileElement.getMd5Checksum());
        BackupServiceImpl.convertToBackUpImage(fileElement, device.getDeviceUUID(), backUpImage, device, fileElement.isBaseBackup(), fsPath, newStatus);
        long fileSizeinBytes = fileElement.getSize();
        long filesizeInKB = fileSizeinBytes / 1024L;
        backUpImage.setFileEncrypted(isEncrypted);
        backUpImage.setSize(filesizeInKB);
        backUpImage.setSizeInBytes(fileSizeinBytes);
        backUpImage.setGatewayName(fileElement.getGatewayName());
        backUpImage.setSubject(fileElement.getSubject());
        backUpImage.setFrom(fileElement.getFrom());
        backUpImage.setBodyContent(fileElement.getBodyContent());
        backUpImage.setBccRecipients(fileElement.getBccRecipients());
        backUpImage.setCcRecipients(fileElement.getCcRecipients());
        backUpImage.setToRecipients(fileElement.getToRecipients());
        backUpImage.setHasAttachments(fileElement.isHasAttachments());
        if (fileElement.isCompressed()) {
            backUpImage.setCompressed(fileElement.isCompressed());
        }
        backUpImage.setCompressed(true);
        backUpImage.setTaskId(fileElement.getTaskId());
        backUpImage.setTaskListId(fileElement.getTaskListId());
        backUpImage.setTaskSubject(fileElement.getTaskSubject());
        backUpImage.setTaskStartDate(fileElement.getTaskStartDate());
        backUpImage.setTaskReminderTime(fileElement.getTaskReminderTime());
        backUpImage.setTaskDueDate(fileElement.getTaskDueDate());
        backUpImage.setContactMobile(fileElement.getContactMobile());
        backUpImage.setContactAddrStreet(fileElement.getContactAddrStreet());
        backUpImage.setContactAddrCity(fileElement.getContactAddrCity());
        backUpImage.setContactAddrState(fileElement.getContactAddrState());
        backUpImage.setContactAddrCountry(fileElement.getContactAddrCountry());
        backUpImage.setContactAddrPostalCode(fileElement.getContactAddrPostalCode());
        backUpImage.setContactBusiAddrStreet(fileElement.getContactBusiAddrStreet());
        backUpImage.setContactBusiAddrCity(fileElement.getContactBusiAddrCity());
        backUpImage.setContactBusiAddrState(fileElement.getContactBusiAddrState());
        backUpImage.setContactBusiAddrCountry(fileElement.getContactBusiAddrCountry());
        backUpImage.setContactBusiAddrPostalCode(fileElement.getContactBusiAddrPostalCode());
        backUpImage.setContactOfficeLocation(fileElement.getContactOfficeLocation());
        backUpImage.setContactCompanyName(fileElement.getContactCompanyName());
        backUpImage.setContactJobTitle(fileElement.getContactJobTitle());
        backUpImage.setContactDepartment(fileElement.getContactDepartment());
        backUpImage.setContactBirthday(fileElement.getContactBirthday());
        backUpImage.setContactHomePhones(fileElement.getContactHomePhones());
        backUpImage.setContactBusinessPhones(fileElement.getContactBusinessPhones());
        backUpImage.setContactWebSite(fileElement.getContactWebSite());
        backUpImage.setContactEmail(fileElement.getContactEmail());
        backUpImage.setTaskMyDayTask(fileElement.isTaskMyDayTask());
        backUpImage.setCalendarDuration(fileElement.getCalendarDuration());
        backUpImage.setCalendarStartDate(fileElement.getCalendarStartDate());
        backUpImage.setCalendarEndDate(fileElement.getCalendarEndDate());
        backUpImage.setContactTitle(fileElement.getContactTitle());
        backUpImage.setContactFirstName(fileElement.getContactFirstName());
        backUpImage.setContactMiddleName(fileElement.getContactMiddleName());
        backUpImage.setContactLastName(fileElement.getContactLastName());
        backUpImage.setContactSuffix(fileElement.getContactSuffix());
        backUpImage.setVersionId(fileElement.getVersionId());
        backUpImage.setTaskId(fileElement.getTaskId());
        backUpImage.setTaskListId(fileElement.getTaskListId());
        logger.debug("..taskkduedate..." + String.valueOf(fileElement.getTaskDueDate()));
        boolean isMail = false;
        if (device.getOsType().equalsIgnoreCase("OUTLOOK")) {
            isMail = true;
            backUpImage.setEwsId(fileElement.getEwsId());
        }
        backUpImage.setMail(isMail);
        ArrayList<MailAttachment> attachments = new ArrayList<MailAttachment>();
        if (!CollectionUtils.isEmpty((Collection)fileElement.getAttachments())) {
            for (Object elementattachment : fileElement.getAttachments()) {
                logger.debug("..mailattachment..." + String.valueOf(elementattachment));
                MailAttachment mailAttachment = new MailAttachment();
                BeanUtils.copyProperties((Object)elementattachment, (Object)mailAttachment);
                logger.debug("..mailattachment val... ..." + elementattachment.getName());
                attachments.add(mailAttachment);
            }
            backUpImage.setAttachments(attachments);
        }
        if (fileElement.getFromEmailAddress() != null) {
            OutlookEmailAddress outlookEmailAddress = new OutlookEmailAddress();
            BeanUtils.copyProperties((Object)fileElement.getFromEmailAddress(), (Object)outlookEmailAddress);
            backUpImage.setFromEmailAddress(outlookEmailAddress);
        }
        ArrayList<OutlookEmailAddress> addresses = new ArrayList<OutlookEmailAddress>();
        if (!CollectionUtils.isEmpty((Collection)fileElement.getToRecipientsAddress())) {
            for (OutlookEmailAddressElement address : fileElement.getToRecipientsAddress()) {
                emailAddress = new OutlookEmailAddress();
                BeanUtils.copyProperties((Object)address, (Object)emailAddress);
                addresses.add(emailAddress);
            }
            backUpImage.setToRecipientsAddress(addresses);
        }
        if (!CollectionUtils.isEmpty((Collection)fileElement.getCcRecipientsAddress())) {
            addresses = new ArrayList();
            for (OutlookEmailAddressElement address : fileElement.getCcRecipientsAddress()) {
                emailAddress = new OutlookEmailAddress();
                BeanUtils.copyProperties((Object)address, (Object)emailAddress);
                addresses.add(emailAddress);
            }
            backUpImage.setCcRecipientsAddress(addresses);
        }
        if (!CollectionUtils.isEmpty((Collection)fileElement.getBccRecipientsAddress())) {
            addresses = new ArrayList();
            for (OutlookEmailAddressElement address : fileElement.getBccRecipientsAddress()) {
                emailAddress = new OutlookEmailAddress();
                BeanUtils.copyProperties((Object)address, (Object)emailAddress);
                addresses.add(emailAddress);
            }
            backUpImage.setBccRecipientsAddress(addresses);
        }
        if (fileElement.getSentDate() != null) {
            Date sentDate = null;
            try {
                SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                sentDate = f.parse(fileElement.getSentDate());
                backUpImage.setSentDate(sentDate);
            }
            catch (ParseException e) {
                logger.error("....invalid sentdate...." + fileElement.getSentDate());
                try {
                    long milliseconds = Long.parseLong(fileElement.getSentDate());
                    sentDate = new Date(milliseconds);
                    backUpImage.setSentDate(sentDate);
                    backUpImage.setTaskStartDate(sentDate);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            if (!(sentDate == null && StringUtils.isEmpty((String)fileElement.getSubject()) && StringUtils.isEmpty((String)fileElement.getBodyContent()) || sentDate == null)) {
                backUpImage.setLastServerModifiedTime(sentDate.getTime());
            }
        }
        backUpImage.setLastServerModifiedTime(System.currentTimeMillis());
        return this.createRevisionForExternalBackupFile(cloudId, cloudName, intermediateFile, backUpImage, filesizeInKB, device, user, miniCloud, fileElement.getIsSync());
    }

    private String getFsPathForFile(String md5) {
        return PathGenerator.getFsPath((String)md5);
    }

    public static void convertToBackUpImage(BackupElement fileElement, String regID, BackUpImage backUpImage, Device device, boolean isBaseBackupFolder, String fsPath, String status) {
        long timeMilliSec = System.currentTimeMillis();
        backUpImage.setDevicePath(fileElement.getFileCompletePath());
        backUpImage.setFileName(fileElement.getFileName());
        backUpImage.setDeviceUUID(device.getDeviceUUID());
        backUpImage.setLastServerModifiedTime(timeMilliSec);
        backUpImage.setFolder(fileElement.isFolder());
        backUpImage.setMd5Checksum(fileElement.getMd5Checksum());
        backUpImage.setPresent(fileElement.isPresent());
        backUpImage.setfSPath(fsPath);
        backUpImage.setStatus(status);
        backUpImage.setLastClientModifiedTime(fileElement.getLastClientModifiedTime());
        backUpImage.setBaseBackup(isBaseBackupFolder);
        backUpImage.setSize(fileElement.getSize());
        backUpImage.setOdItemId(fileElement.getOdItemId());
        backUpImage.setEwsId(fileElement.getEwsId());
        backUpImage.setOdParentItemId(fileElement.getParentItemId());
        backUpImage.setUserName(device.getUserName());
        if (fileElement.getAccessTime() != 0L) {
            backUpImage.setAccessTime(fileElement.getAccessTime());
        }
        if (fileElement.getCreationTime() != 0L) {
            backUpImage.setCreationTime(fileElement.getCreationTime());
        }
        if (!StringUtils.isEmpty((String)fileElement.getContainerName())) {
            backUpImage.setContainerName(fileElement.getContainerName());
        }
        if (!StringUtils.isEmpty((String)fileElement.getContainerType())) {
            backUpImage.setContainerType(fileElement.getContainerType());
        }
        backUpImage.setSync(fileElement.getIsSync());
        backUpImage.setCrawlStartTimestamp(timeMilliSec);
    }

    public ObjectId createRevisionForExternalBackupFile(int cloudId, String cloudName, File intermediateUploadPath, BackUpImage backUpImage, long fileSize, Device device, User user, MiniCloud miniCloud, boolean isSync) throws IOException {
        return this.createParentsAndSaveEntryForExternalBackup(cloudId, cloudName, backUpImage, device, user, miniCloud, isSync);
    }

    public ObjectId createParentsAndSaveEntryForExternalBackup(int cloudId, String cloudName, BackUpImage backUpImage, Device device, User user, MiniCloud miniCloud, boolean isSync) {
        if (isSync && backUpImage.getDevicePath().equalsIgnoreCase("ParaBlu")) {
            logger.debug("Base path : ParaBlu, not adding to image list");
        } else {
            List<BackupElement> fileElementList;
            BackUpImage parentBackUpImage = this.getParentFile(cloudId, cloudName, backUpImage, device, user, miniCloud, isSync);
            BaseController.printLogs(backUpImage.getEwsId() + "... parent file path ews.... " + backUpImage.getDevicePath(), PCHelperConstant.isBrevityLogging());
            if (!(parentBackUpImage != null && parentBackUpImage.isPresent() || (fileElementList = this.getParentFolders(cloudId, cloudName, backUpImage.getDevicePath(), device, backUpImage.getContainerName(), backUpImage.getContainerType(), user, miniCloud, isSync)) == null || fileElementList.isEmpty())) {
                this.createParentFolders(cloudId, cloudName, fileElementList, device, backUpImage.getOdParentItemId(), user, miniCloud, isSync);
            }
        }
        if (!StringUtils.isEmpty((String)backUpImage.getContainerName())) {
            this.setContainerDetailsForBackupImage(backUpImage);
        }
        backUpImage.setExternalStorage(true);
        if (isSync) {
            this.syncBackUpImageDAO.saveToBackUpImageDB(cloudId, backUpImage, user, miniCloud);
        } else {
            this.backUpImageDao.saveImageToBackUp(cloudId, backUpImage, device);
        }
        BaseController.printLogs("...ewwsssiiiddd...." + backUpImage.getEwsId() + "....id... " + String.valueOf(backUpImage.getId()), PCHelperConstant.isBrevityLogging());
        return backUpImage.getId();
    }

    public void createParentFolders(int cloudId, String cloudName, List<BackupElement> fileElementList, Device device, String parentItemId, User user, MiniCloud miniCloud, boolean isSync) {
        for (BackupElement fileElement : fileElementList) {
            BackUpImage oldBckupImage;
            if (fileElement.getFileCompletePath() == null) {
                oldBckupImage = isSync ? this.syncBackUpImageDAO.getSyncBackUpImageWithNullPath(cloudId, cloudName, fileElement.getFileName(), user, miniCloud) : this.backUpImageDao.getBackUpImageForFileWithNullPath(cloudId, cloudName, fileElement.getFileName(), device);
            } else {
                boolean readPreference = false;
                if (PCHelperConstant.isReadPreferenceFromSecondary()) {
                    logger.debug(" Readpreference to Secondary createParentFolders .......");
                    readPreference = true;
                }
                oldBckupImage = isSync ? this.syncBackUpImageDAO.getSyncBackUpImageForFile(cloudId, cloudName, fileElement.getFileName(), fileElement.getFileCompletePath(), readPreference, user, miniCloud) : this.backUpImageDao.getBackUpImageForFile(cloudId, cloudName, fileElement.getFileName(), fileElement.getFileCompletePath(), device, readPreference);
            }
            if (oldBckupImage != null && oldBckupImage.isPresent()) continue;
            BackUpImage backUpImage = new BackUpImage();
            BackupServiceImpl.convertToBackUpImage(fileElement, device.getDeviceUUID(), backUpImage, device, false, PathGenerator.getFsPath((String)fileElement.getMd5Checksum()), PCHelperConstant.REVISION_STATUS.ADDED.toString());
            if (Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(device.getDeviceType()) || Device.TYPE.SHAREPOINT.toString().equalsIgnoreCase(device.getDeviceType())) {
                logger.debug("...ourlogic...." + backUpImage.getFileName());
                if (!"Files".equalsIgnoreCase(backUpImage.getFileName())) {
                    String path = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
                    logger.debug("....before getting  path itemidfor folder ..... ");
                    String folderItemId = this.msUtilDao.getFolderItemId(path, device.getDeviceUUID());
                    logger.debug("....after path itemidfor folder ..... " + path + "...... " + folderItemId);
                    if (!StringUtils.isEmpty((String)folderItemId)) {
                        backUpImage.setOdItemId(folderItemId);
                    } else {
                        backUpImage.setOdItemId(parentItemId);
                    }
                } else {
                    backUpImage.setOdItemId("");
                }
            }
            if (isSync) {
                this.syncBackUpImageDAO.saveToBackUpImageDB(cloudId, backUpImage, user, miniCloud);
                continue;
            }
            this.backUpImageDao.saveImageToBackUpDao(cloudId, cloudName, backUpImage, device);
        }
    }

    private BackUpImage getParentFile(int cloudId, String cloudName, BackUpImage childBackUpImage, Device device, User user, MiniCloud miniCloud, boolean isSync) {
        String fileName;
        String parentFilePath = childBackUpImage.getDevicePath();
        if (parentFilePath == null) {
            return null;
        }
        int lastIndex = parentFilePath.lastIndexOf(47);
        if (lastIndex == -1 && "".equals(parentFilePath)) {
            return null;
        }
        if (parentFilePath.endsWith("/")) {
            parentFilePath = parentFilePath.substring(0, lastIndex);
            lastIndex = parentFilePath.lastIndexOf(47);
            fileName = parentFilePath.substring(lastIndex + 1);
        } else {
            fileName = parentFilePath.substring(lastIndex + 1);
        }
        String filePath = null;
        if (lastIndex != -1) {
            filePath = parentFilePath.substring(0, parentFilePath.length() - fileName.length() - 1);
        }
        return this.getBackUpImage(cloudId, cloudName, fileName, filePath, device, user, miniCloud, isSync);
    }

    public BackUpImage getBackUpImage(int cloudId, String cloudName, String fileName, String folderPath, Device device, User user, MiniCloud miniCloud, boolean isSync) {
        boolean readPreference = false;
        if (PCHelperConstant.isReadPreferenceFromSecondary()) {
            logger.debug(" Readpreference to Secondary getBackUpImage .......");
            readPreference = true;
        }
        if (isSync) {
            return this.syncBackUpImageDAO.getSyncBackUpImageForFile(cloudId, cloudName, fileName, folderPath, readPreference, user, miniCloud);
        }
        return this.backUpImageDao.getBackUpImageForFile(cloudId, cloudName, fileName, folderPath, device, readPreference);
    }

    private List<BackupElement> getParentFolders(int cloudId, String cloudName, String parentFilePath, Device device, String containerName, String containerType, User user, MiniCloud miniCloud, boolean isSync) {
        BackUpImage backUpImage;
        String fileName;
        String parentFilePathTemp = parentFilePath;
        ArrayList<BackupElement> elements = new ArrayList<BackupElement>();
        BackupElement fileElement = new BackupElement();
        if (parentFilePathTemp == null) {
            return null;
        }
        int lastIndex = parentFilePathTemp.lastIndexOf(47);
        if (lastIndex == -1 && "".equals(parentFilePathTemp)) {
            return null;
        }
        if (parentFilePathTemp.endsWith("/")) {
            parentFilePathTemp = parentFilePathTemp.substring(0, lastIndex);
            lastIndex = parentFilePathTemp.lastIndexOf(47);
            fileName = parentFilePathTemp;
        } else {
            fileName = parentFilePathTemp.substring(lastIndex + 1);
        }
        if (isSync && parentFilePathTemp.equalsIgnoreCase("ParaBlu")) {
            return null;
        }
        String filePath = null;
        if (lastIndex != -1) {
            filePath = parentFilePathTemp.substring(0, parentFilePathTemp.length() - fileName.length() - 1);
        }
        if ((backUpImage = this.getBackUpImage(cloudId, cloudName, fileName, filePath, device, user, miniCloud, isSync)) != null && backUpImage.isPresent()) {
            return null;
        }
        fileElement.setFileName(fileName);
        fileElement.setFolder(true);
        if (filePath != null && filePath.isEmpty()) {
            filePath = "ROOT";
        }
        fileElement.setFileCompletePath(filePath);
        fileElement.setMd5Checksum("null");
        fileElement.setPresent(true);
        fileElement.setSize(0L);
        fileElement.setIsSync(isSync);
        if (containerName != null && fileElement.getFileCompletePath() != null) {
            if (!fileElement.getFileCompletePath().endsWith(containerName)) {
                fileElement.setContainerName(null);
            } else {
                fileElement.setContainerName(containerName);
            }
        }
        elements.add(fileElement);
        List<BackupElement> elements2 = this.getParentFolders(cloudId, cloudName, fileElement.getFileCompletePath(), device, containerName, containerType, user, miniCloud, isSync);
        if (elements2 != null) {
            elements.addAll(elements2);
        }
        return elements;
    }

    private void removeBackupImage(BackUpImage toDeleteBackupImage, int cloudId, String cloudName, Device device, boolean isSync) {
        this.backUpImageDao.deleteRevision(cloudId, cloudName, toDeleteBackupImage, device);
        List chunkFiles = toDeleteBackupImage.getChunkFiles();
        String userName = toDeleteBackupImage.getUserName();
        String dedupVal = this.getDedupValue(userName, isSync, device);
        if (!CollectionUtils.isEmpty((Collection)toDeleteBackupImage.getChunkFiles())) {
            logger.debug(".....deleted chunk list..." + toDeleteBackupImage.getChunkFiles().size());
        } else {
            logger.debug(".....empty.....");
        }
        block4: for (ChunkFile chunkFile : chunkFiles) {
            logger.debug("....dedupval and chunk..." + dedupVal);
            ChunkDetail chunkDetail = null;
            chunkDetail = this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(toDeleteBackupImage.getUserName(), dedupVal, chunkFile.getMd5(), toDeleteBackupImage.getLastServerModifiedTime(), chunkDetail, false);
            if (chunkDetail == null) {
                logger.debug("................chunk detail is empty for userName " + toDeleteBackupImage.getUserName() + " so search with userName case insesitive...........");
                chunkDetail = this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(toDeleteBackupImage.getUserName(), dedupVal, chunkFile.getMd5(), toDeleteBackupImage.getLastServerModifiedTime(), chunkDetail, true);
            }
            if (chunkDetail == null) continue;
            try {
                chunkDetail.setRefCount(chunkDetail.getRefCount() - 1);
                this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetail);
                logger.debug(" Chunk updated succcessfully for delete ..........");
            }
            catch (OptimisticLockingFailureException e) {
                logger.trace(String.valueOf((Object)e));
                logger.error("Exception while removing backup image :" + e.getMessage());
                int count = 0;
                int maxTries = PCHelperConstant.getMaxRetryForChunkUpdate();
                while (true) {
                    try {
                        logger.debug(" retry chunk update ..............." + chunkFile.getMd5());
                        ChunkDetail chunkDetailObj = null;
                        chunkDetailObj = this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(toDeleteBackupImage.getUserName(), dedupVal, chunkFile.getMd5(), toDeleteBackupImage.getLastServerModifiedTime(), chunkDetailObj, false);
                        if (chunkDetailObj == null) {
                            logger.debug("................chunk detail is empty for userName " + toDeleteBackupImage.getUserName() + " so search with userName case insesitive...........");
                            chunkDetailObj = this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(toDeleteBackupImage.getUserName(), dedupVal, chunkFile.getMd5(), toDeleteBackupImage.getLastServerModifiedTime(), chunkDetailObj, true);
                        }
                        chunkDetailObj.setRefCount(chunkDetailObj.getRefCount() - 1);
                        logger.debug(chunkFile.getMd5() + " @@@@@@ ................ retry count " + count);
                        this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetailObj);
                        continue block4;
                    }
                    catch (Exception ex) {
                        logger.trace(String.valueOf(ex));
                        logger.error(" ex ..." + ex.getMessage());
                        if (++count != maxTries) continue;
                    }
                    break;
                }
            }
        }
    }

    @Override
    public List<BackupElement> getChildrenForAgent(int cloudId, String cloudName, String folderPath, Device device, boolean isExternalStorage, String serverModifiedTime, boolean restoreDeletedFiles) {
        List backUpImages;
        ArrayList<BackupElement> backupElements = new ArrayList<BackupElement>();
        if (folderPath == null || "".equals(folderPath)) {
            logger.debug("..inside device...");
            backUpImages = !StringUtils.isEmpty((String)serverModifiedTime) ? this.backUpImageDao.getBaseChildrenByDeviceandTimeStamp(cloudId, cloudName, device, serverModifiedTime) : this.backUpImageDao.getBaseChildrenByDevice(cloudId, cloudName, device, true);
        } else {
            logger.debug("..inside folderpath..." + serverModifiedTime);
            backUpImages = !StringUtils.isEmpty((String)serverModifiedTime) ? this.backUpImageDao.getRestBackupFilesForGivenPathfromBackupImage(cloudId, cloudName, folderPath, device, isExternalStorage, serverModifiedTime, restoreDeletedFiles) : this.backUpImageDao.getChildrenByFolderForAgent(cloudId, cloudName, folderPath, device, isExternalStorage, restoreDeletedFiles);
        }
        if (backUpImages == null || backUpImages.isEmpty()) {
            logger.debug("NO FILES FOR PATH ...." + folderPath + " device UUID " + device.getDeviceUUID());
            return null;
        }
        logger.debug("backup images from DB: " + backUpImages.size());
        for (BackUpImage b : backUpImages) {
            if (b == null || !b.isFolder() && StringUtils.isEmpty((String)b.getGatewayName()) && StringUtils.isEmpty((String)b.getStoragePlace())) {
                logger.debug("old files in pg cannot restore............");
            }
            if (b == null || !b.isFolder() && StringUtils.isEmpty((String)b.getGatewayName()) && StringUtils.isEmpty((String)b.getStoragePlace())) continue;
            BackupElement backupElement = new BackupElement();
            BeanUtils.copyProperties((Object)b, (Object)backupElement);
            if (!b.isFolder() && b.getSize() == 0L && b.getSizeInBytes() > 0L) {
                long filesizeInKB = (long)Math.ceil(b.getSizeInBytes() / 1024L);
                if (filesizeInKB <= 0L) {
                    filesizeInKB = 1L;
                }
                backupElement.setSize(filesizeInKB);
            }
            backupElement.setFileCompletePath(b.getDevicePath());
            String mailExt = "";
            if (!b.isFolder() && !StringUtils.isEmpty((String)b.getSubject())) {
                mailExt = ".eml";
            }
            backupElement.setFileName(b.getFileName() + mailExt);
            backupElement.setFileUserOwner(b.getUserName());
            backupElement.setBackupId(b.getId().toString());
            backupElement.setGatewayName(b.getGatewayName());
            backupElements.add(backupElement);
        }
        return backupElements;
    }

    private void setContainerDetailsForBackupImage(BackUpImage backUpImage) {
        Path p = Paths.get(backUpImage.getDevicePath(), new String[0]);
        String parentFile = p.getFileName().toString();
        if (!parentFile.equalsIgnoreCase(backUpImage.getContainerName())) {
            backUpImage.setContainerName(null);
            backUpImage.setContainerType(null);
        }
    }

    private boolean checkIfOfficeProduct(Device device) {
        boolean officeProduct = false;
        if (device != null && (device.getOsType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name()) || device.getOsType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name()) || device.getOsType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.name()))) {
            officeProduct = true;
        }
        return officeProduct;
    }

    private String getDedupValue(String userName, boolean isSync, Device device) {
        String dedupVal = null;
        User userByName = this.userDao.getUserByName(1, userName);
        if (device != null && this.checkIfOfficeProduct(device)) {
            String policyName = "";
            String policyType = "";
            if (device != null) {
                if (device.getOsType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
                    policyName = userByName.getExchangePolicyName();
                    policyType = "Exchange";
                } else if (device.getOsType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
                    policyName = userByName.getOneDrivePolicyName();
                    policyType = "ODB";
                } else if (device.getOsType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
                    policyName = userByName.getSpPolicyName();
                    policyType = "Sharepoint";
                }
                OfficeBackupPolicy officeBackupPolicy = this.userDao.getOfficeBackupPolicyForPolicyName(1, policyName, policyType);
                if (officeBackupPolicy != null) {
                    dedupVal = officeBackupPolicy.getDedup();
                }
            }
        } else if (!isSync && userByName != null && !StringUtils.isEmpty((String)userByName.getPolicyName())) {
            BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(1, userByName.getPolicyName());
            dedupVal = backupPolicy.getDedup();
        } else if (isSync && userByName != null && !StringUtils.isEmpty((String)userByName.getSyncPolicyName())) {
            SyncPolicy syncPolicy = this.userDao.getSyncPolicyByPolicyName(1, userByName.getSyncPolicyName());
            dedupVal = syncPolicy.getDedup();
        }
        return dedupVal;
    }

    @Override
    public boolean runRwDetectionScript(File inputFile) {
        try {
            String s;
            String[] cmd = new String[]{"python3", "/parablu/RWdetection/source_oct/run_model.py", "/parablu/RWdetection/source_oct/newmodel.model", inputFile.getPath()};
            logger.debug("  inputFile path" + inputFile.getPath());
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(cmd);
            StringBuilder data = new StringBuilder();
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((s = in.readLine()) != null) {
                System.out.println(s);
                logger.debug(s + "  output...");
                if (!s.contains("result::")) continue;
                data.append(s).append(NEWLINE);
                List<String> results = Arrays.asList((s = s.replace("result::", "")).split("::"));
                if (results.size() <= 1) continue;
                return results.get(1).equalsIgnoreCase("encrypted");
            }
            logger.debug(String.valueOf(data) + " ...........");
        }
        catch (IOException e) {
            logger.error("error to run python file ......" + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return false;
    }

    @Override
    public void updateLInkGen(String backupId, String destCollection, boolean linkGenerated) {
        this.backUpImageDao.updateLInkGen(backupId, destCollection, linkGenerated);
    }

    private BackUpImage convertToBkpImage(String deviceUUID, BackUpImage backUpImageold) {
        BackUpImage backUpImageDeleted = new BackUpImage();
        BeanUtils.copyProperties((Object)backUpImageold, (Object)backUpImageDeleted);
        backUpImageDeleted.setId(null);
        long timeMilliSec = System.currentTimeMillis();
        backUpImageDeleted.setDevicePath(backUpImageold.getDevicePath());
        backUpImageDeleted.setFileName(backUpImageold.getFileName());
        backUpImageDeleted.setDeviceUUID(deviceUUID);
        backUpImageDeleted.setLastServerModifiedTime(timeMilliSec);
        backUpImageDeleted.setFolder(backUpImageold.isFolder());
        backUpImageDeleted.setMd5Checksum(backUpImageold.getMd5Checksum());
        backUpImageDeleted.setPresent(false);
        backUpImageDeleted.setfSPath(backUpImageold.getfSPath());
        backUpImageDeleted.setUserName(backUpImageold.getUserName());
        backUpImageDeleted.setStatus(PCHelperConstant.REVISION_STATUS.DELETED.toString());
        backUpImageDeleted.setLastClientModifiedTime(backUpImageold.getLastClientModifiedTime());
        backUpImageDeleted.setBaseBackup(false);
        backUpImageDeleted.setSize(backUpImageold.getSize());
        backUpImageDeleted.setOdItemId(backUpImageold.getOdItemId());
        backUpImageDeleted.setGatewayName(backUpImageold.getGatewayName());
        backUpImageDeleted.setSubject(backUpImageold.getSubject());
        backUpImageDeleted.setFrom(backUpImageold.getFrom());
        backUpImageDeleted.setBodyContent(backUpImageold.getBodyContent());
        backUpImageDeleted.setBccRecipients(backUpImageold.getBccRecipients());
        backUpImageDeleted.setCcRecipients(backUpImageold.getCcRecipients());
        backUpImageDeleted.setToRecipients(backUpImageold.getToRecipients());
        backUpImageDeleted.setHasAttachments(backUpImageold.isHasAttachments());
        backUpImageDeleted.setTaskSubject(backUpImageold.getTaskSubject());
        backUpImageDeleted.setTaskStartDate(backUpImageold.getTaskStartDate());
        backUpImageDeleted.setTaskReminderTime(backUpImageold.getTaskReminderTime());
        backUpImageDeleted.setTaskDueDate(backUpImageold.getTaskDueDate());
        backUpImageDeleted.setContactMobile(backUpImageold.getContactMobile());
        backUpImageDeleted.setContactAddrStreet(backUpImageold.getContactAddrStreet());
        backUpImageDeleted.setContactAddrCity(backUpImageold.getContactAddrCity());
        backUpImageDeleted.setContactAddrState(backUpImageold.getContactAddrState());
        backUpImageDeleted.setContactAddrCountry(backUpImageold.getContactAddrCountry());
        backUpImageDeleted.setContactAddrPostalCode(backUpImageold.getContactAddrPostalCode());
        backUpImageDeleted.setChunkFiles(backUpImageold.getChunkFiles());
        boolean isMail = false;
        if (backUpImageold.isMail()) {
            isMail = true;
            backUpImageDeleted.setEwsId(backUpImageold.getEwsId());
        }
        backUpImageDeleted.setMail(isMail);
        return backUpImageDeleted;
    }
}

