/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.aad.adal4j.AuthenticationCallback;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.DateOnly;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.httpcore.HttpClients;
import com.microsoft.graph.models.Attachment;
import com.microsoft.graph.models.AttachmentBase;
import com.microsoft.graph.models.Attendee;
import com.microsoft.graph.models.AttendeeType;
import com.microsoft.graph.models.Contact;
import com.microsoft.graph.models.ConvertIdResult;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.EmailAddress;
import com.microsoft.graph.models.Event;
import com.microsoft.graph.models.ExchangeIdFormat;
import com.microsoft.graph.models.FileAttachment;
import com.microsoft.graph.models.Message;
import com.microsoft.graph.models.PatternedRecurrence;
import com.microsoft.graph.models.ProfilePhoto;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.models.RecurrenceRange;
import com.microsoft.graph.models.TaskFileAttachment;
import com.microsoft.graph.models.TodoTask;
import com.microsoft.graph.models.TodoTaskList;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.UserTranslateExchangeIdsParameterSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.AttachmentBaseCollectionPage;
import com.microsoft.graph.requests.AttachmentBaseCollectionRequest;
import com.microsoft.graph.requests.AttachmentCollectionPage;
import com.microsoft.graph.requests.AttachmentCollectionRequest;
import com.microsoft.graph.requests.DriveItemContentStreamRequestBuilder;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.requests.UserTranslateExchangeIdsCollectionPage;
import com.microsoft.graph.requests.UserTranslateExchangeIdsCollectionRequest;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.parablu.cloudbackup.CloudBackupStorageBridge;
import com.parablu.cloudbackup.OfficeRestoreService;
import com.parablu.cloudbackup.StorageService;
import com.parablu.cloudbackup.UploadStatus;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.CMBackUpImage;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.FailedFileReason;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.MailAttachment;
import com.parablu.pcbd.domain.MailBackupBatch;
import com.parablu.pcbd.domain.O365BlackListUser;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.OutlookEmailAddress;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.SearchIndex;
import com.parablu.serializer.DateOnlyDeserializer;
import com.parablu.serializer.PatternedRecurrenceDeserializer;
import com.parablu.serializer.RecurrenceRangeDeserializer;
import com.pg.controller.BaseController;
import com.pg.controller.Graph;
import com.pg.dao.BackupFileDao;
import com.pg.domain.DriveFileInfo;
import com.pg.domain.FileInfo;
import com.pg.element.BackupElement;
import com.pg.element.BluKryptElement;
import com.pg.element.ChunkFileElement;
import com.pg.element.FileUploadDetailsElement;
import com.pg.element.MailAttachmentElement;
import com.pg.element.OutlookEmailAddressElement;
import com.pg.element.RestorePoint;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.helper.utils.MemoryStore;
import com.pg.odb.util.RetryPolicyFactory;
import com.pg.service.BackupService;
import com.pg.service.ChunkableUploadService;
import com.pg.service.ComponentSettingService;
import com.pg.service.DownloadService;
import com.pg.service.JobConfigService;
import com.pg.service.RetryService;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncDownloadService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ConnectingIdType;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.BasePropertySet;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.core.service.schema.ItemSchema;
import microsoft.exchange.webservices.data.misc.ImpersonatedUserId;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.property.complex.AttachmentCollection;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.apache.james.mime4j.message.MessageImpl;
import org.apache.james.mime4j.message.MultipartImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.jvnet.hk2.annotations.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Service
public class CloudBackupController
extends BaseController
implements DisposableBean,
ApplicationContextAware,
Runnable,
CloudBackupStorageBridge {
    private static final Logger logger = LogManager.getLogger(CloudBackupController.class);
    private static final String AUTHORITY = "https://login.microsoftonline.com/";
    private static final String EWS_URL = "https://outlook.office365.com/EWS/Exchange.asmx";
    private static final String RESOURCE = "https://outlook.office365.com";
    @Autowired
    private UploadService uploadService;
    @Autowired
    private ChunkableUploadService chunkableUploadService;
    @Autowired
    private BackupService backupService;
    @Autowired
    private ComponentSettingService componentSettingService;
    @Autowired
    private JobConfigService jobConfigService;
    @Autowired
    private RetryPolicyFactory retryPolicyFactory;
    @Autowired
    private RetryService<?> retryService;
    public static final String FILE_NOT_EXISTS = "File Not exists";
    @Autowired
    private SyncDownloadService syncDownloadService;
    @Autowired
    private DownloadService downloadService;
    @Autowired
    BackupFileDao backupFileDao;
    @Autowired
    ExternalStorageBackupFileDao externalStorageBackupFileDao;
    @Autowired
    private UtilService utilService;
    static Thread thisThread;
    private static final Semaphore sem;
    private static ApplicationContext applicationContext;
    private static final String USER_STORAGE_LIMIT_REACHED = " User Storage limit reached ..... ";
    private static final String DIRECT_CALL_STORAGE_LIMIT = " direct call .... storage limit .......";
    private static final String UPLOAD_COUNT = "uploadCount";
    private static final String JOB_ID = "JobId";
    private static final String CHUNK = "chunk";
    private static final String ALREADY_EXISTS = "ALREADY_EXISTS";
    private static final String ALREADY_EXISTS_LINK = "ALREADY_EXISTS_LINK";
    private static final String LARGE_MONGO_ENTRY = "LARGE_MONGO_ENTRY";
    private static final String BATCH_ID_LOG = "##batch id >>>>";
    private static final long DAY_IN_MS = 86400000L;

    public RetryService<?> getRetryService() {
        return this.retryService;
    }

    public void setRetryService(RetryService<?> retryService) {
        this.retryService = retryService;
    }

    public RetryPolicyFactory getRetryPolicyFactory() {
        return this.retryPolicyFactory;
    }

    public void setRetryPolicyFactory(RetryPolicyFactory retryPolicyFactory) {
        this.retryPolicyFactory = retryPolicyFactory;
    }

    public void setComponentSettingService(ComponentSettingService componentSettingService) {
        this.componentSettingService = componentSettingService;
    }

    public void setJobConfigService(JobConfigService jobConfigService) {
        this.jobConfigService = jobConfigService;
    }

    public void setSyncDownloadService(SyncDownloadService syncDownloadService) {
        this.syncDownloadService = syncDownloadService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        logger.debug("---- Application context is set! ---- ");
        CloudBackupController.applicationContext = applicationContext;
        sem.release();
    }

    public static ApplicationContext getContext() {
        return applicationContext;
    }

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    public void setChunkableUploadService(ChunkableUploadService chunkableUploadService) {
        this.chunkableUploadService = chunkableUploadService;
    }

    public void setBackupService(BackupService backupService) {
        this.backupService = backupService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    CloudBackupController() {
        logger.debug("----------------~~~~~~ CloudBackupBridge ~~~~~~----------------");
        this.runOnce();
    }

    void runOnce() {
        logger.info("Triggered run Once");
        if (thisThread == null) {
            logger.info("Launching thread!");
            thisThread = new Thread(this);
            logger.info("@@@@@@@@@@@@@ ----- @@@@@@@@@@@");
            thisThread.start();
        }
    }

    public void destroy() {
        try {
            StorageService.GETINST.shutdown();
            OfficeRestoreService.GETINST.shutdown();
            try {
                logger.debug("going to sleep no work found");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("Sleep interrupted", (Throwable)e);
            }
            thisThread.join();
        }
        catch (InterruptedException e) {
            logger.error("Exception while destroying", (Throwable)e);
        }
        logger.info("----------------~~~~~~ CloudBackupBridge ~~~~~~----------------");
    }

    private static ChunkFileElement createChunkFileElement(String deviceUUID, BluKryptElement bluKryptElement, String chunkFilechecksum, String chunkFileName, String checkSum, List<String> list) {
        ChunkFileElement chunkFileElement = new ChunkFileElement();
        if (CollectionUtils.isEmpty(list)) {
            logger.info("List is empty sooo adding md5checksum" + checkSum);
            list.add(checkSum);
        }
        chunkFileElement.setFileChunks(list);
        chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
        logger.info("createChunkFileElemet " + bluKryptElement.getFileCompletePath());
        chunkFileElement.setFileName(checkSum);
        chunkFileElement.setMd5checksum(checkSum);
        chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
        if (!org.springframework.util.StringUtils.isEmpty((Object)chunkFilechecksum)) {
            chunkFileElement.setMd5checksum(chunkFilechecksum);
            chunkFileElement.setFileChunks(list);
            logger.info("Create chunk file element " + chunkFileName);
            chunkFileElement.setFileCompletePath(chunkFileName);
            chunkFileElement.setFileName(chunkFileName);
            chunkFileElement.setDeviceUUID(deviceUUID);
        }
        return chunkFileElement;
    }

    private static boolean checkMachineStorage(String fileSizeInString) {
        File file = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint());
        long incomingFileSize = Long.parseLong(fileSizeInString);
        long availableSpaceInServer = file.getFreeSpace();
        logger.info("Total space for this machine.." + file.getTotalSpace() + "FREE_SIZE" + file.getFreeSpace() + "incoming File Size:" + incomingFileSize);
        if (availableSpaceInServer - incomingFileSize <= 0L) {
            logger.info("Space in server is exceeded........");
            return true;
        }
        return false;
    }

    public static double getSizeinMb(long size) {
        double m = (double)size / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    private double getFileSizeInMb(Map<String, String> headerMap) {
        long fileSizeInBytes = Long.parseLong(headerMap.get("file-size"));
        long filesizeInKB = (long)Math.ceil((double)fileSizeInBytes / 1024.0);
        return CloudBackupController.getSizeinMb(filesizeInKB);
    }

    protected FileUploadDetailsElement insertEntryForBackupFromBK(Map<String, Object> request, String cloudName, String userName, String maxVersionsToKeep, Device device, boolean isMail, boolean isCompressed) {
        FileUploadDetailsElement fileUploadDetailsElement;
        block43: {
            fileUploadDetailsElement = new FileUploadDetailsElement();
            try {
                String deviceUUID;
                OutlookEmailAddressElement outlookEmailAddress;
                OutlookEmailAddress add;
                Iterator iterator;
                ArrayList<OutlookEmailAddressElement> llist;
                Object addresses;
                logger.debug("beforeins 1112...");
                BackupElement fileElement = new BackupElement();
                logger.debug("beforeins 1112...");
                fileElement.setCompressed(isCompressed);
                logger.debug("beforeins 1112.33..");
                fileElement.setFileName((String)request.get("file-name"));
                fileElement.setFileCompletePath((String)request.get("file-path"));
                fileElement.setPresent(Boolean.valueOf((String)request.get("is-exists")).booleanValue());
                fileElement.setFolder(Boolean.valueOf((String)request.get("is-folder")).booleanValue());
                fileElement.setMd5Checksum((String)request.get("fileMD5"));
                if (request.get("taskStartDate") != null) {
                    fileElement.setTaskStartDate((Date)request.get("taskStartDate"));
                }
                if (request.get("taskDueDate") != null) {
                    fileElement.setTaskDueDate((Date)request.get("taskDueDate"));
                }
                if (request.get("versionId") != null) {
                    fileElement.setVersionId((String)request.get("versionId"));
                }
                if (request.get("taskReminderTime") != null) {
                    fileElement.setTaskReminderTime((Date)request.get("taskReminderTime"));
                }
                if (request.get("taskSubject") != null) {
                    fileElement.setTaskSubject((String)request.get("taskSubject"));
                    fileElement.setFileName((String)request.get("taskSubject"));
                }
                if (request.get("taskId") != null) {
                    fileElement.setTaskId((String)request.get("taskId"));
                }
                if (request.get("taskListId") != null) {
                    fileElement.setTaskListId((String)request.get("taskListId"));
                }
                logger.debug(String.valueOf(request.get("taskSubject")) + "****" + String.valueOf(request.get("taskListId")) + "....beforeins 111..." + String.valueOf(request.get("o365LastModifiedTime")));
                if (request.get("file-size") != null) {
                    if (!org.springframework.util.StringUtils.isEmpty((Object)((String)request.get("file-size")))) {
                        fileElement.setSize(Long.valueOf((String)request.get("file-size")).longValue());
                    } else {
                        fileElement.setSize(0L);
                    }
                } else {
                    fileElement.setSize(0L);
                }
                if (!isMail) {
                    String fileModifiedTimestamp = (String)request.get("modified");
                    fileElement.setLastClientModifiedTime(Long.valueOf(fileModifiedTimestamp).longValue());
                    if (request.get("o365LastModifiedTime") != null) {
                        fileElement.setLastClientModifiedTime(Long.parseLong(request.get("o365LastModifiedTime").toString()));
                    }
                } else {
                    fileElement.setLastClientModifiedTime(System.currentTimeMillis());
                }
                if (request.get("taskCreatedDate") != null) {
                    fileElement.setSentDate(request.get("taskCreatedDate").toString());
                }
                logger.debug(String.valueOf(request.get("taskCreatedDate")) + ".....beforeins 111..." + String.valueOf(request.get("o365LastModifiedTime")));
                fileElement.setBaseBackup(Boolean.valueOf((String)request.get("is-base-folder")).booleanValue());
                fileElement.setGatewayName((String)request.get("gatewayName"));
                String version = (String)request.get("maxVersions");
                logger.debug(String.valueOf(request.get("parentItemID")) + ".... item id iss.... " + String.valueOf(request.get("odItemId")) + "..ewsid..." + String.valueOf(request.get("ewsId")));
                fileElement.setOdItemId((String)request.get("odItemId"));
                if (!org.springframework.util.StringUtils.isEmpty((Object)fileElement.getTaskId())) {
                    fileElement.setOdItemId((String)request.get("odItemId"));
                    String[] arrObj = fileElement.getOdItemId().split("-##-");
                    fileElement.setOdItemId(arrObj[1]);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)request.get("ewsId"))) {
                    fileElement.setEwsId((String)request.get("ewsId"));
                }
                fileElement.setParentItemId((String)request.get("parentItemID"));
                fileElement.setSubject((String)request.get("subject"));
                fileElement.setFrom((String)request.get("from"));
                fileElement.setBodyContent((String)request.get("bodyContent"));
                fileElement.setDisplayContent((String)request.get("displayContent"));
                fileElement.setCcRecipients((String)request.get("ccRecipients"));
                fileElement.setBccRecipients((String)request.get("bccRecipients"));
                fileElement.setToRecipients((String)request.get("toRecipients"));
                if (request.get("hasAttachments") != null) {
                    fileElement.setHasAttachments(((Boolean)request.get("hasAttachments")).booleanValue());
                }
                if (request.get("taskMyDayTask") != null) {
                    fileElement.setTaskMyDayTask(((Boolean)request.get("taskMyDayTask")).booleanValue());
                }
                if (fileElement.isHasAttachments()) {
                    ArrayList<MailAttachmentElement> list = new ArrayList<MailAttachmentElement>();
                    List attachments = (List)request.get("attachments");
                    if (!CollectionUtils.isEmpty((Collection)attachments)) {
                        for (MailAttachment attachment : attachments) {
                            MailAttachmentElement elemen = new MailAttachmentElement();
                            BeanUtils.copyProperties((Object)attachment, (Object)elemen);
                            logger.debug("..pcibusattach..." + elemen.getName());
                            list.add(elemen);
                        }
                    }
                    fileElement.setAttachments(list);
                }
                if (request.get("fromEmailAddress") != null) {
                    addresses = (OutlookEmailAddress)request.get("fromEmailAddress");
                    OutlookEmailAddressElement emailAddress = new OutlookEmailAddressElement();
                    BeanUtils.copyProperties((Object)addresses, (Object)emailAddress);
                    fileElement.setFromEmailAddress(emailAddress);
                }
                if (request.get("toRecipientsAddress") != null) {
                    addresses = (List)request.get("toRecipientsAddress");
                    llist = new ArrayList<OutlookEmailAddressElement>();
                    logger.debug("...ttooo addrr..." + String.valueOf(addresses));
                    if (!CollectionUtils.isEmpty((Collection)addresses)) {
                        iterator = addresses.iterator();
                        while (iterator.hasNext()) {
                            add = (OutlookEmailAddress)iterator.next();
                            outlookEmailAddress = new OutlookEmailAddressElement();
                            BeanUtils.copyProperties((Object)add, (Object)outlookEmailAddress);
                            logger.debug("..toadddddd...." + add.getAddress());
                            llist.add(outlookEmailAddress);
                        }
                    }
                    fileElement.setToRecipientsAddress(llist);
                }
                if (request.get("ccRecipientsAddress") != null) {
                    addresses = (List)request.get("ccRecipientsAddress");
                    logger.debug("...cc addrr..." + String.valueOf(addresses));
                    llist = new ArrayList();
                    if (!CollectionUtils.isEmpty((Collection)addresses)) {
                        iterator = addresses.iterator();
                        while (iterator.hasNext()) {
                            add = (OutlookEmailAddress)iterator.next();
                            outlookEmailAddress = new OutlookEmailAddressElement();
                            BeanUtils.copyProperties((Object)add, (Object)outlookEmailAddress);
                            llist.add(outlookEmailAddress);
                        }
                    }
                    fileElement.setCcRecipientsAddress(llist);
                }
                if (request.get("bccRecipientsAddress") != null) {
                    addresses = (List)request.get("bccRecipientsAddress");
                    logger.debug("...bccRecipientsAddress addrr..." + String.valueOf(addresses));
                    llist = new ArrayList();
                    if (!CollectionUtils.isEmpty((Collection)addresses)) {
                        iterator = addresses.iterator();
                        while (iterator.hasNext()) {
                            add = (OutlookEmailAddress)iterator.next();
                            outlookEmailAddress = new OutlookEmailAddressElement();
                            BeanUtils.copyProperties((Object)add, (Object)outlookEmailAddress);
                            llist.add(outlookEmailAddress);
                        }
                    }
                    fileElement.setBccRecipientsAddress(llist);
                }
                fileElement.setSentDate((String)request.get("sentDate"));
                if (request.get("taskCreatedDate") != null) {
                    fileElement.setSentDate(request.get("taskCreatedDate").toString());
                }
                logger.debug("..fileElement.setSentDate.." + String.valueOf(request.get("sentDate")));
                String userUnderLegalHold = (String)request.get("userUnderLegalHold");
                boolean isFullBackup = false;
                String fullBackup = (String)request.get("isFullBackup");
                if (!org.springframework.util.StringUtils.isEmpty((Object)fullBackup)) {
                    isFullBackup = Boolean.parseBoolean(fullBackup);
                }
                if ((deviceUUID = (String)request.get("deviceUUID")) != null) {
                    CloudBackupController.printLogs("Device UUID is not null", PCHelperConstant.isBrevityLogging());
                }
                int uploadCount = 0;
                if (MemoryStore.get((String)UPLOAD_COUNT) != null) {
                    uploadCount = (Integer)MemoryStore.get((String)UPLOAD_COUNT);
                    logger.info(" From MEMSTORE ........... " + uploadCount);
                }
                if (request.get("calendarDuration") != null) {
                    fileElement.setCalendarDuration(request.get("calendarDuration").toString());
                }
                if (request.get("calendarStartDate") != null) {
                    fileElement.setCalendarStartDate(request.get("calendarStartDate").toString());
                }
                if (request.get("calendarEndDate") != null) {
                    fileElement.setCalendarEndDate(request.get("calendarEndDate").toString());
                }
                this.setContactDetails(request, fileElement);
                logger.debug("beforeins 22..." + String.valueOf(request.get("calendarDuration")));
                logger.info(fileElement.getTaskSubject() + " Before calling uploadExternalFileToBackUp ..........." + fileElement.getSubject() + "..." + String.valueOf(fileElement.getTaskDueDate()));
                fileUploadDetailsElement = this.backupService.uploadExternalFileToBackUp(1, cloudName, fileElement, device, userUnderLegalHold, isFullBackup, false);
                logger.info(" After calling uploadExternalFileToBackUp ..........." + fileUploadDetailsElement.getBkpId() + "...." + fileUploadDetailsElement.getFileSize());
                MemoryStore.delete((String)UPLOAD_COUNT);
                MemoryStore.add((String)UPLOAD_COUNT, (Object)(++uploadCount));
            }
            catch (MongoException e) {
                MongoCommandException commandException;
                int errorCode;
                if (e instanceof MongoCommandException && (errorCode = (commandException = (MongoCommandException)e).getErrorCode()) == 10334) {
                    fileUploadDetailsElement.setBkpId(LARGE_MONGO_ENTRY);
                }
            }
            catch (Exception e) {
                MongoCommandException commandException;
                int errorCode;
                e.printStackTrace();
                logger.error("..Exception When Inserting Entry For Backup From BK :....", (Throwable)e);
                if (!(e instanceof MongoCommandException) || (errorCode = (commandException = (MongoCommandException)e).getErrorCode()) != 10334) break block43;
                fileUploadDetailsElement.setBkpId(LARGE_MONGO_ENTRY);
            }
        }
        return fileUploadDetailsElement;
    }

    private void setContactDetails(Map<String, Object> request, BackupElement fileElement) {
        if (request.get("contactMobile") != null) {
            fileElement.setContactMobile((String)request.get("contactMobile"));
        }
        if (request.get("contactEmail") != null) {
            fileElement.setContactEmail((String)request.get("contactEmail"));
        }
        if (request.get("contactAddrStreet") != null) {
            fileElement.setContactAddrStreet((String)request.get("contactAddrStreet"));
        }
        if (request.get("contactAddrCity") != null) {
            fileElement.setContactAddrCity((String)request.get("contactAddrCity"));
        }
        if (request.get("contactAddrState") != null) {
            fileElement.setContactAddrState((String)request.get("contactAddrState"));
        }
        if (request.get("contactAddrCountry") != null) {
            fileElement.setContactAddrCountry((String)request.get("contactAddrCountry"));
        }
        if (request.get("contactAddrPostalCode") != null) {
            fileElement.setContactAddrPostalCode((String)request.get("contactAddrPostalCode"));
        }
        if (request.get("contactBusiAddrStreet") != null) {
            fileElement.setContactBusiAddrStreet((String)request.get("contactBusiAddrStreet"));
        }
        if (request.get("contactBusiAddrCity") != null) {
            fileElement.setContactBusiAddrCity((String)request.get("contactBusiAddrCity"));
        }
        if (request.get("contactBusiAddrState") != null) {
            fileElement.setContactBusiAddrState((String)request.get("contactBusiAddrState"));
        }
        if (request.get("contactBusiAddrCountry") != null) {
            fileElement.setContactBusiAddrCountry((String)request.get("contactBusiAddrCountry"));
        }
        if (request.get("contactBusiAddrPostalCode") != null) {
            fileElement.setContactBusiAddrPostalCode((String)request.get("contactBusiAddrPostalCode"));
        }
        if (request.get("contactOfficeLocation") != null) {
            fileElement.setContactOfficeLocation((String)request.get("contactOfficeLocation"));
        }
        if (request.get("contactCompanyName") != null) {
            fileElement.setContactCompanyName((String)request.get("contactCompanyName"));
        }
        if (request.get("contactJobTitle") != null) {
            fileElement.setContactJobTitle((String)request.get("contactJobTitle"));
        }
        if (request.get("contactDepartment") != null) {
            fileElement.setContactDepartment((String)request.get("contactDepartment"));
        }
        if (request.get("contactbirthday") != null) {
            fileElement.setContactBirthday(String.valueOf((OffsetDateTime)request.get("contactbirthday")));
        }
        if (request.get("contactHomePhones") != null) {
            fileElement.setContactHomePhones((String)request.get("contactHomePhones"));
        }
        if (request.get("contactBusinessPhones") != null) {
            fileElement.setContactBusinessPhones((String)request.get("contactBusinessPhones"));
        }
        if (request.get("contactwebSite") != null) {
            fileElement.setContactWebSite((String)request.get("contactwebSite"));
        }
        if (request.get("contactTitle") != null) {
            fileElement.setContactTitle((String)request.get("contactTitle"));
        }
        if (request.get("contactFirstName") != null) {
            fileElement.setContactFirstName((String)request.get("contactFirstName"));
        }
        if (request.get("contactMiddleName") != null) {
            fileElement.setContactMiddleName((String)request.get("contactMiddleName"));
        }
        if (request.get("contactLastName") != null) {
            fileElement.setContactLastName((String)request.get("contactLastName"));
        }
        if (request.get("contactSuffix") != null) {
            fileElement.setContactSuffix((String)request.get("contactSuffix"));
        }
    }

    private void setContactDetailsFileInfo(Map<String, Object> request, FileInfo fileElement) {
        if (request.get("contactMobile") != null) {
            fileElement.setContactMobile((String)request.get("contactMobile"));
        }
        if (request.get("contactEmail") != null) {
            fileElement.setContactEmail((String)request.get("contactEmail"));
        }
        if (request.get("contactAddrStreet") != null) {
            fileElement.setContactAddrStreet((String)request.get("contactAddrStreet"));
        }
        if (request.get("contactAddrCity") != null) {
            fileElement.setContactAddrCity((String)request.get("contactAddrCity"));
        }
        if (request.get("contactAddrState") != null) {
            fileElement.setContactAddrState((String)request.get("contactAddrState"));
        }
        if (request.get("contactAddrCountry") != null) {
            fileElement.setContactAddrCountry((String)request.get("contactAddrCountry"));
        }
        if (request.get("contactAddrPostalCode") != null) {
            fileElement.setContactAddrPostalCode((String)request.get("contactAddrPostalCode"));
        }
        if (request.get("contactBusiAddrStreet") != null) {
            fileElement.setContactBusiAddrStreet((String)request.get("contactBusiAddrStreet"));
        }
        if (request.get("contactBusiAddrCity") != null) {
            fileElement.setContactBusiAddrCity((String)request.get("contactBusiAddrCity"));
        }
        if (request.get("contactBusiAddrState") != null) {
            fileElement.setContactBusiAddrState((String)request.get("contactBusiAddrState"));
        }
        if (request.get("contactBusiAddrCountry") != null) {
            fileElement.setContactBusiAddrCountry((String)request.get("contactBusiAddrCountry"));
        }
        if (request.get("contactBusiAddrPostalCode") != null) {
            fileElement.setContactBusiAddrPostalCode((String)request.get("contactBusiAddrPostalCode"));
        }
        if (request.get("contactOfficeLocation") != null) {
            fileElement.setContactOfficeLocation((String)request.get("contactOfficeLocation"));
        }
        if (request.get("contactCompanyName") != null) {
            fileElement.setContactCompanyName((String)request.get("contactCompanyName"));
        }
        if (request.get("contactJobTitle") != null) {
            fileElement.setContactJobTitle((String)request.get("contactJobTitle"));
        }
        if (request.get("contactDepartment") != null) {
            fileElement.setContactDepartment((String)request.get("contactDepartment"));
        }
        if (request.get("contactbirthday") != null) {
            fileElement.setContactBirthday(String.valueOf((OffsetDateTime)request.get("contactbirthday")));
        }
        if (request.get("contactHomePhones") != null) {
            fileElement.setContactHomePhones((String)request.get("contactHomePhones"));
        }
        if (request.get("contactBusinessPhones") != null) {
            fileElement.setContactBusinessPhones((String)request.get("contactBusinessPhones"));
        }
        if (request.get("contactwebSite") != null) {
            fileElement.setContactWebSite((String)request.get("contactwebSite"));
        }
        if (request.get("contactTitle") != null) {
            fileElement.setContactTitle((String)request.get("contactTitle"));
        }
        if (request.get("contactFirstName") != null) {
            fileElement.setContactFirstName((String)request.get("contactFirstName"));
        }
        if (request.get("contactMiddleName") != null) {
            fileElement.setContactMiddleName((String)request.get("contactMiddleName"));
        }
        if (request.get("contactLastName") != null) {
            fileElement.setContactLastName((String)request.get("contactLastName"));
        }
        if (request.get("contactSuffix") != null) {
            fileElement.setContactSuffix((String)request.get("contactSuffix"));
        }
    }

    private File createFileInBackupPath(Map<String, Object> headerMap, String cloudName, String fileName, boolean isMail) throws IOException {
        logger.info("Entering createFileInBackupPath ");
        String backupBatchId = (String)headerMap.get("backupBatchId");
        if (org.springframework.util.StringUtils.isEmpty((Object)backupBatchId)) {
            backupBatchId = "FIXME-INBA";
        }
        String deviceUUID = (String)headerMap.get("deviceUUID");
        String deviceTempPath = PCHelperConstant.getMntTempChunkPath() + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupBatchId;
        File uploadBackupPath = new File(deviceTempPath);
        uploadBackupPath.mkdirs();
        if (isMail) {
            String itemId = (String)headerMap.get("odItemId");
            logger.debug("...changem md5 for filenamemail..." + itemId);
            String md5 = MD5Generator.generateMD5OfString((String)itemId);
            fileName = md5 + ".tmp";
        }
        String filePath = String.valueOf(uploadBackupPath) + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + (String)fileName;
        logger.info("File path: " + filePath);
        File tempFilePath = new File(filePath);
        if (tempFilePath.exists()) {
            logger.info("Temp file exists so deleting the file####");
            tempFilePath.delete();
        }
        try {
            tempFilePath.createNewFile();
        }
        catch (IOException e) {
            logger.error("....unable to create filepppp...");
            logger.error(String.valueOf(tempFilePath) + "....unable to create filepppp..." + e.getMessage());
        }
        logger.info("Leaving createFileInBackupPath");
        return tempFilePath;
    }

    private File createSearchFileInBackupPath(Map<String, Object> headerMap, String cloudName, String fileName, boolean isMail) throws IOException {
        logger.info("Entering createFileInBackupPath ");
        String backupBatchId = (String)headerMap.get("backupBatchId");
        if (org.springframework.util.StringUtils.isEmpty((Object)backupBatchId)) {
            backupBatchId = "FIXME-INBA";
        }
        String deviceUUID = (String)headerMap.get("deviceUUID");
        String deviceTempPath = PCHelperConstant.getMntTempChunkPath() + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupBatchId;
        File uploadBackupPath = new File(deviceTempPath);
        uploadBackupPath.mkdirs();
        if (isMail) {
            String itemId = (String)headerMap.get("odItemId");
            logger.debug("...changem md5 for filenamemail..." + itemId);
            String md5 = MD5Generator.generateMD5OfString((String)itemId);
            fileName = md5 + "search.tmp";
        }
        String filePath = String.valueOf(uploadBackupPath) + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + (String)fileName;
        logger.info("File path: " + filePath);
        File tempFilePath = new File(filePath);
        if (tempFilePath.exists()) {
            logger.info("Temp file exists so deleting the file####");
            tempFilePath.delete();
        }
        try {
            tempFilePath.createNewFile();
        }
        catch (IOException e) {
            logger.error("....unable to create filepppp...");
            logger.error(String.valueOf(tempFilePath) + "....unable to create filepppp..." + e.getMessage());
        }
        logger.info("Leaving createFileInBackupPath");
        return tempFilePath;
    }

    private void checkNThrottleAndUploadFileV2(String cloudName, String gatewayName, InputStream inputStream, InputStream searchInputStream, long fileSize, ChunkFileElement chunkFileElement, String sourceFilePath, String osType, String indexPath, String batchId, boolean isCompressed) throws InterruptedException {
        this.chunkableUploadService.uploadChunkableFileToBackUp(cloudName, inputStream, searchInputStream, chunkFileElement, osType, false, indexPath, batchId, isCompressed);
    }

    private List<String> getBackupIdAppendedToChunks(List<String> newChunkList, String newBackupId) {
        ArrayList<String> resChunkList = new ArrayList<String>();
        for (String chunkName : newChunkList) {
            resChunkList.add(chunkName + "." + newBackupId);
        }
        Collections.sort(resChunkList);
        return resChunkList;
    }

    protected FileInfo getFileInfo(BluKryptElement bluKryptElement, String backupId, String prevBackupId, List<String> list) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setChunkFiles(new ArrayList());
        fileInfo.setFileName(bluKryptElement.getFileName());
        fileInfo.setId(backupId);
        fileInfo.setFilePath(bluKryptElement.getFilePath());
        fileInfo.setDeviceUUID(bluKryptElement.getDeviceUUID());
        fileInfo.setOsType(bluKryptElement.getOsType());
        fileInfo.setPrevBackupId(prevBackupId);
        fileInfo.setUserName(bluKryptElement.getUserName());
        fileInfo.getChunkFiles().addAll(list);
        return fileInfo;
    }

    private String getUploadFilePath(String deviceUUID, String cloudName, String batchId) {
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID;
        if (!org.springframework.util.StringUtils.isEmpty((Object)batchId)) {
            deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
        }
        return deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
    }

    private List<String> moveFilesFromTmpPath(String deviceUUID, List<String> orgChunks, String chunkPath, String batchId) throws Exception {
        ArrayList<String> chunkNames = new ArrayList<String>();
        for (String chunkName : orgChunks) {
            String path = PCHelperConstant.getMntTempChunkPath() + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
            String srcfilePath = path + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName;
            File fileObj = new File(srcfilePath);
            if (fileObj.exists()) {
                File chunkDir = new File(chunkPath);
                if (!chunkDir.exists()) {
                    chunkDir.mkdirs();
                }
                String destPath = chunkPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName;
                Object newChunkName = chunkName;
                int dedupCount = 1;
                while (new File(destPath).exists()) {
                    logger.debug("file is exist in destination path>>>>>>: " + destPath);
                    destPath = chunkPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + chunkName + "_" + dedupCount;
                    newChunkName = chunkName + "_" + dedupCount;
                    ++dedupCount;
                }
                chunkNames.add((String)newChunkName);
                logger.debug("newChunkName check exists :" + (String)newChunkName);
                File destFile = new File(destPath);
                if (fileObj.exists()) {
                    Files.move(fileObj.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                logger.debug("destFile :" + destFile.getAbsolutePath());
                continue;
            }
            logger.debug("....file not exixts......" + srcfilePath);
            throw new Exception(FILE_NOT_EXISTS);
        }
        return chunkNames;
    }

    private void closeInputStreamAndDelTempFile(File tempFilePath, InputStream inputStream) {
        if (inputStream != null) {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        if (tempFilePath != null && tempFilePath.exists()) {
            tempFilePath.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int upload(Map<String, Object> headerMap, InputStream dataStream, int uploadCount, List<String> chunkMd5s, Cloud cloud, boolean sharepoint, com.parablu.pcbd.domain.User user) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        CloudBackupController.printLogs("Entering upload!", PCHelperConstant.isBrevityLogging());
        InputStream inputStream = dataStream;
        try {
            String deviceUUID = (String)headerMap.get("deviceUUID");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            String driveFileInfoId = (String)headerMap.get("driveFileInfoId");
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fileSizeInString = (String)headerMap.get("file-size");
            String chunkFilechecksum = (String)headerMap.get("chunkFileMD5");
            String chunkFileName = (String)headerMap.get("chunkFileName");
            batchId = (String)headerMap.get("backupBatchId");
            String isChunkOfAFile = "false";
            String checkSum = (String)headerMap.get("fileMD5");
            String prevBackupId = (String)headerMap.get("prevBackupId");
            String isCompressed = "false";
            String isNormalFile = "true";
            long fileSize = Long.parseLong(fileSizeInString);
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            logger.debug("!!!Obtained the device " + device.getDeviceUUID());
            boolean isOneDrive = false;
            if (!org.springframework.util.StringUtils.isEmpty((Object)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
                isOneDrive = true;
            }
            boolean isOutlook = false;
            if (!org.springframework.util.StringUtils.isEmpty((Object)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
                isOutlook = true;
            }
            boolean isSharepoint = false;
            if (!org.springframework.util.StringUtils.isEmpty((Object)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
                isSharepoint = true;
            }
            logger.debug(BATCH_ID_LOG + batchId);
            ArrayList<String> list = new ArrayList<String>();
            boolean isMachineStorageReached = CloudBackupController.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                int n = 507;
                return n;
            }
            boolean isBlobFuseUnmounted = this.checkBlobFuseMounted(cloud.getCloudId(), cloud);
            if (isBlobFuseUnmounted) {
                int n = 410;
                return n;
            }
            cloudName = bluKryptElement.getCloudName();
            logger.debug("!!!Obtained the device " + device.getDeviceUUID());
            ChunkFileElement chunkFileElement = CloudBackupController.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
            String sourceFilePath = (String)headerMap.get("file-path");
            String osType = "Microsoft OneDrive";
            String fsPath = CloudBackupController.getFsPath((String)headerMap.get("fileMD5"));
            String indexPath = null;
            int cloudId = cloud.getCloudId();
            boolean isSearchEnabled = false;
            OfficeBackupPolicy backupPolicy = null;
            if (device != null && Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(device.getOsType())) {
                backupPolicy = this.utilService.getOfficeBackupPolicy(cloudId, user.getOneDrivePolicyName(), "ODB");
            } else if (device != null && Device.TYPE.OUTLOOK.toString().equalsIgnoreCase(device.getOsType())) {
                backupPolicy = this.utilService.getOfficeBackupPolicy(cloudId, user.getExchangePolicyName(), "Exchange");
            } else if (device != null && Device.TYPE.SHAREPOINT.toString().equalsIgnoreCase(device.getOsType())) {
                backupPolicy = this.utilService.getOfficeBackupPolicy(cloudId, user.getSpPolicyName(), "Sharepoint");
            }
            if (cloud.getContentSearchEnabled() == 1) {
                boolean isFileAllowed = true;
                if (backupPolicy.isContentIndexEnabled() && isFileAllowed) {
                    isSearchEnabled = true;
                }
            }
            if (isSearchEnabled && isOneDrive && cloud.getContentSearchEnabledForOnedrive() == 0) {
                isSearchEnabled = false;
            } else if (isSearchEnabled && sharepoint && cloud.getContentSearchEnabledForSharepoint() == 0) {
                isSearchEnabled = false;
            } else if (isSearchEnabled && isOutlook && cloud.getContentSearchEnabledForExchange() == 0) {
                isSearchEnabled = false;
            }
            if (isSearchEnabled) {
                indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            }
            boolean isCompressedBool = backupPolicy.isCompressionEnabled();
            logger.debug(isCompressedBool + ".....index path....." + indexPath);
            logger.debug("File name after creating the random uuid: " + chunkFileElement.getFileName());
            this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), inputStream, null, fileSize, chunkFileElement, sourceFilePath, osType, indexPath, batchId, isCompressedBool);
            chunkMd5s.add(chunkFileElement.getMd5checksum());
            logger.debug("Chunk file md5 list>>>>> " + chunkMd5s.size());
            checkSum = chunkFileElement.getMd5checksum();
            assert (Boolean.parseBoolean(isNormalFile));
            logger.debug(" Before calling insert query  latest...........");
            FileUploadDetailsElement fileUploadDetailsElement = this.insertEntryForBackupFromBK(headerMap, cloudName, bluKryptElement.getUserName(), bluKryptElement.getVersionsToKeep(), device, false, isCompressedBool);
            backupId = fileUploadDetailsElement.getBkpId();
            if (org.springframework.util.StringUtils.isEmpty((Object)backupId) || ALREADY_EXISTS.equalsIgnoreCase(backupId) || LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId) || backupId.contains(ALREADY_EXISTS_LINK) || backupId.contains(ALREADY_EXISTS)) {
                File file2;
                logger.debug(" Already exists!" + backupId);
                this.removeDriveItem(driveFileInfoId, false, deviceUUID);
                if (LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                    int n = 200;
                    return n;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)indexPath) && (file2 = new File(indexPath)).exists()) {
                    file2.delete();
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)backupId) && backupId.contains(ALREADY_EXISTS)) {
                    int file2 = 200;
                    return file2;
                }
                int file2 = 409;
                return file2;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.info(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            logger.debug("backupid ---> " + backupId + "(" + org.springframework.util.StringUtils.isEmpty((Object)backupId) + ")");
            FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            ArrayList<String> orgChunks = list;
            fileInfo.setSize(Long.valueOf(fileSize));
            if (headerMap.get("hasAttachments") != null) {
                fileInfo.setHasAttachments(((Boolean)headerMap.get("hasAttachments")).booleanValue());
            }
            if (fileInfo.isHasAttachments()) {
                fileInfo.setAttachments((List)headerMap.get("attachments"));
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)headerMap.get(JOB_ID))) {
                fileInfo.setServerBackupJobId((String)headerMap.get(JOB_ID));
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)isCompressed)) {
                fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
            }
            fileInfo.setBatchId(batchId);
            fileInfo.setCompressed(isCompressedBool);
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, fileInfo.getBatchId());
            logger.debug("orgchunks list>>" + orgChunks.size());
            boolean fileExists = false;
            logger.debug("Chunk file path --" + chunkPath + " size ->" + orgChunks.size());
            List<String> moveFilesFromTmpPath = this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath, fileInfo.getBatchId());
            fileInfo.getChunkFiles().clear();
            fileInfo.getChunkFiles().addAll(moveFilesFromTmpPath);
            if (!org.springframework.util.StringUtils.isEmpty((Object)chunkFilechecksum)) {
                List<String> resChunkList = this.getBackupIdAppendedToChunks(moveFilesFromTmpPath, fileInfo.getId());
                fileInfo.getChunkFiles().clear();
                fileInfo.getChunkFiles().addAll(resChunkList);
            }
            logger.debug("...isfileexistsisSearchEnabled....." + fileExists + "...." + isSearchEnabled);
            if (fileExists) {
                this.uploadService.updateFileInfo(cloudName, "", fileInfo);
                this.removeDriveItem(driveFileInfoId, false, deviceUUID);
            } else {
                fileInfo.setGatewayName(PCHelperConstant.getComponentName());
                this.updateStorageUtilization(cloudName, batchId, deviceUUID, list, fileUploadDetailsElement);
                fileInfo.setReducePGSize(true);
                this.uploadService.saveFileInfoForODB(cloudName, bluKryptElement.getUserName(), fileInfo, driveFileInfoId, false);
                String siteId = "";
                String listId = "";
                if (isSharepoint) {
                    siteId = (String)headerMap.get("siteId");
                    listId = (String)headerMap.get("listId");
                }
                BackUpImage backUpImage = this.utilService.getBackupImageFile(cloudId, backupId, device);
                logger.debug(".....check link...");
                boolean isSPArchivingEnabled = this.isSPArchivingEnabled(cloud);
                boolean onedriveLinkEnabled = this.isOneDriveArchivingEnabled(cloud);
                if (backUpImage != null && isOneDrive && onedriveLinkEnabled) {
                    this.createCpImage(cloud, device, isSharepoint, siteId, listId, backUpImage);
                }
                if (backUpImage != null && isSharepoint && isSPArchivingEnabled) {
                    this.createCpImage(cloud, device, isSharepoint, siteId, listId, backUpImage);
                }
                logger.debug(".. start of adding search index....");
                bluKryptElement.setDeviceUUID(device.getDeviceUUID());
                if (isSearchEnabled) {
                    SearchIndex index = this.formSearchIndex(1, bluKryptElement, new ObjectId(backupId), fsPath, device.getId());
                    if (sharepoint) {
                        index = this.formSpSearchIndex(1, bluKryptElement, new ObjectId(backupId), fsPath, device.getId());
                    }
                    index.setDeviceType(device.getDeviceType());
                    index.setDeviceName(device.getDeviceName());
                    this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                    logger.debug(index.getDeviceUUID() + ".. end of adding search index...." + String.valueOf(index.getDeviceId()));
                }
            }
            logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            logger.error(BATCH_ID_LOG + batchId + " Exception While Uploading", (Throwable)e);
            int n = 500;
            return n;
        }
        finally {
            this.closeInputStreamAndDelTempFile(null, inputStream);
        }
        return 200;
    }

    private boolean checkBlobFuseMounted(int cloudId, Cloud cloud) {
        boolean isBlobFuseUnmounted = false;
        if (PCHelperConstant.isBlobFuseEnabled() && (isBlobFuseUnmounted = this.uploadService.isStopBackupBasedOnBlobFuse(cloudId, cloud))) {
            this.componentSettingService.updatePGOverloadLimitInComponentProperties(PCHelperConstant.getComponentName(), 1, "0");
            PCHelperConstant.setPGOverloadLimit((String)"0");
            logger.debug("blobfusedModifiedTime limit reached/BlobFuseEnable is not present so stop backup:::::");
        }
        return isBlobFuseUnmounted;
    }

    private void createCpImage(Cloud cloud, Device device, boolean isSharepoint, String siteId, String listId, BackUpImage backUpImage) {
        if (backUpImage != null && !backUpImage.isMailLinkGenerated() && !backUpImage.isLinkGenerated()) {
            CMBackUpImage cmBackUpImage = new CMBackUpImage();
            BeanUtils.copyProperties((Object)backUpImage, (Object)cmBackUpImage);
            cmBackUpImage.setId(null);
            cmBackUpImage.setBkpImageId(backUpImage.getId());
            if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
                cmBackUpImage.setDeviceType(Device.TYPE.SHAREPOINT.name());
            } else if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
                cmBackUpImage.setDeviceType(Device.TYPE.ONEDRIVE.name());
            } else if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
                cmBackUpImage.setDeviceType(Device.TYPE.OUTLOOK.name());
            }
            cmBackUpImage.setLastModifiedTime(backUpImage.getLastClientModifiedTime());
            cmBackUpImage.setTimeStampUpdated(true);
            if (isSharepoint) {
                cmBackUpImage.setSiteId(siteId);
                cmBackUpImage.setListId(listId);
            }
            this.utilService.saveCapacityMgmtImage(cloud.getCloudId(), cmBackUpImage, device.getDestCollection(), cmBackUpImage.getDeviceType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int uploadMail(Map<String, Object> headerMap, InputStream inputStreamWoAttach, InputStream dataStream, int uploadCount, List<String> chunkMd5s, Cloud cloud, OfficeBackupPolicy backupPolicy, boolean isInPlaceArchive) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        InputStream inputStream = inputStreamWoAttach;
        InputStream searchInputStream = dataStream;
        logger.debug("Entering mail upload!--" + String.valueOf(headerMap.get("receivedDateTime")));
        try {
            BackUpImage backUpImage;
            String deviceUUID = (String)headerMap.get("deviceUUID");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            String driveFileInfoId = (String)headerMap.get("driveFileInfoId");
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fileSizeInString = (String)headerMap.get("file-size");
            String chunkFilechecksum = (String)headerMap.get("chunkFileMD5");
            String chunkFileName = (String)headerMap.get("chunkFileName");
            batchId = (String)headerMap.get("backupBatchId");
            String isChunkOfAFile = "false";
            String checkSum = (String)headerMap.get("fileMD5");
            String prevBackupId = (String)headerMap.get("prevBackupId");
            String isCompressed1 = "false";
            String isNormalFile = "true";
            long fileSize = Long.parseLong(fileSizeInString);
            logger.debug(BATCH_ID_LOG + batchId);
            ArrayList<String> list = new ArrayList<String>();
            boolean isMachineStorageReached = CloudBackupController.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                int n = 507;
                return n;
            }
            boolean isBlobFuseUnmounted = this.checkBlobFuseMounted(cloud.getCloudId(), cloud);
            if (isBlobFuseUnmounted) {
                int n = 410;
                return n;
            }
            cloudName = bluKryptElement.getCloudName();
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            logger.debug("!!!Obtained the device " + device.getDeviceUUID());
            ChunkFileElement chunkFileElement = CloudBackupController.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
            String sourceFilePath = (String)headerMap.get("file-path");
            String osType = "Microsoft OneDrive";
            String fsPath = CloudBackupController.getFsPath((String)headerMap.get("fileMD5"));
            String indexPath = null;
            int cloudId = cloud.getCloudId();
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1 && backupPolicy.isContentIndexEnabled() && cloud.getContentSearchEnabledForExchange() == 1) {
                isSearchEnabled = true;
            }
            if (isSearchEnabled) {
                indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            }
            logger.debug(".....isSearchEnabled...." + isSearchEnabled);
            logger.debug("index path" + indexPath);
            logger.debug(backupPolicy.isCompressionEnabled() + "...File name after creating the random uuid: " + chunkFileElement.getFileName());
            boolean isCompressedBool = backupPolicy.isCompressionEnabled();
            this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), inputStream, searchInputStream, fileSize, chunkFileElement, sourceFilePath, osType, indexPath, batchId, isCompressedBool);
            chunkMd5s.add(chunkFileElement.getMd5checksum());
            logger.debug("Chunk file md5 list>>>>> " + chunkMd5s.size());
            checkSum = chunkFileElement.getMd5checksum();
            FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            logger.debug(" Before calling insert query mail...........");
            FileUploadDetailsElement fileUploadDetailsElement = this.insertEntryForBackupFromBK(headerMap, cloudName, bluKryptElement.getUserName(), bluKryptElement.getVersionsToKeep(), device, true, isCompressedBool);
            backupId = fileUploadDetailsElement.getBkpId();
            if (org.springframework.util.StringUtils.isEmpty((Object)backupId) || ALREADY_EXISTS.equalsIgnoreCase(backupId) || LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId) || backupId.contains(ALREADY_EXISTS_LINK) || backupId.contains(ALREADY_EXISTS)) {
                File file;
                logger.debug(" Already exists!" + backupId);
                this.removeDriveItem(driveFileInfoId, true, deviceUUID);
                if (!org.springframework.util.StringUtils.isEmpty((Object)indexPath) && (file = new File(indexPath)).exists()) {
                    file.delete();
                }
                if (backupId.contains("ALREADY_EXISTS-") && backupPolicy.isCreateMailLinkEnabled()) {
                    logger.debug(backupId + ".......file to create link...." + fileInfo.getFilePath() + "...." + fileInfo.getFileName());
                    String[] stringarray = backupId.split("-");
                    logger.debug(backupId + ".......file to create link1...." + fileInfo.getFilePath() + "...." + fileInfo.getFileName());
                    if (!isInPlaceArchive) {
                        backupId = stringarray[1];
                        BackUpImage backUpImage2 = this.utilService.getBackupImageFile(cloudId, backupId, device);
                        if (backUpImage2 != null && backUpImage2.isHasAttachments() && !backUpImage2.isMailLinkGenerated() && backUpImage2 != null && !backUpImage2.isMailLinkGenerated() && !backUpImage2.isLinkGenerated()) {
                            long receivedDateTime = (Long)headerMap.get("receivedDateTime");
                            this.createCMBackupImage(cloud, device.getDestCollection(), backUpImage2, receivedDateTime);
                        }
                        backupId = ALREADY_EXISTS;
                    }
                }
                if (LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                    int stringarray = 200;
                    return stringarray;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)backupId) && backupId.contains(ALREADY_EXISTS)) {
                    int stringarray = 200;
                    return stringarray;
                }
                int stringarray = 409;
                return stringarray;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.info(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            logger.debug("backupid ---> " + backupId + "(" + org.springframework.util.StringUtils.isEmpty((Object)backupId) + ")");
            fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            fileInfo.setSubject((String)headerMap.get("subject"));
            fileInfo.setFrom((String)headerMap.get("from"));
            fileInfo.setBodyContent((String)headerMap.get("bodyContent"));
            if (headerMap.get("receivedDateTime") != null) {
                fileInfo.setReceivedDateTime(((Long)headerMap.get("receivedDateTime")).longValue());
            }
            if (headerMap.get("sentDateTime") != null) {
                fileInfo.setSentDateTime(((Long)headerMap.get("sentDateTime")).longValue());
            }
            fileInfo.setCcRecipients((String)headerMap.get("ccRecipients"));
            fileInfo.setBccRecipients((String)headerMap.get("bccRecipients"));
            fileInfo.setToRecipients((String)headerMap.get("toRecipients"));
            fileInfo.setHasAttachments(((Boolean)headerMap.get("hasAttachments")).booleanValue());
            fileInfo.setFromAddr((String)headerMap.get("fromAddr"));
            fileInfo.setCcRecipientsAddr((String)headerMap.get("ccRecipientsAddr"));
            fileInfo.setBccRecipientsAddr((String)headerMap.get("bccRecipientsAddr"));
            fileInfo.setToRecipientsAddr((String)headerMap.get("toRecipientsAddr"));
            if (fileInfo.isHasAttachments()) {
                fileInfo.setAttachments((List)headerMap.get("attachments"));
            }
            if (headerMap.get("toRecipientsAddress") != null) {
                fileInfo.setToRecipientsAddress((List)headerMap.get("toRecipientsAddress"));
            }
            if (headerMap.get("ccRecipientsAddress") != null) {
                fileInfo.setCcRecipientsAddress((List)headerMap.get("ccRecipientsAddress"));
            }
            if (headerMap.get("bccRecipientsAddress") != null) {
                fileInfo.setBccRecipientsAddress((List)headerMap.get("bccRecipientsAddress"));
            }
            if (headerMap.get("fromEmailAddress") != null) {
                fileInfo.setFromEmailAddress((OutlookEmailAddress)headerMap.get("fromEmailAddress"));
            }
            ArrayList<String> orgChunks = list;
            fileInfo.setSize(Long.valueOf(fileSize));
            if (!org.springframework.util.StringUtils.isEmpty((Object)headerMap.get(JOB_ID))) {
                fileInfo.setServerBackupJobId((String)headerMap.get(JOB_ID));
            }
            if (isCompressedBool) {
                fileInfo.setCompressed(isCompressedBool);
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)chunkFilechecksum)) {
                List<String> resChunkList = this.getBackupIdAppendedToChunks(list, backupId);
                fileInfo.getChunkFiles().clear();
                fileInfo.getChunkFiles().addAll(resChunkList);
            }
            fileInfo.setBatchId(batchId);
            logger.debug("..batchidpath...." + batchId);
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, fileInfo.getBatchId());
            logger.debug("orgchunks list>>" + orgChunks.size());
            boolean isFullBackup = true;
            boolean fileExists = false;
            logger.debug(fileUploadDetailsElement.getFileSize() + "Chunk file path --" + chunkPath + " size ->" + orgChunks.size());
            this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath, fileInfo.getBatchId());
            this.updateMailStorageUtilization(deviceUUID, fileUploadDetailsElement);
            fileInfo.setReducePGSize(true);
            HashedMap urlSetMap = new HashedMap();
            boolean isLocalSaveSuccess = this.uploadService.saveFileInfoForODB(cloudName, bluKryptElement.getUserName(), fileInfo, driveFileInfoId, true);
            logger.debug(isCompressedBool + "...savelocalsuccess..." + isLocalSaveSuccess);
            logger.debug(fileInfo.isCompressed() + ".....mail isSearchEnabled...." + isSearchEnabled);
            logger.debug(".....outlook ....");
            boolean isMailArchivingEnabled = this.isMailArchivingEnabled(cloud);
            if (!isInPlaceArchive && isMailArchivingEnabled && (backUpImage = this.utilService.getBackupImageFile(cloudId, backupId, device)) != null && backUpImage.isHasAttachments() && backUpImage != null && !backUpImage.isMailLinkGenerated() && !backUpImage.isLinkGenerated()) {
                long receivedDateTime = (Long)headerMap.get("receivedDateTime");
                this.createCMBackupImage(cloud, device.getDestCollection(), backUpImage, receivedDateTime);
            }
            if (isSearchEnabled) {
                if (headerMap.get("fsMailPath") != null) {
                    // empty if block
                }
                SearchIndex index = this.formMailSearchIndex(1, bluKryptElement, new ObjectId(backupId), fsPath, device.getId());
                index.setSubject(fileInfo.getSubject());
                index.setFrom(fileInfo.getFrom());
                index.setBodyContent(fileInfo.getBodyContent());
                index.setReceivedDateTime(fileInfo.getReceivedDateTime());
                index.setSentDateTime(fileInfo.getSentDateTime());
                index.setCcRecipients(fileInfo.getCcRecipients());
                index.setBccRecipients(fileInfo.getBccRecipients());
                index.setToRecipients(fileInfo.getToRecipients());
                index.setHasAttachments(fileInfo.isHasAttachments());
                index.setAttachments(fileInfo.getAttachments());
                index.setCcRecipientsAddr(fileInfo.getCcRecipientsAddr());
                index.setFromAddr(fileInfo.getFromAddr());
                index.setBccRecipientsAddr(fileInfo.getBccRecipientsAddr());
                index.setToRecipientsAddr(fileInfo.getToRecipientsAddr());
                logger.debug("....torecepientsaddress ......" + fileInfo.getToRecipientsAddr());
                index.setDeviceType(device.getDeviceType());
                index.setDeviceName(device.getDeviceName());
                this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                logger.debug(index.getDeviceUUID() + ".. end of adding search index...." + String.valueOf(index.getDeviceId()));
            }
            logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
        }
        catch (Exception e) {
            logger.error(BATCH_ID_LOG + batchId + " Exception While Uploading", (Throwable)e);
            int n = 500;
            return n;
        }
        finally {
            this.closeInputStreamAndDelTempFile(null, inputStream);
        }
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int uploadCalendar(Map<String, Object> headerMap, InputStream dataStream, int uploadCount, List<String> chunkMd5s, Cloud cloud, OfficeBackupPolicy backupPolicy, boolean isInPlaceArchive) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        InputStream inputStream = dataStream;
        logger.debug("Entering calendar upload!" + String.valueOf(headerMap.get("subject")));
        try {
            String deviceUUID = (String)headerMap.get("deviceUUID");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            String driveFileInfoId = (String)headerMap.get("driveFileInfoId");
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fsPath = CloudBackupController.getFsPath((String)headerMap.get("fileMD5"));
            String fileSizeInString = (String)headerMap.get("file-size");
            String chunkFilechecksum = (String)headerMap.get("chunkFileMD5");
            String chunkFileName = (String)headerMap.get("chunkFileName");
            batchId = (String)headerMap.get("backupBatchId");
            String indexPath = null;
            String isChunkOfAFile = "false";
            String checkSum = (String)headerMap.get("fileMD5");
            String prevBackupId = (String)headerMap.get("prevBackupId");
            String isCompressed1 = "false";
            String isNormalFile = "true";
            long fileSize = Long.parseLong(fileSizeInString);
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1 && backupPolicy.isContentIndexEnabled()) {
                isSearchEnabled = true;
            }
            if (isSearchEnabled) {
                indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            }
            logger.debug(BATCH_ID_LOG + batchId);
            ArrayList<String> list = new ArrayList<String>();
            boolean isMachineStorageReached = CloudBackupController.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                int n = 507;
                return n;
            }
            boolean isBlobFuseUnmounted = this.checkBlobFuseMounted(cloud.getCloudId(), cloud);
            if (isBlobFuseUnmounted) {
                int n = 410;
                return n;
            }
            cloudName = bluKryptElement.getCloudName();
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            logger.debug("!!!Obtained the device " + device.getDeviceUUID());
            ChunkFileElement chunkFileElement = CloudBackupController.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
            String sourceFilePath = (String)headerMap.get("file-path");
            String osType = "Microsoft OneDrive";
            int cloudId = cloud.getCloudId();
            logger.debug("index path" + indexPath);
            logger.debug(backupPolicy.isCompressionEnabled() + "...File name after creating the random uuid: " + chunkFileElement.getFileName());
            boolean isCompressedBool = backupPolicy.isCompressionEnabled();
            this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), inputStream, null, fileSize, chunkFileElement, sourceFilePath, osType, indexPath, batchId, isCompressedBool);
            chunkMd5s.add(chunkFileElement.getMd5checksum());
            logger.debug("Chunk file md5 list>>>>> " + chunkMd5s.size());
            checkSum = chunkFileElement.getMd5checksum();
            FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            logger.debug(" Before calling insert query mail...........");
            FileUploadDetailsElement fileUploadDetailsElement = this.insertEntryForBackupFromBK(headerMap, cloudName, bluKryptElement.getUserName(), bluKryptElement.getVersionsToKeep(), device, true, isCompressedBool);
            backupId = fileUploadDetailsElement.getBkpId();
            if (org.springframework.util.StringUtils.isEmpty((Object)backupId) || ALREADY_EXISTS.equalsIgnoreCase(backupId) || LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId) || backupId.contains(ALREADY_EXISTS_LINK) || backupId.contains(ALREADY_EXISTS)) {
                File file2;
                logger.debug(" Already exists!" + backupId);
                this.removeDriveItem(driveFileInfoId, true, deviceUUID);
                if (!org.springframework.util.StringUtils.isEmpty((Object)indexPath) && (file2 = new File(indexPath)).exists()) {
                    file2.delete();
                }
                if (LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                    int file2 = 200;
                    return file2;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)backupId) && backupId.contains(ALREADY_EXISTS)) {
                    int file2 = 200;
                    return file2;
                }
                int file2 = 409;
                return file2;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.info(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            logger.debug("backupid ---> " + backupId + "(" + org.springframework.util.StringUtils.isEmpty((Object)backupId) + ")");
            fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            fileInfo.setSubject((String)headerMap.get("subject"));
            fileInfo.setFrom((String)headerMap.get("from"));
            fileInfo.setBodyContent((String)headerMap.get("bodyContent"));
            if (headerMap.get("receivedDateTime") != null) {
                fileInfo.setReceivedDateTime(((Long)headerMap.get("receivedDateTime")).longValue());
            }
            if (headerMap.get("sentDateTime") != null) {
                fileInfo.setSentDateTime(((Long)headerMap.get("sentDateTime")).longValue());
            }
            fileInfo.setCcRecipients((String)headerMap.get("ccRecipients"));
            fileInfo.setBccRecipients((String)headerMap.get("bccRecipients"));
            fileInfo.setToRecipients((String)headerMap.get("toRecipients"));
            fileInfo.setHasAttachments(((Boolean)headerMap.get("hasAttachments")).booleanValue());
            fileInfo.setFromAddr((String)headerMap.get("fromAddr"));
            fileInfo.setCcRecipientsAddr((String)headerMap.get("ccRecipientsAddr"));
            fileInfo.setBccRecipientsAddr((String)headerMap.get("bccRecipientsAddr"));
            fileInfo.setToRecipientsAddr((String)headerMap.get("toRecipientsAddr"));
            if (fileInfo.isHasAttachments()) {
                fileInfo.setAttachments((List)headerMap.get("attachments"));
            }
            if (headerMap.get("toRecipientsAddress") != null) {
                fileInfo.setToRecipientsAddress((List)headerMap.get("toRecipientsAddress"));
            }
            if (headerMap.get("ccRecipientsAddress") != null) {
                fileInfo.setCcRecipientsAddress((List)headerMap.get("ccRecipientsAddress"));
            }
            if (headerMap.get("bccRecipientsAddress") != null) {
                fileInfo.setBccRecipientsAddress((List)headerMap.get("bccRecipientsAddress"));
            }
            if (headerMap.get("fromEmailAddress") != null) {
                fileInfo.setFromEmailAddress((OutlookEmailAddress)headerMap.get("fromEmailAddress"));
            }
            ArrayList<String> orgChunks = list;
            fileInfo.setSize(Long.valueOf(fileSize));
            if (!org.springframework.util.StringUtils.isEmpty((Object)headerMap.get(JOB_ID))) {
                fileInfo.setServerBackupJobId((String)headerMap.get(JOB_ID));
            }
            if (isCompressedBool) {
                fileInfo.setCompressed(isCompressedBool);
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)chunkFilechecksum)) {
                List<String> resChunkList = this.getBackupIdAppendedToChunks(list, backupId);
                fileInfo.getChunkFiles().clear();
                fileInfo.getChunkFiles().addAll(resChunkList);
            }
            fileInfo.setBatchId(batchId);
            logger.debug("..batchidpath...." + batchId);
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, fileInfo.getBatchId());
            logger.debug("orgchunks list>>" + orgChunks.size());
            boolean isFullBackup = true;
            boolean fileExists = false;
            logger.debug(fileUploadDetailsElement.getFileSize() + "Chunk file path --" + chunkPath + " size ->" + orgChunks.size());
            this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath, fileInfo.getBatchId());
            this.updateMailStorageUtilization(deviceUUID, fileUploadDetailsElement);
            fileInfo.setReducePGSize(true);
            HashedMap urlSetMap = new HashedMap();
            boolean isLocalSaveSuccess = this.uploadService.saveFileInfoForODB(cloudName, bluKryptElement.getUserName(), fileInfo, driveFileInfoId, true);
            logger.debug(isCompressedBool + "...savelocalsuccess..." + isLocalSaveSuccess);
            logger.debug(fileInfo.isCompressed() + ".....mail isSearchEnabled....");
            logger.debug(".....calendar ....");
            if (isSearchEnabled) {
                if (headerMap.get("fsMailPath") != null) {
                    fsPath = (String)headerMap.get("fsMailPath");
                    logger.debug("....updated-path...." + fsPath);
                }
                SearchIndex index = this.formCalendarSearchIndex(1, fileInfo, new ObjectId(backupId), fsPath, device.getId(), cloudName);
                if (headerMap.get("calendarDuration") != null) {
                    index.setCalendarDuration(headerMap.get("calendarDuration").toString());
                }
                if (headerMap.get("calendarStartDate") != null) {
                    index.setCalendarStartDate(headerMap.get("calendarStartDate").toString());
                }
                if (headerMap.get("calendarEndDate") != null) {
                    index.setCalendarEndDate(headerMap.get("calendarEndDate").toString());
                }
                index.setSubject(fileInfo.getSubject());
                index.setFrom(fileInfo.getFrom());
                index.setBodyContent(fileInfo.getBodyContent());
                index.setCcRecipients(fileInfo.getCcRecipients());
                index.setBccRecipients(fileInfo.getBccRecipients());
                index.setToRecipients(fileInfo.getToRecipients());
                index.setHasAttachments(fileInfo.isHasAttachments());
                index.setAttachments(fileInfo.getAttachments());
                index.setCcRecipientsAddr(fileInfo.getCcRecipientsAddr());
                index.setFromAddr(fileInfo.getFromAddr());
                index.setBccRecipientsAddr(fileInfo.getBccRecipientsAddr());
                index.setToRecipientsAddr(fileInfo.getToRecipientsAddr());
                logger.debug("....torecepientsaddress ......" + fileInfo.getToRecipientsAddr());
                index.setDeviceType(device.getDeviceType());
                index.setDeviceName(device.getDeviceName());
                this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                logger.debug(index.getDeviceUUID() + ".. end of adding search index...." + String.valueOf(index.getDeviceId()));
            }
            logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
        }
        catch (Exception e) {
            logger.error(BATCH_ID_LOG + batchId + " Exception While Uploading", (Throwable)e);
            int n = 500;
            return n;
        }
        finally {
            this.closeInputStreamAndDelTempFile(null, inputStream);
        }
        return 200;
    }

    private void createCMBackupImage(Cloud cloud, String destCollection, BackUpImage backUpImage, long recieveDateTime) {
        CMBackUpImage cmBackUpImage = new CMBackUpImage();
        BeanUtils.copyProperties((Object)backUpImage, (Object)cmBackUpImage);
        cmBackUpImage.setId(backUpImage.getId());
        cmBackUpImage.setLastModifiedTime(recieveDateTime);
        cmBackUpImage.setDeviceType(Device.TYPE.OUTLOOK.name());
        cmBackUpImage.setTimeStampUpdated(true);
        this.utilService.saveCapacityMgmtImage(cloud.getCloudId(), cmBackUpImage, destCollection, cmBackUpImage.getDeviceType());
    }

    private static String txtToHtml(String s) {
        logger.debug("...converting txt to html....");
        StringBuilder builder = new StringBuilder();
        boolean previousWasASpace = false;
        try {
            block10: for (char c : s.toCharArray()) {
                switch (c) {
                    case ' ': {
                        if (previousWasASpace) {
                            builder.append("&nbsp;");
                        } else {
                            builder.append(' ');
                        }
                        previousWasASpace = !previousWasASpace;
                        continue block10;
                    }
                    case '<': {
                        builder.append("&lt;");
                        continue block10;
                    }
                    case '>': {
                        builder.append("&gt;");
                        continue block10;
                    }
                    case '\"': {
                        builder.append("&quot;");
                        continue block10;
                    }
                    case '\n': {
                        builder.append("<br>");
                        continue block10;
                    }
                    case '\t': {
                        builder.append("&nbsp;&nbsp;&nbsp;");
                        continue block10;
                    }
                    default: {
                        builder.append(c);
                        previousWasASpace = false;
                    }
                }
            }
            String converted = builder.toString();
            String regex = "(?i)\\b((https?://|www\\.)\\S+)";
            converted = converted.replaceAll(regex, "<a href=\"$1\">$1</a>");
            return converted;
        }
        catch (Exception e) {
            logger.error("Unable to process text to HTML conversion: {}", (Object)e.getMessage(), (Object)e);
            return "ERROR-CASE";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String txtToHtmlWithTimeout(String s) {
        String str = "";
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<String> future = executor.submit(() -> CloudBackupController.txtToHtml(s));
        try {
            str = future.get(1L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            logger.error("Processing timed out after 2 minutes");
            str = "ERROR-CASE";
        }
        catch (Exception e) {
            logger.error("An error occurred: " + e.getMessage(), (Throwable)e);
            str = "ERROR-CASE";
        }
        finally {
            executor.shutdownNow();
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int uploadContacts(Map<String, Object> headerMap, InputStream dataStream, int uploadCount, List<String> chunkMd5s, Cloud cloud, OfficeBackupPolicy backupPolicy) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        InputStream inputStream = dataStream;
        logger.debug("Entering Contacts upload!");
        try {
            String deviceUUID = (String)headerMap.get("deviceUUID");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            bluKryptElement.setFilePath("Contacts");
            String driveFileInfoId = (String)headerMap.get("driveFileInfoId");
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fileSizeInString = (String)headerMap.get("file-size");
            String chunkFilechecksum = (String)headerMap.get("chunkFileMD5");
            String chunkFileName = (String)headerMap.get("chunkFileName");
            batchId = (String)headerMap.get("backupBatchId");
            String isChunkOfAFile = "false";
            String checkSum = (String)headerMap.get("fileMD5");
            String prevBackupId = (String)headerMap.get("prevBackupId");
            String isCompressed = "false";
            String isNormalFile = "true";
            long fileSize = Long.parseLong(fileSizeInString);
            logger.debug(BATCH_ID_LOG + batchId);
            ArrayList<String> list = new ArrayList<String>();
            boolean isMachineStorageReached = CloudBackupController.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                int n = 507;
                return n;
            }
            boolean isBlobFuseUnmounted = this.checkBlobFuseMounted(cloud.getCloudId(), cloud);
            if (isBlobFuseUnmounted) {
                int n = 410;
                return n;
            }
            cloudName = bluKryptElement.getCloudName();
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            logger.debug("!!!Obtained the device " + device.getDeviceUUID());
            ChunkFileElement chunkFileElement = CloudBackupController.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
            String sourceFilePath = (String)headerMap.get("file-path");
            String osType = "Microsoft OneDrive";
            String fsPath = CloudBackupController.getFsPath((String)headerMap.get("fileMD5"));
            String indexPath = null;
            int cloudId = cloud.getCloudId();
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1 && backupPolicy.isContentIndexEnabled()) {
                isSearchEnabled = true;
            }
            if (isSearchEnabled) {
                indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            }
            logger.debug(".....isSearchEnabled...." + isSearchEnabled);
            logger.debug("index path" + indexPath);
            logger.debug("File name after creating the random uuid: " + chunkFileElement.getFileName());
            this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), inputStream, null, fileSize, chunkFileElement, sourceFilePath, osType, indexPath, batchId, false);
            chunkMd5s.add(chunkFileElement.getMd5checksum());
            logger.debug("Chunk file md5 list>>>>> " + chunkMd5s.size());
            checkSum = chunkFileElement.getMd5checksum();
            logger.debug(" Before calling insert query mail...........");
            FileUploadDetailsElement fileUploadDetailsElement = this.insertEntryForBackupFromBK(headerMap, cloudName, bluKryptElement.getUserName(), bluKryptElement.getVersionsToKeep(), device, true, false);
            backupId = fileUploadDetailsElement.getBkpId();
            if (org.springframework.util.StringUtils.isEmpty((Object)backupId) || ALREADY_EXISTS.equalsIgnoreCase(backupId) || LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                logger.debug(" Already exists!" + backupId);
                this.removeDriveItem(driveFileInfoId, true, deviceUUID);
                if (LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                    int n = 200;
                    return n;
                }
                int n = 409;
                return n;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.info(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            logger.debug("backupid ---> " + backupId + "(" + org.springframework.util.StringUtils.isEmpty((Object)backupId) + ")");
            FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            if (headerMap.get("hasAttachments") == null) {
                headerMap.put("hasAttachments", false);
            }
            logger.debug("..attachphoto...." + String.valueOf(headerMap.get("hasAttachments")));
            fileInfo.setHasAttachments(((Boolean)headerMap.get("hasAttachments")).booleanValue());
            fileInfo.setSubject((String)headerMap.get("subject"));
            fileInfo.setFrom((String)headerMap.get("from"));
            logger.debug("......mob...." + String.valueOf(headerMap.get("contactMobile")));
            if (headerMap.get("contactMobile") != null) {
                fileInfo.setContactMobile((String)headerMap.get("contactMobile"));
            }
            this.setContactDetailsFileInfo(headerMap, fileInfo);
            if (headerMap.get("contactAddrStreet") != null) {
                fileInfo.setContactAddrStreet((String)headerMap.get("contactAddrStreet"));
            }
            if (headerMap.get("contactAddrCity") != null) {
                fileInfo.setContactAddrCity((String)headerMap.get("contactAddrCity"));
            }
            if (headerMap.get("contactAddrState") != null) {
                fileInfo.setContactAddrState((String)headerMap.get("contactAddrState"));
            }
            if (headerMap.get("contactAddrCountry") != null) {
                fileInfo.setContactAddrCountry((String)headerMap.get("contactAddrCountry"));
            }
            if (headerMap.get("contactAddrPostalCode") != null) {
                fileInfo.setContactAddrPostalCode((String)headerMap.get("contactAddrPostalCode"));
            }
            if (fileInfo.isHasAttachments()) {
                fileInfo.setAttachments((List)headerMap.get("attachments"));
            }
            ArrayList<String> orgChunks = list;
            fileInfo.setSize(Long.valueOf(fileSize));
            if (!org.springframework.util.StringUtils.isEmpty((Object)headerMap.get(JOB_ID))) {
                fileInfo.setServerBackupJobId((String)headerMap.get(JOB_ID));
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)isCompressed)) {
                fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)chunkFilechecksum)) {
                List<String> resChunkList = this.getBackupIdAppendedToChunks(list, backupId);
                fileInfo.getChunkFiles().clear();
                fileInfo.getChunkFiles().addAll(resChunkList);
            }
            fileInfo.setBatchId(batchId);
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, fileInfo.getBatchId());
            logger.debug("orgchunks list>>" + orgChunks.size());
            boolean isFullBackup = true;
            boolean fileExists = false;
            logger.debug(fileUploadDetailsElement.getFileSize() + "Chunk file path --" + chunkPath + " size ->" + orgChunks.size());
            this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath, fileInfo.getBatchId());
            this.updateMailStorageUtilization(deviceUUID, fileUploadDetailsElement);
            fileInfo.setReducePGSize(true);
            boolean isLocalSaveSuccess = this.uploadService.saveFileInfoForODB(cloudName, bluKryptElement.getUserName(), fileInfo, driveFileInfoId, true);
            logger.debug("...savelocalsuccess..." + isLocalSaveSuccess);
            logger.debug(".....mail isSearchEnabled...." + isSearchEnabled);
            if (isSearchEnabled) {
                if (headerMap.get("fsMailPath") != null) {
                    fsPath = (String)headerMap.get("fsMailPath");
                    logger.debug("....updated-path...." + fsPath);
                }
                SearchIndex index = this.formContactsSearchIndex(1, fileInfo, new ObjectId(backupId), fsPath, device.getId(), cloudName);
                index.setSubject(fileInfo.getSubject());
                index.setFrom(fileInfo.getFrom());
                index.setBodyContent(fileInfo.getBodyContent());
                index.setCcRecipients(fileInfo.getCcRecipients());
                index.setBccRecipients(fileInfo.getBccRecipients());
                index.setToRecipients(fileInfo.getToRecipients());
                index.setHasAttachments(fileInfo.isHasAttachments());
                index.setAttachments(fileInfo.getAttachments());
                index.setCcRecipientsAddr(fileInfo.getCcRecipientsAddr());
                index.setFromAddr(fileInfo.getFromAddr());
                index.setBccRecipientsAddr(fileInfo.getBccRecipientsAddr());
                index.setToRecipientsAddr(fileInfo.getToRecipientsAddr());
                logger.debug("....torecepientsaddress ......" + fileInfo.getToRecipientsAddr());
                index.setDeviceType(device.getDeviceType());
                index.setDeviceName(device.getDeviceName());
                this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                logger.debug(index.getDeviceUUID() + ".. end of adding search index...." + String.valueOf(index.getDeviceId()));
            }
            logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            logger.error(BATCH_ID_LOG + batchId + " Exception While Uploading", (Throwable)e);
            int n = 500;
            return n;
        }
        finally {
            this.closeInputStreamAndDelTempFile(null, inputStream);
        }
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int uploadTasks(Map<String, Object> headerMap, InputStream dataStream, int uploadCount, List<String> chunkMd5s, Cloud cloud, OfficeBackupPolicy backupPolicy) {
        String backupId = "";
        String cloudName = "";
        String batchId = "";
        InputStream inputStream = dataStream;
        logger.debug("Entering Contacts upload!");
        try {
            String deviceUUID = (String)headerMap.get("deviceUUID");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(headerMap);
            String taskListName = (String)headerMap.get("taskListName");
            bluKryptElement.setFilePath("To Do/" + taskListName);
            headerMap.put("file-path", bluKryptElement.getFilePath());
            String driveFileInfoId = (String)headerMap.get("driveFileInfoId");
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
            }
            String fileSizeInString = (String)headerMap.get("file-size");
            String chunkFilechecksum = (String)headerMap.get("chunkFileMD5");
            String chunkFileName = (String)headerMap.get("chunkFileName");
            batchId = (String)headerMap.get("backupBatchId");
            String checkSum = (String)headerMap.get("fileMD5");
            String prevBackupId = (String)headerMap.get("prevBackupId");
            String isCompressed = "false";
            long fileSize = Long.parseLong(fileSizeInString);
            logger.debug(String.valueOf(headerMap.get("taskSubject")) + "....##batch id >>>>" + batchId);
            ArrayList<String> list = new ArrayList<String>();
            boolean isMachineStorageReached = CloudBackupController.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                int n = 507;
                return n;
            }
            boolean isBlobFuseUnmounted = this.checkBlobFuseMounted(cloud.getCloudId(), cloud);
            if (isBlobFuseUnmounted) {
                int n = 410;
                return n;
            }
            cloudName = bluKryptElement.getCloudName();
            Device device = this.utilService.getDeviceForUUID(cloud.getCloudId(), deviceUUID);
            logger.debug("!!!Obtained the device " + device.getDeviceUUID());
            ChunkFileElement chunkFileElement = CloudBackupController.createChunkFileElement(deviceUUID, bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
            String sourceFilePath = (String)headerMap.get("file-path");
            String osType = "Microsoft OneDrive";
            String fsPath = CloudBackupController.getFsPath((String)headerMap.get("fileMD5"));
            String indexPath = null;
            int cloudId = cloud.getCloudId();
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1 && backupPolicy.isContentIndexEnabled()) {
                isSearchEnabled = true;
            }
            if (isSearchEnabled) {
                indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            }
            logger.debug(".....isSearchEnabled...." + isSearchEnabled);
            logger.debug("index path" + indexPath);
            logger.debug("File name after creating the random uuid: " + chunkFileElement.getFileName());
            this.checkNThrottleAndUploadFileV2(cloudName, bluKryptElement.getGatewayName(), inputStream, null, fileSize, chunkFileElement, sourceFilePath, osType, indexPath, batchId, false);
            chunkMd5s.add(chunkFileElement.getMd5checksum());
            logger.debug("Chunk file md5 list>>>>> " + chunkMd5s.size());
            checkSum = chunkFileElement.getMd5checksum();
            logger.debug(" Before calling insert query mail...........");
            FileUploadDetailsElement fileUploadDetailsElement = this.insertEntryForBackupFromBK(headerMap, cloudName, bluKryptElement.getUserName(), bluKryptElement.getVersionsToKeep(), device, true, false);
            backupId = fileUploadDetailsElement.getBkpId();
            if (org.springframework.util.StringUtils.isEmpty((Object)backupId) || ALREADY_EXISTS.equalsIgnoreCase(backupId) || LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                logger.debug(" Already exists!" + backupId);
                this.removeDriveItem(driveFileInfoId, true, deviceUUID);
                if (LARGE_MONGO_ENTRY.equalsIgnoreCase(backupId)) {
                    int n = 200;
                    return n;
                }
                int n = 409;
                return n;
            }
            if (CollectionUtils.isEmpty(list)) {
                logger.info(BATCH_ID_LOG + batchId + " List is empty sooo adding md5checksum" + checkSum);
                list.add(checkSum);
            }
            logger.debug("backupid ---> " + backupId + "(" + org.springframework.util.StringUtils.isEmpty((Object)backupId) + ")");
            FileInfo fileInfo = this.getFileInfo(bluKryptElement, backupId, prevBackupId, list);
            logger.debug("..attachphoto...." + String.valueOf(headerMap.get("hasAttachments")));
            if (headerMap.get("hasAttachments") != null) {
                fileInfo.setHasAttachments(((Boolean)headerMap.get("hasAttachments")).booleanValue());
            }
            fileInfo.setSubject((String)headerMap.get("subject"));
            fileInfo.setFrom((String)headerMap.get("from"));
            if (fileInfo.isHasAttachments()) {
                fileInfo.setAttachments((List)headerMap.get("attachments"));
            }
            ArrayList<String> orgChunks = list;
            fileInfo.setSize(Long.valueOf(fileSize));
            if (!org.springframework.util.StringUtils.isEmpty((Object)headerMap.get(JOB_ID))) {
                fileInfo.setServerBackupJobId((String)headerMap.get(JOB_ID));
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)isCompressed)) {
                fileInfo.setCompressed(Boolean.valueOf(isCompressed).booleanValue());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)chunkFilechecksum)) {
                List<String> resChunkList = this.getBackupIdAppendedToChunks(list, backupId);
                fileInfo.getChunkFiles().clear();
                fileInfo.getChunkFiles().addAll(resChunkList);
            }
            fileInfo.setBatchId(batchId);
            if (headerMap.get("taskStartDate") != null) {
                fileInfo.setTaskStartDate((Date)headerMap.get("taskStartDate"));
            }
            if (headerMap.get("taskDueDate") != null) {
                fileInfo.setTaskDueDate((Date)headerMap.get("taskDueDate"));
            }
            if (headerMap.get("taskReminderTime") != null) {
                fileInfo.setTaskReminderTime((Date)headerMap.get("taskReminderTime"));
            }
            if (headerMap.get("taskSubject") != null) {
                fileInfo.setTaskSubject((String)headerMap.get("taskSubject"));
                fileInfo.setFileName((String)headerMap.get("taskSubject"));
            }
            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, fileInfo.getBatchId());
            logger.debug("orgchunks list>>" + orgChunks.size());
            boolean isFullBackup = true;
            boolean fileExists = false;
            logger.debug(fileUploadDetailsElement.getFileSize() + "Chunk file path --" + chunkPath + " size ->" + orgChunks.size());
            this.moveFilesFromTmpPath(deviceUUID, orgChunks, chunkPath, fileInfo.getBatchId());
            this.updateMailStorageUtilization(deviceUUID, fileUploadDetailsElement);
            fileInfo.setReducePGSize(true);
            boolean isLocalSaveSuccess = this.uploadService.saveFileInfoForODB(cloudName, bluKryptElement.getUserName(), fileInfo, driveFileInfoId, true);
            logger.debug("...savelocalsuccess..." + isLocalSaveSuccess);
            logger.debug(".....mail isSearchEnabled...." + isSearchEnabled);
            if (isSearchEnabled) {
                if (headerMap.get("fsMailPath") != null) {
                    fsPath = (String)headerMap.get("fsMailPath");
                    logger.debug("....updated-path...." + fsPath);
                }
                SearchIndex index = this.formTaskSearchIndex(1, fileInfo, new ObjectId(backupId), fsPath, device.getId(), cloudName);
                index.setSubject(fileInfo.getSubject());
                index.setFrom(fileInfo.getFrom());
                index.setBodyContent(fileInfo.getBodyContent());
                index.setCcRecipients(fileInfo.getCcRecipients());
                index.setBccRecipients(fileInfo.getBccRecipients());
                index.setToRecipients(fileInfo.getToRecipients());
                index.setHasAttachments(fileInfo.isHasAttachments());
                index.setAttachments(fileInfo.getAttachments());
                index.setCcRecipientsAddr(fileInfo.getCcRecipientsAddr());
                index.setFromAddr(fileInfo.getFromAddr());
                index.setBccRecipientsAddr(fileInfo.getBccRecipientsAddr());
                index.setToRecipientsAddr(fileInfo.getToRecipientsAddr());
                logger.debug("....torecepientsaddress ......" + fileInfo.getToRecipientsAddr());
                index.setDeviceType(device.getDeviceType());
                index.setDeviceName(device.getDeviceName());
                this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                logger.debug(index.getDeviceUUID() + ".. end of adding search index...." + String.valueOf(index.getDeviceId()));
            }
            logger.debug(BATCH_ID_LOG + batchId + " End of uploading multi part file...........");
        }
        catch (Exception e) {
            logger.error(BATCH_ID_LOG + batchId + " Exception While Uploading", (Throwable)e);
            int n = 500;
            return n;
        }
        finally {
            this.closeInputStreamAndDelTempFile(null, inputStream);
        }
        return 200;
    }

    protected SearchIndex formSearchIndex(int cloudId, BluKryptElement bluKryptElement, ObjectId consId, String fsPath, ObjectId deviceId) {
        SearchIndex searchIndex = new SearchIndex();
        searchIndex.setCloudId(cloudId);
        searchIndex.setBackup(false);
        searchIndex.setConsolidatedImageId(consId);
        searchIndex.setPresent(true);
        searchIndex.setCloudName(bluKryptElement.getCloudName());
        searchIndex.setAbstractFolderUrl(bluKryptElement.getFileCompletePath());
        searchIndex.setFileName(bluKryptElement.getFileName());
        searchIndex.setFolder(false);
        searchIndex.setSize(String.valueOf(bluKryptElement.getFileSize()));
        searchIndex.setLastModifiedTime(String.valueOf(System.currentTimeMillis()));
        searchIndex.setFsPath(fsPath);
        searchIndex.setMiniCloud(false);
        searchIndex.setUserName(bluKryptElement.getUserName());
        searchIndex.setStatus("ACTIVE");
        searchIndex.setOneDrive(true);
        searchIndex.setDeviceUUID(bluKryptElement.getDeviceUUID());
        searchIndex.setDeviceId(deviceId);
        return searchIndex;
    }

    protected SearchIndex formSpSearchIndex(int cloudId, BluKryptElement bluKryptElement, ObjectId consId, String fsPath, ObjectId deviceId) {
        SearchIndex searchIndex = new SearchIndex();
        searchIndex.setBackup(false);
        searchIndex.setCloudId(cloudId);
        searchIndex.setConsolidatedImageId(consId);
        searchIndex.setPresent(true);
        searchIndex.setCloudName(bluKryptElement.getCloudName());
        searchIndex.setAbstractFolderUrl(bluKryptElement.getFileCompletePath());
        searchIndex.setFileName(bluKryptElement.getFileName());
        searchIndex.setFolder(false);
        searchIndex.setSize(String.valueOf(bluKryptElement.getFileSize()));
        searchIndex.setLastModifiedTime(String.valueOf(System.currentTimeMillis()));
        searchIndex.setFsPath(fsPath);
        searchIndex.setMiniCloud(false);
        searchIndex.setUserName(bluKryptElement.getUserName());
        searchIndex.setStatus("ACTIVE");
        searchIndex.setSharePoint(true);
        searchIndex.setDeviceUUID(bluKryptElement.getDeviceUUID());
        searchIndex.setDeviceId(deviceId);
        return searchIndex;
    }

    protected SearchIndex formMailSearchIndex(int cloudId, BluKryptElement bluKryptElement, ObjectId consId, String fsPath, ObjectId deviceId) {
        SearchIndex searchIndex = new SearchIndex();
        searchIndex.setBackup(false);
        searchIndex.setCloudId(cloudId);
        searchIndex.setConsolidatedImageId(consId);
        searchIndex.setPresent(true);
        searchIndex.setCloudName(bluKryptElement.getCloudName());
        searchIndex.setAbstractFolderUrl(bluKryptElement.getFileCompletePath());
        searchIndex.setFileName(bluKryptElement.getFileName());
        searchIndex.setFolder(false);
        searchIndex.setSize(String.valueOf(bluKryptElement.getFileSize()));
        searchIndex.setLastModifiedTime(String.valueOf(System.currentTimeMillis()));
        searchIndex.setFsPath(fsPath);
        searchIndex.setMiniCloud(false);
        searchIndex.setUserName(bluKryptElement.getUserName());
        searchIndex.setStatus("ACTIVE");
        searchIndex.setMail(true);
        searchIndex.setDeviceUUID(bluKryptElement.getDeviceUUID());
        searchIndex.setDeviceId(deviceId);
        return searchIndex;
    }

    protected SearchIndex formContactsSearchIndex(int cloudId, FileInfo fileInfo, ObjectId consId, String fsPath, ObjectId deviceId, String cloudName) {
        SearchIndex searchIndex = new SearchIndex();
        BeanUtils.copyProperties((Object)fileInfo, (Object)searchIndex);
        searchIndex.setBackup(false);
        searchIndex.setCloudId(cloudId);
        searchIndex.setConsolidatedImageId(consId);
        searchIndex.setPresent(true);
        searchIndex.setCloudName(cloudName);
        searchIndex.setFileName(fileInfo.getFileName());
        searchIndex.setFolder(false);
        searchIndex.setLastModifiedTime(String.valueOf(System.currentTimeMillis()));
        searchIndex.setFsPath(fsPath);
        searchIndex.setMiniCloud(false);
        searchIndex.setUserName(fileInfo.getUserName());
        searchIndex.setStatus("ACTIVE");
        searchIndex.setContacts(true);
        searchIndex.setDeviceUUID(fileInfo.getDeviceUUID());
        searchIndex.setDeviceId(deviceId);
        return searchIndex;
    }

    protected SearchIndex formTaskSearchIndex(int cloudId, FileInfo fileInfo, ObjectId consId, String fsPath, ObjectId deviceId, String cloudName) {
        SearchIndex searchIndex = new SearchIndex();
        BeanUtils.copyProperties((Object)fileInfo, (Object)searchIndex);
        searchIndex.setBackup(false);
        searchIndex.setCloudId(cloudId);
        searchIndex.setConsolidatedImageId(consId);
        searchIndex.setPresent(true);
        searchIndex.setCloudName(cloudName);
        searchIndex.setFileName(fileInfo.getFileName());
        searchIndex.setFolder(false);
        searchIndex.setLastModifiedTime(String.valueOf(System.currentTimeMillis()));
        searchIndex.setFsPath(fsPath);
        searchIndex.setMiniCloud(false);
        searchIndex.setUserName(fileInfo.getUserName());
        searchIndex.setStatus("ACTIVE");
        searchIndex.setTask(true);
        searchIndex.setDeviceUUID(fileInfo.getDeviceUUID());
        searchIndex.setDeviceId(deviceId);
        return searchIndex;
    }

    protected SearchIndex formCalendarSearchIndex(int cloudId, FileInfo fileInfo, ObjectId consId, String fsPath, ObjectId deviceId, String cloudName) {
        SearchIndex searchIndex = new SearchIndex();
        BeanUtils.copyProperties((Object)fileInfo, (Object)searchIndex);
        searchIndex.setBackup(false);
        searchIndex.setCloudId(cloudId);
        searchIndex.setConsolidatedImageId(consId);
        searchIndex.setPresent(true);
        searchIndex.setCloudName(cloudName);
        searchIndex.setFileName(fileInfo.getFileName());
        searchIndex.setFolder(false);
        searchIndex.setLastModifiedTime(String.valueOf(System.currentTimeMillis()));
        searchIndex.setFsPath(fsPath);
        searchIndex.setMiniCloud(false);
        searchIndex.setUserName(fileInfo.getUserName());
        searchIndex.setStatus("ACTIVE");
        searchIndex.setCalendar(true);
        searchIndex.setDeviceUUID(fileInfo.getDeviceUUID());
        searchIndex.setDeviceId(deviceId);
        return searchIndex;
    }

    private void updateStorageUtilization(String cloudName, String batchId, String deviceUUID, List<String> list, FileUploadDetailsElement fileUploadDetailsElement) {
        long pgChunkSize = 0L;
        if (!CollectionUtils.isEmpty(list)) {
            Object chunkFolderPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
            chunkFolderPath = (String)chunkFolderPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            for (String chunkName : list) {
                try {
                    File file = new File((String)chunkFolderPath + chunkName).getAbsoluteFile();
                    pgChunkSize += file.length() / 1024L;
                }
                catch (Exception e) {
                    logger.debug(".......Exception...." + e.getMessage());
                }
            }
        }
        logger.debug("..................total pgChunkSizeInKB............" + pgChunkSize);
        this.utilService.updateStorageUtilized(1, deviceUUID, fileUploadDetailsElement.getFileSize(), fileUploadDetailsElement.getLatestVersionSize(), pgChunkSize);
    }

    private void updateMailStorageUtilization(String deviceUUID, FileUploadDetailsElement fileUploadDetailsElement) {
        long pgChunkSize = fileUploadDetailsElement.getFileSize();
        logger.debug("..................total pgChunkSizeInKB............" + pgChunkSize);
        this.utilService.updateStorageUtilized(1, deviceUUID, fileUploadDetailsElement.getFileSize(), fileUploadDetailsElement.getLatestVersionSize(), pgChunkSize);
    }

    public static String getPropertyFileValueParabluFolderBasePath(String cloudName) {
        return PCHelperConstant.getPropertyFileValueParacloudMountPoint() + cloudName + "/f/";
    }

    public static String getFsPath(String md5) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd-MM-yyyy");
        Date date = new Date();
        String baseFolder = sdfDate.format(date) + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + String.valueOf(date.getTime());
        String fileName = md5;
        return baseFolder + fileName;
    }

    @Override
    public void removeDriveItem(String driveFileInfoId, boolean isMail, String deviceUUID) {
        this.uploadService.removeFileInfoForAlreadyExists(driveFileInfoId, isMail, deviceUUID);
    }

    public boolean initialize() {
        boolean success = true;
        if (CloudBackupController.getContext() == null) {
            logger.info("Application context not set!");
            return false;
        }
        try {
            if (this.backupService == null) {
                this.backupService = (BackupService)CloudBackupController.getContext().getBean("BackupServiceImpl", BackupService.class);
                if (this.backupService == null) {
                    success = false;
                    logger.error("failed to get backupService");
                }
            }
            if (this.utilService == null) {
                this.utilService = (UtilService)CloudBackupController.getContext().getBean("UtilServiceImpl", UtilService.class);
                if (this.utilService == null) {
                    success = false;
                    logger.error("failed to get utilService");
                }
            }
            if (this.uploadService == null) {
                this.uploadService = (UploadService)CloudBackupController.getContext().getBean("UploadService", UploadService.class);
                if (this.uploadService == null) {
                    success = false;
                    logger.error("failed to get chunkableUploadService");
                }
            }
            if (this.chunkableUploadService == null) {
                this.chunkableUploadService = (ChunkableUploadService)CloudBackupController.getContext().getBean("ChunkableUploadService", ChunkableUploadService.class);
                if (this.chunkableUploadService != null) {
                    success = false;
                    logger.error("failed to get chunkableUploadService");
                }
            }
            if (this.componentSettingService == null) {
                this.componentSettingService = (ComponentSettingService)CloudBackupController.getContext().getBean("ComponentSettingServiceImpl", ComponentSettingService.class);
                if (this.componentSettingService == null) {
                    success = false;
                    logger.error("failed to get componentSettingService");
                }
            }
            if (this.jobConfigService == null) {
                this.jobConfigService = (JobConfigService)CloudBackupController.getContext().getBean("JobConfigServiceImpl", JobConfigService.class);
                if (this.jobConfigService == null) {
                    success = false;
                    logger.error("failed to get jobConfigService");
                }
            }
            if (this.retryService == null) {
                this.retryService = (RetryService)CloudBackupController.getContext().getBean("RetryServiceImpl", RetryService.class);
                if (this.retryService == null) {
                    success = false;
                    logger.error("failed to get retryService");
                }
            }
            if (this.retryPolicyFactory == null) {
                this.retryPolicyFactory = (RetryPolicyFactory)CloudBackupController.getContext().getBean("RetryPolicyFactory", RetryPolicyFactory.class);
                if (this.retryPolicyFactory == null) {
                    success = false;
                    logger.error("failed to get utilService");
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            e.printStackTrace(System.out);
            success = false;
        }
        return success;
    }

    @Override
    public void run() {
        try {
            logger.info("Invoking storage service!");
            try {
                sem.acquire(1);
            }
            catch (InterruptedException e) {
                logger.error("Failed to acquire semaphore! ", (Throwable)e);
            }
            Thread.sleep(100L);
            logger.info("Invoking storage service!");
            if (!StorageService.GETINST.initialize(this, this.utilService, this.componentSettingService, this.jobConfigService)) {
                logger.error("Failed to init storage service!");
                return;
            }
            if (!OfficeRestoreService.GETINST.initialize(this, this.utilService, this.syncDownloadService, this.downloadService, this.backupFileDao, this.externalStorageBackupFileDao)) {
                logger.error("Failed to init OfficeRestoreService  service!");
                return;
            }
            OfficeRestoreService.GETINST.run();
            StorageService.GETINST.run();
            logger.info("^^^^^^^^^^^^^^DONE^^^^^^^^^^^^^^^^^^^");
        }
        catch (InterruptedException e) {
            logger.error("Woke up!", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Something bad happened while executing test", (Throwable)e);
        }
    }

    UploadStatus uploadAsync(UploadStatus status, Map<String, Object> fileProperties, com.parablu.pcbd.domain.User user) {
        block381: {
            long fileSize = 0L;
            Cloud cloud = this.utilService.getCloud(1);
            String currentUploadIPToUse = PCHelperConstant.getComponentName();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("gatewayName", currentUploadIPToUse);
            parameters.put("dedupifiedBackupId", "false");
            parameters.put("maxVersions", String.valueOf("10"));
            parameters.put("is-base-folder", String.valueOf(false));
            parameters.put("is-folder", String.valueOf(false));
            parameters.put("is-exists", String.valueOf(true));
            String batchId = (String)fileProperties.get("backupBatchId");
            parameters.put("backupBatchId", batchId);
            parameters.put("userUnderLegalHold", String.valueOf(true));
            parameters.put("userName", (String)fileProperties.get("userName"));
            String deviceUUID = (String)fileProperties.get("deviceUUID");
            parameters.put("deviceUUID", deviceUUID);
            parameters.put("file-path", (String)fileProperties.get("file-path"));
            parameters.put("file-name", (String)fileProperties.get("file-name"));
            parameters.put("driveFileInfoId", (String)fileProperties.get("driveFileInfoId"));
            String messageId = (String)fileProperties.get("itemID");
            parameters.put("odItemId", messageId);
            logger.debug(String.valueOf(fileProperties.get("versionId")) + ".... parent id set for parameter.... " + String.valueOf(fileProperties.get("parentItemID")));
            if (fileProperties.get("parentItemID") != null) {
                parameters.put("parentItemID", (String)fileProperties.get("parentItemID"));
            }
            if (fileProperties.get("versionId") != null) {
                parameters.put("versionId", (String)fileProperties.get("versionId"));
            }
            String cloudName = cloud.getCloudName();
            parameters.put("cloudName", cloudName);
            parameters.put("prevGatewayName", currentUploadIPToUse);
            parameters.put("osType", "Android");
            parameters.put("restartId", String.valueOf(0));
            parameters.put("isFullBackup", Boolean.valueOf(fileProperties.get("isFullBackup").toString()).toString());
            Boolean isCalendar = Boolean.valueOf(fileProperties.get("isCalendar").toString());
            Boolean isMail = Boolean.valueOf(fileProperties.get("isMail").toString());
            Boolean isContact = Boolean.valueOf(fileProperties.get("isContact").toString());
            Boolean isTasks = Boolean.valueOf(fileProperties.get("isTasks").toString());
            Boolean isInPlaceArchive = Boolean.valueOf(fileProperties.get("isInPlaceArchive").toString());
            Boolean isSharePoint = false;
            if (fileProperties.get("isSharePoint") != null) {
                isSharePoint = Boolean.valueOf(fileProperties.get("isSharePoint").toString());
            }
            parameters.put("isMail", isMail.toString());
            if (fileProperties.get("o365LastModifiedTime") != null) {
                parameters.put("o365LastModifiedTime", fileProperties.get("o365LastModifiedTime"));
            }
            File tempFilePath = null;
            logger.debug("....deviceUUID available... " + deviceUUID);
            String accessToken = "";
            if (isContact.booleanValue()) {
                UploadStatus uploadStatus;
                logger.debug("...inside contacts...... ");
                logger.debug(messageId + "..... contacts uppload...." + String.valueOf(fileProperties.get("graphUserId")));
                String graphuserId = (String)fileProperties.get("graphUserId");
                logger.debug("...after contact...." + graphuserId);
                String odItemId = messageId;
                logger.debug("...after contact1...." + odItemId);
                Contact contact = (Contact)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().users(graphuserId).contacts(odItemId).buildRequest(new Option[0]).get());
                try {
                    logger.debug("...after contact2....");
                    ProfilePhoto profilePhoto = (ProfilePhoto)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().users(graphuserId).contacts(odItemId).photo().buildRequest(new Option[0]).get());
                    logger.debug("...after contact3....");
                    ArrayList<MailAttachment> updatedAttachments = new ArrayList<MailAttachment>();
                    if (profilePhoto != null) {
                        String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
                        logger.debug("... profilePhoto available... " + profilePhoto.id);
                        String attachId = profilePhoto.id;
                        String attachname = "photo";
                        String downloadedNameobj = CloudBackupController.downloadPhoto(accessToken, attachId, attachname, graphuserId, odItemId, chunkPath, cloudName);
                        logger.debug(downloadedNameobj + "........attachu1.........");
                        String[] arrObj = downloadedNameobj.split("~~");
                        String downloadedName = arrObj[0];
                        String fsPath = arrObj[1];
                        logger.debug(downloadedNameobj + "........attachu........." + downloadedName);
                        MailAttachment updatedAttachmentFile = new MailAttachment();
                        updatedAttachmentFile.setId(attachId);
                        updatedAttachmentFile.setName(attachname);
                        ArrayList<String> chunkFiles = new ArrayList<String>();
                        chunkFiles.add(downloadedName);
                        updatedAttachmentFile.setChunkFiles(chunkFiles);
                        updatedAttachments.add(updatedAttachmentFile);
                        parameters.put("fileMD5", downloadedName);
                        parameters.put("fsMailPath", fsPath);
                        parameters.put("hasAttachments", true);
                    }
                    parameters.put("attachments", updatedAttachments);
                }
                catch (Error eee) {
                    logger.error(".. no photo available");
                }
                catch (GraphServiceException ee) {
                    if (ee.getResponseCode() != 404) {
                        logger.error("...error trying to download photo....." + ee.getMessage());
                    }
                }
                catch (Exception eee) {
                    logger.error(".. excno photo available" + eee.getMessage());
                }
                logger.debug(".....contacts after...." + String.valueOf(fileProperties.get("userName")));
                LinkedList<String> empty = new LinkedList<String>();
                String md5val = "contact";
                parameters.put("fileMD5", md5val);
                parameters.put("file-name", contact.displayName);
                logger.debug(contact.displayName + "...disp..." + contact.mobilePhone);
                parameters.put("contactMobile", contact.mobilePhone);
                parameters.put("contactAddrStreet", contact.homeAddress.street);
                parameters.put("contactAddrCity", contact.homeAddress.city);
                parameters.put("contactAddrState", contact.homeAddress.state);
                parameters.put("contactAddrCountry", contact.homeAddress.countryOrRegion);
                parameters.put("contactAddrPostalCode", contact.homeAddress.postalCode);
                try {
                    parameters.put("contactBusiAddrStreet", contact.businessAddress.street);
                    parameters.put("contactBusiAddrCity", contact.businessAddress.city);
                    parameters.put("contactBusiAddrState", contact.businessAddress.state);
                    parameters.put("contactBusiAddrCountry", contact.businessAddress.countryOrRegion);
                    parameters.put("contactBusiAddrPostalCode", contact.businessAddress.postalCode);
                    parameters.put("contactOfficeLocation", contact.officeLocation);
                    parameters.put("contactCompanyName", contact.companyName);
                    parameters.put("contactJobTitle", contact.jobTitle);
                    parameters.put("contactDepartment", contact.department);
                    parameters.put("contactbirthday", contact.birthday);
                    parameters.put("contactDepartment", contact.department);
                    parameters.put("contactTitle", contact.title);
                    parameters.put("contactFirstName", contact.givenName);
                    parameters.put("contactMiddleName", contact.middleName);
                    parameters.put("contactLastName", contact.surname);
                    parameters.put("contactSuffix", contact.generation);
                    Object contactEmail = "";
                    if (!CollectionUtils.isEmpty((Collection)contact.emailAddresses)) {
                        for (EmailAddress emailAddress : contact.emailAddresses) {
                            if (org.springframework.util.StringUtils.isEmpty((Object)contactEmail)) {
                                contactEmail = emailAddress.address;
                                continue;
                            }
                            contactEmail = (String)contactEmail + "," + emailAddress.address;
                        }
                    }
                    parameters.put("contactEmail", contactEmail);
                    String homePhones = "";
                    if (!CollectionUtils.isEmpty((Collection)contact.homePhones)) {
                        homePhones = String.join((CharSequence)", ", contact.homePhones);
                    }
                    parameters.put("contactHomePhones", homePhones);
                    String businessPhones = "";
                    if (!CollectionUtils.isEmpty((Collection)contact.businessPhones)) {
                        businessPhones = String.join((CharSequence)", ", contact.businessPhones);
                    }
                    parameters.put("contactBusinessPhones", businessPhones);
                    logger.debug("....webpage...." + contact.businessHomePage);
                    parameters.put("contactwebSite", contact.businessHomePage);
                }
                catch (GraphServiceException e3) {
                    e3.printStackTrace();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                OfficeBackupPolicy officeBackupPolicy = this.uploadService.getOfficeBackupPolicyForUser(cloud.getCloudId(), (String)fileProperties.get("userName"));
                parameters.put("graphUserId", graphuserId);
                String token = (String)fileProperties.get("token");
                String userMailId = (String)fileProperties.get("userMailId");
                Contact contactObj = null;
                try {
                    contactObj = (Contact)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().users(graphuserId).contacts(messageId).buildRequest(new Option[0]).get());
                }
                catch (Exception e) {
                    logger.error("...unable to get contact.... " + e.getMessage());
                    try {
                        contactObj = (Contact)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().users(graphuserId).contacts(messageId).buildRequest(new Option[0]).get());
                    }
                    catch (Exception ee) {
                        logger.error("...unable to get contact.... " + e.getMessage());
                        int statusval = 234;
                        UploadStatus uploadStatus2 = new UploadStatus(messageId, false, statusval, 0L);
                        return uploadStatus2;
                    }
                }
                try {
                    tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + ".tmp", true);
                    File temp = new File(tempFilePath.getAbsolutePath());
                    if (temp.exists()) {
                        temp.delete();
                    }
                    temp.createNewFile();
                    parameters.put("modified", String.valueOf(temp.lastModified()));
                }
                catch (IOException e) {
                    logger.error("error trying to create new files " + e.getMessage(), (Throwable)e);
                }
                InputStream inputStream = null;
                try {
                    inputStream = CloudBackupController.convertContactToStream(contactObj);
                }
                catch (GraphServiceException e2) {
                    e2.printStackTrace();
                }
                logger.debug(tempFilePath.getAbsolutePath() + "................." + String.valueOf(inputStream));
                Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
                try {
                    Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException statusval) {
                    // empty catch block
                }
                FileInputStream is = new FileInputStream(tempFilePath);
                try {
                    UploadStatus uploadStatus3;
                    try {
                        String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                        logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloadingmai..... " + md5);
                        parameters.put("fileMD5", md5);
                    }
                    catch (Exception e) {
                        logger.error("MD5 computation failed", (Throwable)e);
                    }
                    fileSize = Files.size(tempFilePath.toPath());
                    parameters.put("file-size", String.valueOf(fileSize));
                    int statusval = this.uploadContacts(parameters, is, 1, empty, cloud, officeBackupPolicy);
                    logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                    logger.debug(".....Contacts............" + String.valueOf(parameters.get("file-size")));
                    fileProperties.put("file-size", parameters.get("file-size"));
                    boolean isSuccess = false;
                    if (statusval == 200) {
                        isSuccess = true;
                    }
                    uploadStatus = uploadStatus3 = new UploadStatus(messageId, isSuccess, statusval, fileSize);
                }
                catch (Throwable statusval) {
                    try {
                        try {
                            is.close();
                        }
                        catch (Throwable isSuccess) {
                            statusval.addSuppressed(isSuccess);
                        }
                        throw statusval;
                    }
                    catch (Exception e) {
                        logger.error("Failed to get the file in right path!", (Throwable)e);
                    }
                }
                is.close();
                return uploadStatus;
            } else if (isTasks.booleanValue()) {
                Object fsPath;
                logger.debug("...inside tasks...... ");
                logger.debug(messageId + "..... contacts uppload...." + String.valueOf(fileProperties.get("graphUserId")));
                String graphuserId = (String)fileProperties.get("graphUserId");
                logger.debug("...after tasks...." + graphuserId);
                logger.debug(".....tasks after...." + String.valueOf(fileProperties.get("userName")));
                LinkedList<String> empty = new LinkedList<String>();
                String md5val = "contact";
                parameters.put("fileMD5", md5val);
                OfficeBackupPolicy officeBackupPolicy = this.uploadService.getOfficeBackupPolicyForUser(cloud.getCloudId(), (String)fileProperties.get("userName"));
                parameters.put("graphUserId", graphuserId);
                String token = (String)fileProperties.get("token");
                String userMailId = (String)fileProperties.get("userMailId");
                logger.debug(userMailId + ".....tasks... ... " + messageId);
                TodoTask task = null;
                TodoTaskList taskList = null;
                String taskListId = null;
                String taskId = null;
                try {
                    String[] arrObj = messageId.split("-##-");
                    taskListId = arrObj[0];
                    taskId = arrObj[1];
                    task = (TodoTask)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().users(graphuserId).todo().lists(arrObj[0]).tasks(arrObj[1]).buildRequest(new Option[0]).select("checklistItems").get());
                    taskList = (TodoTaskList)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().users(graphuserId).todo().lists(arrObj[0]).buildRequest(new Option[0]).get());
                }
                catch (Exception e) {
                    logger.error("...unable to get tasks.... " + e.getMessage());
                    int statusval = 234;
                    UploadStatus uploadStatus = new UploadStatus(messageId, false, statusval, 0L);
                    return uploadStatus;
                }
                try {
                    tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + ".tmp", true);
                    File temp = new File(tempFilePath.getAbsolutePath());
                    if (temp.exists()) {
                        temp.delete();
                    }
                    temp.createNewFile();
                    parameters.put("modified", String.valueOf(temp.lastModified()));
                }
                catch (IOException e) {
                    logger.error("error trying to create new files " + e.getMessage(), (Throwable)e);
                }
                ByteArrayInputStream inputStream = null;
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                objectMapper.registerModule((Module)new JavaTimeModule());
                SimpleModule module = new SimpleModule();
                module.addDeserializer(DateOnly.class, (JsonDeserializer)new DateOnlyDeserializer());
                module.addDeserializer(RecurrenceRange.class, (JsonDeserializer)new RecurrenceRangeDeserializer());
                module.addDeserializer(PatternedRecurrence.class, (JsonDeserializer)new PatternedRecurrenceDeserializer());
                objectMapper.registerModule((Module)module);
                String taskJson = "";
                try {
                    task.checklistItems = null;
                    taskJson = objectMapper.writeValueAsString((Object)task);
                }
                catch (Exception e1) {
                    logger.error("....task string.........");
                    e1.printStackTrace();
                }
                logger.debug("....task string1.........");
                logger.debug("....task string1........." + taskJson);
                try {
                    File tasktempFilePath = this.createFileInBackupPath(parameters, cloudName, "Task-" + (String)fileProperties.get("file-name") + ".tmp", true);
                    File temp = new File(tempFilePath.getAbsolutePath());
                    if (temp.exists()) {
                        temp.delete();
                    }
                    temp.createNewFile();
                    FileWriter fileWriter = new FileWriter(tasktempFilePath);
                    fileWriter.write(taskJson);
                    fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                inputStream = new ByteArrayInputStream(taskJson.getBytes());
                ArrayList<MailAttachment> updatedAttachments = new ArrayList<MailAttachment>();
                if (task.hasAttachments != null && task.hasAttachments.booleanValue()) {
                    AttachmentBaseCollectionPage attachments = (AttachmentBaseCollectionPage)((AttachmentBaseCollectionRequest)Graph.getGraphClientFromGraph().users(graphuserId).todo().lists(taskListId).tasks(taskId).attachments().buildRequest(new Option[0])).get();
                    for (AttachmentBase attachmentBase : attachments.getCurrentPage()) {
                        if (attachmentBase instanceof TaskFileAttachment) {
                            TaskFileAttachment fileAttachment = (TaskFileAttachment)attachmentBase;
                            InputStream inputStreamAttach = Graph.getGraphClientFromGraph().users(graphuserId).todo().lists(taskListId).tasks(taskId).attachments(fileAttachment.id).content().buildRequest(new Option[0]).get();
                            String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
                            logger.debug("... fileAttachment available... " + fileAttachment.id);
                            String attachId = fileAttachment.id;
                            String attachname = fileAttachment.name;
                            chunkPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
                            String downloadedNameobj = CloudBackupController.downloadTaskAttachment(inputStreamAttach, attachname, chunkPath, cloudName);
                            logger.debug((String)downloadedNameobj + "........attachu1.........");
                            String[] arrObj = downloadedNameobj.split("~~");
                            String downloadedName = arrObj[0];
                            fsPath = arrObj[1];
                            logger.debug((String)downloadedNameobj + "........attachu........." + downloadedName);
                            MailAttachment updatedAttachmentFile = new MailAttachment();
                            updatedAttachmentFile.setId(attachId);
                            updatedAttachmentFile.setName(attachname);
                            ArrayList<String> chunkFiles = new ArrayList<String>();
                            chunkFiles.add(downloadedName);
                            updatedAttachmentFile.setChunkFiles(chunkFiles);
                            updatedAttachments.add(updatedAttachmentFile);
                            parameters.put("fileMD5", downloadedName);
                            parameters.put("fsMailPath", fsPath);
                            parameters.put("hasAttachments", true);
                            continue;
                        }
                        logger.debug("Unknown attachment type: " + attachmentBase.oDataType);
                    }
                    parameters.put("attachments", updatedAttachments);
                }
                logger.debug(tempFilePath.getAbsolutePath() + "........tasks........." + String.valueOf(inputStream));
                Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
                try {
                    Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException fileWriter) {
                    // empty catch block
                }
                FileInputStream is = new FileInputStream(tempFilePath);
                try {
                    Date createdDateTime;
                    try {
                        String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                        logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloadingmai..... " + md5);
                        parameters.put("fileMD5", md5);
                    }
                    catch (Exception e) {
                        logger.error("MD5 computation failed", (Throwable)e);
                    }
                    fileSize = Files.size(tempFilePath.toPath());
                    parameters.put("file-size", String.valueOf(fileSize));
                    OutParam reminderDueBy = new OutParam();
                    logger.debug("Task Subject: " + task.title);
                    logger.debug("Task Due Date: " + (task.dueDateTime != null ? task.dueDateTime.dateTime : "No due date"));
                    logger.debug("Task Status: " + String.valueOf(task.status));
                    logger.debug("Task Importance: " + String.valueOf(task.importance));
                    logger.debug("Task Created Date: " + String.valueOf(task.createdDateTime));
                    logger.debug(taskListId + "-----sdasdas----" + taskList.displayName);
                    String taskSubject = task.title;
                    Date taskStartDate = createdDateTime = Date.from(task.createdDateTime.toInstant());
                    parameters.put("taskReminderTime", CloudBackupController.convertDateTimeTimeZoneToDate(task.reminderDateTime));
                    parameters.put("taskStartDate", CloudBackupController.convertDateTimeTimeZoneToDate(task.startDateTime));
                    parameters.put("taskDueDate", CloudBackupController.convertDateTimeTimeZoneToDate(task.dueDateTime));
                    parameters.put("taskSubject", taskSubject);
                    parameters.put("taskId", taskId);
                    parameters.put("taskListId", taskListId);
                    parameters.put("taskListName", taskList.displayName);
                    if (task.status.name().equalsIgnoreCase("COMPLETED")) {
                        parameters.put("taskListName", "Completed/" + taskList.displayName);
                    }
                    parameters.put("taskCreatedDate", taskStartDate.getTime());
                    boolean taskMyDayTask = false;
                    List categories = task.categories;
                    if (!CollectionUtils.isEmpty((Collection)categories)) {
                        for (String cat : categories) {
                            logger.debug("Categories........" + cat);
                        }
                    }
                    if (task.categories != null && task.categories.contains("MyDay")) {
                        logger.debug("Task was part of 'My Day'.");
                        taskMyDayTask = true;
                    } else {
                        logger.debug("Task was not part of 'My Day'.");
                    }
                    parameters.put("taskMyDayTask", taskMyDayTask);
                    int statusval = this.uploadTasks(parameters, is, 1, empty, cloud, officeBackupPolicy);
                    logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^taskid^^^^^^^^^^^^^^^^" + task.id);
                    logger.debug(".....Tasks............" + String.valueOf(parameters.get("file-size")));
                    fileProperties.put("file-size", parameters.get("file-size"));
                    boolean isSuccess = false;
                    if (statusval == 200) {
                        isSuccess = true;
                    }
                    UploadStatus uploadStatus = new UploadStatus(messageId, isSuccess, statusval, fileSize);
                    fsPath = uploadStatus;
                }
                catch (Throwable reminderDueBy) {
                    try {
                        try {
                            is.close();
                        }
                        catch (Throwable taskSubject) {
                            reminderDueBy.addSuppressed(taskSubject);
                        }
                        throw reminderDueBy;
                    }
                    catch (Exception e) {
                        logger.error("Failed to get the file in right path!", (Throwable)e);
                        logger.debug(messageId + "..... tasks uppload...." + String.valueOf(fileProperties.get("graphUserId")));
                    }
                }
                is.close();
                return fsPath;
            } else if (isInPlaceArchive.booleanValue()) {
                block379: {
                    UploadStatus uploadStatus;
                    logger.debug(messageId + "..... isInPlaceArchive...." + String.valueOf(fileProperties.get("graphUserId")));
                    logger.debug(String.valueOf(fileProperties.get("file-name")) + "..... mail uppload...." + String.valueOf(fileProperties.get("graphUserId")));
                    LinkedList<String> empty = new LinkedList<String>();
                    String graphuserId = (String)fileProperties.get("graphUserId");
                    String userMailId = (String)fileProperties.get("userMailId");
                    String token = (String)fileProperties.get("token");
                    logger.debug(".....ews token ... " + token);
                    ExchangeService service = CloudBackupController.getAuthenticatedService(token, userMailId);
                    logger.debug("...user mail id value ..... " + userMailId);
                    EmailMessage item = null;
                    try {
                        ItemId itemId = new ItemId(messageId);
                        item = EmailMessage.bind((ExchangeService)service, (ItemId)itemId);
                    }
                    catch (Exception e) {
                        logger.error("...unable to get mail.... " + e.getMessage());
                        try {
                            if (e.getMessage().contains("401")) {
                                logger.debug("...ews401 retry...");
                                token = this.utilService.getEWSToken(cloud.getCloudId());
                                service = CloudBackupController.getAuthenticatedService(token, userMailId);
                            } else {
                                logger.debug("...wait and retry failed mails..." + String.valueOf(fileProperties.get("file-path")) + "...subj..." + String.valueOf(fileProperties.get("file-name")));
                                if (e.getMessage().contains("compatible with the requested item type (microsoft.exchange.webservices.data.core.service.item.EmailMessage)")) {
                                    int statusval = 234;
                                    UploadStatus uploadStatus4 = new UploadStatus(messageId, false, statusval, 0L);
                                    return uploadStatus4;
                                }
                            }
                            ItemId itemId = new ItemId(messageId);
                            item = EmailMessage.bind((ExchangeService)service, (ItemId)itemId);
                        }
                        catch (Exception ee) {
                            logger.error("...unable to get mail.... " + e.getMessage());
                            if (e.getMessage() != null && e.getMessage().contains("(401)Unauthorized")) {
                                try {
                                    logger.debug("...ews token expired wait for 5 mins");
                                    TimeUnit.MINUTES.sleep(5L);
                                }
                                catch (InterruptedException uploadStatus4) {
                                    // empty catch block
                                }
                            }
                            int statusval = 234;
                            UploadStatus uploadStatus5 = new UploadStatus(messageId, false, statusval, 0L);
                            return uploadStatus5;
                        }
                    }
                    try {
                        String md5 = "mail";
                        parameters.put("fileMD5", md5);
                    }
                    catch (Exception e) {
                        logger.error("MD5 computation failed", (Throwable)e);
                    }
                    parameters.put("file-name", item.getSubject());
                    logger.debug("....itemmessage ..... " + item.getSubject());
                    parameters.put("ewsId", item.getId().getUniqueId());
                    parameters.put("subject", item.getSubject());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)item.getFrom())) {
                        parameters.put("from", item.getFrom().getName());
                        parameters.put("fromAddr", item.getFrom().getAddress());
                        OutlookEmailAddress senderEmail = new OutlookEmailAddress();
                        senderEmail.setAddress(item.getFrom().getAddress());
                        senderEmail.setName(item.getFrom().getName());
                        parameters.put("fromEmailAddress", senderEmail);
                    }
                    parameters.put("bodyContent", item.getBody().toString());
                    String cccRecipients = "";
                    String ccRecipientsAddr = "";
                    ArrayList<OutlookEmailAddress> ccMails = new ArrayList<OutlookEmailAddress>();
                    StringJoiner emailAddressSJ = new StringJoiner(",");
                    StringJoiner emailNameSJ = new StringJoiner(",");
                    if (!org.springframework.util.StringUtils.isEmpty((Object)item.getCcRecipients())) {
                        List ccList = item.getCcRecipients().getItems();
                        for (microsoft.exchange.webservices.data.property.complex.EmailAddress ccRec : ccList) {
                            emailNameSJ.add(ccRec.getName());
                            emailAddressSJ.add(ccRec.getAddress());
                            OutlookEmailAddress ccEmail = new OutlookEmailAddress();
                            ccEmail.setAddress(ccRec.getAddress());
                            ccEmail.setName(ccRec.getName());
                            ccMails.add(ccEmail);
                        }
                        cccRecipients = emailNameSJ.toString();
                        ccRecipientsAddr = emailAddressSJ.toString();
                    }
                    parameters.put("ccRecipients", cccRecipients);
                    parameters.put("ccRecipientsAddr", ccRecipientsAddr);
                    parameters.put("ccRecipientsAddress", ccMails);
                    ArrayList<OutlookEmailAddress> bccMails = new ArrayList<OutlookEmailAddress>();
                    String bccRecipients = "";
                    String bccRecipientsAddr = "";
                    StringJoiner emailBCCAddressSJ = new StringJoiner(",");
                    StringJoiner emailBCCNameSJ = new StringJoiner(",");
                    if (!org.springframework.util.StringUtils.isEmpty((Object)item.getBccRecipients())) {
                        List bccList = item.getBccRecipients().getItems();
                        for (microsoft.exchange.webservices.data.property.complex.EmailAddress bccRec : bccList) {
                            emailBCCNameSJ.add(bccRec.getName());
                            emailBCCAddressSJ.add(bccRec.getAddress());
                            OutlookEmailAddress bccEmail = new OutlookEmailAddress();
                            bccEmail.setAddress(bccRec.getAddress());
                            bccEmail.setName(bccRec.getName());
                            bccMails.add(bccEmail);
                        }
                        bccRecipients = emailBCCNameSJ.toString();
                        bccRecipientsAddr = emailBCCAddressSJ.toString();
                    }
                    parameters.put("bccRecipients", bccRecipients);
                    parameters.put("bccRecipientsAddr", bccRecipientsAddr);
                    parameters.put("bccRecipientsAddress", bccMails);
                    ArrayList<OutlookEmailAddress> toMails = new ArrayList<OutlookEmailAddress>();
                    String toRecipients = "";
                    String toRecipientsAddr = "";
                    StringJoiner emailTOAddressSJ = new StringJoiner(",");
                    StringJoiner emailTONameSJ = new StringJoiner(",");
                    if (!org.springframework.util.StringUtils.isEmpty((Object)item.getToRecipients())) {
                        List toList = item.getToRecipients().getItems();
                        for (microsoft.exchange.webservices.data.property.complex.EmailAddress toRec : toList) {
                            emailTONameSJ.add(toRec.getName());
                            emailTOAddressSJ.add(toRec.getAddress());
                            OutlookEmailAddress toRecEmail = new OutlookEmailAddress();
                            toRecEmail.setAddress(toRec.getAddress());
                            toRecEmail.setName(toRec.getName());
                            toMails.add(toRecEmail);
                        }
                        toRecipients = emailTONameSJ.toString();
                        toRecipientsAddr = emailTOAddressSJ.toString();
                    }
                    parameters.put("toRecipients", toRecipients);
                    parameters.put("toRecipientsAddr", toRecipientsAddr);
                    parameters.put("toRecipientsAddress", toMails);
                    parameters.put("hasAttachments", item.getHasAttachments());
                    String policyType = OfficeBackupPolicy.TYPE.EXCHANGE.toString();
                    OfficeBackupPolicy officeBackupPolicy = this.utilService.getO365BackupPolicy(cloud.getCloudId(), (String)fileProperties.get("userName"), policyType);
                    parameters.put("graphUserId", graphuserId);
                    if (item.getDateTimeSent() != null) {
                        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                        String date = df2.format(item.getDateTimeSent());
                        parameters.put("sentDate", date);
                    }
                    logger.debug("..attachaaa.." + item.getHasAttachments());
                    boolean fileAllowed = true;
                    ArrayList<MailAttachment> updatedAttachments = new ArrayList<MailAttachment>();
                    if (item.getHasAttachments()) {
                        AttachmentCollection attachments = item.getAttachments();
                        for (microsoft.exchange.webservices.data.property.complex.Attachment attItemAttachment : attachments.getItems()) {
                            try {
                                logger.debug("... attachments available... " + attItemAttachment.getName());
                                String attachId = attItemAttachment.getId();
                                String attachname = attItemAttachment.getName();
                                boolean skipFileBasedonSize = CloudBackupController.checkFileSize(Long.valueOf(attItemAttachment.getSize()), Long.parseLong(officeBackupPolicy.getMaxFileSize()));
                                logger.debug("...check skip attachments because of size ..." + skipFileBasedonSize);
                                if (skipFileBasedonSize || !fileAllowed) continue;
                                boolean extcheck = this.checkForExtensions(attachname, officeBackupPolicy.getInclusionFilter(), officeBackupPolicy.getFilterType());
                                if (!org.springframework.util.StringUtils.isEmpty((Object)attachname) && (attachname = attachname.trim()).contains("/")) {
                                    attachname = attachname.replaceAll("/", "-");
                                }
                                if (org.springframework.util.StringUtils.isEmpty((Object)attachname)) continue;
                                logger.debug(extcheck + "...EXTCHECK...." + attachname);
                                fileAllowed = extcheck;
                                if (!extcheck) continue;
                                MailAttachment updatedAttachmentFile = new MailAttachment();
                                updatedAttachmentFile.setId(attItemAttachment.getId());
                                updatedAttachmentFile.setName(attItemAttachment.getName());
                                updatedAttachmentFile.setSize(Integer.valueOf(attItemAttachment.getSize()));
                                updatedAttachmentFile.setContentType(attItemAttachment.getContentType());
                                ArrayList<String> chunkFiles = new ArrayList<String>();
                                updatedAttachmentFile.setChunkFiles(chunkFiles);
                                chunkFiles.add("checkthisvaluesomethingiswrong.txt");
                                updatedAttachmentFile.setChunkFiles(chunkFiles);
                                updatedAttachments.add(updatedAttachmentFile);
                            }
                            catch (Exception e) {
                                logger.error("..error trying to get attach..... " + e.getMessage());
                            }
                        }
                        parameters.put("attachments", updatedAttachments);
                    }
                    Map mailFilterMap = officeBackupPolicy.getOutlookFilters();
                    boolean isFromAllowed = true;
                    boolean isToAllowed = true;
                    boolean isSubjectAllowed = true;
                    logger.debug(item.getSubject() + "......message from.21.....");
                    String fromVal = "";
                    String toVal = "";
                    String subject = "";
                    if (mailFilterMap != null && mailFilterMap.size() > 0) {
                        for (Map.Entry filterEntry : mailFilterMap.entrySet()) {
                            if ("from".equalsIgnoreCase((String)filterEntry.getKey())) {
                                fromVal = (String)filterEntry.getValue();
                            }
                            if ("to".equalsIgnoreCase((String)filterEntry.getKey())) {
                                toVal = (String)filterEntry.getValue();
                            }
                            if (!"subject".equalsIgnoreCase((String)filterEntry.getKey())) continue;
                            subject = (String)filterEntry.getValue();
                        }
                        logger.debug(fromVal + "......mailfilter..latest........." + toVal + "...." + subject);
                        if (!org.springframework.util.StringUtils.isEmpty((Object)fromVal)) {
                            isFromAllowed = this.fromFilterCheck(item, fromVal);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)toVal)) {
                            isToAllowed = this.toFilterCheck(item, toVal);
                        }
                        if (!org.springframework.util.StringUtils.isEmpty((Object)subject)) {
                            String[] subjectArr = subject.split(",");
                            List<Object> subjList = new ArrayList();
                            subjList = Arrays.asList(subjectArr);
                            if (!CollectionUtils.isEmpty(subjList)) {
                                for (String string : subjList) {
                                    logger.debug(item.getSubject() + "....sub..." + string);
                                    if (org.springframework.util.StringUtils.isEmpty((Object)item.getSubject()) || !CloudBackupController.isContainExactWord(item.getSubject().toLowerCase(), string.toLowerCase())) continue;
                                    isSubjectAllowed = false;
                                }
                            }
                        }
                    }
                    boolean isMailAllowed = true;
                    if (!org.springframework.util.StringUtils.isEmpty((Object)fromVal) && org.springframework.util.StringUtils.isEmpty((Object)toVal) && org.springframework.util.StringUtils.isEmpty((Object)subject) && !isFromAllowed) {
                        isMailAllowed = false;
                        fileAllowed = false;
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)toVal) && org.springframework.util.StringUtils.isEmpty((Object)fromVal) && org.springframework.util.StringUtils.isEmpty((Object)subject) && !isToAllowed) {
                        isMailAllowed = false;
                        fileAllowed = false;
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)subject) && org.springframework.util.StringUtils.isEmpty((Object)toVal) && org.springframework.util.StringUtils.isEmpty((Object)fromVal) && !isSubjectAllowed) {
                        isMailAllowed = false;
                    }
                    if (!(org.springframework.util.StringUtils.isEmpty((Object)subject) || org.springframework.util.StringUtils.isEmpty((Object)toVal) || org.springframework.util.StringUtils.isEmpty((Object)fromVal))) {
                        if (!(isSubjectAllowed || isToAllowed || isFromAllowed)) {
                            isMailAllowed = false;
                            fileAllowed = false;
                        } else {
                            isMailAllowed = true;
                        }
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)subject) && !org.springframework.util.StringUtils.isEmpty((Object)toVal) && org.springframework.util.StringUtils.isEmpty((Object)fromVal)) {
                        if (!isSubjectAllowed && !isToAllowed) {
                            isMailAllowed = false;
                            fileAllowed = false;
                        } else {
                            isMailAllowed = true;
                        }
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)subject) && !org.springframework.util.StringUtils.isEmpty((Object)fromVal) && org.springframework.util.StringUtils.isEmpty((Object)toVal)) {
                        if (!isSubjectAllowed && !isFromAllowed) {
                            isMailAllowed = false;
                            fileAllowed = false;
                        } else {
                            isMailAllowed = true;
                        }
                    }
                    if (!org.springframework.util.StringUtils.isEmpty((Object)toVal) && !org.springframework.util.StringUtils.isEmpty((Object)fromVal) && org.springframework.util.StringUtils.isEmpty((Object)subject)) {
                        logger.debug(item.getSubject() + "...fromto condition...." + isToAllowed + ".." + isFromAllowed);
                        if (!isToAllowed && !isFromAllowed) {
                            isMailAllowed = false;
                            fileAllowed = false;
                        } else {
                            isMailAllowed = true;
                        }
                    }
                    logger.debug("...mail allowed ..." + fileAllowed + "..." + isMailAllowed);
                    if (!fileAllowed) {
                        logger.debug("...ext not allowed so exclude...");
                        int statusval = 555;
                        UploadStatus uploadStatus6 = new UploadStatus(messageId, false, statusval, 0L);
                        return uploadStatus6;
                    }
                    if (CollectionUtils.isEmpty(updatedAttachments)) {
                        parameters.put("hasAttachments", false);
                    }
                    try {
                        tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + ".tmp", isMail);
                        File temp = new File(tempFilePath.getAbsolutePath());
                        parameters.put("modified", String.valueOf(temp.lastModified()));
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new UploadStatus(messageId, false, -1, 0L);
                    }
                    logger.debug(graphuserId + "........before downloadmail........." + messageId);
                    try {
                        PropertySet psPropset = new PropertySet(BasePropertySet.IdOnly);
                        psPropset.add((PropertyDefinitionBase)ItemSchema.MimeContent);
                        item.load(psPropset);
                    }
                    catch (Exception e2) {
                        logger.error("...unalbe to load email with mime content.....");
                        e2.printStackTrace();
                    }
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(item.getMimeContent().getContent());
                    logger.debug(tempFilePath.getAbsolutePath() + "........after download........." + String.valueOf(inputStream));
                    Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
                    try {
                        Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    FileInputStream fileInputStream = new FileInputStream(tempFilePath);
                    try {
                        UploadStatus uploadStatus7;
                        try {
                            String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                            logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloadingmai..... " + md5);
                            parameters.put("fileMD5", md5);
                        }
                        catch (Exception e) {
                            logger.error("MD5 computation failed", (Throwable)e);
                        }
                        fileSize = Files.size(tempFilePath.toPath());
                        parameters.put("file-size", String.valueOf(fileSize));
                        BaseController.printLogs("Going to launch read" + String.valueOf(parameters.get("ewsId")), PCHelperConstant.isBrevityLogging());
                        int statusval = this.uploadMail(parameters, fileInputStream, fileInputStream, 1, empty, cloud, officeBackupPolicy, true);
                        logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                        logger.debug(".....MAILSIZEEE............" + String.valueOf(parameters.get("file-size")));
                        fileProperties.put("file-size", parameters.get("file-size"));
                        boolean isSuccess = false;
                        if (statusval == 200) {
                            isSuccess = true;
                        }
                        try {
                            if (service != null) {
                                service.close();
                            }
                        }
                        catch (Exception e) {
                            logger.debug("...unable to close connection....");
                        }
                        uploadStatus = uploadStatus7 = new UploadStatus(messageId, isSuccess, statusval, fileSize);
                    }
                    catch (Throwable statusval) {
                        try {
                            try {
                                try {
                                    fileInputStream.close();
                                }
                                catch (Throwable isSuccess) {
                                    statusval.addSuppressed(isSuccess);
                                }
                                throw statusval;
                            }
                            catch (Exception exception) {
                                logger.error("Failed to get the file in right path!", (Throwable)exception);
                            }
                        }
                        catch (ClientException e) {
                            logger.error("... mail not found1........." + String.valueOf(fileProperties.get("file-name")));
                            return new UploadStatus(messageId, false, 409, 0L);
                        }
                        catch (ServiceLocalException e2) {
                            logger.error("... mail not found1...ServiceLocalException......" + e2.getMessage());
                            return new UploadStatus(messageId, false, 409, 0L);
                        }
                        catch (Exception eee) {
                            if (!eee.getMessage().contains("401")) break block379;
                            logger.error("... 401 exception...mail not found1...ServiceLocalException......" + eee.getMessage());
                        }
                    }
                    fileInputStream.close();
                    return uploadStatus;
                }
                logger.debug("....completed inplace archive ............");
            } else if (isSharePoint.booleanValue()) {
                UploadStatus emailBCCNameSJ;
                String siteId = "";
                String listId = "";
                logger.debug("...sharepoint  backup file.." + siteId);
                String versionId = (String)fileProperties.get("versionId");
                if (fileProperties.get("siteId") != null) {
                    siteId = (String)fileProperties.get("siteId");
                }
                if (fileProperties.get("listId") != null) {
                    listId = (String)fileProperties.get("listId");
                }
                logger.debug(listId + "...sharepoint  siteId file.." + siteId);
                String siteIdVal = siteId;
                String listIdVal = listId;
                String userName = (String)fileProperties.get("userName");
                InputStream inputStream = null;
                DriveItemContentStreamRequestBuilder content = null;
                String fileName = (String)fileProperties.get("file-name");
                try {
                    block380: {
                        logger.debug(fileName + "...." + messageId + "...sharepoint backup file12.." + versionId);
                        if (!org.springframework.util.StringUtils.isEmpty((Object)versionId)) {
                            try {
                                String downloadUrl = "/sites/" + siteId + "/drive/items/" + messageId + "/versions/" + versionId + "/content";
                                inputStream = (InputStream)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().sites(siteIdVal).lists(listIdVal).drive().items(messageId).versions(versionId).content().buildRequest(new Option[0]).get());
                            }
                            catch (GraphServiceException e) {
                                e.printStackTrace();
                                logger.debug(e.getResponseCode() + "....error trying to download file....");
                                if (e.getResponseCode() == 404) {
                                    try {
                                        content = (DriveItemContentStreamRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().sites(siteIdVal).lists(listIdVal).drive().items(messageId).content());
                                        inputStream = content.buildRequest(new Option[0]).get();
                                    }
                                    catch (GraphServiceException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                if (e.getMessage().contains("You cannot get the content of the current version.")) {
                                    content = (DriveItemContentStreamRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().sites(siteIdVal).lists(listIdVal).drive().items(messageId).content());
                                    inputStream = content.buildRequest(new Option[0]).get();
                                }
                                break block380;
                            }
                        }
                        content = (DriveItemContentStreamRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().sites(siteIdVal).lists(listIdVal).drive().items(messageId).content());
                        inputStream = content.buildRequest(new Option[0]).get();
                        logger.debug("...sharepoint backup file2..");
                    }
                    if (inputStream == null) {
                        return new UploadStatus(messageId, false, 555, 0L);
                    }
                }
                catch (GraphServiceException e) {
                    e.printStackTrace();
                    logger.error("....unable to get drive .... " + e.getResponseCode());
                    if (e.getResponseCode() == 403) {
                        logger.debug(e.getError().error.message + ".....check for maleware..." + e.getError().error.code);
                        if (e.getError() != null && e.getError().error != null && !org.springframework.util.StringUtils.isEmpty((Object)e.getError().error.code) && "malwareDetected".equalsIgnoreCase(e.getError().error.code)) {
                            this.saveFailedFilesReason(cloud.getCloudId(), userName, 403, fileName, (String)fileProperties.get("file-path"), "malwareDetected", deviceUUID, Device.TYPE.SHAREPOINT.name(), batchId);
                            return new UploadStatus(messageId, false, 409, 0L);
                        }
                    }
                    if (e.getResponseCode() == 404) {
                        try {
                            logger.debug(siteId + "...retry 404 driveid.." + messageId);
                            logger.debug("...sharepoint backup file1..");
                            content = (DriveItemContentStreamRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().sites(siteIdVal).lists(listIdVal).drive().items(messageId).content());
                            inputStream = content.buildRequest(new Option[0]).get();
                            if (inputStream == null) {
                                logger.debug("...sharepoint backup file1..");
                                content = (DriveItemContentStreamRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().sites(siteIdVal).lists(listIdVal).drive().items(messageId).content());
                                inputStream = content.buildRequest(new Option[0]).get();
                                if (inputStream == null) {
                                    return new UploadStatus(messageId, false, 555, 0L);
                                }
                            }
                        }
                        catch (GraphServiceException eee) {
                            logger.debug(eee.getResponseCode() + "...unable to get file...." + messageId);
                            return new UploadStatus(messageId, false, 555, 0L);
                        }
                    }
                    if (e.getResponseCode() == 429) {
                        logger.debug(".... retry .. after 2 mins.. ");
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (InterruptedException eee) {
                            // empty catch block
                        }
                        boolean downloaded = false;
                        do {
                            try {
                                logger.debug("...sharepoint backup file1..");
                                content = (DriveItemContentStreamRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().sites(siteIdVal).lists(listIdVal).drive().items(messageId).content());
                                inputStream = content.buildRequest(new Option[0]).get();
                                downloaded = true;
                            }
                            catch (GraphServiceException ee) {
                                downloaded = false;
                                if (e.getResponseCode() == 429) {
                                    logger.debug(".... retry .. after 2 mins.. ");
                                    try {
                                        Thread.sleep(120000L);
                                    }
                                    catch (InterruptedException bccRecipients) {
                                        // empty catch block
                                    }
                                }
                                if (ee.getResponseCode() != 404) continue;
                                downloaded = true;
                            }
                        } while (downloaded);
                    }
                    if (e.getResponseCode() == 403) {
                        this.saveBlackListUser(cloud, userName);
                        return new UploadStatus(messageId, false, 403, 0L);
                    }
                }
                catch (ClientException ee) {
                    this.sleep5sec();
                    logger.debug("...onedrive backup file1..");
                    content = (DriveItemContentStreamRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().sites(siteIdVal).lists(listIdVal).drive().items(messageId).content());
                    inputStream = content.buildRequest(new Option[0]).get();
                    logger.debug("...onedrive backup file2..");
                }
                try {
                    tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + "-" + versionId + "-" + System.currentTimeMillis() + ".tmp", isMail);
                    File temp = new File(tempFilePath.getAbsolutePath());
                    parameters.put("modified", String.valueOf(temp.lastModified()));
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return new UploadStatus(messageId, false, -1, 0L);
                }
                logger.debug(tempFilePath.getAbsolutePath() + "................." + String.valueOf(inputStream));
                Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
                if (!Files.exists(target, LinkOption.NOFOLLOW_LINKS)) {
                    logger.error("....unable to download file....");
                    return new UploadStatus(messageId, false, -1, 0L);
                }
                try {
                    Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
                    inputStream.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    logger.error("....unable to download file1....");
                    return new UploadStatus(messageId, false, -1, 0L);
                }
                LinkedList<String> empty = new LinkedList<String>();
                FileInputStream is = new FileInputStream(tempFilePath);
                try {
                    UploadStatus uploadStatus;
                    try {
                        String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                        logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloading..... " + md5);
                        parameters.put("fileMD5", md5);
                    }
                    catch (Exception e) {
                        logger.error("MD5 computation failed", (Throwable)e);
                    }
                    fileSize = Files.size(tempFilePath.toPath());
                    parameters.put("file-size", String.valueOf(Files.size(tempFilePath.toPath())));
                    logger.debug("Going to launch read");
                    parameters.put("siteId", siteId);
                    parameters.put("listId", listId);
                    parameters.put("versionId", versionId);
                    logger.debug(listId + "...sharepoint  siteId file.." + siteId);
                    int statusval = this.upload(parameters, is, 1, empty, cloud, true, user);
                    logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                    boolean isSuccess = false;
                    if (statusval == 200) {
                        isSuccess = true;
                    }
                    if (tempFilePath.exists()) {
                        tempFilePath.delete();
                    }
                    inputStream.close();
                    content = null;
                    emailBCCNameSJ = uploadStatus = new UploadStatus(messageId, isSuccess, statusval, fileSize);
                }
                catch (Throwable statusval) {
                    try {
                        try {
                            is.close();
                        }
                        catch (Throwable isSuccess) {
                            statusval.addSuppressed(isSuccess);
                        }
                        throw statusval;
                    }
                    catch (Exception e) {
                        logger.error("Failed to get the file in right path!", (Throwable)e);
                    }
                }
                is.close();
                return emailBCCNameSJ;
            } else {
                if (isCalendar.booleanValue()) {
                    Object attachname;
                    List listAttachments;
                    AttachmentCollectionPage AttachmentCollectionPage2;
                    logger.debug("...calendar.....");
                    logger.debug(messageId + "..... tasks uppload...." + String.valueOf(fileProperties.get("graphUserId")));
                    String graphuserId = (String)fileProperties.get("graphUserId");
                    logger.debug(String.valueOf(fileProperties.get("file-name")) + "..... calendar uppload...." + String.valueOf(fileProperties.get("graphUserId")));
                    LinkedList<String> empty = new LinkedList<String>();
                    Event event = null;
                    int count = 0;
                    int maxTries = 5;
                    while (true) {
                        try {
                            logger.debug("...trying for time..." + count + "..." + maxTries);
                            event = (Event)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().users(graphuserId).events(messageId).buildRequest(new Option[0]).get());
                        }
                        catch (Exception ex) {
                            logger.error("...error...." + ex.getMessage());
                            if (ex != null && !org.springframework.util.StringUtils.isEmpty((Object)ex.getMessage()) && (ex.getMessage().contains("Error code: ErrorItemNotFound") || ex.getMessage().contains("Error code: ResourceNotFound"))) {
                                UploadStatus uploadStatus = new UploadStatus(messageId, false, 555, 0L);
                                return uploadStatus;
                            }
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException uploadStatus) {
                                // empty catch block
                            }
                            logger.error(graphuserId + "..slept for 3 secs ....unable to get calendar general.... " + messageId);
                            if (++count != maxTries) continue;
                        }
                        break;
                    }
                    if (event == null) {
                        int statusval = 234;
                        UploadStatus uploadStatus = new UploadStatus(messageId, false, statusval, 0L);
                        return uploadStatus;
                    }
                    String subject = event.subject;
                    logger.debug(".....calendar subject....." + subject);
                    if (org.springframework.util.StringUtils.isEmpty((Object)subject)) {
                        subject = "(No subject)";
                    }
                    try {
                        String md5 = MD5Generator.generateMD5OfString((String)("Calendar" + subject));
                        parameters.put("fileMD5", md5);
                    }
                    catch (Exception e) {
                        logger.error("MD5 computation failed", (Throwable)e);
                    }
                    parameters.put("file-name", subject);
                    parameters.put("subject", subject);
                    if (event.organizer != null) {
                        parameters.put("from", event.organizer.emailAddress.name);
                        parameters.put("fromAddr", event.organizer.emailAddress.address);
                        OutlookEmailAddress senderEmail = new OutlookEmailAddress();
                        senderEmail.setAddress(event.organizer.emailAddress.address);
                        senderEmail.setName(event.organizer.emailAddress.name);
                        parameters.put("fromEmailAddress", senderEmail);
                    }
                    parameters.put("bodyContent", event.body.content);
                    if (!"HTML".equals(event.body.contentType.name())) {
                        String content = this.txtToHtmlWithTimeout(event.body.content);
                        if (!StringUtils.isEmpty((CharSequence)content) && "ERROR-CASE".equals(content)) {
                            int statusval = 234;
                            UploadStatus uploadStatus = new UploadStatus(messageId, false, statusval, 0L);
                            return uploadStatus;
                        }
                        parameters.put("bodyContent", content);
                    }
                    Object cccRecipients = "";
                    Object ccRecipientsAddr = "";
                    ArrayList<OutlookEmailAddress> ccMails = new ArrayList<OutlookEmailAddress>();
                    Object toRecipients = "";
                    Object toRecipientsAddr = "";
                    ArrayList<OutlookEmailAddress> toMails = new ArrayList<OutlookEmailAddress>();
                    logger.debug("Required Attendees (To):");
                    for (Attendee attendee : event.attendees) {
                        if (attendee.type != AttendeeType.REQUIRED) continue;
                        logger.debug("Name: " + attendee.emailAddress.name + ", Email: " + attendee.emailAddress.address);
                        logger.debug("Name: " + attendee.emailAddress.name + ", Email: " + attendee.emailAddress.address);
                        OutlookEmailAddress toEmail = new OutlookEmailAddress();
                        toEmail.setAddress(attendee.emailAddress.address);
                        toEmail.setName(attendee.emailAddress.name);
                        toMails.add(toEmail);
                        toRecipients = org.springframework.util.StringUtils.isEmpty((Object)toRecipients) ? attendee.emailAddress.name : (String)toRecipients + "," + attendee.emailAddress.name;
                        if (org.springframework.util.StringUtils.isEmpty((Object)toRecipientsAddr)) {
                            toRecipientsAddr = attendee.emailAddress.address;
                            continue;
                        }
                        toRecipientsAddr = (String)toRecipientsAddr + "," + attendee.emailAddress.address;
                    }
                    logger.debug("...failurecase5....");
                    parameters.put("toRecipients", toRecipients);
                    parameters.put("toRecipientsAddr", toRecipientsAddr);
                    parameters.put("toRecipientsAddress", toMails);
                    logger.debug("\nOptional Attendees (CC):");
                    for (Attendee attendee : event.attendees) {
                        if (attendee.type != AttendeeType.OPTIONAL) continue;
                        logger.debug("Name: " + attendee.emailAddress.name + ", Email: " + attendee.emailAddress.address);
                        OutlookEmailAddress ccEmail = new OutlookEmailAddress();
                        ccEmail.setAddress(attendee.emailAddress.address);
                        ccEmail.setName(attendee.emailAddress.name);
                        ccMails.add(ccEmail);
                        cccRecipients = org.springframework.util.StringUtils.isEmpty((Object)cccRecipients) ? attendee.emailAddress.name : (String)cccRecipients + "," + attendee.emailAddress.name;
                        if (org.springframework.util.StringUtils.isEmpty((Object)ccRecipientsAddr)) {
                            ccRecipientsAddr = attendee.emailAddress.address;
                            continue;
                        }
                        ccRecipientsAddr = (String)ccRecipientsAddr + "," + attendee.emailAddress.address;
                    }
                    parameters.put("ccRecipients", cccRecipients);
                    parameters.put("ccRecipientsAddr", ccRecipientsAddr);
                    parameters.put("ccRecipientsAddress", ccMails);
                    String calendarDuration = this.getCalendarDuration(event);
                    parameters.put("calendarDuration", calendarDuration);
                    parameters.put("calendarStartDate", CloudBackupController.convertToZonedDateTime(event.start));
                    parameters.put("calendarEndDate", CloudBackupController.convertToZonedDateTime(event.end));
                    parameters.put("hasAttachments", (boolean)event.hasAttachments);
                    String policyType = OfficeBackupPolicy.TYPE.EXCHANGE.toString();
                    OfficeBackupPolicy officeBackupPolicy = this.utilService.getO365BackupPolicy(cloud.getCloudId(), (String)fileProperties.get("userName"), policyType);
                    parameters.put("graphUserId", graphuserId);
                    String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
                    boolean fileAllowed = true;
                    ArrayList<MailAttachment> updatedAttachments = new ArrayList<MailAttachment>();
                    if (event.hasAttachments != null && event.hasAttachments.booleanValue() && (AttachmentCollectionPage2 = (AttachmentCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (AttachmentCollectionPage)((AttachmentCollectionRequest)Graph.getInstance().getGraphClient().users(graphuserId).events(messageId).attachments().buildRequest(new Option[0])).get())) != null && !CollectionUtils.isEmpty((Collection)(listAttachments = AttachmentCollectionPage2.getCurrentPage()))) {
                        for (Attachment attachment : listAttachments) {
                            try {
                                Attachment attachmentObj = null;
                                do {
                                    try {
                                        attachmentObj = (Attachment)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().users(graphuserId).events(messageId).attachments(attachment.id).buildRequest(new Option[0]).get());
                                    }
                                    catch (ClientException ee) {
                                        logger.error("..error trying to  get attachment obj wait for 5 secs....");
                                        Thread.sleep(5000L);
                                        attachmentObj = null;
                                    }
                                } while (attachmentObj == null);
                                if (attachmentObj.isInline.booleanValue()) continue;
                                logger.debug("... attachments available... " + attachmentObj.id);
                                String attachId = attachmentObj.id;
                                attachname = attachmentObj.name;
                                boolean skipFileBasedonSize = CloudBackupController.checkFileSize((long)attachment.size, Long.parseLong(officeBackupPolicy.getMaxFileSize()));
                                logger.debug("...check skip attachments because of size ..." + skipFileBasedonSize);
                                if (skipFileBasedonSize || !fileAllowed) continue;
                                boolean extcheck = this.checkForExtensions((String)attachname, officeBackupPolicy.getInclusionFilter(), officeBackupPolicy.getFilterType());
                                if (!org.springframework.util.StringUtils.isEmpty((Object)attachname) && ((String)(attachname = ((String)attachname).trim())).contains("/")) {
                                    attachname = ((String)attachname).replaceAll("/", "-");
                                }
                                if (org.springframework.util.StringUtils.isEmpty((Object)attachname)) continue;
                                logger.debug(extcheck + "...EXTCHECK...." + (String)attachname);
                                fileAllowed = extcheck;
                                if (!extcheck) continue;
                                logger.debug("........attachu........." + (String)attachname);
                                MailAttachment updatedAttachmentFile = new MailAttachment();
                                BeanUtils.copyProperties((Object)attachment, (Object)updatedAttachmentFile);
                                if (attachment.isInline.booleanValue()) continue;
                                logger.debug(attachment.name + "---attachvalues1---" + attachment.isInline);
                                updatedAttachmentFile.setId(attachment.id);
                                updatedAttachmentFile.setName(attachment.name);
                                updatedAttachmentFile.setSize(attachment.size);
                                updatedAttachmentFile.setContentType(attachment.contentType);
                                ArrayList<Object> chunkFiles = new ArrayList<Object>();
                                updatedAttachmentFile.setChunkFiles(chunkFiles);
                                chunkFiles.add(attachname);
                                updatedAttachmentFile.setChunkFiles(chunkFiles);
                                updatedAttachments.add(updatedAttachmentFile);
                                parameters.put("fileMD5", attachname);
                                parameters.put("fsMailPath", "");
                            }
                            catch (Exception e) {
                                logger.error("..error trying to get attach..... " + e.getMessage());
                            }
                        }
                        parameters.put("attachments", updatedAttachments);
                    }
                    if (!fileAllowed) {
                        logger.debug("...ext not allowed so exclude...");
                        int statusval = 234;
                        UploadStatus uploadStatus = new UploadStatus(messageId, false, statusval, 0L);
                        return uploadStatus;
                    }
                    if (CollectionUtils.isEmpty(updatedAttachments)) {
                        parameters.put("hasAttachments", false);
                    }
                    try {
                        tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + ".tmp", true);
                        File temp = new File(tempFilePath.getAbsolutePath());
                        parameters.put("modified", String.valueOf(temp.lastModified()));
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new UploadStatus(messageId, false, -1, 0L);
                    }
                    ObjectMapper objectMapper = new ObjectMapper();
                    try {
                        objectMapper.registerModule((Module)new JavaTimeModule());
                        objectMapper.writeValue(tempFilePath, (Object)event);
                        logger.debug("Event content saved to event.json");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(event.body.content.getBytes());
                    logger.debug(tempFilePath.getAbsolutePath() + "................." + String.valueOf(inputStream));
                    FileInputStream is = new FileInputStream(tempFilePath);
                    try {
                        try {
                            String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                            logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloadingmai..... " + md5);
                            parameters.put("fileMD5", md5);
                        }
                        catch (Exception e) {
                            logger.error("MD5 computation failed", (Throwable)e);
                        }
                        fileSize = Files.size(tempFilePath.toPath());
                        parameters.put("file-size", String.valueOf(fileSize));
                        logger.debug("Going to launch read" + String.valueOf(parameters.get("ewsId")));
                        int statusval = this.uploadCalendar(parameters, is, 1, empty, cloud, officeBackupPolicy, false);
                        logger.debug("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
                        logger.debug(".....MAILSIZEEE............" + String.valueOf(parameters.get("file-size")));
                        fileProperties.put("file-size", parameters.get("file-size"));
                        boolean isSuccess = false;
                        if (statusval == 200) {
                            isSuccess = true;
                        }
                        if (tempFilePath.exists()) {
                            tempFilePath.delete();
                        }
                        if (inputStream != null) {
                            ((InputStream)inputStream).close();
                        }
                        UploadStatus uploadStatus15 = new UploadStatus(messageId, isSuccess, statusval, fileSize);
                        attachname = uploadStatus15;
                    }
                    catch (Throwable statusval) {
                        try {
                            try {
                                try {
                                    is.close();
                                }
                                catch (Throwable isSuccess) {
                                    statusval.addSuppressed(isSuccess);
                                }
                                throw statusval;
                            }
                            catch (Exception e) {
                                logger.error("Failed to get the file in right path!", (Throwable)e);
                                break block381;
                            }
                        }
                        catch (ClientException e) {
                            logger.error(e.getMessage() + "... mail not found1........." + String.valueOf(fileProperties.get("file-name")));
                            return new UploadStatus(messageId, false, 409, 0L);
                        }
                    }
                    is.close();
                    return attachname;
                }
                if (!isMail.booleanValue()) {
                    UploadStatus uploadStatus;
                    DriveItemContentStreamRequestBuilder content;
                    InputStream inputStream;
                    block384: {
                        String driveIdFinal;
                        String driveId;
                        String userName;
                        block383: {
                            logger.debug("...onedrive backup file..");
                            userName = (String)fileProperties.get("userName");
                            String versionId = (String)fileProperties.get("versionId");
                            user = this.utilService.getUserInfoByName(cloud.getCloudId(), userName);
                            String driveIdVal = "";
                            if (fileProperties.get("driveId") != null) {
                                driveIdVal = (String)fileProperties.get("driveId");
                            }
                            logger.debug("...onedrivedriveid1.." + driveIdVal);
                            driveId = "";
                            driveId = org.springframework.util.StringUtils.isEmpty((Object)driveIdVal) ? this.getDriveIdForUserMailId(user.getEmailId()) : driveIdVal;
                            driveIdFinal = driveId;
                            logger.debug("...onedrivedriveid2.." + driveId);
                            if (org.springframework.util.StringUtils.isEmpty((Object)driveId)) {
                                logger.error(".......nulldrive move to fail case for user...." + userName);
                                int statusval = 234;
                                UploadStatus uploadStatus8 = new UploadStatus(messageId, false, statusval, 0L);
                                return uploadStatus8;
                            }
                            if (org.springframework.util.StringUtils.isEmpty((Object)driveId)) {
                                logger.error(".......nulldrive for user...." + userName);
                                return new UploadStatus(messageId, false, -1, 0L);
                            }
                            Object drives1 = null;
                            inputStream = null;
                            content = null;
                            String fileName = (String)fileProperties.get("file-name");
                            try {
                                if ("$$%^&malarefile.txt".equalsIgnoreCase(fileName)) {
                                    this.saveFailedFilesReason(cloud.getCloudId(), userName, 403, fileName, (String)fileProperties.get("file-path"), "malwareDetected", deviceUUID, "ONEDRIVE", batchId);
                                    return new UploadStatus(messageId, false, 409, 0L);
                                }
                                logger.debug(versionId + "...onedrive backup file1..");
                                if (!org.springframework.util.StringUtils.isEmpty((Object)versionId)) {
                                    inputStream = (InputStream)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().drives(driveIdFinal).items(messageId).versions(versionId).content().buildRequest(new Option[0]).get());
                                } else {
                                    content = (DriveItemContentStreamRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().drives(driveIdFinal).items(messageId).content());
                                    inputStream = content.buildRequest(new Option[0]).get();
                                }
                                logger.debug(messageId + "...onedrive backup file2......." + String.valueOf(inputStream));
                                if (inputStream == null) {
                                    logger.debug("...retry one more time...." + messageId);
                                    if (!org.springframework.util.StringUtils.isEmpty((Object)versionId)) {
                                        inputStream = (InputStream)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().drives(driveIdFinal).items(messageId).versions(versionId).content().buildRequest(new Option[0]).get());
                                    } else {
                                        content = (DriveItemContentStreamRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().drives(driveIdFinal).items(messageId).content());
                                        inputStream = content.buildRequest(new Option[0]).get();
                                    }
                                    logger.debug(messageId + "...onedrive backup file2 after retrylatest......." + String.valueOf(inputStream));
                                    if (inputStream == null) {
                                        DriveItem driveItem = (DriveItem)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().drives(driveIdFinal).items(messageId).buildRequest(new Option[0]).get());
                                        if (driveItem == null) {
                                            logger.debug("....drive item null.....");
                                        } else {
                                            logger.debug("....drive item not null....");
                                            return new UploadStatus(messageId, false, 555, 0L);
                                        }
                                    }
                                    logger.debug(messageId + "...onedrive backup file2 after retrylatest......." + String.valueOf(inputStream));
                                }
                            }
                            catch (GraphServiceException e) {
                                logger.error("....unable to get drive .... " + e.getResponseCode());
                                if (e.getResponseCode() == 403) {
                                    logger.debug(e.getError().error.message + ".....check for maleware..." + e.getError().error.code);
                                    if (e.getError() != null && e.getError().error != null && !org.springframework.util.StringUtils.isEmpty((Object)e.getError().error.code) && "malwareDetected".equalsIgnoreCase(e.getError().error.code)) {
                                        this.saveFailedFilesReason(cloud.getCloudId(), userName, 403, fileName, (String)fileProperties.get("file-path"), "malwareDetected", deviceUUID, "ONEDRIVE", batchId);
                                        return new UploadStatus(messageId, false, 409, 0L);
                                    }
                                }
                                if (e.getResponseCode() == 429 || e.getResponseCode() == 401) {
                                    logger.debug(".... retry .. after 2 mins.. ");
                                    try {
                                        Thread.sleep(120000L);
                                    }
                                    catch (InterruptedException toRecipientsAddr) {
                                        // empty catch block
                                    }
                                    boolean downloaded = false;
                                    do {
                                        block382: {
                                            try {
                                                if (!org.springframework.util.StringUtils.isEmpty((Object)versionId)) {
                                                    inputStream = (InputStream)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().drives(driveIdFinal).items(messageId).versions(versionId).content().buildRequest(new Option[0]).get());
                                                } else {
                                                    content = (DriveItemContentStreamRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().drives(driveIdFinal).items(messageId).content());
                                                    inputStream = content.buildRequest(new Option[0]).get();
                                                }
                                                downloaded = true;
                                            }
                                            catch (GraphServiceException ee) {
                                                downloaded = false;
                                                if (e.getResponseCode() == 429) {
                                                    logger.debug(".... retry .. after 2 mins.. ");
                                                    try {
                                                        Thread.sleep(120000L);
                                                    }
                                                    catch (InterruptedException calendarDuration) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (ee.getResponseCode() == 404) {
                                                    downloaded = true;
                                                }
                                                if (ee.getResponseCode() != 401) break block382;
                                                logger.debug(".... retry .. after 1 mins.. ");
                                                try {
                                                    Thread.sleep(60000L);
                                                }
                                                catch (InterruptedException calendarDuration) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        logger.debug(versionId + "...isdownloaded...." + downloaded);
                                    } while (downloaded);
                                }
                                if (e.getResponseCode() == 403) {
                                    this.saveBlackListUser(cloud, userName);
                                    return new UploadStatus(messageId, false, 403, 0L);
                                }
                                if (e.getResponseCode() != 404) break block383;
                                try {
                                    logger.debug(driveId + "...retry 404 driveid.." + messageId);
                                    if ("$$%^&malarefile.txt".equalsIgnoreCase(fileName)) {
                                        this.saveFailedFilesReason(cloud.getCloudId(), userName, 403, fileName, (String)fileProperties.get("file-path"), "malwareDetected", deviceUUID, "ONEDRIVE", batchId);
                                        return new UploadStatus(messageId, false, 409, 0L);
                                    }
                                    logger.debug(driveId + "...onedrive backup file1 retry.." + messageId);
                                    content = (DriveItemContentStreamRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().drives(driveIdFinal).items(messageId).content());
                                    inputStream = content.buildRequest(new Option[0]).get();
                                    logger.debug(messageId + "...onedrive backup file2......." + String.valueOf(inputStream));
                                    if (inputStream == null) {
                                        logger.debug("...retry one more time...." + messageId);
                                        content = (DriveItemContentStreamRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().drives(driveIdFinal).items(messageId).content());
                                        inputStream = content.buildRequest(new Option[0]).get();
                                        logger.debug(messageId + "...onedrive backup file2 after retry......." + String.valueOf(inputStream));
                                    }
                                }
                                catch (GraphServiceException eee) {
                                    logger.debug(eee.getResponseCode() + "...unable to get file...." + messageId);
                                    return new UploadStatus(messageId, false, 555, 0L);
                                }
                            }
                            catch (ClientException ee) {
                                this.sleep5sec();
                                logger.debug("...onedrive backup file1..");
                                content = (DriveItemContentStreamRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().drives(driveIdFinal).items(messageId).content());
                                inputStream = content.buildRequest(new Option[0]).get();
                                logger.debug("...onedrive backup file2..");
                            }
                        }
                        try {
                            tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + System.currentTimeMillis() + ".tmp", isMail);
                            File temp = new File(tempFilePath.getAbsolutePath());
                            parameters.put("modified", String.valueOf(temp.lastModified()));
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                            return new UploadStatus(messageId, false, -1, 0L);
                        }
                        logger.debug(tempFilePath.getAbsolutePath() + "..........afterdownloading......." + String.valueOf(inputStream));
                        Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
                        if (!Files.exists(target, LinkOption.NOFOLLOW_LINKS)) {
                            logger.error("....unable to download file....");
                            return new UploadStatus(messageId, false, -1, 0L);
                        }
                        logger.debug("..........afterdownloading1......." + String.valueOf(target));
                        try {
                            Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
                            inputStream.close();
                            logger.debug("..........afterdownloading1 stream closed......." + String.valueOf(target));
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            logger.error(userName + "....unable to download file...." + e1.getMessage());
                            boolean fileDownloadedSuccessfully = false;
                            do {
                                try {
                                    logger.debug(driveId + "...retry one more time...." + messageId);
                                    content = (DriveItemContentStreamRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().drives(driveIdFinal).items(messageId).content());
                                    inputStream = content.buildRequest(new Option[0]).get();
                                    logger.debug(messageId + "...onedrive backup file2 after retry......." + String.valueOf(inputStream));
                                    Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
                                    inputStream.close();
                                    fileDownloadedSuccessfully = true;
                                }
                                catch (GraphServiceException e) {
                                    if (e.getResponseCode() == 429) {
                                        inputStream = null;
                                        logger.debug("..sleep for 90 sec...");
                                        try {
                                            Thread.sleep(90000L);
                                        }
                                        catch (InterruptedException policyType) {
                                            // empty catch block
                                        }
                                    }
                                    logger.error("....issue downloading...." + e.getMessage());
                                }
                                catch (IOException e) {
                                    inputStream = null;
                                    logger.error("....issue downloading1...." + e.getMessage());
                                    if (!e.getMessage().contains("tiemout")) continue;
                                    int statusval = 234;
                                    UploadStatus uploadStatus9 = new UploadStatus(messageId, false, statusval, 0L);
                                    return uploadStatus9;
                                }
                            } while (inputStream == null && !org.springframework.util.StringUtils.isEmpty((Object)driveId) && !org.springframework.util.StringUtils.isEmpty((Object)messageId));
                            if (fileDownloadedSuccessfully) break block384;
                            return new UploadStatus(messageId, false, -1, 0L);
                        }
                    }
                    logger.debug("....before generating md5...." + tempFilePath.getAbsolutePath());
                    LinkedList<String> empty = new LinkedList<String>();
                    FileInputStream is = new FileInputStream(tempFilePath);
                    try {
                        UploadStatus uploadStatus10;
                        try {
                            logger.debug("....before generating md51...." + tempFilePath.getAbsolutePath());
                            String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                            logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloading..... " + md5);
                            parameters.put("fileMD5", md5);
                        }
                        catch (Exception e) {
                            logger.error("MD5 computation failed", (Throwable)e);
                        }
                        fileSize = Files.size(tempFilePath.toPath());
                        parameters.put("file-size", String.valueOf(Files.size(tempFilePath.toPath())));
                        logger.debug("Going to launch read");
                        int statusval = this.upload(parameters, is, 1, empty, cloud, false, user);
                        logger.debug("^^^^^^^^^^^^^^^^^^^^status for onedrive^^^^^^^^^^^^^^^^^^^^^" + statusval);
                        boolean isSuccess = false;
                        if (statusval == 200) {
                            isSuccess = true;
                        }
                        if (tempFilePath.exists()) {
                            tempFilePath.delete();
                        }
                        inputStream.close();
                        content = null;
                        uploadStatus = uploadStatus10 = new UploadStatus(messageId, isSuccess, statusval, fileSize);
                    }
                    catch (Throwable statusval) {
                        try {
                            try {
                                is.close();
                            }
                            catch (Throwable isSuccess) {
                                statusval.addSuppressed(isSuccess);
                            }
                            throw statusval;
                        }
                        catch (Exception e) {
                            logger.error("Failed to get the file in right path!", (Throwable)e);
                        }
                    }
                    is.close();
                    return uploadStatus;
                } else {
                    UploadStatus uploadStatus;
                    logger.debug(String.valueOf(fileProperties.get("file-name")) + "..... mail uppload...." + String.valueOf(fileProperties.get("graphUserId")));
                    LinkedList<String> empty = new LinkedList<String>();
                    String graphuserId = (String)fileProperties.get("graphUserId");
                    Message message = null;
                    int count = 0;
                    int maxTries = 5;
                    while (true) {
                        try {
                            Instant start = Instant.now();
                            logger.debug("...trying for time..." + count + "..." + maxTries);
                            message = (Message)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().users(graphuserId).messages(messageId).buildRequest(new Option[0]).get());
                            Instant end = Instant.now();
                            Duration timeElapsed = Duration.between(start, end);
                            if (timeElapsed.getSeconds() > 60L) {
                                this.printGraphHeaders(messageId, graphuserId, message);
                            }
                        }
                        catch (Exception ex) {
                            logger.error("...error...." + ex.getMessage());
                            if (ex != null && !org.springframework.util.StringUtils.isEmpty((Object)ex.getMessage()) && ex.getMessage().contains("A participant ENTRYID is malformed and cannot be read")) {
                                UploadStatus uploadStatus11 = new UploadStatus(messageId, false, 555, 0L);
                                return uploadStatus11;
                            }
                            if (ex != null && !org.springframework.util.StringUtils.isEmpty((Object)ex.getMessage()) && (ex.getMessage().contains("Error code: ErrorItemNotFound") || ex.getMessage().contains("Error code: ResourceNotFound"))) {
                                UploadStatus uploadStatus12 = new UploadStatus(messageId, false, 555, 0L);
                                return uploadStatus12;
                            }
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException uploadStatus12) {
                                // empty catch block
                            }
                            logger.error(graphuserId + "..slept for 3 secs ....unable to get mail general.... " + messageId);
                            if (++count != maxTries) continue;
                        }
                        break;
                    }
                    if (message == null) {
                        int statusval = 234;
                        UploadStatus uploadStatus13 = new UploadStatus(messageId, false, statusval, 0L);
                        return uploadStatus13;
                    }
                    try {
                        String md5 = "mail";
                        parameters.put("fileMD5", md5);
                    }
                    catch (Exception e) {
                        logger.error("MD5 computation failed", (Throwable)e);
                    }
                    String subject = message.subject;
                    if (org.springframework.util.StringUtils.isEmpty((Object)subject)) {
                        subject = "(No subject)";
                    }
                    parameters.put("file-name", subject);
                    LinkedList<String> inputIdsList = new LinkedList<String>();
                    ExchangeIdFormat sourceIdType = ExchangeIdFormat.REST_ID;
                    ExchangeIdFormat targetIdType = ExchangeIdFormat.EWS_ID;
                    inputIdsList.add(messageId);
                    UserTranslateExchangeIdsParameterSet exchangeIdsParameterSet = new UserTranslateExchangeIdsParameterSet();
                    exchangeIdsParameterSet.inputIds = inputIdsList;
                    exchangeIdsParameterSet.targetIdType = targetIdType;
                    exchangeIdsParameterSet.sourceIdType = sourceIdType;
                    UserTranslateExchangeIdsCollectionPage post = (UserTranslateExchangeIdsCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (UserTranslateExchangeIdsCollectionPage)((UserTranslateExchangeIdsCollectionRequest)Graph.getInstance().getGraphClient().users(graphuserId).translateExchangeIds(exchangeIdsParameterSet).buildRequest(new Option[0])).post());
                    List convertedIdPages = post.getCurrentPage();
                    String ewsId = "";
                    for (ConvertIdResult convertIdResult : convertedIdPages) {
                        logger.debug(inputIdsList.size() + "...converted ewsids ...." + convertIdResult.targetId);
                        ewsId = convertIdResult.targetId;
                    }
                    logger.debug("...failurecase1....");
                    parameters.put("ewsId", ewsId);
                    parameters.put("subject", subject);
                    logger.debug("...failurecase2....");
                    String filePath = (String)fileProperties.get("file-path");
                    long receivedDateTime = this.getMailRecievedDate(message, filePath);
                    logger.debug(filePath + "...receivedDateTime...." + receivedDateTime);
                    parameters.put("receivedDateTime", receivedDateTime);
                    if (message.from != null) {
                        parameters.put("from", message.from.emailAddress.name);
                        parameters.put("fromAddr", message.from.emailAddress.address);
                        OutlookEmailAddress senderEmail = new OutlookEmailAddress();
                        senderEmail.setAddress(message.from.emailAddress.address);
                        senderEmail.setName(message.from.emailAddress.name);
                        parameters.put("fromEmailAddress", senderEmail);
                    }
                    logger.debug("...failurecase3...." + String.valueOf(message.body));
                    logger.debug("...failurecase3b...." + String.valueOf(message.body.contentType));
                    logger.debug("...failurecase3c...." + message.body.contentType.name());
                    parameters.put("bodyContent", message.body.content);
                    if (!"HTML".equals(message.body.contentType.name())) {
                        String content = this.txtToHtmlWithTimeout(message.body.content);
                        if (!StringUtils.isEmpty((CharSequence)content) && "ERROR-CASE".equals(content)) {
                            int statusval = 234;
                            UploadStatus uploadStatus14 = new UploadStatus(messageId, false, statusval, 0L);
                            return uploadStatus14;
                        }
                        parameters.put("bodyContent", content);
                    }
                    logger.debug(message.subject + "...failurecase3d...." + message.body.contentType.name());
                    String cccRecipients = "";
                    String ccRecipientsAddr = "";
                    ArrayList<OutlookEmailAddress> ccMails = new ArrayList<OutlookEmailAddress>();
                    if (message.ccRecipients != null) {
                        try {
                            cccRecipients = message.ccRecipients.stream().map(a -> String.valueOf(a.emailAddress.name)).collect(Collectors.joining(","));
                        }
                        catch (Exception inputStream) {
                            // empty catch block
                        }
                        try {
                            ccRecipientsAddr = message.ccRecipients.stream().map(a -> String.valueOf(a.emailAddress.address)).collect(Collectors.joining(","));
                        }
                        catch (Exception inputStream) {
                            // empty catch block
                        }
                        for (Recipient ccRec : message.ccRecipients) {
                            OutlookEmailAddress ccEmail = new OutlookEmailAddress();
                            ccEmail.setAddress(ccRec.emailAddress.address);
                            ccEmail.setName(ccRec.emailAddress.name);
                            ccMails.add(ccEmail);
                        }
                    }
                    logger.debug("...failurecase4....");
                    parameters.put("ccRecipients", cccRecipients);
                    parameters.put("ccRecipientsAddr", ccRecipientsAddr);
                    parameters.put("ccRecipientsAddress", ccMails);
                    ArrayList<OutlookEmailAddress> bccMails = new ArrayList<OutlookEmailAddress>();
                    List bccRecipientsCol = message.bccRecipients;
                    String bccRecipients = "";
                    String bccRecipientsAddr = "";
                    if (bccRecipientsCol != null) {
                        try {
                            bccRecipients = bccRecipientsCol.stream().map(a -> String.valueOf(a.emailAddress.name)).collect(Collectors.joining(","));
                        }
                        catch (Exception uploadStatus15) {
                            // empty catch block
                        }
                        try {
                            bccRecipientsAddr = bccRecipientsCol.stream().map(a -> String.valueOf(a.emailAddress.address)).collect(Collectors.joining(","));
                        }
                        catch (Exception uploadStatus15) {
                            // empty catch block
                        }
                        for (Recipient bccRec : bccRecipientsCol) {
                            OutlookEmailAddress bccEmail = new OutlookEmailAddress();
                            bccEmail.setAddress(bccRec.emailAddress.address);
                            bccEmail.setName(bccRec.emailAddress.name);
                            bccMails.add(bccEmail);
                        }
                    }
                    parameters.put("bccRecipients", bccRecipients);
                    parameters.put("bccRecipientsAddr", bccRecipientsAddr);
                    parameters.put("bccRecipientsAddress", bccMails);
                    ArrayList<OutlookEmailAddress> toMails = new ArrayList<OutlookEmailAddress>();
                    List toRecipientsCol = message.toRecipients;
                    String toRecipients = "";
                    String toRecipientsAddr = "";
                    if (toRecipientsCol != null) {
                        try {
                            toRecipients = toRecipientsCol.stream().map(a -> String.valueOf(a.emailAddress.name)).collect(Collectors.joining(","));
                        }
                        catch (Exception updatedAttachmentFile) {
                            // empty catch block
                        }
                        try {
                            toRecipientsAddr = toRecipientsCol.stream().map(a -> String.valueOf(a.emailAddress.address)).collect(Collectors.joining(","));
                        }
                        catch (Exception updatedAttachmentFile) {
                            // empty catch block
                        }
                        for (Recipient toRec : toRecipientsCol) {
                            OutlookEmailAddress toEmail = new OutlookEmailAddress();
                            toEmail.setAddress(toRec.emailAddress.address);
                            toEmail.setName(toRec.emailAddress.name);
                            toMails.add(toEmail);
                        }
                    }
                    logger.debug("...failurecase5....");
                    parameters.put("toRecipients", toRecipients);
                    parameters.put("toRecipientsAddr", toRecipientsAddr);
                    parameters.put("toRecipientsAddress", toMails);
                    parameters.put("hasAttachments", (boolean)message.hasAttachments);
                    String policyType = "Exchange";
                    OfficeBackupPolicy officeBackupPolicy = this.utilService.getO365BackupPolicy(cloud.getCloudId(), (String)fileProperties.get("userName"), policyType);
                    parameters.put("graphUserId", graphuserId);
                    logger.debug("...failurecase6....");
                    if (message.sentDateTime != null && message.sentDateTime.toInstant() != null) {
                        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                        String date = df2.format(message.sentDateTime.toInstant().toEpochMilli());
                        parameters.put("sentDate", date);
                    }
                    logger.debug("..attachaaa latest.." + message.hasAttachments);
                    String chunkPath = this.getUploadFilePath(deviceUUID, cloudName, batchId);
                    boolean fileAllowed = true;
                    GraphServiceClient graphServiceClient = (GraphServiceClient)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient());
                    ArrayList<MailAttachment> updatedAttachments = new ArrayList<MailAttachment>();
                    if (message.hasAttachments != null && message.hasAttachments.booleanValue()) {
                        logger.debug("..attachaaa latest1.." + message.hasAttachments);
                        AttachmentCollectionPage AttachmentCollectionPage3 = (AttachmentCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (AttachmentCollectionPage)((AttachmentCollectionRequest)Graph.getInstance().getGraphClient().users(graphuserId).messages(messageId).attachments().buildRequest(new Option[0])).get());
                        if (AttachmentCollectionPage3 != null) {
                            List listAttachments = AttachmentCollectionPage3.getCurrentPage();
                            logger.debug("..attachaaa latest2.." + message.hasAttachments);
                            if (!CollectionUtils.isEmpty((Collection)listAttachments)) {
                                for (Attachment attachment : listAttachments) {
                                    try {
                                        Attachment attachmentObj = null;
                                        int retry = 0;
                                        do {
                                            try {
                                                logger.debug(retry + "..attachaaa latest3.." + message.hasAttachments);
                                                attachmentObj = graphServiceClient.users(graphuserId).messages(messageId).attachments(attachment.id).buildRequest(new Option[0]).get();
                                            }
                                            catch (ClientException ee) {
                                                logger.error("..error trying to  get attachment obj wait for 5 secs....");
                                                Thread.sleep(5000L);
                                                attachmentObj = null;
                                            }
                                            if (++retry <= 2) continue;
                                            logger.error("....retried 5 times moving to failed files...." + messageId);
                                            int statusval = 234;
                                            UploadStatus uploadStatus16 = new UploadStatus(messageId, false, statusval, 0L);
                                            return uploadStatus16;
                                        } while (attachmentObj == null);
                                        if (attachmentObj.isInline.booleanValue()) continue;
                                        logger.debug("... attachments available... " + attachmentObj.id);
                                        String attachId = attachmentObj.id;
                                        String attachname = attachmentObj.name;
                                        boolean skipFileBasedonSize = CloudBackupController.checkFileSize((long)attachment.size, Long.parseLong(officeBackupPolicy.getMaxFileSize()));
                                        logger.debug("...check skip attachments because of size ..." + skipFileBasedonSize);
                                        if (skipFileBasedonSize || !fileAllowed) continue;
                                        boolean extcheck = this.checkForExtensions(attachname, officeBackupPolicy.getInclusionFilter(), officeBackupPolicy.getFilterType());
                                        if (!org.springframework.util.StringUtils.isEmpty((Object)attachname) && (attachname = attachname.trim()).contains("/")) {
                                            attachname = attachname.replaceAll("/", "-");
                                        }
                                        if (org.springframework.util.StringUtils.isEmpty((Object)attachname)) continue;
                                        logger.debug(extcheck + "...EXTCHECK...." + attachname);
                                        fileAllowed = extcheck;
                                        if (!extcheck) continue;
                                        Object downloadedNameobj1 = null;
                                        MailAttachment updatedAttachmentFile = new MailAttachment();
                                        BeanUtils.copyProperties((Object)attachment, (Object)updatedAttachmentFile);
                                        if (attachment.isInline.booleanValue()) continue;
                                        logger.debug(attachment.name + "---attachvalues1---" + attachment.isInline + "...." + chunkPath);
                                        byte[] contentBytes = ((FileAttachment)attachment).contentBytes;
                                        Object downloadedName = MD5Generator.generateMD5OfString((String)(attachment.name + attachment.id));
                                        downloadedName = "Att-" + (String)downloadedName;
                                        File chunkPathFile = new File(chunkPath);
                                        if (!chunkPathFile.exists()) {
                                            chunkPathFile.mkdirs();
                                        }
                                        updatedAttachmentFile.setId(attachment.id);
                                        updatedAttachmentFile.setName(attachment.name);
                                        updatedAttachmentFile.setSize(attachment.size);
                                        updatedAttachmentFile.setContentType(attachment.contentType);
                                        ArrayList<Object> chunkFiles = new ArrayList<Object>();
                                        updatedAttachmentFile.setChunkFiles(chunkFiles);
                                        chunkFiles.add(downloadedName);
                                        updatedAttachmentFile.setChunkFiles(chunkFiles);
                                        updatedAttachments.add(updatedAttachmentFile);
                                        parameters.put("fileMD5", downloadedName);
                                        parameters.put("fsMailPath", "CHECK_PATH");
                                    }
                                    catch (Exception e) {
                                        logger.error("..error trying to get attach..... " + e.getMessage());
                                        e.printStackTrace();
                                    }
                                }
                                parameters.put("attachments", updatedAttachments);
                            }
                        }
                    }
                    if (!fileAllowed) {
                        logger.debug("...ext not allowed so exclude...");
                        int statusval = 234;
                        UploadStatus uploadStatus17 = new UploadStatus(messageId, false, statusval, 0L);
                        return uploadStatus17;
                    }
                    if (CollectionUtils.isEmpty(updatedAttachments)) {
                        parameters.put("hasAttachments", false);
                    }
                    File tempSearchFilePath = null;
                    try {
                        tempFilePath = this.createFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + ".tmp", isMail);
                        File temp = new File(tempFilePath.getAbsolutePath());
                        parameters.put("modified", String.valueOf(temp.lastModified()));
                        tempSearchFilePath = this.createSearchFileInBackupPath(parameters, cloudName, (String)fileProperties.get("file-name") + ".searchtmp", isMail);
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new UploadStatus(messageId, false, -1, 0L);
                    }
                    InputStream fullInputStream = this.downloadMail(graphuserId, messageId);
                    if (new File(tempSearchFilePath.getAbsolutePath()).exists()) {
                        new File(tempSearchFilePath.getAbsolutePath()).delete();
                    }
                    Path path = Paths.get(tempSearchFilePath.getAbsolutePath(), new String[0]);
                    try {
                        new File(tempSearchFilePath.getAbsolutePath()).createNewFile();
                        Files.copy(fullInputStream, path, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException attachment) {
                        // empty catch block
                    }
                    InputStream inputStream = this.downloadMail(graphuserId, messageId);
                    logger.debug(tempFilePath.getAbsolutePath() + "................." + String.valueOf(inputStream));
                    if (new File(tempFilePath.getAbsolutePath()).exists()) {
                        new File(tempFilePath.getAbsolutePath()).delete();
                    }
                    Path target = Paths.get(tempFilePath.getAbsolutePath(), new String[0]);
                    try {
                        new File(tempFilePath.getAbsolutePath()).createNewFile();
                        Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException retry) {
                        // empty catch block
                    }
                    FileInputStream is = new FileInputStream(tempFilePath);
                    try {
                        UploadStatus uploadStatus18;
                        try {
                            String md5 = MD5Generator.generateMD5OfFile((File)new File(tempFilePath.getAbsolutePath()));
                            logger.debug(tempFilePath.getAbsolutePath() + "...md5 value calculation after downloadingmai..... " + md5);
                            parameters.put("fileMD5", md5);
                        }
                        catch (Exception e) {
                            logger.error("MD5 computation failed", (Throwable)e);
                        }
                        fileSize = Files.size(tempSearchFilePath.toPath());
                        parameters.put("file-size", String.valueOf(fileSize));
                        logger.debug(Files.size(tempSearchFilePath.toPath()) + "..tempSearchFilePath..Going to launch read" + Files.size(tempFilePath.toPath()));
                        FileInputStream searchStream = null;
                        int statusval = this.uploadMail(parameters, is, is, 1, empty, cloud, officeBackupPolicy, false);
                        logger.debug("^^^^^^^^^^^^^^^^^temp search path^^^^^^^^^^^^^^^^^^^^^^^^" + String.valueOf(tempSearchFilePath));
                        logger.debug(".....MAILSIZEEE............" + String.valueOf(parameters.get("file-size")));
                        fileProperties.put("file-size", parameters.get("file-size"));
                        boolean isSuccess = false;
                        if (statusval == 200) {
                            isSuccess = true;
                        }
                        if (tempFilePath.exists()) {
                            tempFilePath.delete();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (tempSearchFilePath.exists()) {
                            tempSearchFilePath.delete();
                        }
                        if (searchStream != null) {
                            searchStream.close();
                        }
                        uploadStatus = uploadStatus18 = new UploadStatus(messageId, isSuccess, statusval, fileSize);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                logger.error("Failed to get the file in right path!", (Throwable)e);
                            }
                        }
                        catch (ClientException e) {
                            logger.error(e.getMessage() + "... mail not found1........." + String.valueOf(fileProperties.get("file-name")));
                            return new UploadStatus(messageId, false, 409, 0L);
                        }
                    }
                    is.close();
                    return uploadStatus;
                }
            }
        }
        return status;
    }

    private String getCalendarDuration(Event event) {
        DateTimeTimeZone start = event.start;
        DateTimeTimeZone end = event.end;
        ZonedDateTime startTime = CloudBackupController.convertToZonedDateTime(start);
        ZonedDateTime endTime = CloudBackupController.convertToZonedDateTime(end);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE M/d/yyyy, h:mm a");
        String formattedStart = startTime.format(formatter);
        String formattedEnd = endTime.format(formatter);
        String finalFormattedTime = formattedStart + " to " + formattedEnd;
        return finalFormattedTime;
    }

    private static ZonedDateTime convertToZonedDateTime(DateTimeTimeZone dateTimeTimeZone) {
        ZonedDateTime eventStartTime = ZonedDateTime.of(LocalDateTime.parse(dateTimeTimeZone.dateTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME), ZoneId.of(dateTimeTimeZone.timeZone));
        ZonedDateTime eventStart = eventStartTime.withZoneSameInstant(ZoneId.systemDefault());
        return eventStart;
    }

    public static InputStream convert(OutputStream outputStream) throws IOException {
        if (!(outputStream instanceof ByteArrayOutputStream)) {
            throw new IllegalArgumentException("OutputStream must be an instance of ByteArrayOutputStream");
        }
        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)outputStream;
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        return new ByteArrayInputStream(byteArray);
    }

    public InputStream removeAttachmentsFromMime(InputStream inputStream) {
        InputStream convertedStream = null;
        logger.debug("......entering remove attachments1111111111.........");
        try {
            logger.debug("......entering remove attachments1.........");
            DefaultMessageBuilder messageBuilder = new DefaultMessageBuilder();
            org.apache.james.mime4j.dom.Message message = messageBuilder.parseMessage(inputStream);
            logger.debug("......entering remove attachments3.........");
            if (message.isMultipart()) {
                logger.debug("......entering remove attachments7.........");
                MultipartImpl newMultipart = null;
                if (message.getBody() instanceof Multipart) {
                    Multipart multipart = (Multipart)message.getBody();
                    newMultipart = new MultipartImpl(multipart.getSubType());
                    for (Entity part : multipart.getBodyParts()) {
                        if (part.getDispositionType() != null && part.getDispositionType().equalsIgnoreCase("attachment")) continue;
                        newMultipart.addBodyPart(part);
                    }
                }
                logger.debug("......entering remove attachments7a.........");
                MessageImpl newMessage = new MessageImpl();
                newMessage.setBody((Body)newMultipart);
                newMessage.setHeader(message.getHeader());
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                logger.debug("......entering remove attachments8.........");
                DefaultMessageWriter messageWriter = new DefaultMessageWriter();
                logger.debug("......entering remove attachments9.........");
                messageWriter.writeMessage((org.apache.james.mime4j.dom.Message)newMessage, (OutputStream)outputStream);
                logger.debug("......entering remove attachments10.........");
                convertedStream = CloudBackupController.convert(outputStream);
                logger.debug("......entering remove attachments11.........");
            } else {
                logger.debug("The message does not contain attachments.");
                String contentType = message.getMimeType();
                logger.debug("Single-part message Content-Type: " + contentType);
                convertedStream = inputStream;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("....error converting stream...." + e.getMessage());
        }
        return convertedStream;
    }

    private long getMailRecievedDate(Message message, String filePath) {
        long receivedDateTime = 0L;
        if (filePath.contains("Sent Item")) {
            if (message.sentDateTime != null && message.sentDateTime.toInstant() != null) {
                SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                String date = df2.format(message.sentDateTime.toInstant().toEpochMilli());
                logger.debug("....sent date....." + date);
                SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                try {
                    long milliseconds;
                    Date d = f.parse(date);
                    receivedDateTime = milliseconds = d.getTime();
                    logger.debug(".....date-to-parse...." + milliseconds);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        } else if (message.receivedDateTime != null && message.receivedDateTime.toInstant() != null) {
            SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            String date = df2.format(message.receivedDateTime.toInstant().toEpochMilli());
            logger.debug("....receivedDateTime date....." + date);
            SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            try {
                long milliseconds;
                Date d = f.parse(date);
                receivedDateTime = milliseconds = d.getTime();
                logger.debug(".....receivedDateTime-date-to-parse...." + milliseconds);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return receivedDateTime;
    }

    private void saveBlackListUser(Cloud cloud, String userName) {
        O365BlackListUser o365BlackListUser = new O365BlackListUser();
        o365BlackListUser.setUserName(userName);
        o365BlackListUser.setResponseCode("404");
        o365BlackListUser.setLocalHost(PCHelperConstant.getComponentName());
        this.utilService.saveO365BlackListUser(cloud.getCloudId(), o365BlackListUser);
    }

    private void saveFailedFilesReason(int cloudId, String userName, int responseCode, String fileName, String filePath, String reason, String deviceUUID, String osType, String batchId) {
        FailedFileReason failedFileReason = new FailedFileReason();
        failedFileReason.setUserName(userName);
        failedFileReason.setResponseCode(responseCode);
        failedFileReason.setFileName(fileName);
        failedFileReason.setFilePath(filePath);
        failedFileReason.setOsType(osType);
        failedFileReason.setDeviceUUID(deviceUUID);
        failedFileReason.setReason(reason);
        failedFileReason.setBatchId(batchId);
        this.utilService.saveFailedFilesReason(cloudId, failedFileReason);
    }

    private void sleep5sec() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private String getDriveIdForUser(Cloud cloud, String emailId) {
        Drive drive = null;
        try {
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (UserCollectionPage)((UserCollectionRequest)Graph.getInstance().getGraphClient().users().buildRequest(requestOptions)).top(1).get());
            String userId = "";
            for (User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            logger.debug(userId + ".. get drive1 for user given name.... " + emailId);
            int retryDrive = 0;
            do {
                drive = this.getDrive(userId);
                logger.debug(++retryDrive + "....drive for user...." + String.valueOf(drive));
                Thread.sleep(10000L);
            } while (retryDrive < 5 && drive == null || drive == null);
            if (drive != null) {
                logger.debug(emailId + "....drive id for user ... " + drive.id);
                return drive.id;
            }
        }
        catch (GraphServiceException e) {
            logger.error(" ... error trying to get token ..." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.debug("..sleep for 90 sec...");
                try {
                    Thread.sleep(90000L);
                    return this.getDriveIdForUser(cloud, emailId);
                }
                catch (InterruptedException interruptedException) {
                }
            } else if (e.getResponseCode() == 404) {
                logger.error("... not able to access resource check right user token is mapped .... " + emailId);
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
        return null;
    }

    private Drive getDrive(String userId) {
        Drive drive = (Drive)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().users(userId).drive().buildRequest(new Option[0]).get());
        return drive;
    }

    private boolean checkForExtensions(String fileName, List<InclusionFilter> inclusionFilterList, String filterType) {
        boolean allow = false;
        if (CollectionUtils.isEmpty(inclusionFilterList)) {
            return true;
        }
        HashSet<String> inclusionFilterExtensions = new HashSet<String>();
        HashSet<String> exclusionFilterExtensions = new HashSet<String>();
        boolean allowAllextensions = false;
        for (InclusionFilter inclusionFilter : inclusionFilterList) {
            if (inclusionFilter == null) continue;
            String[] extensions = inclusionFilter.getExtensionName().split(",");
            if (!org.springframework.util.StringUtils.isEmpty((Object)filterType) && filterType.equalsIgnoreCase("exclusion")) {
                for (String ext : extensions) {
                    ext = ext.toLowerCase();
                    exclusionFilterExtensions.add(ext);
                }
            } else {
                for (String ext : extensions) {
                    ext = ext.toLowerCase();
                    inclusionFilterExtensions.add(ext);
                }
            }
            if (allowAllextensions) continue;
            allowAllextensions = inclusionFilterExtensions.contains("all");
        }
        logger.debug(inclusionFilterExtensions.size() + "....filterlist... " + exclusionFilterExtensions.size());
        for (String ext : inclusionFilterExtensions) {
            logger.debug(".....inclusion list val..." + ext);
        }
        for (String ext : exclusionFilterExtensions) {
            logger.debug(".....exclusion list val..." + ext);
        }
        if (!allowAllextensions) {
            if (exclusionFilterExtensions.size() > 0 && !exclusionFilterExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
                allow = true;
            } else if (inclusionFilterExtensions.size() > 0 && inclusionFilterExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
                allow = true;
            }
        } else {
            allow = true;
        }
        return allow;
    }

    private Date getDateVal(String dateValue) {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        try {
            JSONObject dateObj = new JSONObject(dateValue);
            date = simpleDateFormat.parse(dateObj.getString("dateTime").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    private static boolean checkFileSize(Long fileSize, long allowedSize) {
        boolean isFileTobeSkipped = true;
        if (allowedSize != 0L && allowedSize != -1L) {
            long fileSizeinBytes = fileSize;
            float fileSizeinMb = (float)fileSizeinBytes / 1048576.0f;
            if (fileSizeinMb <= (float)allowedSize) {
                isFileTobeSkipped = false;
            }
        } else if (allowedSize == -1L) {
            isFileTobeSkipped = false;
        }
        return isFileTobeSkipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String downloadAttachment1(String accessToken, String attachId, String attachname, String userId, String msgId, String filePath, String cloudName) {
        String downloadurl = "https://graph.microsoft.com/v1.0/users/" + userId + "/messages/" + msgId + "/attachments/" + attachId + "/$value";
        Object downloadedName = "";
        try {
            logger.debug("...start download attachment .....");
            OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
            HttpUrl.Builder httpBuilder = HttpUrl.parse((String)downloadurl).newBuilder();
            Request request = new Request.Builder().url(httpBuilder.build()).build();
            Response response = okHttpClient.newCall(request).execute();
            InputStream inputStream = response.body().byteStream();
            int responseCode = response.code();
            logger.debug("...attachment download responsecode...." + responseCode);
            attachname = MD5Generator.generateMD5OfString((String)attachname);
            String fullpath = filePath + "/" + attachname;
            logger.debug("... file PAth...." + fullpath);
            File parent = new File(filePath);
            if (!parent.exists()) {
                parent.mkdirs();
            }
            File file = null;
            try {
                file = new File(fullpath);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
            }
            catch (Exception e) {
                fullpath = filePath + "/" + System.currentTimeMillis();
                file = new File(fullpath);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
            }
            byte[] b = new byte[4096];
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            try (FileOutputStream outstream = new FileOutputStream(file);){
                int buff = -1;
                while ((buff = inputStream.read(b)) != -1) {
                    outstream.write(b, 0, buff);
                    md.update(b, 0, buff);
                }
                logger.error(file.getAbsolutePath() + "  tranferFileFromStream > getSizeinMb(intermediateFile.length()) ................ " + CloudBackupController.getSizeinMb(file.length()));
            }
            catch (FileNotFoundException e) {
                logger.error("Exception", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Exception", (Throwable)e);
            }
            catch (Exception e) {
                logger.trace(String.valueOf(e));
                logger.error("Exception While Transfering File From Stream :" + e.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            try {
                response.close();
            }
            catch (Exception e1) {
                logger.error("..unable to close....");
            }
            String uploadedFileMd5Checksum = MD5Generator.generateMD5OfFile((File)file);
            File chunkFile = new File(filePath + "/" + uploadedFileMd5Checksum);
            logger.debug(attachname + "....renamechunk...." + uploadedFileMd5Checksum);
            file.renameTo(chunkFile);
            downloadedName = uploadedFileMd5Checksum;
            String fsPath = CloudBackupController.getFsPath((String)downloadedName);
            try {
                if (file.exists()) {
                    file.delete();
                }
                if (chunkFile.exists()) {
                    chunkFile.delete();
                }
                downloadedName = (String)downloadedName + "~~" + fsPath;
                logger.debug(" end of move file to search path" + (String)downloadedName);
            }
            catch (Exception e) {
                logger.trace(String.valueOf(e));
                logger.error(" Error trying to create index file ....... " + e.getMessage());
            }
        }
        catch (ClientProtocolException e) {
            logger.error("Exception", (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Exception", (Throwable)e);
        }
        return downloadedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String downloadPhoto(String accessToken, String attachId, String attachname, String userId, String msgId, String filePath, String cloudName) {
        Object downloadedName = "";
        try {
            InputStream inputStream = Graph.getGraphClientFromGraph().users(userId).contacts(msgId).photo().content().buildRequest(new Option[0]).get();
            String fullpath = filePath + "/" + attachname;
            logger.debug("... file PAth...." + fullpath);
            File parent = new File(filePath);
            if (!parent.exists()) {
                parent.mkdirs();
            }
            File file = new File(fullpath);
            file.createNewFile();
            byte[] b = new byte[4096];
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            try (FileOutputStream outstream = new FileOutputStream(file);){
                int buff = -1;
                while ((buff = inputStream.read(b)) != -1) {
                    outstream.write(b, 0, buff);
                    md.update(b, 0, buff);
                }
                logger.error(file.getAbsolutePath() + "  tranferFileFromStream > getSizeinMb(intermediateFile.length()) ................ " + CloudBackupController.getSizeinMb(file.length()));
            }
            catch (FileNotFoundException e) {
                logger.error("Exception", (Throwable)e);
                file.delete();
            }
            catch (IOException e) {
                logger.error("Exception", (Throwable)e);
                file.delete();
            }
            catch (Exception e) {
                logger.trace(String.valueOf(e));
                logger.error("Exception While Transfering File From Stream :" + e.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            String uploadedFileMd5Checksum = "photo-" + MD5Generator.generateMD5OfFile((File)file);
            File chunkFile = new File(filePath + "/" + uploadedFileMd5Checksum);
            logger.debug(attachname + "....renamechunk...." + uploadedFileMd5Checksum);
            file.renameTo(chunkFile);
            downloadedName = uploadedFileMd5Checksum;
            String fsPath = CloudBackupController.getFsPath((String)downloadedName);
            String indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            logger.debug("...indexpat..." + indexPath);
            try {
                File parent1 = new File(indexPath);
                File f = parent1.getParentFile();
                if (!f.exists()) {
                    f.mkdirs();
                }
                logger.debug(" move file to search path" + indexPath);
                FileUtils.copyFile((File)chunkFile, (File)parent1);
                downloadedName = (String)downloadedName + "~~" + fsPath;
                logger.debug(" end of move file to search path" + (String)downloadedName);
            }
            catch (Exception e) {
                logger.trace(String.valueOf(e));
                logger.error(" Error trying to create index file ....... " + e.getMessage());
            }
        }
        catch (ClientProtocolException e) {
            logger.error("Exception", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Exception", (Throwable)e);
        }
        return downloadedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String downloadTaskAttachment(InputStream inputStream, String attachname, String filePath, String cloudName) {
        Object downloadedName = "";
        try {
            String fullpath = filePath + "/" + attachname;
            logger.debug("... file PAth...." + fullpath);
            File parent = new File(filePath);
            if (!parent.exists()) {
                parent.mkdirs();
            }
            File file = new File(fullpath);
            file.createNewFile();
            byte[] b = new byte[4096];
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            try (FileOutputStream outstream = new FileOutputStream(file);){
                int buff = -1;
                while ((buff = inputStream.read(b)) != -1) {
                    outstream.write(b, 0, buff);
                    md.update(b, 0, buff);
                }
                logger.error(file.getAbsolutePath() + "  tranferFileFromStream > getSizeinMb(intermediateFile.length()) ................ " + CloudBackupController.getSizeinMb(file.length()));
            }
            catch (FileNotFoundException e) {
                logger.error("Exception", (Throwable)e);
                file.delete();
            }
            catch (IOException e) {
                logger.error("Exception", (Throwable)e);
                file.delete();
            }
            catch (Exception e) {
                logger.trace(String.valueOf(e));
                logger.error("Exception While Transfering File From Stream :" + e.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            String uploadedFileMd5Checksum = MD5Generator.generateMD5OfFile((File)file);
            File chunkFile = new File(filePath + "/" + uploadedFileMd5Checksum);
            logger.debug(attachname + "....renamechunk...." + uploadedFileMd5Checksum);
            file.renameTo(chunkFile);
            downloadedName = uploadedFileMd5Checksum;
            String fsPath = CloudBackupController.getFsPath((String)downloadedName);
            String indexPath = CloudBackupController.getPropertyFileValueParabluFolderBasePath(cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            logger.debug("...indexpat..." + indexPath);
            try {
                File parent1 = new File(indexPath);
                File f = parent1.getParentFile();
                if (!f.exists()) {
                    f.mkdirs();
                }
                logger.debug(" move file to search path" + indexPath);
                FileUtils.copyFile((File)chunkFile, (File)parent1);
                downloadedName = (String)downloadedName + "~~" + fsPath;
                logger.debug(" end of move file to search path" + (String)downloadedName);
            }
            catch (Exception e) {
                logger.trace(String.valueOf(e));
                logger.error(" Error trying to create index file ....... " + e.getMessage());
            }
        }
        catch (ClientProtocolException e) {
            logger.error("Exception", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Exception", (Throwable)e);
        }
        return downloadedName;
    }

    private InputStream downloadMail(String userId, String msgId) {
        InputStream inputStream = null;
        try {
            inputStream = (InputStream)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().users(userId).messages(msgId).content().buildRequest(new Option[0]).get());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(".....exception trying to download email...." + e.getMessage());
        }
        return inputStream;
    }

    private InputStream downloadMailForSearch(String userId, String msgId) {
        InputStream inputStream = null;
        try {
            inputStream = (InputStream)this.retryPolicyFactory.executeWithRetry(() -> Graph.getInstance().getGraphClient().users(userId).messages(msgId).content().buildRequest(new Option[0]).get());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(".....exception trying to download email...." + e.getMessage());
        }
        return inputStream;
    }

    private static InputStream downloadContact(String accessToken, String userId, String contactId) {
        String downloadurl = "https://graph.microsoft.com/v1.0/users/" + userId + "/contacts/" + contactId + "/$value";
        InputStream inputStream = null;
        try {
            OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
            HttpUrl.Builder httpBuilder = HttpUrl.parse((String)downloadurl).newBuilder();
            Request request = new Request.Builder().url(httpBuilder.build()).build();
            Response response = okHttpClient.newCall(request).execute();
            inputStream = response.body().byteStream();
            int responseCode = response.code();
            logger.debug(" Response status code: " + responseCode);
            try {
                response.close();
            }
            catch (Exception e1) {
                logger.error("..unable to close....");
            }
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return inputStream;
    }

    @Override
    public CompletableFuture<UploadStatus> notifyService(Map<String, ? super Object> fileProperties, InputStream buffer, com.parablu.pcbd.domain.User user) {
        UploadStatus status = new UploadStatus((String)fileProperties.get("messageID"), true, 0, 0L);
        CompletableFuture<UploadStatus> statusWhenDone = new CompletableFuture<UploadStatus>();
        UploadStatus newStatus = this.uploadAsync(status, fileProperties, user);
        statusWhenDone.complete(newStatus);
        return statusWhenDone;
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoList(int cloudId) {
        return this.utilService.getDriveFileInfoList();
    }

    @Override
    public void deleteBatchFromOdServer(ObjectId id, String policyName) {
        this.utilService.deleteBatchFromOdServer(id, policyName);
    }

    @Override
    public List<ODBBackupBatch> getODBBatchList(int cloudId, String policyName, boolean retryDeferredBatch) {
        return this.utilService.getODBBatchList(policyName, retryDeferredBatch);
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoFromListForBatchId(int cloudId, String batchId, String deviceUUID) {
        return this.utilService.getDriveFileInfoFromListForBatchId(batchId, deviceUUID);
    }

    @Override
    public List<MailBackupBatch> getMailBatchList(int cloudId, String policyName) {
        return this.utilService.getMailBatchList(cloudId, policyName);
    }

    @Override
    public List<RestoreEvents> getRestoreEventsList(int cloudId, String policyName) {
        return this.utilService.getRestoreEventsList(cloudId, policyName);
    }

    @Override
    public long getTotalFilesCountByBatchId(int cloudId, String batchId, String deviceUUID) {
        return this.utilService.getTotalFilesCountByBatchId(batchId, deviceUUID);
    }

    @Override
    public List<DriveFileInfo> getOneDriveFileInfoFromListForBatchId(int cloudId, String batchId, String deviceUUID) {
        return this.utilService.getOneDriveFileInfoFromListForBatchId(cloudId, batchId, deviceUUID);
    }

    public static synchronized String getEWSAccesToken(EWSAppSetting ewsAppSetting) {
        String accessToken = "";
        try {
            long now = System.currentTimeMillis();
            ExecutorService es = Executors.newFixedThreadPool(2);
            AuthenticationContext context = new AuthenticationContext(AUTHORITY + ewsAppSetting.getTenantId(), false, es);
            AuthenticationCallback<AuthenticationResult> callback = new AuthenticationCallback<AuthenticationResult>(){

                public void onSuccess(AuthenticationResult result) {
                    logger.debug("received token");
                }

                public void onFailure(Throwable exc) {
                    throw new RuntimeException(exc);
                }
            };
            logger.debug("requesting token");
            Future future = context.acquireToken(RESOURCE, new ClientCredential(ewsAppSetting.getClientId(), ewsAppSetting.getClientSecretKey()), (AuthenticationCallback)callback);
            AuthenticationResult result = (AuthenticationResult)future.get(30L, TimeUnit.SECONDS);
            accessToken = result.getAccessToken();
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return accessToken;
    }

    public static ExchangeService getAuthenticatedService(String token, String senderAddr) {
        ExchangeService service = null;
        try {
            service = new ExchangeService(ExchangeVersion.Exchange2010_SP2);
            service.getHttpHeaders().put("Authorization", "Bearer " + token);
            service.getHttpHeaders().put("X-AnchorMailbox", senderAddr);
            service.setUrl(new URI(EWS_URL));
            service.setImpersonatedUserId(new ImpersonatedUserId(ConnectingIdType.PrincipalName, senderAddr));
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        return service;
    }

    @Override
    public void addFailedFiles(DriveFileInfo item, String policyName) {
        this.uploadService.addFailedFiles(item, policyName);
    }

    @Override
    public List<DriveFileInfo> getFailedFiles(String deviceUUID) {
        return this.uploadService.getFailedFiles(deviceUUID);
    }

    @Override
    public List<ODBBackupBatch> getODBBatchList(int cloudId, String policyName, int limit) {
        return this.utilService.getODBBatchList(policyName, limit);
    }

    private String getDriveIdForUserMailId(String emailId) {
        Drive drive = null;
        try {
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (UserCollectionPage)((UserCollectionRequest)Graph.getInstance().getGraphClient().users().buildRequest(requestOptions)).top(1).get());
            String userId = "";
            for (User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            logger.debug(userId + ".. get drive1 for user given name.... " + emailId);
            int retryDrive = 0;
            do {
                drive = this.getDrive(userId);
                logger.debug(++retryDrive + "....drive for user...." + String.valueOf(drive));
                Thread.sleep(10000L);
            } while (retryDrive < 5 && drive == null || drive == null);
            if (drive != null) {
                logger.debug(emailId + "....drive id for user ... " + drive.id);
                return drive.id;
            }
        }
        catch (GraphServiceException e) {
            logger.error(" ... error trying to get token ..." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.debug("..sleep for 90 sec...");
                try {
                    Thread.sleep(90000L);
                    return this.getDriveIdForUserMailId(emailId);
                }
                catch (InterruptedException interruptedException) {
                }
            } else if (e.getResponseCode() == 404) {
                logger.error("... not able to access resource check right user token is mapped .... " + emailId);
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
        return null;
    }

    protected String encodeBase64UTFString(String value) {
        String encodedString = value;
        try {
            encodedString = new String(Base64.encodeBase64((byte[])value.getBytes()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace(String.valueOf(e));
            logger.error(e.getMessage());
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return encodedString;
    }

    @Override
    public FileInfo getFileInfoForBatch(String batchId, String cloudName) {
        return this.uploadService.getFileInfoForBatch(batchId, cloudName);
    }

    public static OkHttpClient getOkHttpClient() {
        String authorityHost = "https://login.microsoftonline.com";
        OkHttpClient httpClient = null;
        if (!org.springframework.util.StringUtils.isEmpty((Object)PCHelperConstant.getProxyHost()) && PCHelperConstant.getProxyPort() != 0) {
            Authenticator proxyAuthenticator = new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)PCHelperConstant.getProxyUserName(), (String)PCHelperConstant.getProxyPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            };
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()));
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).proxyOptions(proxyOptions)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()))).proxyAuthenticator(proxyAuthenticator).build();
        } else {
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().build();
        }
        return httpClient;
    }

    private double getUsedPercentage(Drive theDrive) {
        long remaining = theDrive.quota.remaining;
        long total = theDrive.quota.total;
        double percentage = (double)remaining / (double)total * 100.0;
        double usedPercent = 100.0 - percentage;
        return usedPercent;
    }

    private static int deleteFile(String driveId, String itemId) {
        String fileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/items/" + itemId;
        logger.debug("...delete url...." + fileUrl);
        int responseCode = 0;
        try {
            OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
            Request request = new Request.Builder().url(fileUrl).delete().build();
            Call call = okHttpClient.newCall(request);
            Response response = call.execute();
            responseCode = response.code();
            logger.debug("...deleted usinggraph...." + responseCode);
            response.close();
        }
        catch (GraphServiceException e) {
            logger.error("GraphServiceException....", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("graph exception to delete:", (Object)e.getMessage());
        }
        return responseCode;
    }

    private boolean toFilterCheck(EmailMessage message, String toVal) {
        boolean isToAllowed = true;
        List<Object> toList = new ArrayList();
        List toRecipients = null;
        try {
            toRecipients = message.getToRecipients().getItems();
        }
        catch (ServiceLocalException e1) {
            e1.printStackTrace();
        }
        if (!CollectionUtils.isEmpty((Collection)toRecipients)) {
            String[] torecArr = toVal.split(",");
            if (torecArr != null) {
                toList = Arrays.asList(torecArr);
            }
            for (microsoft.exchange.webservices.data.property.complex.EmailAddress torec : toRecipients) {
                if (CollectionUtils.isEmpty(toList)) continue;
                for (String string : toList) {
                    String string2 = string.replace("*", "");
                    try {
                        if (!torec.getAddress().contains(string2)) continue;
                        isToAllowed = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return isToAllowed;
    }

    private boolean fromFilterCheck(EmailMessage message, String fromVal) {
        boolean isFromAllowed = true;
        String[] fromValArr = fromVal.split(",");
        logger.debug("......from filter....." + fromVal);
        List<Object> fromList = new ArrayList();
        if (fromValArr != null && !CollectionUtils.isEmpty(fromList = Arrays.asList(fromValArr))) {
            for (String string : fromList) {
                String string2 = string.replace("*", "");
                try {
                    logger.debug(string2 + "......from filter....." + message.getFrom().getAddress());
                    if (!message.getFrom().getAddress().contains(string2)) continue;
                    isFromAllowed = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return isFromAllowed;
    }

    private static boolean isContainExactWord(String fullString, String partWord) {
        String pattern = "\\b" + partWord + "\\b";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(fullString);
        return m.find();
    }

    private boolean isMailArchivingEnabled(Cloud cloud) {
        boolean isMailArchivingEnabled = false;
        List licenseDetails = cloud.getCloudCustomisableDetails();
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"Mail Archiving Enabled".equalsIgnoreCase(license.getName())) continue;
            isMailArchivingEnabled = true;
            break;
        }
        return isMailArchivingEnabled;
    }

    private boolean isOneDriveArchivingEnabled(Cloud cloud) {
        boolean isOneDriveArchivingEnabled = false;
        List licenseDetails = cloud.getCloudCustomisableDetails();
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"OneDrive Archiving Enabled".equalsIgnoreCase(license.getName())) continue;
            isOneDriveArchivingEnabled = true;
            break;
        }
        return isOneDriveArchivingEnabled;
    }

    private boolean isSPArchivingEnabled(Cloud cloud) {
        boolean isSPArchivingEnabled = false;
        List licenseDetails = cloud.getCloudCustomisableDetails();
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"SP Archiving Enabled".equalsIgnoreCase(license.getName())) continue;
            isSPArchivingEnabled = true;
            break;
        }
        return isSPArchivingEnabled;
    }

    private String getOdItemId(String userId, String odItemId) {
        try {
            LinkedList<String> inputIdsList = new LinkedList<String>();
            ExchangeIdFormat sourceIdType = ExchangeIdFormat.EWS_ID;
            ExchangeIdFormat targetIdType = ExchangeIdFormat.REST_ID;
            inputIdsList.add(odItemId);
            UserTranslateExchangeIdsParameterSet exchangeIdsParameterSet = new UserTranslateExchangeIdsParameterSet();
            exchangeIdsParameterSet.inputIds = inputIdsList;
            exchangeIdsParameterSet.targetIdType = targetIdType;
            exchangeIdsParameterSet.sourceIdType = sourceIdType;
            UserTranslateExchangeIdsCollectionPage post = (UserTranslateExchangeIdsCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (UserTranslateExchangeIdsCollectionPage)((UserTranslateExchangeIdsCollectionRequest)Graph.getInstance().getGraphClient().users(userId).translateExchangeIds(exchangeIdsParameterSet).buildRequest(new Option[0])).post());
            List convertedIdPages = post.getCurrentPage();
            for (ConvertIdResult convertIdResult : convertedIdPages) {
                logger.debug(inputIdsList.size() + "...converted ewsidsss ...." + convertIdResult.targetId);
                odItemId = convertIdResult.targetId;
            }
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return odItemId;
    }

    private void printGraphHeaders(String messageId, String graphuserId, Message message) throws InterruptedException {
        if (message != null) {
            Set entrySet = message.additionalDataManager().entrySet();
            Map.Entry next = (Map.Entry)entrySet.iterator().next();
            JsonElement jsonElement = (JsonElement)next.getValue();
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            logger.debug("*****CLIENT-REQUEST-ID***" + String.valueOf(jsonObject.get("client-request-id")));
            logger.debug("*****DATE***" + String.valueOf(jsonObject.get("date")));
            logger.debug("*****request-id***" + String.valueOf(jsonObject.get("request-id")));
            logger.debug("*****x-ms-ags-diagnostic***" + String.valueOf(jsonObject.get("x-ms-ags-diagnostic")));
            logger.debug("*****Graph USER id***" + graphuserId);
            logger.debug("*****Message id***" + messageId);
        }
    }

    @Override
    public ODBBackupBatch getODBBackupBatch(int cloudId, ObjectId id, String policyName) {
        return this.utilService.getODBBackupBatch(cloudId, id, policyName);
    }

    public static Date convertDateTimeTimeZoneToDate(DateTimeTimeZone dateTimeTimeZone) {
        try {
            if (dateTimeTimeZone == null) {
                return null;
            }
            ZonedDateTime eventStartTime = ZonedDateTime.of(LocalDateTime.parse(dateTimeTimeZone.dateTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME), ZoneId.of(dateTimeTimeZone.timeZone));
            ZonedDateTime zonedDateTime = eventStartTime.withZoneSameInstant(ZoneId.systemDefault());
            return Date.from(zonedDateTime.toInstant());
        }
        catch (DateTimeParseException e) {
            logger.debug("Error parsing date time: " + e.getMessage());
            return null;
        }
    }

    public static InputStream convertContactToStream(Contact contact) {
        if (contact == null) {
            logger.debug("No contact data to convert to stream.");
            return null;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerModule((Module)new JavaTimeModule());
            String contactJson = objectMapper.writeValueAsString((Object)contact);
            ByteArrayInputStream contactStream = new ByteArrayInputStream(contactJson.getBytes());
            logger.debug("Contact data converted to stream.");
            return contactStream;
        }
        catch (Exception e) {
            logger.debug("Error converting contact to stream: " + e.getMessage());
            return null;
        }
    }

    @Override
    public String restoretMailboxProtectionUnitsByDirectoryObjectId(Device device, boolean inplace, String restorePointId) {
        return this.uploadService.restoretMailboxProtectionUnitsByDirectoryObjectId(device, inplace, restorePointId);
    }

    @Override
    public void waitForRestoreCompletion(String restoreSessionId, BackupBatch backupBatch, int cloudId, String deviceType) {
        this.uploadService.waitForRestoreCompletion(restoreSessionId, backupBatch, cloudId, deviceType);
    }

    @Override
    public String restoreOdbProtectionUnitsByDirectoryObjectId(Device device, boolean inPlaceRestore, String restorePointId) {
        return this.uploadService.restoreOdbProtectionUnitsByDirectoryObjectId(device, inPlaceRestore, restorePointId);
    }

    @Override
    public RestorePoint getLatestRestorePoint(Device device) {
        return this.uploadService.getLatestRestorePoint(device);
    }

    @Override
    public String restoreSPProtectionUnitsByDirectoryObjectId(Device device, boolean inPlaceRestore, String restorePointId) {
        return this.uploadService.restoreSPProtectionUnitsByDirectoryObjectId(device, inPlaceRestore, restorePointId);
    }

    @Override
    public String getRestoredSiteId(String restoreSessionId, String type) {
        return this.uploadService.getRestoredSiteId(restoreSessionId, type);
    }

    static {
        sem = new Semaphore(1);
        System.setProperty("DEBUG.MONGO", "true");
        System.setProperty("DB.TRACE", "true");
        try {
            sem.acquire(1);
        }
        catch (InterruptedException e) {
            logger.error("Failed to acquire semaphore! ", (Throwable)e);
        }
    }
}

