/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BluKryptStorageMapping;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCredentials;
import com.pg.controller.DownloadController;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UtilService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class BluKryptController {
    private static Logger logger = LogManager.getLogger(DownloadController.class);
    public static final String LOCAL_STORAGE = "localStorage";
    @Autowired
    private UtilService utilService;

    @RequestMapping(value={"/save/bluKryptStorageMapping/"}, method={RequestMethod.POST})
    public void updateRestartID(HttpServletRequest request, HttpServletResponse httpResponse) {
        String blukryptName = PCHelperConstant.getComponentName();
        boolean isGDEnabled = Boolean.valueOf(request.getHeader("isGDEnabled"));
        boolean isODBEnabled = Boolean.valueOf(request.getHeader("isODBEnabled"));
        String cloudType = request.getHeader("cloudType");
        logger.debug(blukryptName + "..comp and productype..." + cloudType);
        BluKryptStorageMapping bluKryptStorageMapping = new BluKryptStorageMapping();
        Cloud cloud = this.utilService.getCloud(1);
        List cloudCredentialsList = cloud.getCloudCredentials();
        CloudCredentials cloudCredentials = null;
        if (!StringUtils.isEmpty((String)cloudType) && "local".equalsIgnoreCase(cloudType) && !CollectionUtils.isEmpty((Collection)cloudCredentialsList)) {
            for (CloudCredentials cc : cloudCredentialsList) {
                if (cc == null || !LOCAL_STORAGE.equalsIgnoreCase(cc.getCloudName())) continue;
                logger.debug(" local storage flag ..... ");
                cloudCredentials = cc;
                break;
            }
        }
        bluKryptStorageMapping.setBlukrytName(blukryptName);
        bluKryptStorageMapping.setGDEnabled(isGDEnabled);
        bluKryptStorageMapping.setODBEnabled(isODBEnabled);
        if (cloudCredentials != null) {
            ArrayList<String> ccList = new ArrayList<String>();
            if (LOCAL_STORAGE.equalsIgnoreCase(cloudCredentials.getCloudName())) {
                ccList.add(LOCAL_STORAGE);
            }
            bluKryptStorageMapping.setCloudCredentials(ccList);
        }
        logger.debug(" Before updating blukrypt storage...........");
        this.utilService.saveBlukryptStorage(1, bluKryptStorageMapping);
        logger.debug(" After updating blukrypt storage...........");
        httpResponse.setStatus(200);
    }

    @RequestMapping(value={"/start/cp/"}, method={RequestMethod.POST})
    public void startCapacitySavings1(HttpServletRequest request, HttpServletResponse httpResponse) {
        String loggedInUserName;
        String productType = request.getHeader("productType");
        String userName = request.getHeader("userName");
        logger.debug(PCHelperConstant.isJobEnabled((String)"spCapacityManualMgmtJobTrigger") + "...." + userName + ".....start /start/cp/...." + productType);
        if (!StringUtils.isEmpty((String)productType)) {
            if ("ODB".equalsIgnoreCase(productType) && !PCHelperConstant.isJobEnabled((String)"odbCapacityManualMgmtJobTrigger")) {
                logger.debug("ODBCapacityManualMgmtJob ............. disabled");
                return;
            }
            if ("SHAREPOINT".equalsIgnoreCase(productType) && !PCHelperConstant.isJobEnabled((String)"spCapacityManualMgmtJobTrigger")) {
                logger.debug("SPCapacityManualMgmtJob ............. disabled");
                return;
            }
            if ("OUTLOOK".equalsIgnoreCase(productType) && !PCHelperConstant.isJobEnabled((String)"outlookCapacityManualMgmtJobTrigger")) {
                logger.debug("OutlookCapacityMgmtJob ............. disabled");
                return;
            }
        }
        if (StringUtils.isNotEmpty((String)(loggedInUserName = request.getHeader("loggedInUserName")))) {
            loggedInUserName = this.decodeBase64UTFString(loggedInUserName);
        }
        logger.debug("...before creating batch...." + loggedInUserName);
        this.utilService.createCPBackupBatch(1, productType, true);
        AuditHistory audit = new AuditHistory();
        audit.setAction("started capacity savings job");
        audit.setActionByUserName(loggedInUserName);
        audit.setActionOnObject("");
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("");
        audit.setActionType(210);
        this.utilService.saveAudit(1, audit);
        httpResponse.setStatus(200);
        logger.debug(".....end /start/cp/....");
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }
}

