/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.cloudbackup;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.microsoft.graph.models.Attachment;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.PatternedRecurrence;
import com.microsoft.graph.models.RecurrencePattern;
import com.microsoft.graph.models.RecurrenceRange;
import com.microsoft.graph.models.TodoTask;
import java.util.HashMap;
import java.util.Map;

public class ODataTypeUtil {
    private static final Map<Class<?>, String> ODATA_TYPE_MAP = new HashMap();

    public static Map<String, Object> addODataType(Object obj) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        Class<?> objClass = obj.getClass();
        if (ODATA_TYPE_MAP.containsKey(objClass)) {
            objectMap.put("@odata.type", ODATA_TYPE_MAP.get(objClass));
        }
        ObjectMapper objectMapper = ODataTypeUtil.getObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Map objectFields = (Map)objectMapper.convertValue(obj, Map.class);
        objectMap.putAll(objectFields);
        return objectMap;
    }

    public static String serializeWithODataType(Object obj) throws Exception {
        Map<String, Object> objectWithODataType = ODataTypeUtil.addODataType(obj);
        ObjectMapper objectMapper = ODataTypeUtil.getObjectMapper();
        return objectMapper.writeValueAsString(objectWithODataType);
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.findAndRegisterModules();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    static {
        ODATA_TYPE_MAP.put(TodoTask.class, "#microsoft.graph.todoTask");
        ODATA_TYPE_MAP.put(ItemBody.class, "#microsoft.graph.itemBody");
        ODATA_TYPE_MAP.put(DateTimeTimeZone.class, "#microsoft.graph.dateTimeTimeZone");
        ODATA_TYPE_MAP.put(PatternedRecurrence.class, "#microsoft.graph.patternedRecurrence");
        ODATA_TYPE_MAP.put(RecurrencePattern.class, "#microsoft.graph.recurrencePattern");
        ODATA_TYPE_MAP.put(RecurrenceRange.class, "#microsoft.graph.recurrenceRange");
        ODATA_TYPE_MAP.put(Attachment.class, "#microsoft.graph.attachment");
    }
}

