/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.parablu.bluvault.udc.dto.DeleteDto;
import com.parablu.bluvault.udc.service.DataAgingService;
import com.parablu.bluvault.udc.service.EventHubManagementService;
import com.parablu.pcbd.domain.ApiGateWayProperties;
import com.parablu.unified.client.token.AzureTokenGenerator;
import com.parablu.unified.client.token.CachedTokenGenerator;
import com.parablu.unified.client.token.TokenGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DataAgingServiceImpl
implements DataAgingService {
    private static Logger logger = LogManager.getLogger(DataAgingServiceImpl.class);
    @Autowired
    private EventHubManagementService eventHubManagementService;

    public void setEventHubManagementService(EventHubManagementService eventHubManagementService) {
        this.eventHubManagementService = eventHubManagementService;
    }

    @Override
    public void deleteDetailsFromUserAndDevice(int cloudId, DeleteDto deleteDto) {
        try {
            AzureTokenGenerator tokenGenerator = new AzureTokenGenerator();
            CachedTokenGenerator cachedTokenGenerator = new CachedTokenGenerator((TokenGenerator)tokenGenerator);
            ApiGateWayProperties apiGateWayProperties = this.eventHubManagementService.getApiGateWayProperties(cloudId);
            String clientId = apiGateWayProperties.getClientId();
            String clientSecret = apiGateWayProperties.getClientSecret();
            String scope = apiGateWayProperties.getScope();
            String tenantId = apiGateWayProperties.getTenantId();
            String baseUrl = apiGateWayProperties.getGateWayUrl();
            String token = cachedTokenGenerator.getToken(clientId, clientSecret, scope, tenantId);
            RestTemplate restTemplate = new RestTemplate();
            ObjectMapper mapper = new ObjectMapper();
            String requestPayload = mapper.writeValueAsString((Object)deleteDto);
            logger.debug("requestPayload-->{}", (Object)requestPayload);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(token);
            HttpEntity request = new HttpEntity((Object)requestPayload, (MultiValueMap)headers);
            logger.debug("unified-->{}", (Object)baseUrl);
            restTemplate.postForEntity(baseUrl + "/delete", (Object)request, Void.class, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

