/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.parablu.bluvault.udc.service.CloudSettingsService;
import com.parablu.helper.constant.GeneralHelperConstant;
import com.parablu.helper.utils.ObjectDiffFinder;
import com.parablu.helper.utils.SmtpDiffFinder;
import com.parablu.paracloud.constant.CloudConfigRegistry;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.CloudAndHostMachineDataElement;
import com.parablu.paracloud.element.CloudCredentialElement;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.CloudRegistrationElement;
import com.parablu.paracloud.element.RwSampleFileElement;
import com.parablu.paracloud.element.SmtpElement;
import com.parablu.paracloud.util.JaxBSerializerHelper;
import com.parablu.paracloud.util.ParacloudUtils;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.PortalPropertiesDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCredentials;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.PortalProperties;
import com.parablu.pcbd.domain.RwSampleFileInfo;
import com.parablu.pcbd.domain.SmtpCredentials;
import jakarta.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CloudSettingsServiceImpl
implements CloudSettingsService {
    private static Logger logger = LogManager.getLogger(CloudSettingsServiceImpl.class);
    private static final String ALGO = "AES";
    private static final byte[] keyValue = new byte[]{84, 104, 101, 66, 101, 115, 116, 83, 101, 99, 114, 101, 116, 75, 101, 121};
    private CloudDao cloudDao;
    @Resource
    private PortalPropertiesDao portalPropertiesDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Autowired
    CloudConfigRegistry registry;
    private static final String IO_EXCEPTION = " IOException  :";
    private static final String EXCEPTION = "Exception  ";

    public void setCloudDao(CloudDao cloudDao) {
        this.cloudDao = cloudDao;
    }

    @Override
    public Cloud registerCloud(CloudAndHostMachineDataElement cloudAndHostMachineDataElement) {
        String localIp = ParacloudUtils.getLocalIP();
        String publicIp = ParacloudUtils.getPublicIP();
        Cloud cloud = null;
        if (localIp == null || localIp.isEmpty()) {
            localIp = publicIp;
        }
        try {
            cloudAndHostMachineDataElement.setCloudLocalIP(localIp);
            cloudAndHostMachineDataElement.setCloudPublicIP(publicIp);
            String xmlResponse = this.sendRegisterRequestToAmazon(cloudAndHostMachineDataElement);
            if (xmlResponse == null) {
                logger.debug("Response null");
                return null;
            }
            cloud = this.createCloudElementFromResponseData(xmlResponse);
            if (cloud != null && cloud.getCloudName() == null) {
                logger.debug("cloud name is null");
                return null;
            }
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return cloud;
    }

    @Override
    public Cloud registerCloudWithAmazon(CloudAndHostMachineDataElement cloudAndHostMachineDataElement) throws IOException {
        String publicIP = ParacloudUtils.getPublicIP();
        Cloud cloud = null;
        cloudAndHostMachineDataElement.setCloudPublicIP(publicIP);
        cloudAndHostMachineDataElement.setCloudLocalIP(publicIP);
        String xmlResponse = this.sendRegisterRequestToAmazon(cloudAndHostMachineDataElement);
        if (xmlResponse == null) {
            return null;
        }
        try {
            cloud = this.createCloudElementFromResponseData(xmlResponse);
            if (cloud != null && cloud.getCloudName() == null) {
                return null;
            }
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return cloud;
    }

    private Cloud createCloudElementFromResponseData(String xmlResponse) {
        Cloud cloud = new Cloud();
        CloudRegistrationElement cloudRegElement = JaxBSerializerHelper.unmarshallCloudRegistrationElement((String)xmlResponse);
        cloud.setCloudRegistrationUUId(cloudRegElement.getCloudUUID());
        cloud.setCloudSizeAllowed(cloudRegElement.getCloudSizeAllowed());
        cloud.setNoOfDevicesAllowed(0);
        cloud.setNoOfUsersAllowed(cloudRegElement.getTotalNoOfUsers());
        cloud.setStatusCode(cloudRegElement.getStatus());
        cloud.setValidityPeriod(cloudRegElement.getValidityPeriod());
        cloud.setCloudName(cloudRegElement.getCloudName());
        return cloud;
    }

    private String sendRegisterRequestToAmazon(CloudAndHostMachineDataElement cloudAndHostMachineDataElement) throws IOException {
        return null;
    }

    @Override
    public void saveCloudToDatabase(Cloud cloud) {
        int cloudId = cloud.getCloudId();
        new File(this.registry.get(cloudId).getPropertyFileValueParacloudMountPoint() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + cloud.getCloudName()).mkdirs();
        new File(this.registry.get(cloudId).getPropertyFileValueDefaultUploadPath(cloud.getCloudName())).mkdirs();
        new File(this.registry.get(cloudId).getPropertyFileValueParabluBackupFolderBasePath(cloud.getCloudName())).mkdirs();
        new File(this.registry.get(cloudId).getPropertyFileValueParabluFolderBasePath(cloud.getCloudName())).mkdirs();
        this.cloudDao.saveCloud(cloud);
    }

    @Override
    public void createNewCloud(Cloud cloud) {
        this.cloudDao.createNewCloud(cloud);
    }

    @Override
    public void saveCloudCredentials(int cloudId, CloudCredentials cloudCredentials) {
        this.cloudDao.saveCloudCredentials(cloudId, cloudCredentials);
    }

    @Override
    public List<CloudCredentialElement> getAllCloudCredentials(int cloudId) {
        List list = this.cloudDao.getAllCloudCredentials(cloudId);
        ArrayList<CloudCredentialElement> ccElementList = new ArrayList<CloudCredentialElement>();
        for (CloudCredentials cc : list) {
            CloudCredentialElement element = new CloudCredentialElement();
            BeanUtils.copyProperties((Object)cc, (Object)element);
            ccElementList.add(element);
        }
        return ccElementList;
    }

    @Override
    public boolean deleteCloudCredentials(int cloudId, String identity) {
        return this.cloudDao.deleteCloudCredentials(cloudId, identity);
    }

    @Override
    public void saveSmtpCredentials(int cloudId, SmtpElement smtpElement, String userName) {
        SmtpCredentials credentials = this.cloudDao.getSmtpCredentials(cloudId);
        SmtpElement changedFields = new SmtpElement();
        if (credentials == null) {
            credentials = new SmtpCredentials();
        }
        BeanUtils.copyProperties((Object)credentials, (Object)changedFields);
        changedFields.setSmtpAuth(smtpElement.getSmtpAuth());
        BeanUtils.copyProperties((Object)smtpElement, (Object)credentials);
        credentials.setSmtpAuth(String.valueOf(smtpElement.getSmtpAuth()));
        SmtpDiffFinder diffFinder = new SmtpDiffFinder();
        String changedFields1 = diffFinder.findDiff(changedFields, smtpElement);
        logger.debug(".......changedFields1....." + changedFields1);
        this.cloudDao.saveSmtpCredentials(cloudId, credentials);
        if (!StringUtils.isEmpty((Object)changedFields1)) {
            this.saveStatisticToDatabase(cloudId, "", " modified SMTP settings. The changed fields are " + changedFields1, userName, "Portal", PCActionTypes.SMTP_EDIT.getActionTypeValue());
        }
    }

    @Override
    public String saveCloudProperties(int cloudId, CloudPropertyElement cloudPropertyElement) {
        CloudPropertyElement existingCloudPropertyElement = new CloudPropertyElement();
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        if (cloudProperties == null) {
            cloudProperties = new CloudProperties();
        }
        String searchExclusionExtName = cloudProperties.getSearchExclusionExtName();
        BeanUtils.copyProperties((Object)cloudProperties, (Object)existingCloudPropertyElement);
        logger.debug(searchExclusionExtName + "cloud property azure vm>" + cloudProperties.getAzureVM());
        logger.debug("cloud property azure vm>" + cloudPropertyElement.getAzureVM());
        logger.debug("new cloud property ssl>" + cloudProperties.getSslAuthEnabled());
        logger.debug("bulk email delay>>" + cloudProperties.getBulkEmailDelay());
        cloudPropertyElement.setOnlySyncFromEndpoint(existingCloudPropertyElement.isOnlySyncFromEndpoint());
        cloudPropertyElement.setClamAvScanDelayInSec(existingCloudPropertyElement.getClamAvScanDelayInSec());
        cloudPropertyElement.setRansomwareDetectionPercentage(existingCloudPropertyElement.getRansomwareDetectionPercentage());
        cloudPropertyElement.setNoOfDaysToKeepRansomwareEvents(existingCloudPropertyElement.getNoOfDaysToKeepRansomwareEvents());
        cloudPropertyElement.setLogUnaccessedFiles(existingCloudPropertyElement.isLogUnaccessedFiles());
        cloudPropertyElement.setRansomwareDetectionFilesCount(existingCloudPropertyElement.getRansomwareDetectionFilesCount());
        cloudPropertyElement.setRestoreBlockedDevices(existingCloudPropertyElement.isRestoreBlockedDevices());
        cloudPropertyElement.setShowBackupCompletionReport(existingCloudPropertyElement.isShowBackupCompletionReport());
        cloudPropertyElement.setMultiTenancy(existingCloudPropertyElement.isMultiTenancy());
        cloudPropertyElement.setDnsPassword(existingCloudPropertyElement.getDnsPassword());
        cloudPropertyElement.setDnsUserName(existingCloudPropertyElement.getDnsUserName());
        cloudPropertyElement.setSuperAdminIPAddress(existingCloudPropertyElement.getSuperAdminIPAddress());
        cloudPropertyElement.setDaysToKeepServerLogs(existingCloudPropertyElement.getDaysToKeepServerLogs());
        cloudPropertyElement.setMaxSizeAllowedForscanInMB(existingCloudPropertyElement.getMaxSizeAllowedForscanInMB());
        cloudPropertyElement.setMaxItemsAllowedInPstExportWhileSearch(existingCloudPropertyElement.getMaxItemsAllowedInPstExportWhileSearch());
        cloudPropertyElement.setSizeAllowedForZipDownloadInMB(existingCloudPropertyElement.getSizeAllowedForZipDownloadInMB());
        cloudPropertyElement.setNoOfFilesAllowedForZipDownload(existingCloudPropertyElement.getNoOfFilesAllowedForZipDownload());
        cloudPropertyElement.setNoOfFoldersAllowedForZipDownload(existingCloudPropertyElement.getNoOfFoldersAllowedForZipDownload());
        if (existingCloudPropertyElement.getNumOfHitsToDBForContentChunkCheck() == 0) {
            cloudPropertyElement.setNumOfHitsToDBForContentChunkCheck(10);
        } else {
            cloudPropertyElement.setNumOfHitsToDBForContentChunkCheck(existingCloudPropertyElement.getNumOfHitsToDBForContentChunkCheck());
        }
        cloudPropertyElement.setShowpreview(existingCloudPropertyElement.isShowpreview());
        cloudPropertyElement.setSuperAdminIPAddress(existingCloudPropertyElement.getSuperAdminIPAddress());
        cloudPropertyElement.setAllowAgentUpdateWithoutDeviceUUID(existingCloudPropertyElement.isAllowAgentUpdateWithoutDeviceUUID());
        cloudPropertyElement.setWaterMarkText(existingCloudPropertyElement.getWaterMarkText());
        cloudPropertyElement.setAddWaterMark(existingCloudPropertyElement.isAddWaterMark());
        cloudPropertyElement.setSolrMultiShardCloudNames(existingCloudPropertyElement.getSolrMultiShardCloudNames());
        cloudPropertyElement.setBlobFuseEnabled(existingCloudPropertyElement.isBlobFuseEnabled());
        cloudPropertyElement.setSmbEmailId(existingCloudPropertyElement.getSmbEmailId());
        cloudPropertyElement.setCppProvisioningEmailId(existingCloudPropertyElement.getCppProvisioningEmailId());
        cloudPropertyElement.seteCommerceId(existingCloudPropertyElement.geteCommerceId());
        BeanUtils.copyProperties((Object)cloudPropertyElement, (Object)cloudProperties);
        String response = this.findCloudPropertyDiff(existingCloudPropertyElement, cloudPropertyElement);
        cloudProperties.setSearchExclusionExtName(searchExclusionExtName);
        if (!StringUtils.isEmpty((Object)cloudProperties.getDbBackupPassword())) {
            try {
                cloudProperties.setDbBackupPassword(this.encrypt(cloudProperties.getDbBackupPassword()));
            }
            catch (Exception e) {
                logger.trace(IO_EXCEPTION + String.valueOf(e));
                logger.error(IO_EXCEPTION + e.getMessage());
            }
        }
        cloudProperties.setLocalSolr(existingCloudPropertyElement.isLocalSolr());
        cloudProperties.setSearchJobThreads(existingCloudPropertyElement.getSearchJobThreads());
        cloudProperties.setFailedSearchRecLimit(existingCloudPropertyElement.getFailedSearchRecLimit());
        cloudProperties.setPgOverLoadLimitFreqCheck(existingCloudPropertyElement.getPgOverLoadLimitFreqCheck());
        cloudProperties.setGraphAppName(existingCloudPropertyElement.getGraphAppName());
        cloudProperties.setDownloadRetentionDays(existingCloudPropertyElement.getDownloadRetentionDays());
        cloudProperties.setSmbEmailId(existingCloudPropertyElement.getSmbEmailId());
        cloudProperties.setCppProvisioningEmailId(existingCloudPropertyElement.getCppProvisioningEmailId());
        cloudProperties.seteCommerceId(existingCloudPropertyElement.geteCommerceId());
        this.cloudDao.saveCloudProperties(cloudId, cloudProperties);
        this.initiateCloudProperties(cloudId);
        this.updatePortalProperties(cloudId, cloudProperties);
        return response;
    }

    private String findCloudPropertyDiff(CloudPropertyElement existingCloudPropertyElement, CloudPropertyElement cloudPropertyElement) {
        StringBuilder changedFields = new StringBuilder();
        ObjectDiffFinder objectDiffFinder = new ObjectDiffFinder();
        objectDiffFinder.finder((Object)existingCloudPropertyElement, (Object)cloudPropertyElement);
        objectDiffFinder.visiter(objectDiffFinder);
        ArrayList changes = new ArrayList(objectDiffFinder.changes);
        HashMap<String, Object> fieldChanges = new HashMap<String, Object>();
        for (Map change : changes) {
            Set keys = change.keySet();
            String propertyName = "";
            String newValue = "";
            String oldValue = "";
            for (String key : keys) {
                if (!StringUtils.isEmpty(change.get(key)) && key.contains("newValue")) {
                    newValue = change.get(key).toString();
                }
                if (key.contains("propertyName")) {
                    propertyName = change.get(key).toString();
                }
                if (StringUtils.isEmpty(change.get(key)) || !key.contains("oldValue")) continue;
                oldValue = change.get(key).toString();
            }
            if (!StringUtils.isEmpty((Object)propertyName)) {
                if (propertyName.startsWith("/")) {
                    propertyName = propertyName.replaceFirst("/", "");
                }
                String value = "";
                try {
                    value = this.decrypt(oldValue);
                    logger.info(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (propertyName.equals("dbBackupPassword") && !value.equals(newValue)) {
                    fieldChanges.put(propertyName, " Password has been changed");
                    logger.debug("Actual Data" + propertyName + "\"" + oldValue + "\" => \"" + newValue + "\"");
                    continue;
                }
                if (propertyName.equals("dbBackupPassword")) continue;
                fieldChanges.put(propertyName, "\"" + oldValue + "\" => \"" + newValue + "\"");
                logger.debug("Actual Data" + propertyName + "\"" + oldValue + "\" => \"" + newValue + "\"");
                continue;
            }
            logger.debug("field changes is empty ");
        }
        for (String field : fieldChanges.keySet()) {
            String key = field;
            key = key.contains("solrServerUrl") ? "Solr Server Url" : (key.contains("solrUrl") ? "Solr URL" : (key.contains("supportMail") ? "Server alert email ID" : (key.contains("emailToAdminOnly") ? "Emails To Admin Only" : (key.contains("canAdminRestoreAll") ? "Can Administrator restore other user's data" : (key.contains("defaultBkpPolicyName") ? "Default Backup Policy Name" : (key.contains("defaultSyncPolicyName") ? "Default Sync Policy Name" : (key.contains("defaultGuestSyncPolicyName") ? "Default Guest Sync Policy Name" : (key.contains("defaultO365PolicyName") ? "Default O365 Policy Name" : (key.contains("azureVM") ? "Azure VM" : (key.contains("localAD") ? "Local AD" : (key.contains("sslAuthEnabled") ? "SSl Auth Enabled" : (key.contains("reportRows") ? "Report Rows" : (key.contains("isCrawlEnabled") ? "Is Crawl Enabled" : (key.contains("isShareFileNameEnabled") ? "Is Share File Name Enabled" : (key.contains("maxCrawlHit") ? "Maximum Crawl Hit" : (key.contains("mongoReadPreference") ? "Mongo Read Preference" : (key.contains("emailBkpGroupName") ? "Email Backup Group Name" : (key.contains("emailSyncGroupName") ? "Email Sync Group Name" : (key.contains("bkpGroupEmail") ? "Backup Group Email" : (key.contains("syncGroupEmail") ? "Sync Group Email" : (key.contains("chunkUpdateMaxRetry") ? "Maximum Retry for Chunk Update" : (key.contains("clientMailName") ? "Signature string for end-user automated emails" : (key.contains("clientSupportMailName") ? "Administrator contact email ID" : (key.contains("adfsUrl") ? "ADFS URL" : (key.contains("isDomainCheckEnabled") ? "Is Domain Check Enabled" : (key.contains("bulkEmailDelay") ? "Bulk Email Delay (In Seconds)" : (key.contains("isEmailNotifierForRestoreEnabled") ? "Notify Through Email For Restores" : (key.contains("isEmailNotifierEnabledForFirstBackupCompletion") ? "Notify Through Email For First Backup Completion" : (key.contains("daysToWaitForNextBackup") ? "Fairness Algorithm" : (key.contains("canAdminChangeUserPassword") ? "Allow Admin To Change User Password" : (key.contains("canDelegatedAdminChangeUserPassword") ? "Allow Delegated Admin To Change User Password" : (key.contains("canUserChangePassword") ? "Allow User To Change Password" : (key.contains("passwordChangeEnforce") ? "Enforce Password Rules" : (key.contains("isAdminDeleteBackupFile") ? "Can Administrator delete other user's data" : (key.contains("softBlockEnabled") ? "Administration approval for blocked users" : (key.contains("overridePolicySettings") ? "Override Policy Settings for Admin Restore All" : (key.contains("allowEndUserTocontrolRestore") ? "Allow enduser To control Restore" : (key.contains("googleAuthenticator") ? "Multi-factor authentication" : (key.contains("enableRecaptcha") ? "Brute force password protection" : (key.contains("autoExpireUsers") ? "Allow automatic user-aging" : (key.contains("allowPasswordReset") ? "Allow reset password for Parablu namespace users" : (key.equals("flipUsersTile") ? "Flip Users Tile for BluVault" : (key.equals("tile8ReportType") ? " Users Without any assets protected for BluVault" : (key.equals("totalCompletedBackups") ? "Active Users with full Backups Completed for BluVault" : (key.equals("flipTotalCompletedBackups") ? "Flip Total Completed Backups for BluVault" : (key.equals("flipTotalActualStorageUtilized") ? "Flip Total Actual Storage Utilized for BluVault" : (key.equals("totalActualStorageUtilized") ? "Total Actual Storage Utilized for BluVault" : (key.equals("flipNotProtectedTile") ? "flip ProtectedTile for BluVault" : (key.equals("activeUsers") ? "Active Users BluVault" : (key.equals("flipDevicesTile") ? "Flip Asset Tile BluVault" : (key.contains("activeDevices") ? "Active Asset" : (key.contains("onlyRansomewarepossibilities") ? "Only Ransomeware possibilities" : (key.contains("canUserRestoreDeletedFiles") ? "Allow user to Restore deleted files/mails" : (key.equals("activeUsersOnedrive") ? "Active Users for Onedrive" : (key.equals("activeDevicesOnedrive") ? "Active Asset for Onedrive" : (key.equals("flipUsersTileOnedrive") ? "Flip Users Tile for Onedrive" : (key.equals("flipDevicesTileOnedrive") ? "Flip Asset Tile for Onedrive" : (key.equals("totalCompletedBackupsOnedrive") ? "Total Completed Backups for Onedrive" : (key.equals("totalActualStorageUtilizedOnedrive") ? "Total Actual Storage Utilized for Onedrive" : (key.equals("flipTotalCompletedBackupsOnedrive") ? "Flip Total Completed Backups for Onedrive" : (key.equals("flipTotalActualStorageUtilizedOnedrive") ? "Flip Total Actual Storage Utilized for Onedrive" : (key.equals("totalActualStorageUtilizedSharepoint") ? "Total Actual Storage Utilized for Sharepoint" : (key.equals("flipTotalActualStorageUtilizedSharepoint") ? "Flip Total Actual Storage Utilized for Sharepoint" : (key.equals("activeUsersExchange") ? "Active Users for Exchange" : (key.contains("activeDevicesExchange") ? "Active Asset for Exchange" : (key.equals("flipUsersTileExchange") ? "Flip Users Tile for Exchange" : (key.equals("flipDevicesTileExchange") ? "Flip Asset Tile for Exchange" : (key.equals("totalCompletedBackupsExchange") ? "Total Completed Backups for Exchange" : (key.equals("totalActualStorageUtilizedExchange") ? "Total Actual Storage Utilized for Exchange" : (key.equals("flipTotalCompletedBackupsExchange") ? "Flip Total Completed Backups for Exchange" : (key.equals("flipTotalActualStorageUtilizedExchange") ? "Flip Total Actual Storage Utilized for Exchange" : (key.contains("complexPassword") ? "Complex Password" : (key.contains("eyeOption") ? "Password Visibility" : (key.contains("forceChangePasswordAtFirstTimeLogin") ? "Force change password at first time login" : (key.contains("forceSessionLogoutAfterChangepassword") ? "Force session logout after change password" : (key.contains("dbBackupPassword") ? "Passphrase to encrypt meta-data during automatic backups" : (key.contains("defaultExchangePolicyName") ? "Default Policy name for Microsoft Exchange users" : (key.contains("defaultOdbPolicyName") ? "Default Policy name for OneDrive for Business users" : (key.contains("defaultSharepointPolicyName") ? "Default Policy name for SharePoint Online" : (key.contains("autoBlockSoftBlockedUsers") ? "Auto Block Soft Blocked Users" : (key.contains("daysToBlockSoftBlockedUsers") ? "Auto-block users in a soft-blocked state after days" : (key.contains("portalSSOEnable") ? "Azure Active Directory Single SignOn from Portal" : (key.contains("flipTotalCompletedBackupsGmail") ? "Flip Total Completed Backups for Gmail" : (key.contains("flipTotalActualStorageUtilizedGmail") ? "Flip Total Actual Storage Utilized for Gmail" : (key.contains("activeUsersGmail") ? "Active Users for Gmail" : (key.contains("activeDevicesGmail") ? "Active Assets for Gmail" : (key.contains("totalCompletedBackupsGmail") ? "Total Completed Backups for Gmail" : (key.contains("totalActualStorageUtilizedGmail") ? "Total Actual Storage Utilized for Gmail" : (key.contains("flipUsersTileGmail") ? "Flip Users Tile for Gmail" : (key.contains("flipDevicesTileGmail") ? "Flip Assets Tile for Gmail" : (key.contains("canDelegatedAdminChangeUserPassword") ? "Allow Delegated Admin To Change User Password" : (key.contains("conversationalAI") ? "Conversational AI" : (key.contains("techsupportaccess") ? "Tech support access" : (key.contains("flipUsersTileGdrive") ? "Flip Users Tile for Gdrive" : (key.contains("flipDevicesTileGdrive") ? "Flip Assets Tile for Gdrive" : (key.contains("flipTotalCompletedBackupsGdrive") ? "Flip Total Completed Backups for Gdrive" : (key.contains("flipTotalActualStorageUtilizedGdrive") ? "Flip Total Actual Storage Utilized for Gdrive" : "")))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
            if (!StringUtils.isEmpty((Object)key)) {
                fieldChanges.get(field);
                changedFields.append(" (");
                changedFields.append(key);
                changedFields.append(" values ");
                changedFields.append((String)fieldChanges.get(field));
                changedFields.append(")");
                if (key.length() > 1) {
                    changedFields.append(", ");
                }
                logger.debug("changed fields *************** " + changedFields.toString());
                continue;
            }
            logger.debug("Key is empty *******************");
        }
        if (changedFields.length() > 0) {
            changedFields.replace(changedFields.length() - 1, changedFields.length(), " ");
        }
        String changedfiled = changedFields.toString().replace("ALL USERS", "ENABLED");
        logger.debug("the changed fields are " + changedfiled);
        return changedfiled;
    }

    @Override
    public CloudPropertyElement getCloudPropertyElement(int cloudId) {
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        CloudPropertyElement cloudPropertyElement = null;
        if (cloudProperties != null) {
            cloudPropertyElement = new CloudPropertyElement();
            BeanUtils.copyProperties((Object)cloudProperties, (Object)cloudPropertyElement);
        }
        if (!StringUtils.isEmpty((Object)cloudProperties.getDbBackupPassword())) {
            try {
                cloudPropertyElement.setDbBackupPassword(this.decrypt(cloudProperties.getDbBackupPassword()));
            }
            catch (Exception e) {
                logger.trace(IO_EXCEPTION + String.valueOf(e));
                logger.error(IO_EXCEPTION + e.getMessage());
            }
        }
        return cloudPropertyElement;
    }

    @Override
    public SmtpElement getSmtpElement(int cloudId) {
        SmtpCredentials smtpCred = this.cloudDao.getSmtpCredentials(cloudId);
        SmtpElement smtpElement = null;
        if (smtpCred != null) {
            smtpElement = new SmtpElement();
            BeanUtils.copyProperties((Object)smtpCred, (Object)smtpElement);
            smtpElement.setSmtpAuth(Boolean.parseBoolean(smtpCred.getSmtpAuth()));
        }
        return smtpElement;
    }

    private void initiateCloudProperties(int cloudId) {
        logger.debug("Starting up ... !");
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        if (cloudProperties == null) {
            return;
        }
        CloudPropertyElement cloudPropertyElement = new CloudPropertyElement();
        BeanUtils.copyProperties((Object)cloudProperties, (Object)cloudPropertyElement);
        logger.debug("cloud property element is not null inside initate cloud properties>>>");
        this.registry.get(cloudId).setPropertyFileValueAdfsUrl(cloudPropertyElement.getAdfsUrl());
        this.registry.get(cloudId).setPropertyFileValueAllowAdminToRestoreAll(String.valueOf(cloudPropertyElement.getCanAdminRestoreAll()));
        this.registry.get(cloudId).setPropertyFileValueBkpEmailGroupName(cloudPropertyElement.getEmailBkpGroupName());
        this.registry.get(cloudId).setPropertyFileValueBkpSupportEmail(cloudPropertyElement.getBkpGroupEmail());
        this.registry.get(cloudId).setPropertyFileValueBkpSyncEmailGroupName(cloudPropertyElement.getEmailSyncGroupName());
        this.registry.get(cloudId).setPropertyFileValueBkpSyncSupportEmail(cloudPropertyElement.getSyncGroupEmail());
        this.registry.get(cloudId).setPropertyFileValueClientDownloadPath(cloudPropertyElement.getBlusyncDownloadPath());
        this.registry.get(cloudId).setPropertyFileValueClientMailName(cloudPropertyElement.getClientMailName());
        this.registry.get(cloudId).setPropertyFileValueClientSupportMailName(cloudPropertyElement.getClientSupportMailName());
        this.registry.get(cloudId).setPropertyFileValueDefaultBkpPolicy(cloudPropertyElement.getDefaultBkpPolicyName());
        this.registry.get(cloudId).setPropertyFileValueDefaultOdbPolicy(cloudPropertyElement.getDefaultOdbPolicyName());
        this.registry.get(cloudId).setPropertyFileValueDefaultExchangePolicy(cloudPropertyElement.getDefaultExchangePolicyName());
        this.registry.get(cloudId).setPropertyFileDefaultSharepointPolicy(cloudPropertyElement.getDefaultSharepointPolicyName());
        this.registry.get(cloudId).setPropertyFileValueDefaultSyncPolicy(cloudPropertyElement.getDefaultSyncPolicyName());
        this.registry.get(cloudId).setPropertyFileValueEmailDomainCheck(String.valueOf(cloudPropertyElement.getIsDomainCheckEnabled()));
        this.registry.get(cloudId).setPropertyFileValueEmailsToadminsOnly(String.valueOf(cloudPropertyElement.getEmailToAdminOnly()));
        this.registry.get(cloudId).setPropertyFileValueIsCrawlEnabled(String.valueOf(cloudPropertyElement.getIsCrawlEnabled()));
        this.registry.get(cloudId).setPropertyFileValueIsShareFileNameEnabled(String.valueOf(cloudPropertyElement.getIsShareFileNameEnabled()));
        this.registry.get(cloudId).setPropertyFileValueMaxCrawlHit(String.valueOf(cloudPropertyElement.getMaxCrawlHit()));
        this.registry.get(cloudId).setPropertyFileValueMaxRetryChunkUpdate(String.valueOf(cloudPropertyElement.getChunkUpdateMaxRetry()));
        this.registry.get(cloudId).setPropertyFileValueMigrationOu(cloudPropertyElement.getAdGroupName());
        this.registry.get(cloudId).setPropertyFileValueParacloudCloudnameFile(cloudPropertyElement.getCloudFileName());
        this.registry.get(cloudId).setPropertyFileValueParacloudMountPoint(cloudPropertyElement.getMntParacloudPath());
        this.registry.get(cloudId).setPropertyFileValueParacloudType(cloudPropertyElement.getCloudType());
        this.registry.get(cloudId).setPropertyFileValuePgWriteDelayLimit(String.valueOf(cloudPropertyElement.getEbmsWriteDelayLimit()));
        this.registry.get(cloudId).setPropertyFileValueReadPreference(String.valueOf(cloudPropertyElement.getMongoReadPreference()));
        this.registry.get(cloudId).setPropertyFileValueReplicaSafeLimit(String.valueOf(cloudPropertyElement.getWriteConcernLimit()));
        this.registry.get(cloudId).setPropertyFileValueReportDisplayRecords(String.valueOf(cloudPropertyElement.getReportRows()));
        this.registry.get(cloudId).setPropertyFileValueScriptsBinDir(cloudPropertyElement.getScriptsBinDir());
        this.registry.get(cloudId).setPropertyFileValueSolrBaseUrl(cloudPropertyElement.getSolrUrl());
        this.registry.get(cloudId).setSolrServerUrl(cloudPropertyElement.getSolrServerUrl());
        this.registry.get(cloudId).setPropertyFileValueSslAuthEnabled(String.valueOf(cloudPropertyElement.getSslAuthEnabled()));
        this.registry.get(cloudId).setPropertyFileValueSupportMail(cloudPropertyElement.getSupportMail());
        this.registry.get(cloudId).setPropertyFileValueSyncEmailGroupName(cloudPropertyElement.getEmailSyncGroupName());
        this.registry.get(cloudId).setPropertyFileValueVideoThumbnailScript(cloudPropertyElement.getScriptsVideoThumbnail());
        this.registry.get(cloudId).setBulkEmailDelay(cloudPropertyElement.getBulkEmailDelay());
        this.registry.get(cloudId).setDaysToWaitForNextBackup(cloudPropertyElement.getDaysToWaitForNextBackup());
        this.registry.get(cloudId).setCanUserChangePassword(cloudPropertyElement.isCanUserChangePassword());
        this.registry.get(cloudId).setCanAdminChangeUserPassword(cloudPropertyElement.isCanAdminChangeUserPassword());
        this.registry.get(cloudId).setPasswordChangeEnforce(cloudPropertyElement.isPasswordChangeEnforce());
        this.registry.get(cloudId).setHideStorageSizeInCloud(cloudPropertyElement.isHideStorageSizeInCloud());
        this.registry.get(cloudId).setHideStorageSizeOnServer(cloudPropertyElement.isHideStorageSizeOnServer());
        this.registry.get(cloudId).setAccessCodeExpiryTimeInMins(cloudPropertyElement.getAccessCodeExpiryTimeInMins() == 0 ? 2 : cloudPropertyElement.getAccessCodeExpiryTimeInMins());
        this.registry.get(cloudId).setDefaultGmailPolicy(cloudPropertyElement.getDefaultGmailPolicyName());
        logger.debug("end of initiating properties... !");
    }

    @Override
    public boolean createCloudCredentials(int cloudId, CloudCredentials cloudCredentials) {
        return this.cloudDao.createCloudCredentials(cloudId, cloudCredentials);
    }

    @Override
    public boolean editCloudCredentials(int cloudId, CloudCredentials cloudCredentials) {
        return this.cloudDao.editCloudCredentials(cloudId, cloudCredentials);
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, int actionType) {
        AuditHistory audit = this.auditHistoryDefaultValue(action, actionByUser, actionType);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    private AuditHistory auditHistoryDefaultValue(String action, String actionByUser, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("Portal");
        audit.setActionType(actionType);
        return audit;
    }

    private void updatePortalProperties(int cloudId, CloudProperties cloudProperties) {
        logger.debug("....updating........." + this.registry.get(cloudId).getPropertyValueComponentName());
        PortalProperties portalProperties = this.portalPropertiesDao.getPortalProperties(cloudId, this.registry.get(cloudId).getPropertyValueComponentName());
        if (portalProperties != null && !CollectionUtils.isEmpty((Map)portalProperties.getComponentsProperties())) {
            Map componentsProperties = portalProperties.getComponentsProperties();
            componentsProperties.put("eyeOption", cloudProperties.isEyeOption());
            componentsProperties.put("flipTotalCompletedBackups", cloudProperties.isFlipTotalCompletedBackups());
            componentsProperties.put("flipTotalActualStorageUtilized", cloudProperties.isFlipTotalActualStorageUtilized());
            componentsProperties.put("enableRecaptcha", cloudProperties.isEnableRecaptcha());
            componentsProperties.put("googleAuthenticator", cloudProperties.isGoogleAuthenticator());
            componentsProperties.put("totalCompletedBackups", cloudProperties.isTotalCompletedBackups());
            componentsProperties.put("totalActualStorageUtilized", cloudProperties.isTotalActualStorageUtilized());
            componentsProperties.put("complexPassword", cloudProperties.isComplexPassword());
            componentsProperties.put("portalSSOutEnable", cloudProperties.isPortalSSOutEnable());
            componentsProperties.put("useLocalPackage", componentsProperties.get("useLocalPackage"));
            componentsProperties.put("flipUsersTile", cloudProperties.isFlipUsersTile());
            componentsProperties.put("activeUsers", cloudProperties.isActiveUsers());
            componentsProperties.put("flipDevicesTile", cloudProperties.isFlipDevicesTile());
            componentsProperties.put("activeDevices", cloudProperties.isActiveDevices());
            componentsProperties.put("allowPasswordReset", cloudProperties.isAllowPasswordReset());
            componentsProperties.put("multifactorAuthWithAccessCode", cloudProperties.isMultifactorAuthWithAccessCode());
            componentsProperties.put("forceChangePasswordAtFirstTimeLogin", cloudProperties.isForceChangePasswordAtFirstTimeLogin());
            componentsProperties.put("forceSessionLogoutAfterChangepassword", cloudProperties.isForceSessionLogoutAfterChangepassword());
            componentsProperties.put("showSmtpSettings", cloudProperties.isShowSmtpSettings());
            componentsProperties.put("activeUsersOnedrive", cloudProperties.isActiveUsersOnedrive());
            componentsProperties.put("activeDevicesOnedrive", cloudProperties.isActiveDevicesOnedrive());
            componentsProperties.put("flipUsersTileOnedrive", cloudProperties.isFlipUsersTileOnedrive());
            componentsProperties.put("flipDevicesTileOnedrive", cloudProperties.isFlipDevicesTileOnedrive());
            componentsProperties.put("totalCompletedBackupsOnedrive", cloudProperties.isTotalCompletedBackupsOnedrive());
            componentsProperties.put("totalActualStorageUtilizedOnedrive", cloudProperties.isTotalActualStorageUtilizedOnedrive());
            componentsProperties.put("flipTotalCompletedBackupsOnedrive", cloudProperties.isFlipTotalCompletedBackupsOnedrive());
            componentsProperties.put("flipTotalActualStorageUtilizedOnedrive", cloudProperties.isFlipTotalActualStorageUtilizedOnedrive());
            componentsProperties.put("totalActualStorageUtilizedSharepoint", cloudProperties.isTotalActualStorageUtilizedSharepoint());
            componentsProperties.put("flipTotalActualStorageUtilizedSharepoint", cloudProperties.isFlipTotalActualStorageUtilizedSharepoint());
            componentsProperties.put("activeUsersExchange", cloudProperties.isActiveUsersExchange());
            componentsProperties.put("activeDevicesExchange", cloudProperties.isActiveDevicesExchange());
            componentsProperties.put("flipUsersTileExchange", cloudProperties.isFlipUsersTileExchange());
            componentsProperties.put("flipDevicesTileExchange", cloudProperties.isFlipDevicesTileExchange());
            componentsProperties.put("totalCompletedBackupsExchange", cloudProperties.isTotalCompletedBackupsExchange());
            componentsProperties.put("totalActualStorageUtilizedExchange", cloudProperties.isTotalActualStorageUtilizedExchange());
            componentsProperties.put("flipTotalCompletedBackupsExchange", cloudProperties.isFlipTotalCompletedBackupsExchange());
            componentsProperties.put("flipTotalActualStorageUtilizedExchange", cloudProperties.isFlipTotalActualStorageUtilizedExchange());
            componentsProperties.put("flipNotProtectedTile", cloudProperties.isFlipNotProtectedTile());
            componentsProperties.put("tile8ReportType", cloudProperties.getTile8ReportType());
            componentsProperties.put("flipUsersTileGmail", cloudProperties.isFlipUsersTileGmail());
            componentsProperties.put("flipDevicesTileGmail", cloudProperties.isFlipDevicesTileGmail());
            componentsProperties.put("flipTotalCompletedBackupsGmail", cloudProperties.isFlipTotalCompletedBackupsGmail());
            componentsProperties.put("flipTotalActualStorageUtilizedGmail", cloudProperties.isFlipTotalActualStorageUtilizedGmail());
            componentsProperties.put("activeUsersGmail", cloudProperties.isActiveUsersGmail());
            componentsProperties.put("activeDevicesGmail", cloudProperties.isActiveDevicesGmail());
            componentsProperties.put("totalCompletedBackupsGmail", cloudProperties.isTotalCompletedBackupsGmail());
            componentsProperties.put("totalActualStorageUtilizedGmail", cloudProperties.isTotalActualStorageUtilizedGmail());
            componentsProperties.put("flipTotalCompletedBackupsGdrive", cloudProperties.isFlipTotalCompletedBackupsGdrive());
            componentsProperties.put("flipDevicesTileGdrive", cloudProperties.isFlipDevicesTileGdrive());
            componentsProperties.put("flipUsersTileGdrive", cloudProperties.isFlipUsersTileGdrive());
            componentsProperties.put("flipTotalActualStorageUtilizedGdrive", cloudProperties.isFlipTotalActualStorageUtilizedGdrive());
            componentsProperties.put("totalCompletedBackupsGdrive", cloudProperties.isTotalCompletedBackupsGdrive());
            componentsProperties.put("activeDevicesGdrive", cloudProperties.isActiveDevicesGdrive());
            componentsProperties.put("activeUsersGdrive", cloudProperties.isActiveUsersGdrive());
            componentsProperties.put("totalActualStorageUtilizedGdrive", cloudProperties.isTotalActualStorageUtilizedGdrive());
            portalProperties.setComponentsProperties(componentsProperties);
            this.portalPropertiesDao.savePortalProperties(cloudId, portalProperties);
            logger.debug("....update complete........." + this.registry.get(cloudId).getPropertyValueComponentName());
        }
    }

    public void setPortalPropertiesDao(PortalPropertiesDao portalPropertiesDao) {
        this.portalPropertiesDao = portalPropertiesDao;
    }

    public String encrypt(String data) throws Exception {
        Key key = CloudSettingsServiceImpl.generateKey();
        Cipher c = Cipher.getInstance(ALGO);
        c.init(1, key);
        byte[] encVal = c.doFinal(data.getBytes());
        return Base64.getEncoder().encodeToString(encVal);
    }

    public String decrypt(String encryptedData) throws Exception {
        Key key = CloudSettingsServiceImpl.generateKey();
        Cipher c = Cipher.getInstance(ALGO);
        c.init(2, key);
        byte[] decordedValue = Base64.getDecoder().decode(encryptedData);
        byte[] decValue = c.doFinal(decordedValue);
        return new String(decValue);
    }

    private static Key generateKey() throws Exception {
        return new SecretKeySpec(keyValue, ALGO);
    }

    @Override
    public List<RwSampleFileElement> getRWSampleFilesCount(int cloudId) {
        List rwSampleFileinfoList = this.portalPropertiesDao.getRWSampleFilesCount(cloudId);
        ArrayList<RwSampleFileElement> rwSampleFileElementList = new ArrayList<RwSampleFileElement>();
        for (RwSampleFileInfo rwSampleFile : rwSampleFileinfoList) {
            RwSampleFileElement rwSampleFileElement = new RwSampleFileElement();
            rwSampleFileElement.setFileName(rwSampleFile.getFileName());
            rwSampleFileElement.setMd5Checksum(rwSampleFile.getMd5Checksum());
            rwSampleFileElement.setTimestamp(rwSampleFile.getTimestamp());
            rwSampleFileElement.setId(rwSampleFile.getId().toString());
            rwSampleFileElementList.add(rwSampleFileElement);
        }
        return rwSampleFileElementList;
    }

    @Override
    public void removeRWSampleFilesCount(int cloudId, String id) {
        this.portalPropertiesDao.removeRWSampleFilesCount(cloudId, id);
    }
}

